/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.handler.PetInfo;
import me.valkeea.fishyaddons.util.FishyNotis;
import me.valkeea.fishyaddons.util.TablistUtils;
import me.valkeea.fishyaddons.util.TextUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class TabScanner {
    private static final Pattern PET_PATTERN = Pattern.compile("\\[Lvl \\d+\\] .+");
    private static final int XP_FAIL_LIMIT = 15;
    private static final int FAIL_LIMIT = 20;
    private static final int SUMMON_FAIL_LIMIT = 15;
    private static PetTabInfo saved = null;
    private static int xpFailCount = 0;
    private static class_2561 override = null;
    private static class_2561 overrideOutline = null;
    private static int failCount = 0;
    private static int summonFailCount = 0;
    private static final Map<String, class_2561> maxLevelCache = new HashMap<String, class_2561>();

    private TabScanner() {
    }

    public static void setPet(class_2561 petInfo) {
        override = petInfo;
    }

    public static void clearPet() {
        override = null;
    }

    public static void setOutline(class_2561 outline) {
        overrideOutline = outline;
    }

    public static void clearOutline() {
        overrideOutline = null;
    }

    public static void clearFailCount() {
        failCount = 0;
    }

    public static class_2561 getPet() {
        if (override != null) {
            return override;
        }
        return saved != null ? saved.getCombined() : null;
    }

    public static class_2561 getOutline() {
        if (overrideOutline != null) {
            return overrideOutline;
        }
        if (override != null) {
            String stripped = class_124.method_539((String)override.getString());
            return class_2561.method_43470((String)stripped).method_27694(style -> style.method_10977(class_124.field_1074));
        }
        return saved != null ? saved.getCombinedForOutline() : null;
    }

    public static void onUpdate() {
        List<class_2561> lines;
        if (PetInfo.isDynamic()) {
            TabScanner.clearPet();
            TabScanner.clearOutline();
        }
        if ((lines = TablistUtils.getLines()).isEmpty()) {
            saved = null;
            return;
        }
        String currentline1 = null;
        int line1Idx = -1;
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            if (!TabScanner.isPetLine(line.getString())) continue;
            currentline1 = line.getString().trim();
            line1Idx = i;
            break;
        }
        if (PetInfo.isPending()) {
            if (line1Idx == -1) {
                if (++summonFailCount >= 15) {
                    PetInfo.setPending(false);
                    PetInfo.setNextCheck(false);
                    summonFailCount = 0;
                    TabScanner.sendFailNoti();
                }
                return;
            }
            class_2561 o = lines.get(line1Idx);
            TabScanner.handlePending(currentline1, o);
            return;
        }
        if (line1Idx == -1) {
            saved = null;
            return;
        }
        String petKey = currentline1;
        class_2561 line1 = lines.get(line1Idx);
        if (PetInfo.isDynamic() && PetInfo.shouldScanForXp()) {
            int contIdx = TabScanner.findXpLineIdx(lines, line1Idx);
            if (contIdx != -1) {
                class_2561 cont = lines.get(contIdx);
                if (TabScanner.isMaxLevelLine(cont)) {
                    maxLevelCache.put(petKey, cont);
                }
                saved = new PetTabInfo(line1Idx, contIdx, line1, cont);
                xpFailCount = 0;
                failCount = 0;
                return;
            }
            class_2561 foundMaxLevel = maxLevelCache.get(petKey);
            if (foundMaxLevel != null) {
                saved = new PetTabInfo(line1Idx, -1, line1, foundMaxLevel);
                xpFailCount = 0;
                failCount = 0;
                return;
            }
            if (++xpFailCount >= 15 || ++failCount >= 20) {
                TabScanner.sendFailNoti();
                xpFailCount = 0;
                failCount = 0;
            }
        }
    }

    private static int findXpLineIdx(List<class_2561> lines, int line1Idx) {
        for (int j = 0; j < lines.size(); ++j) {
            if (j == line1Idx || !TabScanner.isXpLine(lines.get(j))) continue;
            return j;
        }
        return -1;
    }

    private static void handlePending(String c1, class_2561 o) {
        String current;
        String lastline1 = saved != null ? TabScanner.saved.line1.getString().trim() : null;
        String string = current = c1 != null ? c1.trim() : null;
        if (current != null && !current.equals(lastline1)) {
            PetInfo.confirm(true);
            PetInfo.setPending(false);
            saved = new PetTabInfo(-1, -1, o, null);
            summonFailCount = 0;
            return;
        }
        if (PetInfo.isPending() && ++summonFailCount >= 15) {
            PetInfo.setPending(false);
            PetInfo.setNextCheck(false);
            summonFailCount = 0;
            TabScanner.sendFailNoti();
        }
    }

    private static boolean isPetLine(String line) {
        if (line == null) {
            return false;
        }
        Matcher m = PET_PATTERN.matcher(line.trim());
        return m.matches();
    }

    private static boolean isXpLine(class_2561 line) {
        class_2561 maxLevel;
        List siblings = line.method_10855();
        if (siblings.size() == 2 && (maxLevel = (class_2561)siblings.get(1)).getString().trim().equals("MAX LEVEL") && maxLevel.method_10866().method_10973() != null && maxLevel.method_10866().method_10973().method_27716() == 0x55FFFF && Boolean.TRUE.equals(maxLevel.method_10866().method_10984())) {
            return true;
        }
        if (siblings.size() >= 5) {
            boolean match;
            class_2561 t1 = (class_2561)siblings.get(1);
            class_2561 t2 = (class_2561)siblings.get(2);
            class_2561 t3 = (class_2561)siblings.get(3);
            class_2561 t4 = (class_2561)siblings.get(4);
            String s1 = t1.getString().trim();
            String s2 = t2.getString().trim();
            String s3 = t3.getString().trim();
            String s4 = t4.getString().trim();
            boolean bl = match = t1.method_10866().method_10973() != null && t1.method_10866().method_10973().method_27716() == 0xFFFF55 && s1.matches("[\\d,\\.]+") && t2.method_10866().method_10973() != null && t2.method_10866().method_10973().method_27716() == 0xFFAA00 && s2.equals("/") && t3.method_10866().method_10973() != null && t3.method_10866().method_10973().method_27716() == 0xFFFF55 && s3.endsWith("XP") && t4.method_10866().method_10973() != null && t4.method_10866().method_10973().method_27716() == 0xFFAA00 && s4.matches("\\([\\d\\.]+%\\)");
            if (match) {
                return true;
            }
        }
        return false;
    }

    private static boolean isMaxLevelLine(class_2561 line) {
        List siblings = line.method_10855();
        if (siblings.size() == 2) {
            class_2561 maxLevel = (class_2561)siblings.get(1);
            return maxLevel.getString().trim().equals("MAX LEVEL") && maxLevel.method_10866().method_10973() != null && maxLevel.method_10866().method_10973().method_27716() == 0x55FFFF && Boolean.TRUE.equals(maxLevel.method_10866().method_10984());
        }
        return false;
    }

    private static void sendFailNoti() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            FishyNotis.send((class_2561)class_2561.method_43470((String)"Failed to find pet info. Please check your tab widgets.").method_27692(class_124.field_1061));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PetTabInfo {
        public final int line1Idx;
        public final int line2Idx;
        public final class_2561 line1;
        public final class_2561 line2;

        public PetTabInfo(int line1Idx, int line2Idx, class_2561 line1, class_2561 line2) {
            this.line1Idx = line1Idx;
            this.line2Idx = line2Idx;
            this.line1 = line1;
            this.line2 = line2;
        }

        public class_2561 getCombined() {
            if (this.line2 != null) {
                return class_2561.method_43473().method_10852(this.line1).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(this.line2);
            }
            return this.line1;
        }

        public class_2561 getCombinedForOutline() {
            class_2561 combined = this.getCombined();
            return TextUtils.recolor(combined);
        }
    }
}

