/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.render;

import java.util.ArrayList;
import java.util.List;
import me.valkeea.fishyaddons.render.WorldElements;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_822;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class BeaconRenderer {
    private static final List<BeaconData> beacons = new ArrayList<BeaconData>();

    private BeaconRenderer() {
    }

    public static void setBeacon(class_2338 pos, int colorARGB, @Nullable String displayLabel) {
        beacons.add(new BeaconData(pos, colorARGB, displayLabel));
    }

    public static class_2338 getActualPos(class_243 pos) {
        return new class_2338((int)(pos.field_1352 < 0.0 ? Math.floor(pos.field_1352) - 1.0 : Math.floor(pos.field_1352)), (int)(Math.floor(pos.field_1351) - 1.0), (int)(pos.field_1350 < 0.0 ? Math.floor(pos.field_1350) - 1.0 : Math.floor(pos.field_1350)));
    }

    public static void init() {
        WorldRenderEvents.AFTER_ENTITIES.register(context -> {
            if (beacons.isEmpty()) {
                return;
            }
            long now = System.currentTimeMillis();
            beacons.removeIf(beacon -> now - beacon.setTime > 60000L);
            for (BeaconData beacon2 : beacons) {
                BeaconRenderer.renderBeacon(context, beacon2);
            }
        });
    }

    private static void renderBeacon(WorldRenderContext context, BeaconData beacon) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        class_243 camPos = context.camera().method_19326();
        class_4587 matrices = context.matrixStack();
        double x = beacon.pos.method_10263();
        double y = beacon.pos.method_10264();
        double z = beacon.pos.method_10260();
        float r = (float)(beacon.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(beacon.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(beacon.color & 0xFF) / 255.0f;
        float a = (float)(beacon.color >> 24 & 0xFF) / 255.0f;
        matrices.method_22903();
        matrices.method_22904(-camPos.field_1352, -camPos.field_1351, -camPos.field_1350);
        GL11.glDisable((int)2929);
        class_4588 fillConsumer = context.consumers().getBuffer(class_1921.method_49042());
        WorldElements.boxFill(matrices, new class_238(beacon.pos), fillConsumer, r, g, b, 0.3f);
        class_4588 consumer = context.consumers().getBuffer(class_1921.method_23594());
        WorldElements.boxOutline(matrices, new class_238(beacon.pos), consumer, r, g, b, a);
        if (beacon.label != null) {
            WorldElements.text(context, matrices, beacon.label, x + 0.5, y + 0.5, z + 0.5, beacon.color);
        }
        matrices.method_22903();
        matrices.method_22904(x, y + 1.0, z);
        class_822.method_3545((class_4587)matrices, (class_4597)context.consumers(), (class_2960)class_822.field_4338, (float)1.0f, (float)1.0f, (long)client.field_1687.method_8510(), (int)0, (int)256, (int)beacon.color, (float)0.2f, (float)0.25f);
        matrices.method_22909();
        GL11.glEnable((int)2929);
        matrices.method_22909();
    }

    public static void clearBeacons() {
        if (!beacons.isEmpty()) {
            beacons.clear();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class BeaconData {
        final class_2338 pos;
        final int color;
        final String label;
        final long setTime;

        BeaconData(class_2338 pos, int color, @Nullable String label) {
            this.pos = pos;
            this.color = color;
            this.label = label;
            this.setTime = System.currentTimeMillis();
        }
    }
}

