/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.safeguard;

import java.util.Map;
import java.util.WeakHashMap;
import me.valkeea.fishyaddons.config.ItemConfig;
import me.valkeea.fishyaddons.safeguard.ItemHandler;
import me.valkeea.fishyaddons.util.FishyNotis;
import me.valkeea.fishyaddons.util.PlaySound;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_7225;

@Environment(value=EnvType.CLIENT)
public class SellProtectionHandler {
    private static final Map<class_1799, Boolean> protectionCache = new WeakHashMap<class_1799, Boolean>();
    private static final int MAX_CACHE_SIZE = 1000;

    private SellProtectionHandler() {
    }

    public static boolean isProtectedCached(class_1799 stack, class_7225.class_7874 registries) {
        if (stack == null || stack.method_7960() || registries == null) {
            return false;
        }
        if (protectionCache.size() > 1000) {
            protectionCache.clear();
        }
        return protectionCache.computeIfAbsent(stack, s -> {
            try {
                String uuid = ItemHandler.extractUUID(s, registries);
                if (uuid == null) {
                    return false;
                }
                return ItemConfig.isProtected(uuid);
            }
            catch (RuntimeException e) {
                return false;
            }
        });
    }

    public static void triggerProtection() {
        if (ItemConfig.isProtectTriggerEnabled()) {
            PlaySound.protectTrigger();
        }
        if (ItemConfig.isProtectNotiEnabled()) {
            FishyNotis.protectNoti();
        }
    }
}

