/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.tracker;

import java.util.List;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.tracker.ChatDropParser;
import me.valkeea.fishyaddons.tracker.InventoryTracker;
import me.valkeea.fishyaddons.tracker.ItemTrackerData;
import me.valkeea.fishyaddons.tracker.SackDropParser;
import me.valkeea.fishyaddons.util.HelpUtil;
import me.valkeea.fishyaddons.util.SkyblockCheck;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

@Environment(value=EnvType.CLIENT)
public class TrackerUtils {
    private static boolean pricePerItem = false;
    private static boolean enabled = false;

    private TrackerUtils() {
    }

    public static boolean isOn() {
        return pricePerItem;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void refresh() {
        pricePerItem = FishyConfig.getState("pricePerItem", false);
        enabled = FishyConfig.getState("profitTrackerHud", true);
    }

    public static void setPricePerItem(boolean state) {
        pricePerItem = state;
        FishyConfig.toggle("pricePerItem", state);
    }

    public static void handleChat(String message) {
        ChatDropParser.ParseResult result;
        if (!SkyblockCheck.getInstance().rules() || !enabled) {
            return;
        }
        String s = HelpUtil.stripColor(message);
        if (s.startsWith("[") || s.startsWith("Guild") || s.startsWith("Party")) {
            return;
        }
        if (s.toLowerCase().contains("loot share")) {
            InventoryTracker.onLsDetected();
        }
        if ((result = ChatDropParser.parseMessage(message)) != null) {
            SackDropParser.registerChatDrop(result.itemName, result.quantity);
            if (result.isCoinDrop) {
                ItemTrackerData.addCoins(result.quantity);
            } else if (result.itemName.toLowerCase().contains("enchanted book")) {
                InventoryTracker.onEnchantedBookDropDetected(result.quantity, result.magicFind);
            } else {
                ItemTrackerData.addDrop(result.itemName, result.quantity);
            }
        }
    }

    public static void handleSackDrop(ChatDropParser.ParseResult drop) {
        if (!SkyblockCheck.getInstance().rules()) {
            return;
        }
        if (drop != null) {
            ItemTrackerData.addDrop(drop.itemName, drop.quantity);
        }
    }

    public static void checkForHoverEvents(class_2561 message) {
        String fullMessageText;
        boolean sackTrackingEnabled = SackDropParser.isOn();
        if (sackTrackingEnabled && SackDropParser.isSackNotification(fullMessageText = TrackerUtils.reconstruct(message))) {
            TrackerUtils.handleSackNotification(message);
            return;
        }
        for (class_2561 sibling : message.method_10855()) {
            TrackerUtils.checkForHoverEvents(sibling);
        }
    }

    private static String reconstruct(class_2561 message) {
        StringBuilder fullText = new StringBuilder();
        fullText.append(message.getString());
        for (class_2561 sibling : message.method_10855()) {
            fullText.append(TrackerUtils.reconstruct(sibling));
        }
        return fullText.toString();
    }

    private static void handleSackNotification(class_2561 message) {
        if (TrackerUtils.processSackHover(message.method_10866())) {
            return;
        }
        for (class_2561 sibling : message.method_10855()) {
            if (!TrackerUtils.processSackHover(sibling.method_10866())) continue;
            return;
        }
    }

    private static boolean processSackHover(class_2583 style) {
        if (style != null && style.method_10969() != null) {
            List<ChatDropParser.ParseResult> sackDrops = SackDropParser.parseSackHoverEvent(style.method_10969());
            for (ChatDropParser.ParseResult drop : sackDrops) {
                TrackerUtils.handleSackDrop(drop);
            }
            return true;
        }
        return false;
    }
}

