/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.util;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.tracker.InventoryTracker;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class EntityTracker {
    private static final Set<class_1297> trackedEntities = ConcurrentHashMap.newKeySet();
    private static final Map<class_1297, TrackedMob> mobData = new ConcurrentHashMap<class_1297, TrackedMob>();
    private static final Map<class_1297, Long> armorStandSpawnTimes = new ConcurrentHashMap<class_1297, Long>();
    private static final double TRACKING_DISTANCE = 32.0;
    private static final double ASSOCIATION_DISTANCE = 10.0;
    private static boolean foundVal = false;
    private static final Pattern VALUABLE_MOB_PATTERN = Pattern.compile(".*\\b(the loch emperor|lord jawbus|thunder)\\b.*", 2);
    private static final Pattern MOB_INFO_PATTERN = Pattern.compile("\\[Lv(\\d+)\\]\\s+(.+?)\\s+(\\d+(?:\\.\\d+)?[kmbtKMBT]?)/(\\d+(?:\\.\\d+)?[kmbtKMBT]?)\u2764");
    private static final Pattern VALUABLE_PLAYERENTITY_PATTERN = Pattern.compile(".*\\b(great white shark|tiger shark|ent)\\b.*", 2);

    private EntityTracker() {
    }

    public static void onEntityAdded(class_1297 entity) {
        if (entity == null) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        double distance = client.field_1724.method_5739(entity);
        if (distance > 32.0) {
            return;
        }
        if (trackedEntities.add(entity) && !mobData.containsKey(entity)) {
            EntityTracker.handleNewEntity(entity, distance);
        }
    }

    public static void onEntityRemoved(class_1297 entity) {
        if (entity == null) {
            return;
        }
        trackedEntities.remove(entity);
        TrackedMob trackedMob = mobData.remove(entity);
        if (trackedMob != null && trackedMob.isValuable()) {
            EntityTracker.handleMobDeath();
        }
        armorStandSpawnTimes.remove(entity);
        mobData.values().removeIf(mob -> mob.getNameArmorStand() == entity);
    }

    private static void handleNewEntity(class_1297 entity, double distance) {
        class_1297 class_12972 = entity;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1308.class, class_1531.class, class_1657.class}, (Object)class_12973, n)) {
            case 0: {
                class_1308 mobEntity = (class_1308)class_12973;
                EntityTracker.handleMobDetected(mobEntity, distance);
                break;
            }
            case 1: {
                class_1531 armorStand = (class_1531)class_12973;
                EntityTracker.handleArmorStandDetected(armorStand, distance);
                break;
            }
            case 2: {
                class_1657 player = (class_1657)class_12973;
                EntityTracker.handlePlayerEntityDetected(player);
                break;
            }
        }
    }

    private static void handlePlayerEntityDetected(class_1657 player) {
        boolean isValuablePlayer;
        class_310 client = class_310.method_1551();
        if (player == client.field_1724) {
            return;
        }
        String playerName = player.method_5477().getString();
        String displayName = player.method_5476().getString();
        boolean bl = isValuablePlayer = VALUABLE_PLAYERENTITY_PATTERN.matcher(playerName).matches() || VALUABLE_PLAYERENTITY_PATTERN.matcher(displayName).matches();
        if (!isValuablePlayer && !EntityTracker.hasNearbyMobArmorStand(player)) {
            return;
        }
        String mobType = "player_" + playerName.toLowerCase().replace(" ", "_");
        TrackedMob trackedPlayer = new TrackedMob((class_1297)player, mobType);
        trackedPlayer.setDisplayName(displayName.isEmpty() ? playerName : displayName);
        mobData.put((class_1297)player, trackedPlayer);
        foundVal = true;
        EntityTracker.scheduleArmorStandAssociation(trackedPlayer);
    }

    private static boolean hasNearbyMobArmorStand(class_1657 player) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return false;
        }
        return client.field_1687.method_8335((class_1297)player, player.method_5829().method_1014(3.0)).stream().anyMatch(entity -> {
            String[] possibleNames;
            if (!(entity instanceof class_1531)) {
                return false;
            }
            class_1531 armorStand = (class_1531)entity;
            for (String nameToCheck : possibleNames = new String[]{armorStand.method_5477().getString(), armorStand.method_5797() != null ? armorStand.method_5797().getString() : null, armorStand.method_5476().getString()}) {
                if (nameToCheck == null || !nameToCheck.contains("\u2764") && !nameToCheck.matches(".*\\d+/\\d+.*") && !nameToCheck.matches(".*\\[Lv\\d+\\].*") && !VALUABLE_MOB_PATTERN.matcher(nameToCheck).find() && !VALUABLE_PLAYERENTITY_PATTERN.matcher(nameToCheck).find()) continue;
                return true;
            }
            return false;
        });
    }

    private static void handleMobDetected(class_1308 mob, double distance) {
        if (mobData.containsKey(mob)) {
            return;
        }
        String mobType = mob.getClass().getSimpleName().toLowerCase();
        TrackedMob trackedMob = new TrackedMob((class_1297)mob, mobType);
        mobData.put((class_1297)mob, trackedMob);
        EntityTracker.scheduleArmorStandAssociation(trackedMob);
    }

    private static void handleArmorStandDetected(class_1531 armorStand, double distance) {
        armorStandSpawnTimes.put((class_1297)armorStand, System.currentTimeMillis());
    }

    private static void scheduleArmorStandAssociation(TrackedMob trackedMob) {
        new Thread(() -> {
            try {
                Thread.sleep(100L);
                EntityTracker.tryAssociateWithNearbyArmorStands(trackedMob);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
    }

    private static void tryAssociateWithNearbyArmorStands(TrackedMob trackedMob) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        for (class_1297 entity : armorStandSpawnTimes.keySet()) {
            String[] possibleNames;
            double distance;
            if (!(entity instanceof class_1531)) continue;
            class_1531 armorStand = (class_1531)entity;
            long timeDiff = System.currentTimeMillis() - armorStandSpawnTimes.get(entity);
            if (timeDiff > 2000L || !((distance = (double)trackedMob.mobEntity.method_5739((class_1297)armorStand)) <= 10.0)) continue;
            for (String nameToCheck : possibleNames = new String[]{armorStand.method_5477().getString(), armorStand.method_5797() != null ? armorStand.method_5797().getString() : null, armorStand.method_5476().getString()}) {
                if (nameToCheck == null || !EntityTracker.tryExtractAndAssociateMobInfo(armorStand, nameToCheck, trackedMob)) continue;
                return;
            }
        }
    }

    private static boolean tryExtractAndAssociateMobInfo(class_1531 armorStand, String nameToCheck, TrackedMob trackedMob) {
        Matcher matcher = MOB_INFO_PATTERN.matcher(nameToCheck);
        if (matcher.matches()) {
            String mobName = matcher.group(2).trim();
            int level = Integer.parseInt(matcher.group(1));
            trackedMob.setDisplayName(mobName);
            trackedMob.setLevel(level);
            trackedMob.setNameArmorStand((class_1297)armorStand);
            if (trackedMob.isValuable()) {
                foundVal = true;
            }
            return true;
        }
        return false;
    }

    private static void handleMobDeath() {
        EntityTracker.scanInventoryForDrops();
        EntityTracker.cleanup();
    }

    public static void onDmgAni() {
        if (foundVal) {
            InventoryTracker.onValuableEntityDamaged();
        }
    }

    private static void scanInventoryForDrops() {
        InventoryTracker.onValuableEntityDeath();
    }

    public static void cleanup() {
        trackedEntities.removeIf(entity -> entity.method_31481() || !entity.method_5805());
        mobData.entrySet().removeIf(entry -> ((class_1297)entry.getKey()).method_31481() || !((class_1297)entry.getKey()).method_5805());
        foundVal = mobData.values().stream().anyMatch(TrackedMob::isValuable);
        long currentTime = System.currentTimeMillis();
        armorStandSpawnTimes.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 10000L || ((class_1297)entry.getKey()).method_31481());
        mobData.entrySet().removeIf(entry -> {
            TrackedMob mob = (TrackedMob)entry.getValue();
            if (mob.mobEntity instanceof class_1657 && mob.mobType.startsWith("player_") && !mob.isValuable() && currentTime - mob.getSpawnTime() > 5000L) {
                trackedEntities.remove(entry.getKey());
                return true;
            }
            return false;
        });
    }

    public static void cleanVal() {
        if (foundVal) {
            foundVal = false;
        }
    }

    public static Set<class_1297> getTrackedEntities() {
        return new HashSet<class_1297>(trackedEntities);
    }

    public static Map<class_1297, TrackedMob> getTrackedMobs() {
        return new HashMap<class_1297, TrackedMob>(mobData);
    }

    public static boolean isEntityTracked(class_1297 entity) {
        return trackedEntities.contains(entity);
    }

    public static List<TrackedMob> getValuableMobs() {
        return mobData.values().stream().filter(TrackedMob::isValuable).collect(ArrayList::new, List::add, List::addAll);
    }

    @Environment(value=EnvType.CLIENT)
    public static class TrackedMob {
        public final class_1297 mobEntity;
        public final String mobType;
        private String displayName;
        private int level = 0;
        private long spawnTime;
        private class_1297 nameArmorStand;

        public TrackedMob(class_1297 mobEntity, String mobType) {
            this.mobEntity = mobEntity;
            this.mobType = mobType;
            this.spawnTime = System.currentTimeMillis();
        }

        public boolean isValuable() {
            if (this.displayName == null) {
                return false;
            }
            if (VALUABLE_MOB_PATTERN.matcher(this.displayName).matches()) {
                return true;
            }
            if (VALUABLE_PLAYERENTITY_PATTERN.matcher(this.displayName).matches()) {
                return true;
            }
            if (this.mobEntity instanceof class_1657 && this.mobType.startsWith("player_")) {
                return VALUABLE_PLAYERENTITY_PATTERN.matcher(this.displayName).matches();
            }
            return false;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public long getSpawnTime() {
            return this.spawnTime;
        }

        public class_1297 getNameArmorStand() {
            return this.nameArmorStand;
        }

        public void setNameArmorStand(class_1297 nameArmorStand) {
            this.nameArmorStand = nameArmorStand;
        }
    }
}

