/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import me.valkeea.fishyaddons.command.CmdHelper;
import me.valkeea.fishyaddons.command.ProfitTrackerCommand;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.config.ItemConfig;
import me.valkeea.fishyaddons.gui.AliasAddScreen;
import me.valkeea.fishyaddons.gui.ChatAddScreen;
import me.valkeea.fishyaddons.gui.FishyAddonsScreen;
import me.valkeea.fishyaddons.gui.GUIChatAlert;
import me.valkeea.fishyaddons.gui.HudEditScreen;
import me.valkeea.fishyaddons.gui.QolScreen;
import me.valkeea.fishyaddons.gui.SbScreen;
import me.valkeea.fishyaddons.gui.TabbedListScreen;
import me.valkeea.fishyaddons.gui.VisualSettingsScreen;
import me.valkeea.fishyaddons.handler.ChatAlert;
import me.valkeea.fishyaddons.handler.ChatReplacement;
import me.valkeea.fishyaddons.handler.ClientPing;
import me.valkeea.fishyaddons.handler.CommandAlias;
import me.valkeea.fishyaddons.handler.KeyShortcut;
import me.valkeea.fishyaddons.handler.RenderTweaks;
import me.valkeea.fishyaddons.handler.WeatherTracker;
import me.valkeea.fishyaddons.safeguard.ItemHandler;
import me.valkeea.fishyaddons.tool.GuiScheduler;
import me.valkeea.fishyaddons.util.FishyNotis;
import me.valkeea.fishyaddons.util.PlayerPosition;
import me.valkeea.fishyaddons.util.TextFormatUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

@Environment(value=EnvType.CLIENT)
public class FishyCmd {
    private static final String PROFILE = "profile";

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerCmd() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cmd").then(ClientCommandManager.literal((String)"add").executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new AliasAddScreen(class_310.method_1551().field_1755)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"on").executes(context -> {
            FishyConfig.enable("aliasesOn", true);
            FishyNotis.on("Custom commands");
            CommandAlias.refresh();
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            FishyConfig.disable("aliasesOn");
            FishyNotis.off("Custom commands");
            CommandAlias.refresh();
            return 1;
        }))).executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new TabbedListScreen(class_310.method_1551().field_1755, TabbedListScreen.Tab.COMMANDS)));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerChat() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"chat").then(ClientCommandManager.literal((String)"add").executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new ChatAddScreen(class_310.method_1551().field_1755)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"on").executes(context -> {
            FishyConfig.enable("chatReplacementsOn", true);
            FishyNotis.on("Chat replacements");
            ChatReplacement.refresh();
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            FishyConfig.disable("chatReplacementsOn");
            FishyNotis.off("Chat replacements");
            ChatReplacement.refresh();
            return 1;
        }))).executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new TabbedListScreen(class_310.method_1551().field_1755, TabbedListScreen.Tab.CHAT)));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerKey() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"key").then(ClientCommandManager.literal((String)"on").executes(context -> {
            FishyConfig.enable("keyShortcutsOn", true);
            FishyNotis.on("Keybinds");
            KeyShortcut.refresh();
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            FishyConfig.disable("keyShortcutsOn");
            FishyNotis.off("Keybinds");
            KeyShortcut.refresh();
            return 1;
        }))).executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new TabbedListScreen(class_310.method_1551().field_1755, TabbedListScreen.Tab.KEYBINDS)));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerAlert() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"alert").then(ClientCommandManager.literal((String)"on").executes(context -> {
            FishyConfig.enable("chatAlertsOn", true);
            FishyNotis.on("Chat alerts");
            ChatAlert.refresh();
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            FishyConfig.disable("chatAlertsOn");
            FishyNotis.off("Chat alerts");
            ChatAlert.refresh();
            return 1;
        }))).executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new GUIChatAlert(null)));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerGuide() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"guide").executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            FishyNotis.guideNoti2();
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerHelp() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"help").executes(context -> {
            FishyNotis.helpNoti();
            return 1;
        });
    }

    public static void addGuardSubcommands(LiteralArgumentBuilder<FabricClientCommandSource> root) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then(ClientCommandManager.literal((String)"add").executes(context -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null || mc.field_1687 == null) {
                return 1;
            }
            class_1799 held = mc.field_1724.method_6047();
            if (held == null || held.method_7960()) {
                FishyNotis.notice("You must be holding an item to use this command.");
                return 1;
            }
            class_5455 registries = mc.field_1687.method_30349();
            String uuid = ItemHandler.extractUUID(held, (class_7225.class_7874)registries);
            if (uuid == null || uuid.isEmpty()) {
                FishyNotis.warn("Held item doesn't have a UUID.");
                return 1;
            }
            String displayNameJson = TextFormatUtil.serialize(held.method_7964());
            ItemConfig.addUUID(uuid, held.method_7964());
            class_2561 displayNameText = TextFormatUtil.deserialize(displayNameJson);
            FishyNotis.format((class_2561)class_2561.method_43470((String)"Your ").method_27692(class_124.field_1080).method_10852(displayNameText).method_10852((class_2561)class_2561.method_43470((String)" is now protected.").method_27692(class_124.field_1080)));
            return 1;
        }))).then(ClientCommandManager.literal((String)"remove").executes(context -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null) {
                return 1;
            }
            class_1799 held = mc.field_1724.method_6047();
            if (held == null || held.method_7960()) {
                FishyNotis.notice("You must be holding an item to use this command.");
                return 1;
            }
            class_5455 registries = mc.field_1687.method_30349();
            String uuid = ItemHandler.extractUUID(held, (class_7225.class_7874)registries);
            if (uuid != null && ItemHandler.isProtected(held, (class_7225.class_7874)registries)) {
                ItemConfig.removeUUID(uuid);
                FishyNotis.format((class_2561)class_2561.method_43470((String)"Your ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)held.method_7964().getString()).method_27692(class_124.field_1070)).method_10852((class_2561)class_2561.method_43470((String)" is no longer protected.").method_27692(class_124.field_1080)));
            } else {
                FishyNotis.notice("Held item isn't protected or doesn't have a UUID.");
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"list").executes(context -> {
            CmdHelper.sendSortedProtectedList();
            return 1;
        }))).then(ClientCommandManager.literal((String)"clear").executes(context -> {
            if (!CmdChat.pendingClear) {
                CmdChat.pendingClear = true;
                FishyNotis.send("Are you SURE you want to clear all protected items?");
                FishyCmd.sendClickable();
            } else {
                FishyNotis.warn("Please respond to the confirmation prompt for: /fa guard clear.");
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"confirmclear").executes(context -> {
            ItemConfig.clearAll();
            FishyNotis.send("All protected items have been cleared.");
            CmdChat.pendingClear = false;
            return 1;
        }))).then(ClientCommandManager.literal((String)"cancelclear").executes(context -> {
            FishyNotis.notice("/fa guard clear was canceled.");
            CmdChat.pendingClear = false;
            return 1;
        }))).then(ClientCommandManager.literal((String)"help").executes(context -> {
            FishyNotis.themed("Usage: /fa profit <add | remove | list | clear>");
            return 1;
        }));
    }

    protected static void addProfitSubcommands(LiteralArgumentBuilder<FabricClientCommandSource> root) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.then(ClientCommandManager.literal((String)"toggle").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"toggle"});
            return 1;
        }))).then(ClientCommandManager.literal((String)"stats").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"stats"});
            return 1;
        }))).then(ClientCommandManager.literal((String)"init").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"init"});
            return 1;
        }))).then(ClientCommandManager.literal((String)"refresh").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"refresh"});
            return 1;
        }))).then(ClientCommandManager.literal((String)"status").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"status"});
            return 1;
        }))).then(ClientCommandManager.literal((String)"clear").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"clear"});
            return 1;
        }))).then(ClientCommandManager.literal((String)"ignored").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"ignored"});
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"restore").then(ClientCommandManager.literal((String)"all").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"restore", "all"});
            return 1;
        }))).then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String itemName = StringArgumentType.getString((CommandContext)context, (String)"item");
            ProfitTrackerCommand.handle(new String[]{"restore", itemName});
            return 1;
        }))).executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"restore"});
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"type").then(ClientCommandManager.literal((String)"insta_sell").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"type", "insta_sell"});
            return 1;
        }))).then(ClientCommandManager.literal((String)"sell_offer").executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"type", "sell_offer"});
            return 1;
        }))).executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"type"});
            return 1;
        }))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"price").then(ClientCommandManager.argument((String)"item", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String itemName = StringArgumentType.getString((CommandContext)context, (String)"item");
            ProfitTrackerCommand.handle(new String[]{"price", itemName});
            return 1;
        }))).executes(context -> {
            ProfitTrackerCommand.handle(new String[]{"price"});
            return 1;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)PROFILE).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String profileName = StringArgumentType.getString((CommandContext)context, (String)"name");
            ProfitTrackerCommand.handle(new String[]{PROFILE, profileName});
            return 1;
        }))).then(ClientCommandManager.literal((String)"delete").then(ClientCommandManager.argument((String)PROFILE, (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String profileName = StringArgumentType.getString((CommandContext)context, (String)PROFILE);
            ProfitTrackerCommand.handle(new String[]{PROFILE, "delete", profileName});
            return 1;
        })))).then(ClientCommandManager.literal((String)"rename").then(ClientCommandManager.argument((String)"oldName", (ArgumentType)StringArgumentType.word()).then(ClientCommandManager.argument((String)"newName", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String oldName = StringArgumentType.getString((CommandContext)context, (String)"oldName");
            String newName = StringArgumentType.getString((CommandContext)context, (String)"newName");
            ProfitTrackerCommand.handle(new String[]{PROFILE, "rename", oldName, newName});
            return 1;
        }))))).executes(context -> {
            ProfitTrackerCommand.handle(new String[]{PROFILE});
            return 1;
        }))).executes(context -> {
            ProfitTrackerCommand.handle(new String[0]);
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerLava() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lava").then(ClientCommandManager.literal((String)"on").executes(context -> {
            FishyConfig.settings.set("fishyLava", true);
            FishyNotis.on("Clear Lava");
            RenderTweaks.refresh();
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            FishyConfig.settings.set("fishyLava", false);
            FishyNotis.off("Clear Lava");
            RenderTweaks.refresh();
            return 1;
        }))).executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new VisualSettingsScreen()));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerHud() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"hud").executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new HudEditScreen()));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerPing() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ping").then(ClientCommandManager.literal((String)"on").executes(context -> {
            FishyConfig.enable("pingHud", true);
            FishyNotis.on("Ping display");
            ClientPing.refresh();
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            FishyConfig.disable("pingHud");
            FishyNotis.off("Ping display");
            ClientPing.refresh();
            return 1;
        }))).executes(context -> {
            ClientPing.send();
            FishyNotis.send((class_2561)class_2561.method_43470((String)(ClientPing.get() + " \u00a78ms")).method_27692(class_124.field_1068));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerOld() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"old").executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new FishyAddonsScreen()));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerCam() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"camera").then(ClientCommandManager.literal((String)"on").executes(context -> {
            FishyConfig.enable("skipPerspective", true);
            FishyNotis.on("Custom F5");
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            FishyConfig.disable("skipPerspective");
            FishyNotis.off("Custom F5");
            return 1;
        }))).executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new QolScreen()));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerPos() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"coords").then(ClientCommandManager.argument((String)"label", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String label = (String)context.getArgument("label", String.class);
            PlayerPosition.giveAwayCoordsWithLabel(label);
            return 1;
        }))).executes(context -> {
            PlayerPosition.giveAwayCoords();
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerQol() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"qol").executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new QolScreen()));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerVisual() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"visual").executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new VisualSettingsScreen()));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerSb() {
        return (LiteralArgumentBuilder)ClientCommandManager.literal((String)"sb").executes(context -> {
            if (FishyCmd.checkGUI() == 1) {
                return 1;
            }
            class_310.method_1551().execute(() -> GuiScheduler.scheduleGui(new SbScreen()));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerRain() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"rain").then(ClientCommandManager.literal((String)"track").executes(context -> {
            boolean isRaining = WeatherTracker.isRaining();
            WeatherTracker.track();
            String status = isRaining ? "It is currently raining. You will be notified when the rain stops." : "It is not currently raining.";
            FishyNotis.format((class_2561)class_2561.method_43470((String)status).method_27692(isRaining ? class_124.field_1062 : class_124.field_1061));
            return 1;
        }))).then(ClientCommandManager.literal((String)"on").executes(context -> {
            FishyConfig.toggle("rainNoti", true);
            FishyNotis.on("Rain notifications");
            return 1;
        }))).then(ClientCommandManager.literal((String)"off").executes(context -> {
            FishyConfig.toggle("rainNoti", false);
            WeatherTracker.reset();
            FishyNotis.off("Rain notifications");
            return 1;
        }))).executes(context -> {
            FishyNotis.themed("\u00a7lRain Tracker:");
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa rain track \u00a78- \u00a77Track the current rain state."));
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa rain on | off \u00a78- \u00a77Enable/disable rain notifications"));
            return 1;
        });
    }

    protected static LiteralArgumentBuilder<FabricClientCommandSource> registerFishing() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"fishing").then(ClientCommandManager.literal((String)"sounds").executes(context -> {
            FishyNotis.send("\u00a7aTo create a resource pack:");
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77- Create a folder named: \u00a7bfishyaddons"));
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77- Inside that folder, create another folder named: \u00a7bsounds"));
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77- Inside the sounds folder, create a folder named: \u00a7bcustom"));
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77- Place your custom .ogg files inside the custom folder"));
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77- Then use sound IDs: \u00a7bfishyaddons:fishyaddons_1\u00a77, \u00a7bfishyaddons:fishyaddons_2\u00a77, \u00a7bfishyaddons:fishyaddons_3"));
            return 1;
        }))).executes(context -> {
            FishyNotis.send("\u00a73Usage: /fa fishing sounds - open directory to add your custom .ogg files");
            return 1;
        });
    }

    protected static int checkGUI() {
        if (class_310.method_1551().field_1755 != null && !(class_310.method_1551().field_1755 instanceof class_408)) {
            return 1;
        }
        return 0;
    }

    private static void sendClickable() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        class_5250 yes = class_2561.method_43470((String)"[Yes]").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/fa guard confirmclear")).method_36139(0xCCFFCC));
        class_5250 no = class_2561.method_43470((String)"[No]").method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/fa guard cancelclear")).method_36139(0xFF8080));
        mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)yes).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)no), false);
    }

    private FishyCmd() {
        throw new UnsupportedOperationException("Utility class");
    }

    @Environment(value=EnvType.CLIENT)
    private static class CmdChat {
        static boolean pendingClear = false;

        private CmdChat() {
        }
    }
}

