/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.command;

import java.util.List;
import java.util.Map;
import java.util.Set;
import me.valkeea.fishyaddons.api.HypixelPriceClient;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.config.TrackerProfiles;
import me.valkeea.fishyaddons.hud.TrackerDisplay;
import me.valkeea.fishyaddons.tracker.ItemTrackerData;
import me.valkeea.fishyaddons.tracker.TrackerUtils;
import me.valkeea.fishyaddons.util.FishyNotis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ProfitTrackerCommand {
    private static final String KEY = "profitTrackerHud";

    private ProfitTrackerCommand() {
    }

    public static boolean handle(String[] args) {
        String subcommand;
        if (args.length == 0) {
            FishyNotis.fp();
            return false;
        }
        switch (subcommand = args[0].toLowerCase()) {
            case "toggle": {
                return ProfitTrackerCommand.handleToggle();
            }
            case "clear": {
                return ProfitTrackerCommand.handleClear();
            }
            case "stats": {
                return ProfitTrackerCommand.handleStats();
            }
            case "init": {
                return ProfitTrackerCommand.handleInit();
            }
            case "refresh": {
                return ProfitTrackerCommand.handleRefresh();
            }
            case "status": {
                return ProfitTrackerCommand.handleStatus();
            }
            case "price": {
                return ProfitTrackerCommand.handlePrice(args);
            }
            case "type": {
                return ProfitTrackerCommand.handlePriceType(args);
            }
            case "profile": {
                return ProfitTrackerCommand.handleProfile(args);
            }
            case "ignored": {
                return ProfitTrackerCommand.handleIgnored();
            }
            case "restore": {
                return ProfitTrackerCommand.handleRestore(args);
            }
        }
        FishyNotis.fp();
        return false;
    }

    private static boolean handleToggle() {
        boolean newState = !FishyConfig.getState(KEY, false);
        FishyConfig.enable(KEY, newState);
        String status = newState ? "\u00a7aenabled" : "\u00a7cdisabled";
        String msgStart = "\u00a73Profit Tracker " + status;
        TrackerUtils.refresh();
        if (newState && TrackerProfiles.hasJsonFile()) {
            if (TrackerProfiles.loadFromJson()) {
                FishyNotis.send((class_2561)class_2561.method_43470((String)(msgStart + " \u00a77(loaded from file)")));
            } else {
                FishyNotis.send((class_2561)class_2561.method_43470((String)msgStart));
            }
        } else {
            FishyNotis.send((class_2561)class_2561.method_43470((String)msgStart));
        }
        return true;
    }

    private static boolean handlePriceType(String[] args) {
        String newType;
        String typeArg;
        if (args.length < 2) {
            FishyNotis.themed("Usage: /fp type \u00a73<insta_sell | sell_offer>");
            return false;
        }
        switch (typeArg = args[1].toLowerCase()) {
            case "insta_sell": {
                newType = "sellPrice";
                break;
            }
            case "sell_offer": {
                newType = "buyPrice";
                break;
            }
            default: {
                FishyNotis.warn("Invalid type! Use 'insta_sell' or 'sell_offer'.");
                return false;
            }
        }
        HypixelPriceClient.setPriceType(newType);
        FishyConfig.setString("priceType", newType);
        ItemTrackerData.clearValueCache();
        ItemTrackerData.refreshPrices();
        FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a7bPrice type set to \u00a73%s", newType)));
        return true;
    }

    private static boolean handleClear() {
        ItemTrackerData.clearAll();
        FishyNotis.send("Profit Tracker data cleared");
        return true;
    }

    private static boolean handleStats() {
        Map<String, Integer> items = ItemTrackerData.getAllItems();
        if (items.isEmpty()) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77No items tracked this session. Use \u00a73/fp toggle \u00a77to enable, \u00a73/fp \u00a77to see available commands."));
            return false;
        }
        long sessionTime = ItemTrackerData.getTotalDurationMinutes();
        int totalItems = ItemTrackerData.getTotalItemCount();
        double totalValue = ItemTrackerData.getTotalSessionValue();
        FishyNotis.themed("\u03b1 Profit Tracker Stats \u03b1");
        Object sessionTimeDisplay = String.format("\u00a77Playtime: \u00a73%d h", sessionTime / 60L);
        if (ItemTrackerData.isCurrentlyPaused()) {
            long inactiveMinutes = ItemTrackerData.getInactiveMinutes();
            sessionTimeDisplay = (String)sessionTimeDisplay + String.format(" \u00a78(paused for %d min)", inactiveMinutes);
        }
        FishyNotis.alert((class_2561)class_2561.method_43470((String)sessionTimeDisplay));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Total items: \u00a73%d", totalItems)));
        if (totalValue > 0.0) {
            String valueStr = ProfitTrackerCommand.formatCoins(totalValue);
            long lastApiUpdate = ItemTrackerData.getLastApiUpdateTime();
            boolean hasRecentData = lastApiUpdate > 0L && System.currentTimeMillis() - lastApiUpdate < 300000L;
            String apiStatus = hasRecentData ? " \u00a7a(live prices)" : " \u00a7c(estimated)";
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Value: \u00a7e%s%s", valueStr, apiStatus)));
        }
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Top items (by value):"));
        HypixelPriceClient priceClient = ItemTrackerData.getPriceClient();
        items.entrySet().stream().map(entry -> {
            String itemName = (String)entry.getKey();
            int quantity = (Integer)entry.getValue();
            double unitPrice = 0.0;
            if (priceClient != null) {
                if (priceClient.hasBazaarData(itemName)) {
                    unitPrice = priceClient.getBazaarBuyPrice(itemName);
                } else if (priceClient.hasAuctionData(itemName)) {
                    unitPrice = priceClient.getCachedAuctionPrice(itemName);
                }
            }
            double itemTotal = unitPrice * (double)quantity;
            return new ItemDisplayData(itemName, quantity, unitPrice, itemTotal);
        }).filter(data -> data.totalValue > 0.0).sorted((a, b) -> Double.compare(b.totalValue, a.totalValue)).limit(5L).forEach(data -> {
            String itemName = ProfitTrackerCommand.capitalizeItemName(data.itemName);
            String unitValueStr = ProfitTrackerCommand.formatCoins(data.unitPrice);
            String totalValueStr = ProfitTrackerCommand.formatCoins(data.totalValue);
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("  \u00a7a+%d \u00a7f%s \u00a77(\u00a7e%s\u00a77 each, \u00a7b%s\u00a77 total)", data.quantity, itemName, unitValueStr, totalValueStr)));
        });
        return true;
    }

    private static boolean handleInit() {
        ProfitTrackerCommand.initTracking();
        FishyNotis.notice("Initialized price client");
        return true;
    }

    private static void initTracking() {
        ItemTrackerData.init();
        HypixelPriceClient priceClient = ItemTrackerData.getPriceClient();
        if (priceClient != null) {
            priceClient.clearAuctionCache();
        }
        ItemTrackerData.updateAllAsync();
    }

    private static boolean handleRefresh() {
        ItemTrackerData.refreshPrices();
        FishyNotis.notice("\u00a7b\u00a7oRefreshing prices...");
        return true;
    }

    private static boolean handleStatus() {
        long minutes;
        long lastBazaar = ItemTrackerData.getLastBazaarUpdateTime();
        long lastAuction = ItemTrackerData.getLastAuctionUpdateTime();
        FishyNotis.themed("  \u03b1 API Status \u03b1  ");
        FishyNotis.alert((class_2561)class_2561.method_43470((String)("\u00a77Price type: \u00a73" + HypixelPriceClient.getType())));
        if (lastBazaar > 0L) {
            minutes = (System.currentTimeMillis() - lastBazaar) / 60000L;
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Bazaar: \u00a7a\u2713 \u00a77(%d min ago)", minutes)));
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Bazaar: \u00a7c\u2717"));
        }
        if (lastAuction > 0L) {
            minutes = (System.currentTimeMillis() - lastAuction) / 60000L;
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Auctions: \u00a7a\u2713 \u00a77(%d min ago)", minutes)));
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Auctions: \u00a7c\u2717 \u00a77(on-demand)"));
        }
        return true;
    }

    private static boolean handleProfile(String[] args) {
        if (args.length < 2) {
            ProfitTrackerCommand.sendProfileClickable();
            return true;
        }
        String action = args[1].toLowerCase();
        if ("delete".equals(action)) {
            return ProfitTrackerCommand.profileDelete(args);
        }
        if ("rename".equals(action)) {
            return ProfitTrackerCommand.profileRename(args);
        }
        return ProfitTrackerCommand.profileSwitchOrCreate(args[1]);
    }

    private static boolean profileDelete(String[] args) {
        if (args.length < 3) {
            FishyNotis.themed("Usage: \u00a73/fp profile delete <name>");
            return false;
        }
        String profileToDelete = args[2];
        if ("default".equals(profileToDelete)) {
            FishyNotis.warn("Cannot delete the default profile!");
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a73/fp clear \u00a77if you wish to reset the session."));
            return false;
        }
        if (TrackerProfiles.deleteProfile(profileToDelete)) {
            TrackerUtils.onDelete(profileToDelete);
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)("\u00a7cProfile '" + profileToDelete + "' not found or cannot be deleted")));
        }
        return true;
    }

    private static boolean profileRename(String[] args) {
        if (args.length < 4) {
            FishyNotis.themed("Usage: \u00a73/fp profile rename <old_name> <new_name>");
            return false;
        }
        String oldName = args[2];
        String newName = args[3];
        if (TrackerProfiles.renameProfile(oldName, newName)) {
            TrackerProfiles.setCurrentProfile(newName);
            FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a7aRenamed profile \u00a7b" + oldName + " \u00a7ato \u00a7b" + newName)));
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cInvalid profile name or profile not found"));
        }
        return true;
    }

    private static boolean profileSwitchOrCreate(String profileName) {
        String currentProfile;
        if (!FishyConfig.getState(KEY, false)) {
            FishyConfig.enable(KEY, true);
            ProfitTrackerCommand.initTracking();
        }
        if (!"default".equals(currentProfile = TrackerProfiles.getCurrentProfile())) {
            TrackerProfiles.saveToJson();
        }
        if (profileName.equals(currentProfile)) {
            FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a77Already using profile: \u00a73" + profileName)));
            return true;
        }
        List<String> availableProfiles = TrackerProfiles.getAvailableProfiles();
        if (availableProfiles.contains(profileName.toLowerCase())) {
            TrackerProfiles.setCurrentProfile(profileName);
            FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a7dSwitched to profile: \u00a73" + profileName)));
        } else if (TrackerProfiles.createProfile(profileName)) {
            FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a7aCreated and switched to new profile: \u00a73" + profileName)));
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)("\u00a7cFailed to create profile: " + profileName)));
            return false;
        }
        return true;
    }

    public static void sendProfileClickable() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return;
        }
        String currentProfile = TrackerProfiles.getCurrentProfile();
        List<String> availableProfiles = TrackerProfiles.getAvailableProfiles();
        FishyNotis.alert((class_2561)class_2561.method_43470((String)("\u00a7b\u00a7lCurrent Profile: \u00a73" + currentProfile)));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73Click chat to switch to an existing profile:"));
        for (String profile : availableProfiles) {
            String marker = profile.equals(currentProfile) ? "\u00a7a\u25b6 " : "\u00a78  ";
            class_5250 clickableProfile = class_2561.method_43470((String)(marker + "\u00a77" + profile)).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/fp profile " + profile)));
            FishyNotis.alert((class_2561)clickableProfile);
        }
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73  /fp profile <name> \u00a78- \u00a7bSwitch to or create profile"));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73  /fp profile delete <name> \u00a78- \u00a7bDelete profile"));
    }

    private static boolean handlePrice(String[] args) {
        if (args.length < 2) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cUsage: /fp price [amount] <item>"));
            return false;
        }
        PriceQuery priceQuery = ProfitTrackerCommand.parsePriceArgs(args[1]);
        if (!priceQuery.isValid) {
            return false;
        }
        ProfitTrackerCommand.displayPriceQueryHeader(priceQuery);
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77\u00a7oSearching..."));
        ItemTrackerData.getItemValueAsync(priceQuery.itemName, (value, source) -> ProfitTrackerCommand.handlePriceAsyncCallback(value, source, priceQuery.amount));
        return true;
    }

    private static PriceQuery parsePriceArgs(String arg) {
        String[] splitArgs = arg.split(" ");
        int amount = 1;
        int itemStartIndex = 0;
        if (splitArgs.length > 1) {
            try {
                amount = Integer.parseInt(splitArgs[0]);
                if (amount <= 0) {
                    FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a7cAmount must be a positive number"));
                    return new PriceQuery(1, "", false);
                }
                itemStartIndex = 1;
                if (splitArgs.length < 2) {
                    FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a7cUsage: /fp price [amount] <item>"));
                    return new PriceQuery(1, "", false);
                }
            }
            catch (NumberFormatException e) {
                amount = 1;
                itemStartIndex = 0;
            }
        }
        StringBuilder itemName = new StringBuilder();
        for (int i = itemStartIndex; i < splitArgs.length; ++i) {
            if (i > itemStartIndex) {
                itemName.append(" ");
            }
            itemName.append(splitArgs[i]);
        }
        return new PriceQuery(amount, itemName.toString(), true);
    }

    private static void displayPriceQueryHeader(PriceQuery priceQuery) {
        if (priceQuery.amount > 1) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a7bPrice for \u00a73%dx %s", priceQuery.amount, priceQuery.itemName)));
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a7bPrice for \u00a73%s", priceQuery.itemName)));
        }
    }

    private static void handlePriceAsyncCallback(double value, String source, int amount) {
        if (value > 0.0) {
            double totalValue = value * (double)amount;
            if (amount > 1) {
                FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77[%s] \u00a7e%s \u00a77each", source, ProfitTrackerCommand.formatCoins(value))));
                FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Total: \u00a7e%s", ProfitTrackerCommand.formatCoins(totalValue))));
            } else {
                FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77[%s] \u00a7e%s", source, ProfitTrackerCommand.formatCoins(value))));
            }
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cNo price data found"));
        }
    }

    private static String formatCoins(double coins) {
        if (coins >= 1000000.0) {
            return String.format("%.1fm", coins / 1000000.0);
        }
        if (coins >= 1000.0) {
            return String.format("%.1fk", coins / 1000.0);
        }
        return String.format("%.0f", coins);
    }

    private static boolean handleIgnored() {
        TrackerDisplay trackerInstance = TrackerDisplay.getInstance();
        if (trackerInstance == null) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cTracker display not initialized"));
            return false;
        }
        Set<String> excludedItems = trackerInstance.getExcludedItemsForDisplay();
        if (excludedItems.isEmpty()) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77No items are currently ignored"));
            return true;
        }
        FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a7b\u00a7lIgnored Items:"));
        for (String itemName : excludedItems) {
            String displayName = ProfitTrackerCommand.capitalizeItemName(itemName);
            class_5250 clickableItem = class_2561.method_43470((String)("\u00a78      - \u00a7f" + displayName + " \u00a7a[\u27f3]")).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/fp restore \"" + itemName + "\"")));
            FishyNotis.alert((class_2561)clickableItem);
        }
        class_5250 restoreAllText = class_2561.method_43470((String)"\u00a7         [Restore All Items]").method_27692(class_124.field_1076).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/fp restore all")));
        FishyNotis.alert((class_2561)restoreAllText);
        return true;
    }

    private static boolean handleRestore(String[] args) {
        TrackerDisplay trackerInstance = TrackerDisplay.getInstance();
        if (trackerInstance == null) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cTracker display not initialized"));
            return false;
        }
        if (args.length < 2) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cUsage: /fp restore <item_name> or /fp restore all"));
            return false;
        }
        String restoreTarget = args[1];
        if ("all".equals(restoreTarget)) {
            trackerInstance.restoreAllExcludedItems();
            return true;
        }
        if (restoreTarget.startsWith("\"") && restoreTarget.endsWith("\"")) {
            restoreTarget = restoreTarget.substring(1, restoreTarget.length() - 1);
        }
        if (!trackerInstance.getExcludedItemsForDisplay().contains(restoreTarget)) {
            String displayName = ProfitTrackerCommand.capitalizeItemName(restoreTarget);
            FishyNotis.alert((class_2561)class_2561.method_43470((String)("\u00a7c" + displayName + " is not in the ignored list")));
            return false;
        }
        trackerInstance.restoreExcludedItem(restoreTarget);
        return true;
    }

    private static String capitalizeItemName(String itemName) {
        if (itemName == null || itemName.isEmpty()) {
            return itemName;
        }
        String[] words = itemName.split(" ");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word;
            if (i > 0) {
                result.append(" ");
            }
            if ((word = words[i]).isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            result.append(word.substring(1));
        }
        return result.toString();
    }

    @Environment(value=EnvType.CLIENT)
    private static class PriceQuery {
        final int amount;
        final String itemName;
        final boolean isValid;

        PriceQuery(int amount, String itemName, boolean isValid) {
            this.amount = amount;
            this.itemName = itemName;
            this.isValid = isValid;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class ItemDisplayData {
        final String itemName;
        final int quantity;
        final double unitPrice;
        final double totalValue;

        ItemDisplayData(String itemName, int quantity, double unitPrice, double totalValue) {
            this.itemName = itemName;
            this.quantity = quantity;
            this.unitPrice = unitPrice;
            this.totalValue = totalValue;
        }
    }
}

