/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import me.valkeea.fishyaddons.config.FishyConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class FishyPresets {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Map<String, String> EXAMPLE_COMMANDS_PRESET = Map.of("/m7", "/joininstance MASTER_CATACOMBS_FLOOR_SEVEN", "/m6", "/joininstance MASTER_CATACOMBS_FLOOR_SIX", "/m5", "/joininstance MASTER_CATACOMBS_FLOOR_FIVE", "/m4", "/joininstance MASTER_CATACOMBS_FLOOR_FOUR", "/m3", "/joininstance MASTER_CATACOMBS_FLOOR_THREE", "/m2", "/joininstance MASTER_CATACOMBS_FLOOR_TWO", "/m1", "/joininstance MASTER_CATACOMBS_FLOOR_ONE");
    public static final Map<String, String> EXAMPLE_KEYBINDS_PRESET = Map.of("MOUSE3", "/pets", "MOUSE4", "/wardrobe", "GLFW_KEY_B", "/wardrobe");
    public static final Map<String, String> EXAMPLE_CHAT_PRESET = Map.of(":cat:", "\u15e2\u160f\u14d7", ":hi:", "\u0d9e", "<3", "\u2764", ":star", "\u272e", ":yes:", "\u2714", ":no:", "\u2716", ":java:", "\u2615", ":arrow:", "\u279c", ":shrug:", "\u00af\\_(\u30c4)_/\u00af", ":tableflip:", "(\u256f\u00b0\u25a1\u00b0\uff09\u256f\ufe35 \u253b\u2501\u253b");
    public static final Map<String, FishyConfig.AlertData> EXAMPLE_ALERT_PRESET = Map.of("This is what will be detected from chat.", new FishyConfig.AlertData("this is what you will send in chat!", "Title Screen Alert", 0xFF00FF, "minecraft:entity.player.levelup", 1.0f, true));

    public static Path getPresetPath(PresetType type) {
        String name = switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "commands";
            case 1 -> "keybinds";
            case 2 -> "chat";
            case 3 -> "alert";
        };
        return Paths.get("config", "fishyaddons", "preset", name + ".json");
    }

    public static Path getPresetDir() {
        return Paths.get("config", "fishyaddons", "preset");
    }

    public static List<String> listPresetSuffixes(PresetType type) {
        ArrayList<String> result = new ArrayList<String>();
        Path dir = FishyPresets.getPresetDir();
        if (!Files.exists(dir, new LinkOption[0])) {
            return result;
        }
        try (Stream<Path> stream = Files.list(dir);){
            Pattern pattern = Pattern.compile("preset\\." + Pattern.quote(FishyPresets.getTypeName(type)) + "\\.(.+)\\.json");
            stream.forEach(path -> {
                String fileName = path.getFileName().toString();
                Matcher matcher = pattern.matcher(fileName);
                if (matcher.matches()) {
                    result.add(matcher.group(1));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getTypeName(PresetType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "commands";
            case 1 -> "keybinds";
            case 2 -> "chat";
            case 3 -> "alert";
        };
    }

    public static void ensureDefaultPresets() {
        FishyPresets.ensureDefaultCommandsPreset();
    }

    private static void ensureDefaultCommandsPreset() {
        Path path = FishyPresets.getPresetDir().resolve("preset.commands.default.json");
        if (!Files.exists(path, new LinkOption[0])) {
            FishyPresets.saveStringPreset(PresetType.COMMANDS, "mastermode", EXAMPLE_COMMANDS_PRESET);
            FishyPresets.saveStringPreset(PresetType.KEYBINDS, "example", EXAMPLE_KEYBINDS_PRESET);
            FishyPresets.saveStringPreset(PresetType.CHAT, "hypixel", EXAMPLE_CHAT_PRESET);
            FishyPresets.saveAlertPreset("example", EXAMPLE_ALERT_PRESET);
            System.out.println("Default presets created in " + String.valueOf(path.getParent()));
        }
    }

    public static Map<String, String> loadStringPreset(PresetType type, String suffix) {
        Path path = FishyPresets.getPresetDir().resolve("preset." + FishyPresets.getTypeName(type) + "." + suffix + ".json");
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            String json = Files.readString(path);
            return (Map)GSON.fromJson(json, new TypeToken<Map<String, String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, FishyConfig.AlertData> loadAlertPreset(String suffix) {
        Path path = FishyPresets.getPresetDir().resolve("preset.alert." + suffix + ".json");
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            String json = Files.readString(path);
            return (Map)GSON.fromJson(json, new TypeToken<Map<String, FishyConfig.AlertData>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void saveStringPreset(PresetType type, String suffix, Map<String, String> data) {
        Path path = FishyPresets.getPresetDir().resolve("preset." + FishyPresets.getTypeName(type) + "." + suffix + ".json");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)GSON.toJson(data), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void saveAlertPreset(String suffix, Map<String, FishyConfig.AlertData> data) {
        Path path = FishyPresets.getPresetDir().resolve("preset.alert." + suffix + ".json");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)GSON.toJson(data), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum PresetType {
        COMMANDS,
        KEYBINDS,
        CHAT,
        ALERT;

    }
}

