/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.valkeea.fishyaddons.handler.GuiIcons;
import me.valkeea.fishyaddons.safeguard.BlacklistManager;
import me.valkeea.fishyaddons.util.TextFormatUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ItemConfig {
    private static final File CONFIG_FILE;
    private static final File BACKUP_DIR;
    private static final File BACKUP_FILE;
    private static final Gson GSON;
    private static final String LOCKED_PREFIX = "locked_";
    private static final String BOUND_PREFIX = "bound_";
    private static final String TEXTURE_PREFIX = "texture_";
    private static final String ITEM_PREFIX = "item_";
    private static final String GUIICONS_SCREEN_NAMES = "guiicons_screenNames";
    private static final String GUIICONS_SCREEN_SLOT_MAP = "guiicons_screenSlotMap";
    public static final SimpleConfigSection<Object> settings;
    public static final SimpleConfigSection<String> protectedItems;
    public static final SimpleConfigSection<Integer> slotData;
    public static final SimpleConfigSection<String> equipmentData;
    public static final SimpleConfigSection<Object> blacklistData;
    private static boolean firstLoad;
    private static boolean recreatedConfig;
    private static boolean restoredConfig;
    private static boolean configChanged;

    private ItemConfig() {
    }

    public static boolean isFirstLoad() {
        return firstLoad;
    }

    public static boolean isRecreated() {
        return recreatedConfig;
    }

    public static boolean isRestored() {
        return restoredConfig;
    }

    public static void resetFlags() {
        recreatedConfig = false;
        restoredConfig = false;
        firstLoad = false;
    }

    public static void init() {
        CONFIG_FILE.getParentFile().mkdirs();
        BACKUP_DIR.mkdirs();
        ItemConfig.load();
        if (firstLoad) {
            settings.set("sellProtectionEnabled", true);
            settings.set("tooltipEnabled", true);
            settings.set("protectTriggerEnabled", true);
            settings.set("protectNotiEnabled", true);
            settings.set("lockTriggerEnabled", true);
            ItemConfig.save();
        }
    }

    public static void markConfigChanged() {
        configChanged = true;
    }

    public static void saveConfigIfNeeded() {
        if (configChanged) {
            ItemConfig.save();
            configChanged = false;
        }
    }

    public static synchronized void load() {
        if (!CONFIG_FILE.exists()) {
            System.err.println("[ItemConfig] Config file does not exist. Checking for backup...");
            ItemConfig.loadOrRestore();
            firstLoad = true;
            return;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(CONFIG_FILE), StandardCharsets.UTF_8);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (!ItemConfig.validate(json)) {
                System.err.println("[ItemConfig] Invalid config detected. Attempting to restore from backup...");
                ItemConfig.loadOrRestore();
                return;
            }
            settings.loadFromJson(json);
            if (json.has("protectedUUIDs")) {
                JsonElement element = json.get("protectedUUIDs");
                if (element.isJsonObject()) {
                    protectedItems.loadFromJson(json);
                } else if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    for (JsonElement item : array) {
                        if (!item.isJsonPrimitive()) continue;
                        String uuid = item.getAsString();
                        protectedItems.set(uuid, "Protected Item");
                    }
                }
            }
            ItemConfig.loadSlotData(json);
            ItemConfig.loadEquipmentData(json);
            ItemConfig.loadBlacklistData(json);
            ItemConfig.loadGuiIconsConfig(json);
        }
        catch (JsonIOException | JsonSyntaxException e) {
            System.err.println("[ItemConfig] JSON parsing error: " + e.getMessage());
            ItemConfig.loadOrRestore();
        }
        catch (IOException e) {
            System.err.println("[ItemConfig] IO error loading config: " + e.getMessage());
            ItemConfig.loadOrRestore();
        }
    }

    private static void loadSlotData(JsonObject json) {
        ItemConfig.loadLockedSlots(json);
        ItemConfig.loadBoundSlots(json);
    }

    private static void loadLockedSlots(JsonObject json) {
        JsonElement element;
        if (json.has("lockedSlots") && (element = json.get("lockedSlots")).isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            for (JsonElement item : array) {
                if (!item.isJsonPrimitive() || !item.getAsJsonPrimitive().isNumber()) continue;
                int slot = item.getAsInt();
                slotData.set(LOCKED_PREFIX + slot, slot);
            }
        }
    }

    private static void loadBoundSlots(JsonObject json) {
        JsonElement element;
        if (json.has("boundSlots") && (element = json.get("boundSlots")).isJsonObject()) {
            JsonObject boundObj = element.getAsJsonObject();
            for (Map.Entry entry : boundObj.entrySet()) {
                try {
                    int from = Integer.parseInt((String)entry.getKey());
                    int to = ((JsonElement)entry.getValue()).getAsInt();
                    slotData.set(BOUND_PREFIX + from, to);
                    slotData.set(BOUND_PREFIX + to, from);
                }
                catch (NumberFormatException e) {
                    System.err.println("[ItemConfig] Invalid bound slot key: " + (String)entry.getKey());
                }
            }
        }
    }

    private static void loadEquipmentData(JsonObject json) {
        ItemConfig.loadEquipmentTextures(json);
        ItemConfig.loadEquipmentItems(json);
    }

    private static void loadEquipmentTextures(JsonObject json) {
        JsonElement element;
        if (json.has("equipmentSkullTextures") && (element = json.get("equipmentSkullTextures")).isJsonObject()) {
            JsonObject texturesObj = element.getAsJsonObject();
            for (Map.Entry entry : texturesObj.entrySet()) {
                try {
                    int slot = Integer.parseInt((String)entry.getKey());
                    String texture = ((JsonElement)entry.getValue()).getAsString();
                    equipmentData.set(TEXTURE_PREFIX + slot, texture);
                }
                catch (NumberFormatException e) {
                    System.err.println("[ItemConfig] Invalid equipment texture slot: " + (String)entry.getKey());
                }
            }
        }
    }

    private static void loadEquipmentItems(JsonObject json) {
        JsonElement element;
        if (json.has("equipmentSkullItems") && (element = json.get("equipmentSkullItems")).isJsonObject()) {
            JsonObject itemsObj = element.getAsJsonObject();
            for (Map.Entry entry : itemsObj.entrySet()) {
                try {
                    int slot = Integer.parseInt((String)entry.getKey());
                    String itemData = ((JsonElement)entry.getValue()).getAsString();
                    equipmentData.set(ITEM_PREFIX + slot, itemData);
                }
                catch (NumberFormatException e) {
                    System.err.println("[ItemConfig] Invalid equipment item slot: " + (String)entry.getKey());
                }
            }
        }
    }

    private static void loadBlacklistData(JsonObject json) {
        JsonElement element;
        if (json.has("blacklist") && (element = json.get("blacklist")).isJsonArray()) {
            List<Map<String, Object>> entries = ItemConfig.parseBlacklistArray(element.getAsJsonArray());
            BlacklistManager.loadUserBlacklistFromJson(entries);
        }
    }

    private static List<Map<String, Object>> parseBlacklistArray(JsonArray array) {
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>();
        for (JsonElement item : array) {
            if (!item.isJsonObject()) continue;
            Map<String, Object> entry = ItemConfig.parseBlacklistObject(item.getAsJsonObject());
            entries.add(entry);
        }
        return entries;
    }

    private static Map<String, Object> parseBlacklistObject(JsonObject obj) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        for (Map.Entry e : obj.entrySet()) {
            JsonElement value = (JsonElement)e.getValue();
            if (!value.isJsonPrimitive()) continue;
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            if (primitive.isString()) {
                entry.put((String)e.getKey(), primitive.getAsString());
                continue;
            }
            if (primitive.isNumber()) {
                entry.put((String)e.getKey(), primitive.getAsNumber());
                continue;
            }
            if (!primitive.isBoolean()) continue;
            entry.put((String)e.getKey(), primitive.getAsBoolean());
        }
        return entry;
    }

    private static void loadGuiIconsConfig(JsonObject json) {
        Map map;
        JsonElement element;
        Set names;
        if (json.has(GUIICONS_SCREEN_NAMES) && (names = (Set)GSON.fromJson(element = json.get(GUIICONS_SCREEN_NAMES), new TypeToken<Set<String>>(){}.getType())) != null) {
            GuiIcons.setScreenNames(names);
        }
        if (json.has(GUIICONS_SCREEN_SLOT_MAP) && (map = (Map)GSON.fromJson(element = json.get(GUIICONS_SCREEN_SLOT_MAP), new TypeToken<Map<String, Set<Integer>>>(){}.getType())) != null) {
            GuiIcons.setScreenSlotMap(map);
        }
    }

    public static synchronized void save() {
        JsonObject json = new JsonObject();
        settings.saveToJson(json);
        protectedItems.saveToJson(json);
        ItemConfig.saveSlotData(json);
        ItemConfig.saveEquipmentData(json);
        ItemConfig.saveGuiIconsConfig(json);
        List<Map<String, Object>> serializedBlacklist = BlacklistManager.getUserBlacklistAsJson();
        json.add("blacklist", GSON.toJsonTree(serializedBlacklist));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(CONFIG_FILE), StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[ItemConfig] Failed to save config: " + e.getMessage());
        }
    }

    private static void saveSlotData(JsonObject json) {
        ArrayList<Integer> lockedSlots = new ArrayList<Integer>();
        HashMap<Integer, Integer> boundSlots = new HashMap<Integer, Integer>();
        for (Map.Entry<String, Integer> entry : slotData.getValues().entrySet()) {
            String key = entry.getKey();
            Integer value = entry.getValue();
            if (key.startsWith(LOCKED_PREFIX)) {
                lockedSlots.add(value);
                continue;
            }
            if (!key.startsWith(BOUND_PREFIX)) continue;
            try {
                int slot = Integer.parseInt(key.substring(BOUND_PREFIX.length()));
                boundSlots.put(slot, value);
            }
            catch (NumberFormatException e) {
                System.err.println("[ItemConfig] Invalid bound slot key format: " + key);
            }
        }
        json.add("lockedSlots", GSON.toJsonTree(lockedSlots));
        HashMap<Integer, Integer> filteredBoundSlots = new HashMap<Integer, Integer>();
        for (Map.Entry entry : boundSlots.entrySet()) {
            int to;
            int from = (Integer)entry.getKey();
            if (from >= (to = ((Integer)entry.getValue()).intValue())) continue;
            filteredBoundSlots.put(from, to);
        }
        json.add("boundSlots", GSON.toJsonTree(filteredBoundSlots));
    }

    private static void saveEquipmentData(JsonObject json) {
        HashMap<String, String> textures = new HashMap<String, String>();
        HashMap<String, String> items = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : equipmentData.getValues().entrySet()) {
            String slotStr;
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith(TEXTURE_PREFIX)) {
                slotStr = key.substring(TEXTURE_PREFIX.length());
                textures.put(slotStr, value);
                continue;
            }
            if (!key.startsWith(ITEM_PREFIX)) continue;
            slotStr = key.substring(ITEM_PREFIX.length());
            items.put(slotStr, value);
        }
        json.add("equipmentSkullTextures", GSON.toJsonTree(textures));
        json.add("equipmentSkullItems", GSON.toJsonTree(items));
    }

    public static void saveBackup() {
        try {
            if (CONFIG_FILE.exists()) {
                Files.copy(CONFIG_FILE.toPath(), BACKUP_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            System.err.println("[ItemConfig] Failed to save backup: " + e.getMessage());
        }
    }

    private static boolean validate(JsonObject json) {
        return json != null && json.size() > 0;
    }

    private static void loadOrRestore() {
        if (BACKUP_FILE.exists()) {
            System.err.println("[ItemConfig] Restoring from backup...");
            try {
                Files.copy(BACKUP_FILE.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ItemConfig.load();
                restoredConfig = true;
                return;
            }
            catch (IOException e) {
                System.err.println("[ItemConfig] Failed to restore from backup: " + e.getMessage());
            }
        }
        System.err.println("[ItemConfig] No backup found. Creating default config...");
        ItemConfig.save();
        recreatedConfig = true;
    }

    private static void saveGuiIconsConfig(JsonObject json) {
        Set<String> names = GuiIcons.getScreenNames();
        Map<String, Set<Integer>> map = GuiIcons.getScreenSlotMap();
        json.add(GUIICONS_SCREEN_NAMES, GSON.toJsonTree(names));
        json.add(GUIICONS_SCREEN_SLOT_MAP, GSON.toJsonTree(map));
    }

    public static boolean getState(String key, boolean def) {
        boolean bl;
        Object v = settings.getValues().getOrDefault(key, def);
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            bl = b;
        } else {
            bl = def;
        }
        return bl;
    }

    public static void enable(String key, boolean enabled) {
        settings.set(key, enabled);
        ItemConfig.save();
    }

    public static void disable(String key) {
        settings.set(key, false);
        ItemConfig.save();
    }

    public static void toggle(String key, boolean def) {
        boolean current = ItemConfig.getState(key, def);
        ItemConfig.enable(key, !current);
    }

    public static int getInt(String key, int def) {
        int n;
        Object v = settings.getValues().getOrDefault(key, def);
        if (v instanceof Number) {
            Number n2 = (Number)v;
            n = n2.intValue();
        } else {
            n = def;
        }
        return n;
    }

    public static void setInt(String key, int value) {
        settings.set(key, value);
        ItemConfig.save();
    }

    public static String getString(String key, String def) {
        String str;
        Object v = settings.getValues().getOrDefault(key, def);
        return v instanceof String ? (str = (String)v) : def;
    }

    public static void setString(String key, String value) {
        settings.set(key, value);
        ItemConfig.save();
    }

    public static float getFloat(String key, float def) {
        float f;
        Object v = settings.getValues().getOrDefault(key, Float.valueOf(def));
        if (v instanceof Number) {
            Number n = (Number)v;
            f = n.floatValue();
        } else {
            f = def;
        }
        return f;
    }

    public static void setFloat(String key, float value) {
        settings.set(key, Float.valueOf(value));
        ItemConfig.save();
    }

    public static boolean isSellProtectionEnabled() {
        return ItemConfig.getState("sellProtectionEnabled", true);
    }

    public static void setSellProtectionEnabled(boolean enabled) {
        ItemConfig.enable("sellProtectionEnabled", enabled);
    }

    public static boolean isTooltipEnabled() {
        return ItemConfig.getState("tooltipEnabled", true);
    }

    public static void setTooltipEnabled(boolean enabled) {
        ItemConfig.enable("tooltipEnabled", enabled);
    }

    public static boolean isProtectTriggerEnabled() {
        return ItemConfig.getState("protectTriggerEnabled", true);
    }

    public static void setProtectTriggerEnabled(boolean enabled) {
        ItemConfig.enable("protectTriggerEnabled", enabled);
    }

    public static boolean isProtectNotiEnabled() {
        return ItemConfig.getState("protectNotiEnabled", true);
    }

    public static void setProtectNotiEnabled(boolean enabled) {
        ItemConfig.enable("protectNotiEnabled", enabled);
    }

    public static boolean isLockTriggerEnabled() {
        return ItemConfig.getState("lockTriggerEnabled", true);
    }

    public static void setLockTriggerEnabled(boolean enabled) {
        ItemConfig.enable("lockTriggerEnabled", enabled);
    }

    public static synchronized void addUUID(String uuid, class_2561 displayName) {
        String serialized = TextFormatUtil.serialize(displayName);
        protectedItems.set(uuid, serialized);
        ItemConfig.save();
    }

    public static synchronized void removeUUID(String uuid) {
        protectedItems.remove(uuid);
        ItemConfig.save();
    }

    public static synchronized void clearAll() {
        protectedItems.clear();
        ItemConfig.save();
    }

    public static synchronized boolean isProtected(String uuid) {
        return protectedItems.getValues().containsKey(uuid);
    }

    public static synchronized class_2561 getDisplayName(String uuid) {
        String serialized = protectedItems.getValues().get(uuid);
        return serialized != null ? TextFormatUtil.deserialize(serialized) : null;
    }

    public static synchronized Map<String, String> getProtectedUUIDs() {
        return new HashMap<String, String>(protectedItems.getValues());
    }

    public static synchronized boolean isSlotLocked(int slot) {
        return slotData.getValues().containsKey(LOCKED_PREFIX + slot);
    }

    public static synchronized void toggleSlotLock(int slot) {
        String key = LOCKED_PREFIX + slot;
        if (slotData.getValues().containsKey(key)) {
            slotData.remove(key);
        } else {
            slotData.set(key, slot);
        }
        ItemConfig.save();
    }

    public static synchronized boolean areSlotsBound(int slotA, int slotB) {
        Integer boundSlotA = slotData.getValues().get(BOUND_PREFIX + slotA);
        return boundSlotA != null && boundSlotA == slotB;
    }

    public static synchronized boolean isSlotBound(int slot) {
        return slotData.getValues().containsKey(BOUND_PREFIX + slot);
    }

    public static synchronized int getBoundSlot(int slot) {
        Integer bound = slotData.getValues().get(BOUND_PREFIX + slot);
        return bound != null ? bound : -1;
    }

    public static synchronized void bindSlots(int slotA, int slotB) {
        slotData.set(BOUND_PREFIX + slotA, slotB);
        slotData.set(BOUND_PREFIX + slotB, slotA);
        ItemConfig.save();
    }

    public static synchronized void unbindSlots(int slotA, int slotB) {
        slotData.remove(BOUND_PREFIX + slotA);
        slotData.remove(BOUND_PREFIX + slotB);
        ItemConfig.save();
    }

    public static synchronized void setEqSkull(int slot, String textureUrl) {
        String key = TEXTURE_PREFIX + slot;
        if (textureUrl == null) {
            equipmentData.remove(key);
        } else {
            equipmentData.set(key, textureUrl);
        }
        ItemConfig.save();
    }

    public static synchronized String getEquipmentSkullTexture(int slot) {
        return equipmentData.getValues().get(TEXTURE_PREFIX + slot);
    }

    public static synchronized void setEqItemData(int slot, String itemData) {
        String key = ITEM_PREFIX + slot;
        if (itemData == null) {
            equipmentData.remove(key);
        } else {
            equipmentData.set(key, itemData);
        }
        ItemConfig.save();
    }

    public static synchronized String getEquipmentSkullItemData(int slot) {
        return equipmentData.getValues().get(ITEM_PREFIX + slot);
    }

    public static synchronized boolean hasEquipmentSkull(int slot) {
        return equipmentData.getValues().containsKey(TEXTURE_PREFIX + slot);
    }

    public static synchronized void clearEquipmentSkulls() {
        HashSet<String> keysToRemove = new HashSet<String>();
        for (String key : equipmentData.getValues().keySet()) {
            if (!key.startsWith(TEXTURE_PREFIX) && !key.startsWith(ITEM_PREFIX)) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            equipmentData.remove(key);
        }
        ItemConfig.save();
    }

    public static synchronized Map<Integer, String> getAllEquipmentSkullTextures() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (Map.Entry<String, String> entry : equipmentData.getValues().entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(TEXTURE_PREFIX)) continue;
            try {
                int slot = Integer.parseInt(key.substring(TEXTURE_PREFIX.length()));
                result.put(slot, entry.getValue());
            }
            catch (NumberFormatException e) {
                System.err.println("[ItemConfig] Invalid texture slot key: " + key);
            }
        }
        return result;
    }

    public static synchronized void clearEquipmentSlot(int slot) {
        equipmentData.remove(TEXTURE_PREFIX + slot);
        equipmentData.remove(ITEM_PREFIX + slot);
        ItemConfig.save();
    }

    public static void saveGuiIcons() {
        ItemConfig.save();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        settings = new SimpleConfigSection("settings", new TypeToken<Map<String, Object>>(){}.getType(), v -> ItemConfig.save());
        protectedItems = new SimpleConfigSection("protectedUUIDs", new TypeToken<Map<String, String>>(){}.getType(), v -> ItemConfig.save());
        slotData = new SimpleConfigSection("slotData", new TypeToken<Map<String, Integer>>(){}.getType(), v -> ItemConfig.save());
        equipmentData = new SimpleConfigSection("equipmentData", new TypeToken<Map<String, String>>(){}.getType(), v -> ItemConfig.save());
        blacklistData = new SimpleConfigSection("blacklist", new TypeToken<List<Map<String, Object>>>(){}.getType(), v -> ItemConfig.save());
        File root = new File(class_310.method_1551().field_1697, "config/fishyaddons");
        CONFIG_FILE = new File(root, "fishyitems.json");
        BACKUP_DIR = new File(root, "backup");
        BACKUP_FILE = new File(BACKUP_DIR, "fishyitems.json");
        firstLoad = false;
        recreatedConfig = false;
        restoredConfig = false;
        configChanged = false;
    }

    @Environment(value=EnvType.CLIENT)
    public static class SimpleConfigSection<V> {
        private final Map<String, V> values = new LinkedHashMap<String, V>();
        private final String valuesKey;
        private final Type valueType;
        private final Consumer<Void> onChange;

        public SimpleConfigSection(String valuesKey, Type valueType, Consumer<Void> onChange) {
            this.valuesKey = valuesKey;
            this.valueType = valueType;
            this.onChange = onChange;
        }

        public Map<String, V> getValues() {
            return this.values;
        }

        public void set(String key, V value) {
            if (key == null || key.isEmpty()) {
                return;
            }
            this.values.put(key, value);
            if (this.onChange != null) {
                this.onChange.accept(null);
            }
        }

        public void remove(String key) {
            if (key == null || key.isEmpty()) {
                return;
            }
            this.values.remove(key);
            if (this.onChange != null) {
                this.onChange.accept(null);
            }
        }

        public void clear() {
            this.values.clear();
            if (this.onChange != null) {
                this.onChange.accept(null);
            }
        }

        public void loadFromJson(JsonObject json) {
            JsonElement element;
            Map loaded;
            if (json.has(this.valuesKey) && (loaded = (Map)GSON.fromJson(element = json.get(this.valuesKey), this.valueType)) != null) {
                this.values.clear();
                this.values.putAll(loaded);
            }
        }

        public void saveToJson(JsonObject json) {
            json.add(this.valuesKey, GSON.toJsonTree(this.values));
        }
    }
}

