/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import me.valkeea.fishyaddons.tracker.ItemTrackerData;
import me.valkeea.fishyaddons.util.FishyNotis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class TrackerProfiles {
    private static final String TRACKER_BASE_PATH = "config/fishyaddons/tracker/";
    private static final String BACKUP_DIR = "config/fishyaddons/backup/tracker/";
    private static final String TRACKER_BASE = "profittracker_";
    private static final String JSON_EXTENSION = ".json";
    private static final String PROFILE_NAME_PATTERN = "[^a-z0-9_-]";
    private static final String DEFAULT_PROFILE = "default";
    private static String currentProfile = "default";

    public static void backupAll() {
        try {
            Path backupDir = Paths.get(BACKUP_DIR, new String[0]);
            Files.createDirectories(backupDir, new FileAttribute[0]);
            for (String profile : TrackerProfiles.getAvailableProfiles()) {
                Path src = Paths.get(TrackerProfiles.getTrackerFilePath(profile), new String[0]);
                if (!Files.exists(src, new LinkOption[0])) continue;
                String backupName = TRACKER_BASE + profile + JSON_EXTENSION;
                Path backupFile = backupDir.resolve(backupName);
                Files.copy(src, backupFile, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            System.err.println("Error saving tracker profile backups: " + e.getMessage());
        }
    }

    public static boolean restoreBackup() {
        try {
            Path backupFile = Paths.get(BACKUP_DIR, TRACKER_BASE + currentProfile + JSON_EXTENSION);
            Path dest = Paths.get(TrackerProfiles.getCurrentTrackerFilePath(), new String[0]);
            if (Files.exists(backupFile, new LinkOption[0])) {
                Files.copy(backupFile, dest, StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Error restoring tracker profile backup: " + e.getMessage());
        }
        return false;
    }

    protected static void tryRestore() {
        try {
            List<String> profiles = TrackerProfiles.getAvailableProfiles();
            for (String profile : profiles) {
                TrackerProfiles.setCurrentProfile(profile);
                TrackerProfiles.restoreBackup();
            }
        }
        catch (Exception e) {
            System.err.println("[FishyConfig] Error restoring tracker profile backups: " + e.getMessage());
        }
    }

    public static void saveProfile() {
        if (!DEFAULT_PROFILE.equals(currentProfile)) {
            TrackerProfiles.saveToJson();
        }
    }

    private static String getCurrentTrackerFilePath() {
        return "config/fishyaddons/tracker/profittracker_" + currentProfile + JSON_EXTENSION;
    }

    private static String getTrackerFilePath(String profile) {
        return "config/fishyaddons/tracker/profittracker_" + profile + JSON_EXTENSION;
    }

    public static void setCurrentProfile(String profile) {
        if (profile == null || profile.trim().isEmpty()) {
            profile = DEFAULT_PROFILE;
        }
        TrackerProfiles.saveToJson();
        currentProfile = profile.toLowerCase().replaceAll(PROFILE_NAME_PATTERN, "");
        ItemTrackerData.clearAll();
        TrackerProfiles.loadFromJson();
    }

    public static String getCurrentProfile() {
        return currentProfile;
    }

    public static List<String> getAvailableProfiles() {
        ArrayList<String> profiles;
        block9: {
            profiles = new ArrayList<String>();
            try {
                Path trackerDir = Paths.get(TRACKER_BASE_PATH, new String[0]);
                if (!Files.exists(trackerDir, new LinkOption[0])) break block9;
                try (Stream<Path> stream = Files.list(trackerDir);){
                    stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().startsWith(TRACKER_BASE) && path.getFileName().toString().endsWith(JSON_EXTENSION)).forEach(path -> {
                        String fileName = path.getFileName().toString();
                        String profileName = fileName.substring(TRACKER_BASE.length(), fileName.length() - JSON_EXTENSION.length());
                        profiles.add(profileName);
                    });
                }
            }
            catch (Exception e) {
                System.err.println("Error listing profiles: " + e.getMessage());
            }
        }
        if (!profiles.contains(DEFAULT_PROFILE)) {
            profiles.add(0, DEFAULT_PROFILE);
        }
        return profiles;
    }

    public static boolean createProfile(String profileName) {
        if (profileName == null || profileName.trim().isEmpty()) {
            return false;
        }
        String cleanProfileName = profileName.toLowerCase().replaceAll(PROFILE_NAME_PATTERN, "");
        if (cleanProfileName.isEmpty()) {
            return false;
        }
        if (TrackerProfiles.getAvailableProfiles().contains(cleanProfileName)) {
            return false;
        }
        TrackerProfiles.saveToJson();
        TrackerProfiles.setCurrentProfile(cleanProfileName);
        return true;
    }

    public static boolean deleteProfile(String profile) {
        if (DEFAULT_PROFILE.equals(profile)) {
            return false;
        }
        boolean wasActiveProfile = profile.equals(currentProfile);
        if (wasActiveProfile) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a78\u00a7oSwitched profile to default."));
            TrackerProfiles.setCurrentProfile(DEFAULT_PROFILE);
        }
        try {
            Path filePath = Paths.get(TrackerProfiles.getTrackerFilePath(profile), new String[0]);
            if (Files.exists(filePath, new LinkOption[0])) {
                Files.delete(filePath);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Error deleting profile " + profile + ": " + e.getMessage());
        }
        return false;
    }

    public static void saveToJson() {
        try {
            Path filePath = Paths.get(TrackerProfiles.getCurrentTrackerFilePath(), new String[0]);
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            TrackerData data = new TrackerData();
            data.itemCounts = new HashMap<String, Integer>(ItemTrackerData.getAllItems());
            data.sessionStartTime = ItemTrackerData.getSessionStartTime();
            data.lastActivityTime = ItemTrackerData.getLastActivityTime();
            data.totalPausedTime = ItemTrackerData.getTotalPausedTime();
            data.savedAt = System.currentTimeMillis();
            data.profileName = currentProfile;
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson((Object)data);
            try (FileWriter writer = new FileWriter(filePath.toFile());){
                writer.write(json);
            }
        }
        catch (Exception e) {
            System.err.println("Error saving tracker data: " + e.getMessage());
        }
    }

    public static void saveOrCreate(String newProfileName) {
        if (currentProfile.equals(DEFAULT_PROFILE)) {
            TrackerProfiles.saveToJson();
            boolean isUserInput = true;
            if (newProfileName == null || ((String)newProfileName).trim().isEmpty()) {
                String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
                newProfileName = TRACKER_BASE + timeStamp.substring(4).replaceFirst("_", "");
                isUserInput = false;
            }
            newProfileName = (String)newProfileName + JSON_EXTENSION;
            Path newFilePath = Paths.get(TRACKER_BASE_PATH, new String[]{newProfileName});
            Path defaultFilePath = Paths.get(TrackerProfiles.getCurrentTrackerFilePath(), new String[0]);
            try {
                Files.createDirectories(newFilePath.getParent(), new FileAttribute[0]);
                Files.copy(defaultFilePath, newFilePath, new CopyOption[0]);
                String newName = ((String)newProfileName).replace(TRACKER_BASE, "").replace(JSON_EXTENSION, "");
                String oldProfile = currentProfile;
                currentProfile = newName;
                TrackerProfiles.loadFromJson();
                TrackerProfiles.saveToJson();
                currentProfile = oldProfile;
                ItemTrackerData.clearAll();
                TrackerProfiles.setCurrentProfile(newName);
                FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a7aCreated new tracker profile: " + newName)));
                if (!isUserInput) {
                    FishyNotis.alert((class_2561)class_2561.method_43470((String)("\u00a77Use /fp profile rename " + newName + " <new_name> to rename it.")));
                }
            }
            catch (Exception e) {
                System.err.println("Error creating new tracker data file: " + e.getMessage());
            }
        } else {
            TrackerProfiles.saveToJson();
        }
    }

    public static boolean renameProfile(String oldName, String newName) {
        if (oldName == null || newName == null || oldName.trim().isEmpty() || newName.trim().isEmpty()) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cInvalid profile name(s)"));
            return false;
        }
        String cleanOldName = oldName.toLowerCase().replaceAll(PROFILE_NAME_PATTERN, "");
        String cleanNewName = newName.toLowerCase().replaceAll(PROFILE_NAME_PATTERN, "");
        if (cleanOldName.isEmpty() || cleanNewName.isEmpty()) {
            return false;
        }
        if (!TrackerProfiles.getAvailableProfiles().contains(cleanOldName) || TrackerProfiles.getAvailableProfiles().contains(cleanNewName)) {
            return false;
        }
        try {
            Path oldFilePath = Paths.get(TrackerProfiles.getTrackerFilePath(cleanOldName), new String[0]);
            Path newFilePath = Paths.get(TrackerProfiles.getTrackerFilePath(cleanNewName), new String[0]);
            Files.move(oldFilePath, newFilePath, new CopyOption[0]);
            String json = Files.readString(newFilePath);
            json = json.replace("\"profileName\": \"" + cleanOldName + "\"", "\"profileName\": \"" + cleanNewName + "\"");
            Files.writeString(newFilePath, (CharSequence)json, new OpenOption[0]);
            if (Files.exists(oldFilePath, new LinkOption[0])) {
                System.err.println("Warning: Old profile file still exists after rename.");
                Files.delete(oldFilePath);
            }
            return true;
        }
        catch (Exception e) {
            System.err.println("Error renaming profile " + oldName + " to " + newName + ": " + e.getMessage());
            return false;
        }
    }

    public static boolean loadFromJson() {
        try {
            Path filePath = Paths.get(TrackerProfiles.getCurrentTrackerFilePath(), new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                return false;
            }
            Gson gson = new Gson();
            String json = Files.readString(filePath);
            TrackerData data = (TrackerData)gson.fromJson(json, TrackerData.class);
            if (data != null && data.itemCounts != null) {
                ItemTrackerData.setAllItems(data.itemCounts);
                if (data.sessionStartTime > 0L) {
                    ItemTrackerData.setSessionStartTime(data.sessionStartTime);
                }
                if (data.lastActivityTime > 0L) {
                    ItemTrackerData.setLastActivityTime(data.lastActivityTime);
                } else {
                    ItemTrackerData.setLastActivityTime(System.currentTimeMillis());
                }
                ItemTrackerData.setTotalPausedTime(data.totalPausedTime);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Error loading tracker data: " + e.getMessage());
        }
        return false;
    }

    public static boolean deleteJsonFile() {
        try {
            Path filePath = Paths.get(TrackerProfiles.getCurrentTrackerFilePath(), new String[0]);
            if (Files.exists(filePath, new LinkOption[0])) {
                Files.delete(filePath);
                return true;
            }
        }
        catch (Exception e) {
            System.err.println("Error deleting tracker data file: " + e.getMessage());
        }
        return false;
    }

    public static boolean hasJsonFile() {
        return Files.exists(Paths.get(TrackerProfiles.getCurrentTrackerFilePath(), new String[0]), new LinkOption[0]);
    }

    private TrackerProfiles() {
        throw new UnsupportedOperationException("Configuration class");
    }

    @Environment(value=EnvType.CLIENT)
    private static class TrackerData {
        Map<String, Integer> itemCounts;
        long sessionStartTime;
        long lastActivityTime;
        long totalPausedTime;
        long savedAt;
        String profileName;

        private TrackerData() {
        }
    }
}

