/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.event;

import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.handler.GuiIcons;
import me.valkeea.fishyaddons.handler.KeyShortcut;
import me.valkeea.fishyaddons.mixin.HandledScreenAccessor;
import me.valkeea.fishyaddons.safeguard.SlotProtectionManager;
import me.valkeea.fishyaddons.util.HelpUtil;
import me.valkeea.fishyaddons.util.KeyUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1735;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_490;

@Environment(value=EnvType.CLIENT)
public class FishyKeys {
    private static boolean dragging = false;
    private static class_1735 bindStart = null;
    private static boolean wasPressed = false;
    private static long lastGuiSlotAddTime = 0L;
    private static final long GUI_SLOT_ADD_COOLDOWN_MS = 200L;

    private FishyKeys() {
    }

    public static void register() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null) {
                return;
            }
            boolean isScreenOpen = client.field_1755 != null;
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof class_465) {
                class_465 screen = (class_465)patt0$temp;
                FishyKeys.ifInventory(client, screen);
            } else {
                FishyKeys.resetLockKeyState();
            }
            if (!isScreenOpen) {
                KeyShortcut.handleShortcuts();
            }
        });
    }

    private static void ifInventory(class_310 client, class_465<?> screen) {
        FishyKeys.slotLocking(client, screen);
        FishyKeys.configureIcons(client, screen);
    }

    private static void configureIcons(class_310 client, class_465<?> screen) {
        String guiKey = FishyConfig.getKeyString("lockGuiSlotKey");
        if (guiKey == null || "NONE".equals(guiKey)) {
            return;
        }
        int guiKeyCode = KeyUtil.getKeyCodeFromString(guiKey);
        if (guiKeyCode == -1) {
            return;
        }
        boolean isPressed = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)guiKeyCode);
        class_1735 hovered = ((HandledScreenAccessor)screen).getFocusedSlot();
        String title = screen.method_25440().getString();
        long now = System.currentTimeMillis();
        if (isPressed && hovered != null && hovered.field_7871 != client.field_1724.method_31548()) {
            if (now - lastGuiSlotAddTime > 200L) {
                GuiIcons.addGuiSlot(title, hovered.field_7874);
                lastGuiSlotAddTime = now;
            }
        } else if (!isPressed) {
            lastGuiSlotAddTime = 0L;
        }
    }

    private static void slotLocking(class_310 client, class_465<?> screen) {
        String lockKey = FishyConfig.getKeyString("lockKey");
        if (lockKey == null || "NONE".equals(lockKey)) {
            FishyKeys.resetLockKeyState();
            return;
        }
        int lockKeyCode = KeyUtil.getKeyCodeFromString(lockKey);
        if (lockKeyCode == -1) {
            FishyKeys.resetLockKeyState();
            return;
        }
        boolean isPressed = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)lockKeyCode);
        class_1735 hovered = ((HandledScreenAccessor)screen).getFocusedSlot();
        FishyKeys.lockKeyPress(client, hovered, isPressed);
        FishyKeys.lockKeyRelease(screen, hovered, isPressed);
        wasPressed = isPressed;
    }

    private static void lockKeyPress(class_310 client, class_1735 hovered, boolean isPressed) {
        if (isPressed && !wasPressed && hovered != null && hovered.field_7871 == client.field_1724.method_31548()) {
            bindStart = hovered;
            dragging = true;
        }
    }

    private static void lockKeyRelease(class_465<?> screen, class_1735 hovered, boolean isPressed) {
        if (!isPressed && wasPressed && dragging && bindStart != null && HelpUtil.isPlayerInventory() && hovered != null) {
            if (hovered == bindStart) {
                FishyKeys.singleSlotAction(screen, hovered);
            } else {
                FishyKeys.slotBinding(screen, hovered);
            }
            FishyKeys.resetDragState();
        }
    }

    private static void singleSlotAction(class_465<?> screen, class_1735 hovered) {
        int slotId = SlotProtectionManager.remap(screen, hovered.field_7874);
        if (!FishyKeys.isValidSlot(slotId)) {
            return;
        }
        if (SlotProtectionManager.isSlotLocked(slotId)) {
            SlotProtectionManager.unlockSlot(slotId);
        } else if (SlotProtectionManager.isSlotBound(slotId)) {
            int other = SlotProtectionManager.getBoundSlot(slotId);
            SlotProtectionManager.unbindSlots(slotId, other);
        } else {
            SlotProtectionManager.lockSlot(slotId);
        }
    }

    private static void slotBinding(class_465<?> screen, class_1735 hovered) {
        int startId = SlotProtectionManager.remap(screen, FishyKeys.bindStart.field_7874);
        int endId = SlotProtectionManager.remap(screen, hovered.field_7874);
        if (FishyKeys.isValidSlot(startId) && FishyKeys.isValidSlot(endId)) {
            SlotProtectionManager.bindSlots(startId, endId);
        }
    }

    private static void resetLockKeyState() {
        FishyKeys.resetDragState();
        wasPressed = false;
    }

    private static void resetDragState() {
        dragging = false;
        bindStart = null;
    }

    private static boolean isValidSlot(int remapId) {
        class_465 screen = class_310.method_1551().field_1755 instanceof class_465 ? (class_465)class_310.method_1551().field_1755 : null;
        return screen instanceof class_490 && remapId >= 5 && remapId <= 43 || screen instanceof class_476 && remapId >= 9 && remapId <= 43;
    }
}

