/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.List;
import java.util.Objects;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.ColorWheel;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.FaTextField;
import me.valkeea.fishyaddons.gui.HudEditScreen;
import me.valkeea.fishyaddons.gui.SoundSearchMenu;
import me.valkeea.fishyaddons.gui.VCOverlay;
import me.valkeea.fishyaddons.gui.VCPopup;
import me.valkeea.fishyaddons.handler.ChatAlert;
import me.valkeea.fishyaddons.util.SoundUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class AlertEditScreen
extends class_437 {
    private final class_437 parent;
    private final FishyConfig.AlertData initialData;
    private static final String COLOR = "Color";
    private String alertKey;
    private SoundSearchMenu searchMenu;
    private class_342 msgField;
    private class_342 alertTextField;
    private class_342 soundIdField;
    private class_342 volumeField;
    private class_342 keyField;
    private int alertColor = 7202485;
    private String stateKey = null;
    private String stateMsg = null;
    private String stateOnscreen = null;
    private String stateSoundId = null;
    private String stateVolume = null;

    private static String prefer(String ... values) {
        for (String v : values) {
            if (v == null) continue;
            return v;
        }
        return "";
    }

    private void storeState() {
        this.stateKey = this.keyField.method_1882();
        this.stateMsg = this.msgField.method_1882();
        this.stateOnscreen = this.alertTextField.method_1882();
        this.stateSoundId = this.soundIdField.method_1882();
        this.stateVolume = this.volumeField.method_1882();
    }

    public AlertEditScreen(String key, FishyConfig.AlertData data, class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Edit Alert"));
        this.parent = parent;
        this.alertKey = key;
        this.initialData = data != null ? data : new FishyConfig.AlertData("", "", -1, "", 1.0f, true);
        this.alertColor = this.initialData.getColor();
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2 - 10;
        int x = centerX - 350;
        int y = centerY - 80;
        int w = 300;
        int h = 20;
        this.keyField = new FaTextField(this.field_22793, x, y, w, h, (class_2561)class_2561.method_43470((String)"Key"));
        this.keyField.method_1880(50);
        this.keyField.method_1852(AlertEditScreen.prefer(this.stateKey, this.alertKey));
        this.method_37063((class_364)this.keyField);
        this.msgField = new FaTextField(this.field_22793, x, y + 40, w, h, (class_2561)class_2561.method_43470((String)"Chat message"));
        this.msgField.method_1852(AlertEditScreen.prefer(this.stateMsg, this.initialData.getMsg()));
        this.method_37063((class_364)this.msgField);
        this.alertTextField = new FaTextField(this.field_22793, x, y + 80, w, h, (class_2561)class_2561.method_43470((String)"On-screen Alert"));
        this.alertTextField.method_1852(AlertEditScreen.prefer(this.stateOnscreen, this.initialData.getOnscreen()));
        this.method_37063((class_364)this.alertTextField);
        this.method_37063((class_364)new FaButton(x + w, centerY, 50, h, (class_2561)class_2561.method_43470((String)COLOR).method_27694(style -> style.method_36139(this.alertColor)), btn -> {
            this.storeState();
            float[] rgb = ColorWheel.intToRGB(this.alertColor);
            this.field_22787.method_1507((class_437)new ColorWheel(this, rgb, selected -> {
                this.alertColor = ColorWheel.rgbToInt(selected);
                btn.method_25355((class_2561)class_2561.method_43470((String)COLOR).method_27694(s -> s.method_36139(this.alertColor)));
                ChatAlert.refresh();
                this.field_22787.method_1507((class_437)this);
            }));
        }));
        this.soundIdField = new FaTextField(this.field_22793, x, y + 120, w, h, (class_2561)class_2561.method_43470((String)"SoundEvent ID"));
        this.soundIdField.method_1852(AlertEditScreen.prefer(this.stateSoundId, this.initialData.getSoundId()));
        this.method_37063((class_364)this.soundIdField);
        List<String> soundIds = class_7923.field_41172.method_10220().map(arg_0 -> ((class_2378)class_7923.field_41172).method_10221(arg_0)).filter(Objects::nonNull).map(class_2960::toString).sorted().toList();
        int sx = this.soundIdField.method_46426();
        int sy = this.soundIdField.method_46427();
        int width = this.soundIdField.method_25368();
        int entryHeight = 18;
        this.searchMenu = new SoundSearchMenu(soundIds, sx, sy, width, entryHeight, soundId -> {
            this.soundIdField.method_1852(soundId);
            this.searchMenu.setVisible(false);
        }, soundId -> SoundUtil.playDynamicSound(soundId, 1.0f, 1.0f), this, this.soundIdField);
        this.soundIdField.method_1863(query -> this.searchMenu.setVisible(this.soundIdField.method_25370() && !query.isEmpty()));
        this.searchMenu.setVisible(!this.soundIdField.method_1882().isEmpty());
        this.volumeField = new FaTextField(this.field_22793, x + width, sy, 50, 20, (class_2561)class_2561.method_43470((String)"Volume"));
        if (this.stateVolume != null) {
            this.volumeField.method_1852(this.stateVolume);
        } else if (this.initialData.getVolume() != 1.0f) {
            this.volumeField.method_1852(String.valueOf(this.initialData.getVolume()));
        } else {
            this.volumeField.method_1852("1.0");
        }
        this.method_37063((class_364)this.volumeField);
        this.method_37063((class_364)new FaButton(x + w / 2 + 80, this.soundIdField.method_46427() + 80, 80, 20, (class_2561)class_2561.method_43470((String)"HUD").method_27694(style -> style.method_36139(14863081)), btn -> {
            class_310.method_1551().method_1507((class_437)new HudEditScreen("Title HUD"));
            this.save();
            ChatAlert.refresh();
        }));
        this.method_37063((class_364)new FaButton(x + w / 2, this.soundIdField.method_46427() + 80, 80, 20, (class_2561)class_2561.method_43470((String)"Save").method_27694(style -> style.method_36139(14863081)), btn -> {
            this.save();
            ChatAlert.refresh();
            this.field_22787.method_1507(this.parent);
        }));
        this.method_37063((class_364)new FaButton(x + w / 2 - 80, this.soundIdField.method_46427() + 80, 80, 20, (class_2561)class_2561.method_43470((String)"Cancel").method_27694(style -> style.method_36139(14863081)), btn -> this.field_22787.method_1507(this.parent)));
    }

    private void save() {
        float volume = 1.0f;
        try {
            String input = this.volumeField.method_1882().trim();
            if (!input.isEmpty()) {
                volume = Float.parseFloat(input);
                if (volume < 0.0f) {
                    volume = 0.0f;
                }
                if (volume > 5.0f) {
                    volume = 5.0f;
                }
            }
        }
        catch (NumberFormatException ignored) {
            System.err.println("Invalid volume input: " + this.volumeField.method_1882());
        }
        String newKey = this.keyField.method_1882().trim();
        if (newKey.isEmpty()) {
            this.warn();
            return;
        }
        FishyConfig.AlertData newData = new FishyConfig.AlertData(this.msgField.method_1882(), this.alertTextField.method_1882(), this.alertColor, this.soundIdField.method_1882(), volume, true);
        if (!newKey.equals(this.alertKey)) {
            FishyConfig.removeChatAlert(this.alertKey);
        }
        FishyConfig.setChatAlert(newKey, newData);
        this.volumeField.method_1852(this.stateVolume != null ? this.stateVolume : String.valueOf(this.initialData.getVolume()));
    }

    public void warn() {
        class_310 cl = class_310.method_1551();
        VCPopup popup = new VCPopup((class_2561)class_2561.method_43470((String)"Empty field detected! Would you like to restore it?"), "No", () -> cl.method_1507(this.parent), "Yes", () -> this.keyField.method_1852(this.alertKey), 1.0f);
        cl.method_1507((class_437)new VCOverlay(cl.field_1755, popup));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderGuideText(context);
        if (this.searchMenu != null) {
            this.searchMenu.setVisible(this.soundIdField.method_25370() && !this.soundIdField.method_1882().isEmpty());
            if (this.searchMenu.isVisible()) {
                this.searchMenu.render(context, this, mouseX, mouseY, delta);
            }
        }
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2 - 10;
        int x = centerX - 350;
        int y = centerY - 90;
        int w = 300;
        context.method_51433(this.field_22793, "Detected String", x, y, -8355712, false);
        context.method_51433(this.field_22793, "Auto Chat", x, y + 40, -8355712, false);
        context.method_51433(this.field_22793, "On-screen Title", x, y + 80, -8355712, false);
        context.method_51433(this.field_22793, COLOR, x + w + 10, y + 80, -8355712, false);
        context.method_51433(this.field_22793, "SoundEvent ID", x, y + 120, -8355712, false);
        context.method_51433(this.field_22793, "Volume", x + w + 10, y + 120, -8355712, false);
    }

    public void renderGuideText(class_332 context) {
        String[] instructions;
        int x = this.field_22789 / 2 + 50;
        int y = this.field_22790 / 2 - 175;
        int lineHeight = 15;
        class_5250 title = class_2561.method_43470((String)"FishyAddons Custom Alerts").method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 300.0f);
        context.method_27535(this.field_22793, (class_2561)title, x, y, 0xFFFFFF);
        context.method_51448().method_22909();
        y += lineHeight * 2;
        for (String instruction : instructions = new String[]{" The First field is required to successfully create an alert!", " Leaving other fields empty will disable those functions.", "", "- Detected String -", " \u2022 \u00a77Matched anywhere in the message", " \u2022 \u00a78Example: alert set to 'hel', the alert will also trigger on 'hello'", "", "- Auto Chat -", " \u2022 \u00a77Optional chat message sent with the alert", "", "- On-screen Title -", " \u2022 \u00a77Text appears for 2 seconds", " \u2022 \u00a77Position, color and size can be customized in /fa hud", "", "- SoundEvent -", " \u2022 \u00a77Plays a Minecraft SoundEvent when", "   the alert is triggered", " \u2022 \u00a77You can preview sounds by right-clicking", "   them in the dropdown", " \u2022 \u00a77Volume is affected by internal settings", "   \u00a73Note: FA provides 3 custom events with placeholder sounds.", "   \u00a73You can replace them with a normal resource pack", "   \u00a73by placing fishyaddons_1.ogg, (1-3)", "   \u00a73in assets/fishyaddons/sounds/custom.", " \u2022 \u00a77Alerts can also be loaded from JSON"}) {
            if (instruction.isEmpty()) {
                y += lineHeight / 2;
                continue;
            }
            class_124 format = class_124.field_1080;
            if (instruction.startsWith(" \u2022") || instruction.matches("\\d+\\..*")) {
                format = class_124.field_1075;
            } else if (instruction.contains("-")) {
                format = class_124.field_1062;
            } else if (instruction.startsWith(" The")) {
                format = class_124.field_1063;
            }
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 300.0f);
            class_5250 text = class_2561.method_43470((String)instruction).method_27692(format);
            context.method_27535(this.field_22793, (class_2561)text, x, y, 0xFFFFFF);
            context.method_51448().method_22909();
            y += lineHeight;
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.soundIdField.method_25370() && (this.msgField.method_25405(mouseX, mouseY) || this.alertTextField.method_25405(mouseX, mouseY) || this.volumeField.method_25405(mouseX, mouseY))) {
            this.soundIdField.method_25365(false);
        }
        if (this.searchMenu != null && this.searchMenu.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchMenu != null && this.soundIdField.method_25370() && this.searchMenu.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.searchMenu != null && this.searchMenu.mouseScrolled(mouseX, mouseY, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25421() {
        return false;
    }
}

