/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.function.Consumer;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.FaTextField;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ColorWheel
extends class_437 {
    private float red = 1.0f;
    private float green = 0.0f;
    private float blue = 0.0f;
    private float hue = 0.0f;
    private float saturation = 1.0f;
    private float lightness = 0.5f;
    private Consumer<float[]> onColorSelected;
    private class_437 parent;
    private FaTextField hexField;
    private int colorWheelCenterX;
    private int colorWheelCenterY;
    private int colorWheelRadius = 70;
    private int lightnessBarX;
    private int lightnessBarY;
    private int lightnessBarWidth = 160;
    private int lightnessBarHeight = 10;
    private boolean isDraggingWheel = false;
    private boolean isDraggingLightness = false;

    public ColorWheel(class_437 parent, float[] initialColor, Consumer<float[]> onColorSelected) {
        super((class_2561)class_2561.method_43470((String)"Color Picker"));
        this.parent = parent;
        this.onColorSelected = onColorSelected;
        if (initialColor != null && initialColor.length == 3) {
            this.red = initialColor[0];
            this.green = initialColor[1];
            this.blue = initialColor[2];
            float[] hsl = ColorWheel.rgbToHsl(this.red, this.green, this.blue);
            this.hue = hsl[0];
            this.saturation = hsl[1];
            this.lightness = hsl[2];
        } else {
            this.hue = 0.0f;
            this.saturation = 1.0f;
            this.lightness = 0.5f;
            float[] rgb = ColorWheel.hslToRgb(this.hue * 360.0f, this.saturation, this.lightness);
            this.red = rgb[0];
            this.green = rgb[1];
            this.blue = rgb[2];
        }
    }

    protected void method_25426() {
        this.colorWheelCenterX = this.field_22789 / 2;
        this.colorWheelCenterY = this.field_22790 / 2 - 40;
        this.lightnessBarX = this.colorWheelCenterX - this.lightnessBarWidth / 2;
        this.lightnessBarY = this.colorWheelCenterY + this.colorWheelRadius + 20;
        this.updateRgbFromHsl();
        class_327 tr = this.field_22793;
        int fieldY = this.lightnessBarY + this.lightnessBarHeight + 20;
        this.hexField = new FaTextField(tr, this.colorWheelCenterX - 75, fieldY, 150, 20, (class_2561)class_2561.method_43470((String)"Hex (e.g. #FF00FF)"));
        this.hexField.method_1880(9);
        this.updateHexField();
        this.method_37063((class_364)this.hexField);
        int buttonY = fieldY + 30;
        this.method_37063((class_364)new FaButton(this.colorWheelCenterX - 75, buttonY, 70, 20, (class_2561)class_2561.method_43470((String)"Cancel").method_10862(class_2583.field_24360.method_36139(0xFF8080)), btn -> this.field_22787.method_1507(this.parent)));
        this.method_37063((class_364)new FaButton(this.colorWheelCenterX + 5, buttonY, 70, 20, (class_2561)class_2561.method_43470((String)"Confirm").method_10862(class_2583.field_24360.method_36139(0xCCFFCC)), btn -> {
            String hex = this.hexField.method_1882().trim();
            float[] rgb = new float[]{this.red, this.green, this.blue};
            if (hex.matches("^#?[0-9a-fA-F]{6}$")) {
                try {
                    int color = Integer.parseInt(hex.replace("#", ""), 16);
                    rgb[0] = (float)(color >> 16 & 0xFF) / 255.0f;
                    rgb[1] = (float)(color >> 8 & 0xFF) / 255.0f;
                    rgb[2] = (float)(color & 0xFF) / 255.0f;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.onColorSelected.accept(rgb);
            this.field_22787.method_1507(this.parent);
        }));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderColorWheel(context);
        this.renderLightnessBar(context);
        int previewSize = 50;
        int px = this.colorWheelCenterX + this.colorWheelRadius + 20;
        int py = this.colorWheelCenterY - previewSize / 2;
        int color = 0xFF000000 | (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f);
        context.method_25294(px, py, px + previewSize, py + previewSize, color);
        context.method_49601(px, py, previewSize, previewSize, -1);
        this.renderSelectionIndicators(context);
    }

    private void renderColorWheel(class_332 context) {
        for (int y = -this.colorWheelRadius; y <= this.colorWheelRadius; ++y) {
            for (int x = -this.colorWheelRadius; x <= this.colorWheelRadius; ++x) {
                double distance = Math.sqrt((double)x * (double)x + (double)y * (double)y);
                if (!(distance <= (double)this.colorWheelRadius) || !(distance >= 10.0)) continue;
                float angle = (float)Math.atan2(y, x);
                if (angle < 0.0f) {
                    angle = (float)((double)angle + Math.PI * 2);
                }
                float hueNormalized = angle / ((float)Math.PI * 2);
                float sat = (float)(distance / (double)this.colorWheelRadius);
                float[] rgb = ColorWheel.hslToRgb(hueNormalized * 360.0f, sat, this.lightness);
                int color = 0xFF000000 | (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
                int pixelX = this.colorWheelCenterX + x;
                int pixelY = this.colorWheelCenterY + y;
                context.method_25294(pixelX, pixelY, pixelX + 1, pixelY + 1, color);
            }
        }
    }

    private void renderLightnessBar(class_332 context) {
        for (int x = 0; x < this.lightnessBarWidth; ++x) {
            float currentLightness = (float)x / (float)this.lightnessBarWidth;
            float[] rgb = ColorWheel.hslToRgb(this.hue * 360.0f, this.saturation, currentLightness);
            int color = 0xFF000000 | (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
            context.method_25294(this.lightnessBarX + x, this.lightnessBarY, this.lightnessBarX + x + 1, this.lightnessBarY + this.lightnessBarHeight, color);
        }
        context.method_49601(this.lightnessBarX, this.lightnessBarY, this.lightnessBarWidth, this.lightnessBarHeight, -1);
    }

    private void renderSelectionIndicators(class_332 context) {
        float angle = this.hue * 2.0f * (float)Math.PI;
        int indicatorX = this.colorWheelCenterX + (int)(Math.cos(angle) * (double)this.saturation * (double)this.colorWheelRadius);
        int indicatorY = this.colorWheelCenterY + (int)(Math.sin(angle) * (double)this.saturation * (double)this.colorWheelRadius);
        context.method_25294(indicatorX - 4, indicatorY, indicatorX + 5, indicatorY + 1, -1);
        context.method_25294(indicatorX, indicatorY - 4, indicatorX + 1, indicatorY + 5, -1);
        int lightnessIndicatorX = this.lightnessBarX + (int)(this.lightness * (float)this.lightnessBarWidth);
        context.method_25294(lightnessIndicatorX - 1, this.lightnessBarY - 3, lightnessIndicatorX + 2, this.lightnessBarY + this.lightnessBarHeight + 3, -1);
        context.method_25294(lightnessIndicatorX, this.lightnessBarY - 2, lightnessIndicatorX + 1, this.lightnessBarY + this.lightnessBarHeight + 2, -16777216);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            double dx = mouseX - (double)this.colorWheelCenterX;
            double dy = mouseY - (double)this.colorWheelCenterY;
            double distance = Math.sqrt(dx * dx + dy * dy);
            if (distance <= (double)this.colorWheelRadius && distance >= 10.0) {
                this.isDraggingWheel = true;
                this.updateColorFromWheel(mouseX, mouseY);
                return true;
            }
            if (mouseX >= (double)this.lightnessBarX && mouseX <= (double)(this.lightnessBarX + this.lightnessBarWidth) && mouseY >= (double)this.lightnessBarY && mouseY <= (double)(this.lightnessBarY + this.lightnessBarHeight)) {
                this.isDraggingLightness = true;
                this.updateLightnessFromBar(mouseX);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingWheel) {
            this.updateColorFromWheel(mouseX, mouseY);
            return true;
        }
        if (this.isDraggingLightness) {
            this.updateLightnessFromBar(mouseX);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingWheel = false;
        this.isDraggingLightness = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    private void updateColorFromWheel(double mouseX, double mouseY) {
        float angle;
        double dx = mouseX - (double)this.colorWheelCenterX;
        double dy = mouseY - (double)this.colorWheelCenterY;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance > (double)this.colorWheelRadius) {
            dx = dx / distance * (double)this.colorWheelRadius;
            dy = dy / distance * (double)this.colorWheelRadius;
            distance = this.colorWheelRadius;
        }
        if (distance < 10.0) {
            distance = 10.0;
        }
        if ((angle = (float)Math.atan2(dy, dx)) < 0.0f) {
            angle = (float)((double)angle + Math.PI * 2);
        }
        this.hue = angle / ((float)Math.PI * 2);
        this.saturation = (float)(distance / (double)this.colorWheelRadius);
        this.updateRgbFromHsl();
        this.updateHexField();
    }

    private void updateLightnessFromBar(double mouseX) {
        double relativeX = mouseX - (double)this.lightnessBarX;
        relativeX = Math.clamp(relativeX, 0.0, (double)this.lightnessBarWidth);
        this.lightness = (float)(relativeX / (double)this.lightnessBarWidth);
        this.updateRgbFromHsl();
        this.updateHexField();
    }

    private void updateRgbFromHsl() {
        float[] rgb = ColorWheel.hslToRgb(this.hue * 360.0f, this.saturation, this.lightness);
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
    }

    private void updateHexField() {
        if (this.hexField != null) {
            this.hexField.method_1852(String.format("#%02X%02X%02X", (int)(this.red * 255.0f), (int)(this.green * 255.0f), (int)(this.blue * 255.0f)));
        }
    }

    private static float[] hslToRgb(float h, float s, float l) {
        float b;
        float g;
        float r;
        h /= 360.0f;
        if (s == 0.0f) {
            return new float[]{l, l, l};
        }
        float c = (1.0f - Math.abs(2.0f * l - 1.0f)) * s;
        float x = c * (1.0f - Math.abs(h * 6.0f % 2.0f - 1.0f));
        float m = l - c / 2.0f;
        float h6 = h * 6.0f;
        if (h6 < 1.0f) {
            r = c;
            g = x;
            b = 0.0f;
        } else if (h6 < 2.0f) {
            r = x;
            g = c;
            b = 0.0f;
        } else if (h6 < 3.0f) {
            r = 0.0f;
            g = c;
            b = x;
        } else if (h6 < 4.0f) {
            r = 0.0f;
            g = x;
            b = c;
        } else if (h6 < 5.0f) {
            r = x;
            g = 0.0f;
            b = c;
        } else {
            r = c;
            g = 0.0f;
            b = x;
        }
        return new float[]{r + m, g + m, b + m};
    }

    private static float[] rgbToHsl(float r, float g, float b) {
        float h;
        float s;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float l = (max + min) / 2.0f;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = l > 0.5f ? d / (2.0f - max - min) : d / (max + min);
            h = max == r ? (g - b) / d + (float)(g < b ? 6 : 0) : (max == g ? (b - r) / d + 2.0f : (r - g) / d + 4.0f);
            h /= 6.0f;
        }
        return new float[]{h, s, l};
    }

    public static float[] intToRGB(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static int rgbToInt(float[] rgb) {
        int r = (int)(rgb[0] * 255.0f) & 0xFF;
        int g = (int)(rgb[1] * 255.0f) & 0xFF;
        int b = (int)(rgb[2] * 255.0f) & 0xFF;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

