/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class DropdownMenu {
    private final List<String> entries;
    private final int x;
    private final int y;
    private final int width;
    private final int entryHeight;
    private final Consumer<String> onSelect;
    private int hoveredIndex = -1;
    private boolean visible = true;

    public DropdownMenu(List<String> entries, int x, int y, int width, int entryHeight, Consumer<String> onSelect) {
        this.entries = entries;
        this.x = x;
        this.y = y;
        this.width = width;
        this.entryHeight = entryHeight;
        this.onSelect = onSelect;
    }

    public void render(class_332 context, class_437 screen, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            int entryY = this.y + i * this.entryHeight;
            boolean hovered = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= entryY && mouseY <= entryY + this.entryHeight;
            int bgColor = hovered ? -1914135 : -870178270;
            context.method_25294(this.x, entryY, this.x + this.width, entryY + this.entryHeight, bgColor);
            int textColor = hovered ? -16777216 : -1914135;
            context.method_51433(screen.method_64506(), this.entries.get(i), this.x + 6, entryY + (this.entryHeight - 8) / 2, textColor, false);
            if (!hovered) continue;
            this.hoveredIndex = i;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.visible) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            int entryY = this.y + i * this.entryHeight;
            if (!(mouseX >= (double)this.x) || !(mouseX < (double)(this.x + this.width)) || !(mouseY >= (double)entryY) || !(mouseY < (double)(entryY + this.entryHeight))) continue;
            this.onSelect.accept(this.entries.get(i));
            this.visible = false;
            return true;
        }
        this.visible = false;
        return false;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getEntryHeight() {
        return this.entryHeight;
    }

    public List<String> getEntries() {
        return this.entries;
    }

    public int getHoveredIndex() {
        return this.hoveredIndex;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }
}

