/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.config.FishyPresets;
import me.valkeea.fishyaddons.gui.AlertEditScreen;
import me.valkeea.fishyaddons.gui.DropdownMenu;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.VCButton;
import me.valkeea.fishyaddons.gui.VCLabelField;
import me.valkeea.fishyaddons.gui.VCPopup;
import me.valkeea.fishyaddons.gui.VCRenderUtils;
import me.valkeea.fishyaddons.gui.VCText;
import me.valkeea.fishyaddons.gui.VCTextField;
import me.valkeea.fishyaddons.gui.VCVisuals;
import me.valkeea.fishyaddons.handler.ChatAlert;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class GUIChatAlert
extends class_437 {
    private static final String TITLE_TEXT = "\u2500 \u03b1 Chat Alerts \u03b1 \u2500";
    private static float uiScale;
    private static int entryH;
    private static int entryW;
    private static int btnW;
    private static int delBtnW;
    private static int fieldW;
    private static int fieldH;
    private static int btnH;
    private final class_437 parent;
    private final List<Entry> entries = new ArrayList<Entry>();
    private boolean isDraggingScrollbar = false;
    private boolean addMode = false;
    private int scrollOffset = 0;
    private int maxVisibleEntries = 0;
    private int uploadBtnX = 0;
    private int uploadBtnY = 0;
    private int downloadBtnX = 0;
    private int downloadBtnY = 0;
    private int scrollbarThumbOffset = 0;
    private AddEntry addEntry = null;
    private FaButton addBtn = null;
    private DropdownMenu presetDropdown;
    private VCPopup popup = null;
    private VCTextField presetNameField = null;

    public GUIChatAlert(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)TITLE_TEXT));
        this.parent = parent;
    }

    protected void method_25426() {
        this.entries.clear();
        this.method_37067();
        GUIChatAlert.calcDimensions(FishyConfig.getFloat("modUiScale", 0.4265625f));
        for (Map.Entry<String, FishyConfig.AlertData> entry : FishyConfig.getChatAlerts().entrySet()) {
            Entry e = new Entry(entry.getKey());
            this.entries.add(e);
            this.method_37063((class_364)e.keyField);
            this.method_37063((class_364)e.editBtn);
            this.method_37063((class_364)e.delBtn);
            this.method_37063((class_364)e.toggleBtn);
        }
        int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
        int listTop = 40;
        int listBottom = this.field_22790 - 60;
        int listHeight = listBottom - listTop;
        this.maxVisibleEntries = Math.max(1, listHeight / entryH);
        int maxScroll = Math.max(0, totalEntries - this.maxVisibleEntries);
        this.scrollOffset = Math.clamp((long)this.scrollOffset, 0, maxScroll);
        if (this.scrollOffset > maxScroll || this.addMode && this.scrollOffset < totalEntries - this.maxVisibleEntries) {
            this.scrollOffset = maxScroll;
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (!this.addMode) {
            int addBtnY = this.field_22790 - 40;
            this.addBtn = new FaButton(this.field_22789 / 2 - entryW / 2, addBtnY, btnW, btnH, (class_2561)class_2561.method_43470((String)"Add").method_27694(style -> style.method_36139(0xCCFFCC)), btn -> {
                this.addMode = true;
                this.addEntry = new AddEntry();
                this.method_37063((class_364)this.addEntry.keyField);
                this.method_37063((class_364)this.addEntry.saveBtn);
                this.method_37063((class_364)this.addEntry.cancelBtn);
                this.method_37066((class_364)this.addBtn);
            });
            this.addBtn.setUIScale(uiScale);
            this.method_37063((class_364)this.addBtn);
        }
        FaButton backButton = new FaButton(this.field_22789 / 2 - entryW / 2 + btnW, this.field_22790 - 40, btnW, btnH, (class_2561)class_2561.method_43470((String)"Back").method_27694(style -> style.method_36139(-8355712)), btn -> this.field_22787.method_1507(this.parent));
        backButton.setUIScale(uiScale);
        this.method_37063((class_364)backButton);
        FaButton closeButton = new FaButton(this.field_22789 / 2 - entryW / 2 + btnW * 2, this.field_22790 - 40, btnW, btnH, (class_2561)class_2561.method_43470((String)"Close").method_27694(style -> style.method_36139(-8355712)), btn -> this.method_25419());
        closeButton.setUIScale(uiScale);
        this.method_37063((class_364)closeButton);
        this.downloadBtnX = this.field_22789 / 2 + entryW / 2 - btnW * 2;
        this.downloadBtnY = this.field_22790 - 40;
        this.method_37063((class_364)new FaButton(this.downloadBtnX, this.downloadBtnY, btnW, btnH, (class_2561)class_2561.method_43470((String)"\ud83d\udcc1\u2912").method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_36139(14863081)), b -> this.showPresetDropdown(this.downloadBtnX, this.downloadBtnY)));
        this.uploadBtnX = this.field_22789 / 2 + entryW / 2 - btnW;
        this.uploadBtnY = this.field_22790 - 40;
        this.method_37063((class_364)new FaButton(this.uploadBtnX, this.uploadBtnY, btnW, btnH, (class_2561)class_2561.method_43470((String)"\ud83d\udcc1\u2913").method_27694(style -> style.method_10982(Boolean.valueOf(true)).method_36139(0xB0FFB0)), b -> this.presetPopup()));
    }

    private static void calcDimensions(float scale) {
        uiScale = Math.clamp(scale, 0.7f, 1.3f);
        entryH = (int)(28.0f * uiScale);
        entryW = (int)(600.0f * uiScale);
        btnW = (int)(40.0f * uiScale);
        delBtnW = (int)(20.0f * uiScale);
        fieldW = (int)(480.0f * uiScale);
        fieldH = (int)(20.0f * uiScale);
        btnH = (int)(20.0f * uiScale);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.entries.isEmpty()) {
            String[] instructions;
            int y = this.field_22790 / 2;
            int x = this.field_22789 / 2;
            int lineHeight = 15;
            y += lineHeight * 2;
            for (String instruction : instructions = new String[]{TITLE_TEXT, " -\u00a77Add strings you want to be alerted on.", " -\u00a77After adding, click 'Edit' to configure optional title, chat msg and sound alarms.", " -\u00a77You can share configs by dropping files in fishyaddons/preset."}) {
                context.method_51448().method_22903();
                context.method_51448().method_46416(0.0f, 0.0f, 300.0f);
                class_5250 text = class_2561.method_43470((String)instruction);
                VCText.drawScaledCenteredText(context, this.field_22793, text.getString(), x, y, -11141121, uiScale - 0.1f);
                context.method_51448().method_22909();
                y += lineHeight;
            }
        } else {
            VCText.drawScaledCenteredText(context, this.field_22793, TITLE_TEXT, this.field_22789 / 2, 15, -11141121, uiScale - 0.1f);
        }
        if (this.presetDropdown != null && this.presetDropdown.isVisible()) {
            this.presetDropdown.render(context, this, mouseX, mouseY);
        }
        this.addList(context);
        if (this.popup != null) {
            this.method_25420(context, mouseX, mouseY, delta);
            this.popup.render(context, this.field_22793, mouseX, mouseY, delta);
        }
        if (this.popup != null && this.presetNameField != null) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 500.0f);
            this.presetNameField.method_46421(this.popup.getX() + (this.popup.getWidth() - this.presetNameField.method_25368()) / 2);
            this.presetNameField.method_46419(this.popup.getY() + 30);
            this.presetNameField.method_25394(context, mouseX, mouseY, delta);
            context.method_51448().method_22909();
        }
        if (GUIChatAlert.isInside(this.downloadBtnX, this.downloadBtnY, btnW, btnH, mouseX, mouseY)) {
            VCRenderUtils.preview(context, this.field_22793, Arrays.asList(class_2561.method_43470((String)"Download From File:"), class_2561.method_43470((String)"- \u00a78Format: preset.alert.<name>.json"), class_2561.method_43470((String)"- \u00a78All presets are stored in config/fishyaddons/preset"), class_2561.method_43470((String)"  \u00a78and can be re-downloaded"), class_2561.method_43470((String)"  \u00a78'example' contains the proper json structure")), this.downloadBtnX - 60, this.downloadBtnY - 60, VCVisuals.getThemeColor(), uiScale);
        }
        if (GUIChatAlert.isInside(this.uploadBtnX, this.uploadBtnY, btnW, btnH, mouseX, mouseY)) {
            VCRenderUtils.preview(context, this.field_22793, Arrays.asList(class_2561.method_43470((String)"Save as Preset:"), class_2561.method_43470((String)"- \u00a78Creates a working preset with all current alerts."), class_2561.method_43470((String)"- \u00a78Can be shared with others or saved for later use")), this.uploadBtnX - 60, this.uploadBtnY - 60, VCVisuals.getThemeColor(), uiScale);
        }
    }

    private void addList(class_332 context) {
        int listTop = 40;
        int listBottom = this.field_22790 - 60;
        int listHeight = listBottom - listTop;
        this.maxVisibleEntries = Math.max(1, listHeight / entryH);
        int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
        int y = listTop;
        int startIdx = this.scrollOffset;
        int endIdx = Math.min(startIdx + this.maxVisibleEntries, this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            if (i >= startIdx && i < endIdx) {
                this.entries.get(i).setPosition(this.field_22789 / 2 - entryW / 2, y);
                this.entries.get(i).setVisible(true);
                y += entryH;
                continue;
            }
            this.entries.get(i).setVisible(false);
        }
        if (totalEntries > this.maxVisibleEntries) {
            this.renderScrollIndicator(context, this.field_22789 / 2 + entryW / 2 + 20, listTop, listHeight, totalEntries);
        }
        if (this.addMode && this.addEntry != null) {
            this.addEntry.updateVisibility();
            if (endIdx == this.entries.size()) {
                this.addEntry.setPosition(this.field_22789 / 2 - entryW / 2, y);
            }
        }
        if (this.addBtn != null && !this.addMode) {
            int addBtnY = this.field_22790 - 40;
            this.addBtn.method_46421(this.field_22789 / 2 - entryW / 2);
            this.addBtn.method_46419(addBtnY);
        }
    }

    private void renderScrollIndicator(class_332 context, int x, int y, int listHeight, int totalEntries) {
        int scrollbarWidth = 4;
        context.method_25294(x, y, x + scrollbarWidth, y + listHeight, 0x44000000);
        if (totalEntries > this.maxVisibleEntries) {
            int thumbHeight = Math.max((int)(10.0f * uiScale), this.maxVisibleEntries * listHeight / totalEntries);
            int thumbY = y + this.scrollOffset * (listHeight - thumbHeight) / (totalEntries - this.maxVisibleEntries);
            context.method_25294(x + 1, thumbY, x + scrollbarWidth - 1, thumbY + thumbHeight, VCVisuals.getThemeColor());
            context.method_25294(x + 1, thumbY + thumbHeight - 1, x + scrollbarWidth - 1, thumbY + thumbHeight, -16777216);
        }
    }

    private static boolean isInside(int x, int y, int w, int h, double mouseX, double mouseY) {
        return mouseX >= (double)x && mouseX < (double)(x + w) && mouseY >= (double)y && mouseY < (double)(y + h);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.popup != null && this.presetNameField != null && this.presetNameField.method_25402(mouseX, mouseY, button)) {
            this.presetNameField.method_25365(true);
            this.method_25395((class_364)this.presetNameField);
            return true;
        }
        if (this.presetDropdown != null && this.presetDropdown.isVisible()) {
            if (this.presetDropdown.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            int x = this.presetDropdown.getX();
            int y = this.presetDropdown.getY();
            int w = this.presetDropdown.getWidth();
            int h = this.presetDropdown.getEntryHeight() * this.presetDropdown.getEntries().size();
            if (!(mouseX >= (double)x && mouseX <= (double)(x + w) && mouseY >= (double)y && mouseY <= (double)(y + h))) {
                this.presetDropdown.setVisible(false);
                return true;
            }
        }
        if (this.popup != null) {
            return this.popup.mouseClicked(mouseX, mouseY, button);
        }
        if (this.handleScrollbar(mouseX, mouseY)) {
            return true;
        }
        int startIdx = this.scrollOffset;
        int endIdx = Math.min(startIdx + this.maxVisibleEntries, this.entries.size());
        for (int i = startIdx; i < endIdx; ++i) {
            if (!this.entries.get(i).mouseClicked(mouseX, mouseY)) continue;
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private boolean handleScrollbar(double mouseX, double mouseY) {
        int listTop = 40;
        int listBottom = this.field_22790 - 60;
        int listHeight = listBottom - listTop;
        int scrollbarX = this.field_22789 / 2 + entryW / 2 + 20;
        int scrollbarWidth = Math.max(4, (int)(8.0f * uiScale));
        int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
        if (totalEntries > this.maxVisibleEntries && mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)listTop && mouseY <= (double)(listTop + listHeight)) {
            int thumbHeight = Math.max((int)(10.0f * uiScale), this.maxVisibleEntries * listHeight / totalEntries);
            int thumbY = listTop + this.scrollOffset * (listHeight - thumbHeight) / (totalEntries - this.maxVisibleEntries);
            if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                this.isDraggingScrollbar = true;
                this.scrollbarThumbOffset = (int)mouseY - thumbY;
            } else {
                this.isDraggingScrollbar = true;
                this.scrollbarThumbOffset = thumbHeight / 2;
                double trackClickY = mouseY - (double)listTop - (double)this.scrollbarThumbOffset;
                double scrollPercent = trackClickY / (double)(listHeight - thumbHeight);
                int newScrollOffset = (int)(scrollPercent * (double)(totalEntries - this.maxVisibleEntries));
                this.scrollOffset = Math.clamp((long)newScrollOffset, 0, totalEntries - this.maxVisibleEntries);
            }
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            int listTop = 40;
            int listBottom = this.field_22790 - 60;
            int listHeight = listBottom - listTop;
            int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
            int thumbHeight = Math.max((int)(10.0f * uiScale), this.maxVisibleEntries * listHeight / totalEntries);
            int mouseThumbY = (int)mouseY - listTop - this.scrollbarThumbOffset;
            double scrollPercent = (double)mouseThumbY / (double)(listHeight - thumbHeight);
            int newScrollOffset = (int)(scrollPercent * (double)(totalEntries - this.maxVisibleEntries));
            this.scrollOffset = Math.clamp((long)newScrollOffset, 0, totalEntries - this.maxVisibleEntries);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
        if (totalEntries > this.maxVisibleEntries) {
            this.scrollOffset -= (int)Math.signum(verticalAmount);
            this.scrollOffset = Math.clamp((long)this.scrollOffset, 0, totalEntries - this.maxVisibleEntries);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void showPresetDropdown(int btnX, int btnY) {
        List<String> suffixes = FishyPresets.listPresetSuffixes(FishyPresets.PresetType.ALERT);
        if (suffixes.isEmpty()) {
            this.popup((class_2561)class_2561.method_43470((String)"No presets found for this tab."), "OK", () -> {
                this.popup = null;
            }, "", () -> {});
            return;
        }
        int dropdownX = btnX;
        int dropdownY = btnY - btnH - suffixes.size() * 14 / 2;
        this.presetDropdown = new DropdownMenu(suffixes, dropdownX, dropdownY, 100, 14, suffix -> {
            this.loadPreset((String)suffix);
            this.method_25426();
            this.presetDropdown.setVisible(false);
        });
    }

    private void loadPreset(String suffix) {
        Map<String, FishyConfig.AlertData> map = FishyPresets.loadAlertPreset(suffix);
        if (map != null) {
            FishyConfig.chatAlerts.getValues().putAll(map);
            FishyConfig.save();
            this.method_25426();
        }
    }

    public void popup(class_2561 title, String continueButtonText, Runnable onContinue, String discardButtonText, Runnable onDiscard) {
        this.popup = new VCPopup(title, discardButtonText, onDiscard::run, continueButtonText, onContinue::run, uiScale);
        this.popup.init(this.field_22793, this.field_22789, this.field_22790);
    }

    private void presetPopup() {
        this.presetNameField = new VCTextField(this.field_22793, this.field_22789 / 2 - 60, this.field_22790 / 2 - 35, 120, 20, (class_2561)class_2561.method_43470((String)"Preset Name"));
        this.presetNameField.method_1880(15);
        this.presetNameField.method_1852("");
        this.method_25395((class_364)this.presetNameField);
        this.popup = new VCPopup((class_2561)class_2561.method_43470((String)"Enter preset name:"), "Cancel", () -> {
            this.method_37066((class_364)this.presetNameField);
            this.presetNameField = null;
            this.popup = null;
        }, "Save", () -> {
            String suffix = this.presetNameField.method_1882().trim();
            if (!suffix.isEmpty()) {
                this.savePreset(suffix);
            }
            this.popup = null;
            this.method_37066((class_364)this.presetNameField);
            this.presetNameField = null;
        }, 1.0f);
        this.popup.init(this.field_22793, this.field_22789, this.field_22790);
    }

    public void dupePopup(String input) {
        String truncated = input.length() > 7 ? input.substring(0, 7) + "..." : input;
        this.popup = new VCPopup((class_2561)class_2561.method_43470((String)("Entry with key '" + truncated + "' already exists!")), "Continue Editing", () -> {
            this.popup = null;
        }, "Discard Entry", () -> {
            if (this.addEntry != null) {
                this.addEntry.abortEntry();
            }
            this.popup = null;
        }, 1.0f);
        this.popup.init(this.field_22793, this.field_22789, this.field_22790);
    }

    private void savePreset(String suffix) {
        FishyPresets.saveAlertPreset(suffix, FishyConfig.chatAlerts.getValues());
    }

    @Environment(value=EnvType.CLIENT)
    private class AddEntry {
        private final VCTextField keyField;
        private class_4185 saveBtn;
        private class_4185 cancelBtn;

        public AddEntry() {
            this.keyField = new VCTextField(GUIChatAlert.this.field_22793, 0, 0, fieldW, fieldH, (class_2561)class_2561.method_43470((String)"Key"));
            this.keyField.method_1858(false);
            this.keyField.method_1852("");
            this.keyField.method_1888(true);
            this.keyField.method_1880(50);
            this.keyField.setUIScale(uiScale);
            this.keyField.method_25365(true);
            this.keyField.method_47404((class_2561)class_2561.method_43470((String)"Detected String...").method_27694(style -> style.method_36139(-8355712)));
            GUIChatAlert.this.method_25395((class_364)this.keyField);
            this.saveBtn = new FaButton(0, 0, delBtnW, fieldH, (class_2561)class_2561.method_43470((String)"\u2714").method_27694(s -> s.method_36139(0xCCFFCC)), btn -> {
                String key = this.keyField.method_1882().trim();
                if (!this.checkForDupes(key)) {
                    return;
                }
                if (!key.isEmpty()) {
                    FishyConfig.setChatAlert(key, new FishyConfig.AlertData());
                    this.abortEntry();
                }
            });
            this.cancelBtn = new FaButton(0, 0, delBtnW, fieldH, (class_2561)class_2561.method_43470((String)"\u274c").method_27694(s -> s.method_36139(0xFF8080)), btn -> this.abortEntry());
        }

        public void abortEntry() {
            GUIChatAlert.this.addMode = false;
            GUIChatAlert.this.method_37066((class_364)this.keyField);
            GUIChatAlert.this.method_37066((class_364)this.saveBtn);
            GUIChatAlert.this.method_37066((class_364)this.cancelBtn);
            GUIChatAlert.this.method_25426();
        }

        public void setPosition(int x, int y) {
            this.keyField.method_46421(x);
            this.keyField.method_46419(y);
            this.saveBtn.method_46421(x + fieldW);
            this.saveBtn.method_46419(y);
            this.cancelBtn.method_46421(x + fieldW + delBtnW);
            this.cancelBtn.method_46419(y);
        }

        public void updateVisibility() {
            if (this.keyField.field_22764) {
                this.keyField.method_1862(false);
                this.saveBtn.field_22764 = false;
                this.cancelBtn.field_22764 = false;
            }
            this.setVisible(true);
        }

        public void setVisible(boolean visible) {
            this.keyField.method_1862(visible);
            this.saveBtn.field_22764 = visible;
            this.cancelBtn.field_22764 = visible;
        }

        private boolean checkForDupes(String key) {
            for (Entry entry : GUIChatAlert.this.entries) {
                if (!entry.keyField.getText().trim().equals(key)) continue;
                GUIChatAlert.this.dupePopup(entry.keyField.getText().trim());
                return false;
            }
            return true;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class Entry {
        private final VCLabelField keyField;
        private final class_4185 editBtn;
        private class_4185 delBtn;
        private class_4185 toggleBtn;

        public Entry(String key) {
            this.keyField = new VCLabelField(GUIChatAlert.this.field_22793, 0, 0, fieldW, fieldH, class_2561.method_43470((String)"Key"));
            this.keyField.setText(key);
            this.keyField.setUIScale(uiScale);
            this.keyField.method_25365(false);
            this.editBtn = VCButton.createNavigationButton(0, 0, btnW, fieldH, class_2561.method_43470((String)"Edit").method_27694(s -> s.method_36139(14863081)), btn -> {
                String currentKey = this.keyField.getText().trim();
                FishyConfig.AlertData data = FishyConfig.getChatAlerts().get(currentKey);
                class_310.method_1551().method_1507((class_437)new AlertEditScreen(currentKey, data, GUIChatAlert.this));
            }, uiScale - 0.1f);
            this.delBtn = VCButton.createNavigationButton(0, 0, delBtnW, fieldH, class_2561.method_43470((String)"\ud83d\uddd1").method_10862(class_2583.field_24360.method_36139(-8355712)), btn -> {
                String currentKey = this.keyField.getText().trim();
                FishyConfig.removeChatAlert(currentKey);
                ChatAlert.refresh();
                GUIChatAlert.this.entries.remove(this);
                GUIChatAlert.this.method_37066((class_364)this.keyField);
                GUIChatAlert.this.method_37066((class_364)this.editBtn);
                GUIChatAlert.this.method_37066((class_364)this.delBtn);
                GUIChatAlert.this.method_37066((class_364)this.toggleBtn);
                GUIChatAlert.this.method_25426();
            }, uiScale);
            boolean state = FishyConfig.isChatAlertToggled(key);
            this.toggleBtn = VCButton.createMcToggle(0, 0, btnW, fieldH, state, btn -> {
                String currentKey = this.keyField.getText().trim();
                FishyConfig.toggleChatAlert(currentKey, !state);
                ChatAlert.refresh();
                GUIChatAlert.this.method_25426();
            }, uiScale - 0.1f);
        }

        public void setPosition(int x, int y) {
            this.keyField.method_46421(x);
            this.keyField.method_46419(y);
            this.editBtn.method_46421(x + fieldW);
            this.editBtn.method_46419(y);
            this.toggleBtn.method_46421(x + fieldW + btnW);
            this.toggleBtn.method_46419(y);
            this.delBtn.method_46421(x + fieldW + btnW * 2);
            this.delBtn.method_46419(y);
        }

        public void setVisible(boolean visible) {
            this.keyField.setVisible(visible);
            this.editBtn.field_22764 = visible;
            this.delBtn.field_22764 = visible;
            this.toggleBtn.field_22764 = visible;
        }

        public boolean mouseClicked(double mouseX, double mouseY) {
            if (GUIChatAlert.isInside(this.keyField.method_46426(), this.keyField.method_46427(), this.keyField.method_25368(), this.keyField.method_25364(), mouseX, mouseY)) {
                return true;
            }
            if (GUIChatAlert.isInside(this.editBtn.method_46426(), this.editBtn.method_46427(), this.editBtn.method_25368(), this.editBtn.method_25364(), mouseX, mouseY)) {
                this.editBtn.method_25306();
                return true;
            }
            if (GUIChatAlert.isInside(this.delBtn.method_46426(), this.delBtn.method_46427(), this.delBtn.method_25368(), this.delBtn.method_25364(), mouseX, mouseY)) {
                this.delBtn.method_25306();
                return true;
            }
            if (GUIChatAlert.isInside(this.toggleBtn.method_46426(), this.toggleBtn.method_46427(), this.toggleBtn.method_25368(), this.toggleBtn.method_25364(), mouseX, mouseY)) {
                this.toggleBtn.method_25306();
                return true;
            }
            return false;
        }
    }
}

