/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.ColorWheel;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.VCTextField;
import me.valkeea.fishyaddons.gui.VCVisuals;
import me.valkeea.fishyaddons.handler.FaColors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class GUIFaColor
extends class_437 {
    private static final float UI_SCALE = 1.0f;
    private static final int ENTRY_HEIGHT = 28;
    private static final int ENTRY_WIDTH = 300;
    private static final int COLOR_BTN_WIDTH = 40;
    private static final int DEL_BTN_WIDTH = 20;
    private static final int FIELD_WIDTH = 160;
    private static final int FIELD_HEIGHT = 20;
    private static final String COLOR_TEXT = "Color";
    private final class_437 parent;
    private final List<Entry> entries = new ArrayList<Entry>();
    private boolean addMode = false;
    private boolean isDraggingScrollbar = false;
    private int scrollOffset = 0;
    private int maxVisibleEntries = 0;
    private int scrollbarThumbOffset = 0;
    private AddEntry addEntry = null;
    private class_4185 addBtn = null;

    public GUIFaColor(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"User Color Overrides"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.entries.clear();
        this.method_37067();
        for (Map.Entry<String, Integer> entry : FishyConfig.getFaC().entrySet()) {
            Entry e = new Entry(entry.getKey(), entry.getValue());
            this.entries.add(e);
            this.method_37063((class_364)e.nameField);
            this.method_37063((class_364)e.colorBtn);
            this.method_37063((class_364)e.delBtn);
        }
        int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
        int listTop = 40;
        int listBottom = this.field_22790 - 60;
        int listHeight = listBottom - listTop;
        this.maxVisibleEntries = Math.max(1, listHeight / 28);
        int maxScroll = Math.max(0, totalEntries - this.maxVisibleEntries);
        if (this.scrollOffset > maxScroll) {
            this.scrollOffset = maxScroll;
        }
        if (this.scrollOffset < 0) {
            this.scrollOffset = 0;
        }
        if (!this.addMode) {
            int addBtnY = 40 + this.entries.size() * 28;
            this.addBtn = new FaButton(this.field_22789 / 2 - 150, addBtnY, 80, 20, (class_2561)class_2561.method_43470((String)"Add").method_27694(style -> style.method_36139(0xCCFFCC)), btn -> {
                this.addMode = true;
                this.addEntry = new AddEntry();
                this.method_37063((class_364)this.addEntry.nameField);
                this.method_37063((class_364)this.addEntry.colorBtn);
                this.method_37063((class_364)this.addEntry.saveBtn);
                this.method_37063((class_364)this.addEntry.cancelBtn);
                this.method_37066((class_364)this.addBtn);
            });
            this.method_37063((class_364)this.addBtn);
        }
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 - 150 + 80, this.field_22790 - 40, 80, 20, (class_2561)class_2561.method_43470((String)"Back").method_27694(style -> style.method_36139(-8355712)), btn -> this.field_22787.method_1507(this.parent)));
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 - 150 + 160, this.field_22790 - 40, 80, 20, (class_2561)class_2561.method_43470((String)"Close").method_27694(style -> style.method_36139(-8355712)), btn -> this.method_25419()));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_51433(this.field_22793, "User Color Overrides", this.field_22789 / 2 - 80, 15, -11141121, false);
        int listTop = 40;
        int listBottom = this.field_22790 - 60;
        int listHeight = listBottom - listTop;
        this.maxVisibleEntries = Math.max(1, listHeight / 28);
        int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
        int y = listTop;
        int startIdx = this.scrollOffset;
        int endIdx = Math.min(startIdx + this.maxVisibleEntries, this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            if (i >= startIdx && i < endIdx) {
                this.entries.get(i).setPosition(this.field_22789 / 2 - 150, y);
                this.entries.get(i).setVisible(true);
                y += 28;
                continue;
            }
            this.entries.get(i).setVisible(false);
        }
        if (this.addMode && this.addEntry != null) {
            this.addEntry.updateVisibility();
            if (endIdx == this.entries.size()) {
                this.addEntry.setPosition(this.field_22789 / 2 - 150, y);
            }
        }
        if (this.addBtn != null && !this.addMode) {
            int addBtnY = this.field_22790 - 40;
            this.addBtn.method_46421(this.field_22789 / 2 - 150);
            this.addBtn.method_46419(addBtnY);
        }
        if (totalEntries > this.maxVisibleEntries) {
            this.renderScrollIndicator(context, this.field_22789 / 2 + 150, listTop, listHeight, totalEntries);
        }
    }

    private void renderScrollIndicator(class_332 context, int x, int y, int listHeight, int totalEntries) {
        int scrollbarWidth = 3;
        context.method_25294(x, y, x + scrollbarWidth, y + listHeight, 0x44000000);
        if (totalEntries > this.maxVisibleEntries) {
            int thumbHeight = Math.max(10, this.maxVisibleEntries * listHeight / totalEntries);
            int thumbY = y + this.scrollOffset * (listHeight - thumbHeight) / (totalEntries - this.maxVisibleEntries);
            context.method_25294(x + 1, thumbY, x + scrollbarWidth - 1, thumbY + thumbHeight, VCVisuals.getThemeColor());
            context.method_25294(x + 1, thumbY + thumbHeight - 1, x + scrollbarWidth - 1, thumbY + thumbHeight, -16777216);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int listTop = 40;
        int listBottom = this.field_22790 - 60;
        int listHeight = listBottom - listTop;
        int scrollbarX = this.field_22789 / 2 + 300;
        int scrollbarWidth = Math.max(4, 8);
        int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
        if (totalEntries > this.maxVisibleEntries && mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)listTop && mouseY <= (double)(listTop + listHeight)) {
            int thumbHeight = Math.max(10, this.maxVisibleEntries * listHeight / totalEntries);
            int thumbY = listTop + this.scrollOffset * (listHeight - thumbHeight) / (totalEntries - this.maxVisibleEntries);
            if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                this.isDraggingScrollbar = true;
                this.scrollbarThumbOffset = (int)mouseY - thumbY;
            } else {
                this.isDraggingScrollbar = true;
                this.scrollbarThumbOffset = thumbHeight / 2;
                double trackClickY = mouseY - (double)listTop - (double)this.scrollbarThumbOffset;
                double scrollPercent = trackClickY / (double)(listHeight - thumbHeight);
                int newScrollOffset = (int)(scrollPercent * (double)(totalEntries - this.maxVisibleEntries));
                this.scrollOffset = Math.clamp((long)newScrollOffset, 0, totalEntries - this.maxVisibleEntries);
            }
            return true;
        }
        int startIdx = this.scrollOffset;
        int endIdx = Math.min(startIdx + this.maxVisibleEntries, this.entries.size());
        for (int i = startIdx; i < endIdx; ++i) {
            if (!this.entries.get(i).mouseClicked()) continue;
            return true;
        }
        for (Entry entry : this.entries) {
            entry.saveIfChanged();
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDraggingScrollbar) {
            int listTop = 40;
            int listBottom = this.field_22790 - 60;
            int listHeight = listBottom - listTop;
            int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
            int thumbHeight = Math.max(10, this.maxVisibleEntries * listHeight / totalEntries);
            int mouseThumbY = (int)mouseY - listTop - this.scrollbarThumbOffset;
            double scrollPercent = (double)mouseThumbY / (double)(listHeight - thumbHeight);
            int newScrollOffset = (int)(scrollPercent * (double)(totalEntries - this.maxVisibleEntries));
            this.scrollOffset = Math.clamp((long)newScrollOffset, 0, totalEntries - this.maxVisibleEntries);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int totalEntries = this.entries.size() + (this.addMode ? 1 : 0);
        if (totalEntries > this.maxVisibleEntries) {
            this.scrollOffset -= (int)Math.signum(verticalAmount);
            this.scrollOffset = Math.clamp((long)this.scrollOffset, 0, totalEntries - this.maxVisibleEntries);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public void method_25432() {
        for (Entry entry : this.entries) {
            entry.saveIfChanged();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class AddEntry {
        private final VCTextField nameField;
        private int color = 16759012;
        private class_4185 colorBtn;
        private class_4185 saveBtn;
        private class_4185 cancelBtn;

        public AddEntry() {
            this.nameField = new VCTextField(GUIFaColor.this.field_22793, 0, 0, 160, 20, (class_2561)class_2561.method_43470((String)"Name"));
            this.nameField.method_1852("");
            this.nameField.method_1888(true);
            this.nameField.method_1880(32);
            this.nameField.setUIScale(1.0f);
            this.nameField.method_25365(true);
            GUIFaColor.this.method_25395((class_364)this.nameField);
            this.colorBtn = new FaButton(0, 0, 40, 20, (class_2561)class_2561.method_43470((String)GUIFaColor.COLOR_TEXT).method_27694(s -> s.method_36139(this.color)), btn -> {
                float[] rgb = ColorWheel.intToRGB(this.color);
                class_310.method_1551().method_1507((class_437)new ColorWheel(GUIFaColor.this, rgb, selected -> {
                    this.color = ColorWheel.rgbToInt(selected);
                    this.colorBtn.method_25355((class_2561)class_2561.method_43470((String)GUIFaColor.COLOR_TEXT).method_27694(s -> s.method_36139(this.color)));
                    this.nameField.method_1868(this.color);
                    String name = this.nameField.method_1882().trim();
                    if (!name.isEmpty()) {
                        FaColors.saveUserEntry(name, this.color & 0xFFFFFF);
                        GUIFaColor.this.addMode = false;
                        GUIFaColor.this.method_37066((class_364)this.nameField);
                        GUIFaColor.this.method_37066((class_364)this.colorBtn);
                        GUIFaColor.this.method_37066((class_364)this.saveBtn);
                        GUIFaColor.this.method_37066((class_364)this.cancelBtn);
                        GUIFaColor.this.method_25426();
                    } else {
                        class_310.method_1551().method_1507((class_437)GUIFaColor.this);
                    }
                }));
            });
            this.saveBtn = new FaButton(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)"\u2714").method_27694(s -> s.method_36139(0xCCFFCC)), btn -> {
                String name = this.nameField.method_1882().trim();
                if (!name.isEmpty()) {
                    FaColors.saveUserEntry(name, this.color & 0xFFFFFF);
                    GUIFaColor.this.addMode = false;
                    GUIFaColor.this.method_37066((class_364)this.nameField);
                    GUIFaColor.this.method_37066((class_364)this.colorBtn);
                    GUIFaColor.this.method_37066((class_364)this.saveBtn);
                    GUIFaColor.this.method_37066((class_364)this.cancelBtn);
                    GUIFaColor.this.method_25426();
                }
            });
            this.cancelBtn = new FaButton(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)"\ud83d\uddd1").method_27694(s -> s.method_36139(0xFF8080)), btn -> {
                GUIFaColor.this.addMode = false;
                GUIFaColor.this.method_37066((class_364)this.nameField);
                GUIFaColor.this.method_37066((class_364)this.colorBtn);
                GUIFaColor.this.method_37066((class_364)this.saveBtn);
                GUIFaColor.this.method_37066((class_364)this.cancelBtn);
                GUIFaColor.this.method_25426();
            });
        }

        public void setPosition(int x, int y) {
            this.nameField.method_46421(x);
            this.nameField.method_46419(y);
            this.colorBtn.method_46421(x + 160);
            this.colorBtn.method_46419(y);
            this.saveBtn.method_46421(x + 160 + 40);
            this.saveBtn.method_46419(y);
            this.cancelBtn.method_46421(x + 160 + 40 + 20);
            this.cancelBtn.method_46419(y);
        }

        public void updateVisibility() {
            if (this.nameField.field_22764) {
                this.nameField.method_1862(false);
                this.colorBtn.field_22764 = false;
                this.saveBtn.field_22764 = false;
                this.cancelBtn.field_22764 = false;
            }
            this.setVisible(true);
        }

        public void setVisible(boolean visible) {
            this.nameField.method_1862(visible);
            this.colorBtn.field_22764 = visible;
            this.saveBtn.field_22764 = visible;
            this.cancelBtn.field_22764 = visible;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class Entry {
        private final VCTextField nameField;
        private int color;
        private String originalName;
        private int originalColor;
        private final class_4185 colorBtn;
        private class_4185 delBtn;
        private boolean changed = false;

        public Entry(String name, int color) {
            this.originalName = name;
            this.originalColor = color;
            this.color = color;
            this.nameField = new VCTextField(GUIFaColor.this.field_22793, 0, 0, 160, 20, (class_2561)class_2561.method_43470((String)"Name"));
            this.nameField.method_1852(name);
            this.nameField.method_1888(true);
            this.nameField.method_1880(32);
            this.nameField.setUIScale(1.0f);
            this.nameField.method_25365(false);
            this.colorBtn = new FaButton(0, 0, 40, 20, (class_2561)class_2561.method_43470((String)GUIFaColor.COLOR_TEXT).method_27694(s -> s.method_36139(color)), btn -> {
                float[] rgb = ColorWheel.intToRGB(this.color);
                class_310.method_1551().method_1507((class_437)new ColorWheel(GUIFaColor.this, rgb, selected -> {
                    this.color = ColorWheel.rgbToInt(selected);
                    btn.method_25355((class_2561)class_2561.method_43470((String)GUIFaColor.COLOR_TEXT).method_27694(s -> s.method_36139(this.color)));
                    class_310.method_1551().method_1507((class_437)GUIFaColor.this);
                    this.changed = true;
                    FaColors.saveUserEntry(this.originalName, this.color & 0xFFFFFF);
                }));
            });
            this.delBtn = new FaButton(0, 0, 20, 20, (class_2561)class_2561.method_43470((String)"\u274c").method_27694(style -> style.method_36139(-8355712)), btn -> {
                FaColors.deleteUserEntry(this.originalName);
                GUIFaColor.this.entries.remove(this);
                GUIFaColor.this.method_37066((class_364)this.nameField);
                GUIFaColor.this.method_37066((class_364)this.colorBtn);
                GUIFaColor.this.method_37066((class_364)this.delBtn);
                GUIFaColor.this.method_25426();
            });
        }

        public void setPosition(int x, int y) {
            this.nameField.method_46421(x);
            this.nameField.method_46419(y);
            this.colorBtn.method_46421(x + 160);
            this.colorBtn.method_46419(y);
            this.delBtn.method_46421(x + 160 + 40);
            this.delBtn.method_46419(y);
        }

        public void setVisible(boolean visible) {
            this.nameField.method_1862(visible);
            this.colorBtn.field_22764 = visible;
            this.delBtn.field_22764 = visible;
        }

        public boolean mouseClicked() {
            return false;
        }

        public void saveIfChanged() {
            String newName = this.nameField.method_1882().trim();
            if (!(newName.isEmpty() || !this.changed && newName.equals(this.originalName) && this.color == this.originalColor)) {
                if (!newName.equals(this.originalName)) {
                    FaColors.deleteUserEntry(this.originalName);
                }
                FaColors.saveUserEntry(newName, this.color & 0xFFFFFF);
                this.originalName = newName;
                this.originalColor = this.color;
                this.changed = false;
            }
        }
    }
}

