/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.GuiUtil;
import me.valkeea.fishyaddons.gui.TabbedListScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_4185;

@Environment(value=EnvType.CLIENT)
public abstract class GenericEntryList
extends class_350<GenericEntry> {
    protected final TabbedListScreen parentScreen;
    private final Map<String, GenericEntry> entryMap = new LinkedHashMap<String, GenericEntry>();

    protected GenericEntryList(class_310 client, int width, int height, int y, int itemHeight, TabbedListScreen parentScreen) {
        super(client, width, height, y, itemHeight);
        this.parentScreen = parentScreen;
    }

    public int method_25322() {
        return 550;
    }

    public abstract Map<String, String> getEntries();

    public abstract boolean isEntryToggled(String var1);

    public abstract void setEntry(String var1, String var2);

    public abstract void removeEntry(String var1);

    public abstract void toggleEntry(String var1, boolean var2);

    public abstract void getGuideText(class_332 var1, class_327 var2, int var3, int var4);

    public abstract String getAddButtonText();

    public abstract String getSaveButtonText();

    public abstract String getDeleteButtonText();

    public abstract String getToggleOnText();

    public abstract String getToggleOffText();

    public abstract boolean isValidEntry(String var1, String var2);

    public String getDefaultInput() {
        return "/";
    }

    public String getDefaultOutput() {
        return "/";
    }

    public void refreshWithAdd() {
        Map<String, String> entries = this.getEntries();
        this.entryMap.keySet().removeIf(key -> !entries.containsKey(key));
        for (Map.Entry<String, String> entry : entries.entrySet()) {
            GenericEntry existing = this.entryMap.get(entry.getKey());
            if (existing != null) {
                class_342 field;
                Object object;
                existing.input = entry.getKey();
                existing.output = entry.getValue();
                if (!existing.outputField.method_1882().equals(entry.getValue())) {
                    existing.outputField.method_1852(entry.getValue());
                }
                if (!((object = existing.inputWidget) instanceof class_342) || (field = (class_342)object).method_1882().equals(entry.getKey())) continue;
                field.method_1852(entry.getKey());
                continue;
            }
            this.entryMap.put(entry.getKey(), new GenericEntry(entry.getKey(), entry.getValue(), this, this.parentScreen));
        }
        this.method_25396().clear();
        for (String key2 : entries.keySet()) {
            this.method_25396().add(this.entryMap.get(key2));
        }
        if (this.parentScreen.addingNewEntry) {
            GenericEntry newEntry = new GenericEntry(this.getDefaultInput(), this.getDefaultOutput(), this, this.parentScreen);
            newEntry.isNew = true;
            this.method_25396().add(newEntry);
        }
        this.method_25396().add(new AddEntry(this, this.parentScreen));
    }

    public boolean doesKeyExist(String key, GenericEntry exclude) {
        return this.method_25396().stream().anyMatch(e -> {
            GenericEntry ge;
            return e instanceof GenericEntry && (ge = e) != exclude && !ge.isNew && ge.input.equals(key);
        });
    }

    public Object createInputWidget(String input, GenericEntry output) {
        class_342 field = new class_342(class_310.method_1551().field_1772, 0, 0, 100, 20, (class_2561)class_2561.method_43470((String)"Alias"));
        field.method_1852(input);
        field.method_1880(256);
        field.method_1858(false);
        return field;
    }

    public class_4185 createExtraButton(GenericEntry entry) {
        return null;
    }

    @Environment(value=EnvType.CLIENT)
    public static class GenericEntry
    extends class_350.class_351<GenericEntry> {
        protected String input;
        protected String output;
        protected final class_4185 deleteButton;
        protected final class_4185 toggleButton;
        protected final class_4185 saveButton;
        protected final class_342 outputField;
        protected boolean isNew = false;
        protected final GenericEntryList entryList;
        protected final TabbedListScreen parentScreen;
        protected final Object inputWidget;
        protected final class_4185 extraButton;
        protected String pendingTooltip = null;
        protected int tooltipX = 0;
        protected int tooltipY = 0;
        protected List<class_2561> tooltipLines = null;
        protected boolean duplicatePopupShown = false;

        public GenericEntry(String input, String output, GenericEntryList entryList, TabbedListScreen parentScreen) {
            this.input = input;
            this.output = output;
            this.entryList = entryList;
            this.parentScreen = parentScreen;
            this.inputWidget = entryList.createInputWidget(input, this);
            this.outputField = this.createOutputField(output);
            this.saveButton = this.createSaveButton();
            this.deleteButton = this.createDeleteButton();
            this.toggleButton = this.createToggleButton();
            this.extraButton = entryList.createExtraButton(this);
        }

        private class_342 createOutputField(String output) {
            class_342 field = new class_342(class_310.method_1551().field_1772, 0, 0, 200, 20, (class_2561)class_2561.method_43470((String)"Command"));
            field.method_1852(output);
            field.method_1880(256);
            field.method_1858(false);
            return field;
        }

        private FaButton createSaveButton() {
            return new FaButton(0, 0, 60, 20, (class_2561)class_2561.method_43470((String)this.entryList.getSaveButtonText()).method_27694(style -> style.method_36139(-8355712)), b -> this.handleSave());
        }

        public void dupePopup() {
            String string;
            Object object = this.inputWidget;
            if (object instanceof class_342) {
                class_342 field = (class_342)object;
                string = field.method_1882().trim();
            } else {
                string = this.input;
            }
            String enteredInput = string;
            String enteredOutput = this.outputField.method_1882().trim();
            this.parentScreen.showFishyPopup((class_2561)class_2561.method_43470((String)("Entry with key '" + enteredInput + "' already exists!")), (class_2561)class_2561.method_43470((String)"Overwrite Existing"), () -> {
                this.entryList.setEntry(enteredInput, enteredOutput);
                this.entryList.method_25396().remove((Object)this);
                this.duplicatePopupShown = false;
                this.parentScreen.addingNewEntry = false;
                this.parentScreen.refreshEntryList();
                Object patt0$temp = this.inputWidget;
                if (patt0$temp instanceof class_342) {
                    class_342 field = (class_342)patt0$temp;
                    field.method_25365(false);
                }
                this.parentScreen.refreshEntryList();
                this.parentScreen.fishyPopup = null;
            }, (class_2561)class_2561.method_43470((String)"Discard Entry"), () -> {
                this.entryList.method_25396().remove((Object)this);
                this.parentScreen.addingNewEntry = false;
                this.duplicatePopupShown = false;
                this.parentScreen.refreshEntryList();
                this.parentScreen.fishyPopup = null;
            });
        }

        private void handleSave() {
            String string;
            Object object = this.inputWidget;
            if (object instanceof class_342) {
                class_342 field = (class_342)object;
                string = field.method_1882().trim();
            } else {
                string = this.input;
            }
            String enteredInput = string;
            String enteredOutput = this.outputField.method_1882().trim();
            if (enteredOutput.length() > 255) {
                this.parentScreen.showFishyPopup((class_2561)class_2561.method_43470((String)"Output too long!"), (class_2561)class_2561.method_43470((String)"Continue Editing"), () -> {
                    this.parentScreen.fishyPopup = null;
                }, (class_2561)class_2561.method_43470((String)"Discard Entry"), () -> {
                    this.entryList.method_25396().remove((Object)this);
                    this.parentScreen.addingNewEntry = false;
                    this.parentScreen.refreshEntryList();
                    this.parentScreen.fishyPopup = null;
                });
                return;
            }
            if (!this.entryList.isValidEntry(enteredInput, enteredOutput)) {
                this.parentScreen.showFishyPopup((class_2561)class_2561.method_43470((String)"Invalid entry! Please fix or discard."), (class_2561)class_2561.method_43470((String)"Continue Editing"), () -> {
                    this.parentScreen.fishyPopup = null;
                }, (class_2561)class_2561.method_43470((String)"Discard Entry"), () -> {
                    this.entryList.method_25396().remove((Object)this);
                    this.parentScreen.addingNewEntry = false;
                    this.parentScreen.refreshEntryList();
                    this.parentScreen.fishyPopup = null;
                });
                return;
            }
            boolean keyChanged = !enteredInput.equals(this.input);
            boolean duplicateExists = this.entryList.method_25396().stream().anyMatch(e -> {
                GenericEntry ge;
                return e instanceof GenericEntry && (ge = e) != this && !ge.isNew && ge.input.equals(enteredInput);
            });
            if (duplicateExists && !this.duplicatePopupShown) {
                this.dupePopup();
                return;
            }
            this.duplicatePopupShown = false;
            Object object2 = this.inputWidget;
            if (object2 instanceof class_342) {
                class_342 field = (class_342)object2;
                field.method_25365(false);
            }
            this.outputField.method_25365(false);
            if (keyChanged && !this.isNew) {
                this.entryList.removeEntry(this.input);
            }
            this.entryList.setEntry(enteredInput, enteredOutput);
            this.input = enteredInput;
            this.output = enteredOutput;
            class_310.method_1551().field_1755.method_25395(null);
            this.parentScreen.addingNewEntry = false;
            this.parentScreen.refreshEntryList();
        }

        private FaButton createDeleteButton() {
            return new FaButton(0, 0, 60, 20, (class_2561)class_2561.method_43470((String)this.entryList.getDeleteButtonText()).method_27694(style -> style.method_36139(-8355712)), b -> this.handleDelete());
        }

        public void checkAndSave() {
            this.handleSave();
        }

        private void handleDelete() {
            Object object = this.inputWidget;
            if (object instanceof class_342) {
                class_342 field = (class_342)object;
                field.method_25365(false);
            }
            this.outputField.method_25365(false);
            if (this.isNew) {
                this.parentScreen.addingNewEntry = false;
                this.parentScreen.refreshEntryList();
            } else {
                this.entryList.removeEntry(this.input);
                if (this.parentScreen != null) {
                    this.parentScreen.refreshEntryList();
                }
            }
        }

        private FaButton createToggleButton() {
            FaButton[] toggleButtonRef;
            boolean isToggled = this.entryList.isEntryToggled(this.input);
            FaButton toggleBtn = new FaButton(0, 0, 40, 20, (class_2561)class_2561.method_43470((String)(isToggled ? this.entryList.getToggleOnText() : this.entryList.getToggleOffText())).method_27694(style -> style.method_36139(isToggled ? -3342388 : -32640)), b -> this.handleToggle(toggleButtonRef));
            toggleButtonRef = new FaButton[]{toggleBtn};
            return toggleBtn;
        }

        private void handleToggle(class_4185[] toggleButtonRef) {
            Object object = this.inputWidget;
            if (object instanceof class_342) {
                class_342 field = (class_342)object;
                field.method_25365(false);
            }
            this.outputField.method_25365(false);
            boolean toggled = !this.entryList.isEntryToggled(this.input);
            this.entryList.toggleEntry(this.input, toggled);
            toggleButtonRef[0].method_25355((class_2561)class_2561.method_43470((String)(toggled ? this.entryList.getToggleOnText() : this.entryList.getToggleOffText())).method_27694(style2 -> style2.method_36139(toggled ? -3342388 : -32640)));
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.pendingTooltip = null;
            int ax = x;
            int ay = y;
            int aw = 100;
            int ah = 20;
            int cx = x + 110;
            int cy = y;
            int cw = 200;
            int ch = 20;
            this.renderInputField(context, ax, ay, aw, ah, mouseX, mouseY, delta);
            this.renderOutputField(context, cx, cy, cw, ch, mouseX, mouseY, delta);
            this.renderButtons(context, x, y, mouseX, mouseY, delta);
            this.updateTooltipState(cx, cy, cw, ch, mouseX, mouseY);
        }

        private void renderInputField(class_332 context, int ax, int ay, int aw, int ah, int mouseX, int mouseY, float delta) {
            Object object = this.inputWidget;
            if (object instanceof class_342) {
                class_342 field = (class_342)object;
                int inputColor = field.method_25370() ? -1914135 : -11184811;
                GuiUtil.drawBox(context, ax, ay, aw, ah, inputColor);
                field.method_46421(ax + 2);
                field.method_46419(ay + 5);
                field.method_25394(context, mouseX, mouseY, delta);
            } else {
                object = this.inputWidget;
                if (object instanceof class_4185) {
                    class_4185 button = (class_4185)object;
                    button.method_46421(ax + 2);
                    button.method_46419(ay - 1);
                    button.method_25394(context, mouseX, mouseY, delta);
                }
            }
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            class_342 field;
            if (keyCode == 257 || keyCode == 335) {
                this.handleSave();
                return true;
            }
            if (keyCode == 258) {
                boolean shift = (modifiers & 1) != 0;
                ArrayList<Object> widgets = new ArrayList<Object>();
                Iterator iterator = this.inputWidget;
                if (iterator instanceof class_342) {
                    class_342 field2 = (class_342)iterator;
                    widgets.add(field2);
                }
                widgets.add(this.outputField);
                widgets.add(this.saveButton);
                widgets.add(this.deleteButton);
                widgets.add(this.toggleButton);
                if (this.extraButton != null) {
                    widgets.add(this.extraButton);
                }
                class_339 focused = null;
                for (class_339 class_3392 : widgets) {
                    if (!class_3392.method_25370()) continue;
                    focused = class_3392;
                    break;
                }
                int idx = widgets.indexOf(focused);
                int n = shift ? (idx - 1 + widgets.size()) % widgets.size() : (idx + 1) % widgets.size();
                for (class_339 class_3393 : widgets) {
                    class_3393.method_25365(false);
                }
                ((class_339)widgets.get(n)).method_25365(true);
                return true;
            }
            Object object = this.inputWidget;
            if (object instanceof class_342 && (field = (class_342)object).method_25370()) {
                return field.method_25404(keyCode, scanCode, modifiers);
            }
            if (this.outputField.method_25370()) {
                return this.outputField.method_25404(keyCode, scanCode, modifiers);
            }
            if (this.saveButton.method_25370()) {
                return this.saveButton.method_25404(keyCode, scanCode, modifiers);
            }
            if (this.deleteButton.method_25370()) {
                return this.deleteButton.method_25404(keyCode, scanCode, modifiers);
            }
            if (this.toggleButton.method_25370()) {
                return this.toggleButton.method_25404(keyCode, scanCode, modifiers);
            }
            if (this.extraButton != null && this.extraButton.method_25370()) {
                return this.extraButton.method_25404(keyCode, scanCode, modifiers);
            }
            return false;
        }

        private void renderOutputField(class_332 context, int cx, int cy, int cw, int ch, int mouseX, int mouseY, float delta) {
            int outputColor = this.outputField.method_25370() ? -1914135 : -11184811;
            GuiUtil.drawBox(context, cx, cy, cw, ch, outputColor);
            this.outputField.method_46421(cx + 2);
            this.outputField.method_46419(cy + 5);
            this.outputField.method_25394(context, mouseX, mouseY, delta);
        }

        private void renderButtons(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
            this.saveButton.method_46421(x + 320);
            this.saveButton.method_46419(y);
            this.saveButton.method_25394(context, mouseX, mouseY, delta);
            this.deleteButton.method_46421(x + 385);
            this.deleteButton.method_46419(y);
            this.deleteButton.method_25394(context, mouseX, mouseY, delta);
            this.toggleButton.method_46421(x + 450);
            this.toggleButton.method_46419(y);
            this.toggleButton.method_25394(context, mouseX, mouseY, delta);
            if (this.extraButton != null) {
                this.extraButton.method_46421(x + 495);
                this.extraButton.method_46419(y);
                this.extraButton.method_25394(context, mouseX, mouseY, delta);
            }
        }

        private void updateTooltipState(int cx, int cy, int cw, int ch, int mouseX, int mouseY) {
            if (this.parentScreen.fishyPopup == null) {
                class_342 field;
                String inputText;
                Object mouseFieldY2;
                String outputText = this.outputField.method_1882();
                boolean outputTooltip = false;
                if (outputText.length() > 31) {
                    int mouseFieldX = cx + 2;
                    int mouseFieldY2 = cy + 5;
                    int fieldWidth = cw - 4;
                    int fieldHeight = ch - 10 + 10;
                    if (mouseX >= mouseFieldX && mouseX < mouseFieldX + fieldWidth && mouseY >= mouseFieldY2 && mouseY < mouseFieldY2 + fieldHeight) {
                        outputTooltip = true;
                        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
                        for (int i = 0; i < outputText.length(); i += 64) {
                            tooltipLines.add((class_2561)class_2561.method_43470((String)outputText.substring(i, Math.min(i + 64, outputText.length()))));
                        }
                        this.pendingTooltip = outputText;
                        this.tooltipX = mouseX;
                        this.tooltipY = mouseY;
                        this.tooltipLines = tooltipLines;
                    }
                }
                if (!outputTooltip && (mouseFieldY2 = this.inputWidget) instanceof class_342 && (inputText = (field = (class_342)mouseFieldY2).method_1882()).length() > 31) {
                    int mouseFieldX = field.method_46426();
                    int mouseFieldY3 = field.method_46427();
                    int fieldWidth = field.method_25368();
                    int fieldHeight = field.method_25364();
                    if (mouseX >= mouseFieldX && mouseX < mouseFieldX + fieldWidth && mouseY >= mouseFieldY3 && mouseY < mouseFieldY3 + fieldHeight) {
                        ArrayList<class_2561> tooltipLines = new ArrayList<class_2561>();
                        for (int i = 0; i < inputText.length(); i += 64) {
                            tooltipLines.add((class_2561)class_2561.method_43470((String)inputText.substring(i, Math.min(i + 64, inputText.length()))));
                        }
                        this.pendingTooltip = inputText;
                        this.tooltipX = mouseX;
                        this.tooltipY = mouseY;
                        this.tooltipLines = tooltipLines;
                        return;
                    }
                }
                if (!outputTooltip) {
                    this.pendingTooltip = null;
                    this.tooltipLines = null;
                }
            } else {
                this.pendingTooltip = null;
                this.tooltipLines = null;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class AddEntry
    extends GenericEntry {
        private final GenericEntryList entryList;
        private final TabbedListScreen parentScreen;
        private final class_4185 addButton;

        public AddEntry(GenericEntryList entryList, TabbedListScreen parentScreen) {
            super("", "", entryList, parentScreen);
            this.entryList = entryList;
            this.parentScreen = parentScreen;
            this.addButton = new FaButton(0, -20, 100, 20, (class_2561)class_2561.method_43470((String)entryList.getAddButtonText()), b -> {
                if (parentScreen.addingNewEntry) {
                    parentScreen.addingNewEntry = false;
                    parentScreen.refreshEntryList();
                    return;
                }
                GenericEntry lastEntry = null;
                for (class_350.class_351 entry : entryList.method_25396()) {
                    if (!(entry instanceof GenericEntry)) continue;
                    GenericEntry ce = (GenericEntry)entry;
                    if (!ce.isNew) continue;
                    lastEntry = ce;
                    break;
                }
                if (lastEntry != null) {
                    String string;
                    Object patt0$temp = lastEntry.inputWidget;
                    if (patt0$temp instanceof class_342) {
                        class_342 field = (class_342)patt0$temp;
                        string = field.method_1882().trim();
                    } else {
                        string = lastEntry.input;
                    }
                    String input = string;
                    String output = lastEntry.outputField.method_1882().trim();
                    if (!entryList.isValidEntry(input, output)) {
                        parentScreen.addingNewEntry = false;
                        parentScreen.refreshEntryList();
                        return;
                    }
                }
                if (!parentScreen.addingNewEntry) {
                    parentScreen.addingNewEntry = true;
                    parentScreen.refreshEntryList();
                }
            });
        }

        public boolean isSelectable() {
            return false;
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            if (this.parentScreen.addingNewEntry) {
                this.addButton.method_25355((class_2561)class_2561.method_43470((String)"Cancel").method_27694(style -> style.method_36139(-32640)));
            } else {
                this.addButton.method_25355((class_2561)class_2561.method_43470((String)this.entryList.getAddButtonText()).method_27694(style -> style.method_36139(-3342388)));
            }
            this.addButton.method_46421(x);
            this.addButton.method_46419(y);
            this.addButton.method_25394(context, mouseX, mouseY, delta);
            if (this.parentScreen.addingNewEntry && mouseX >= this.addButton.method_46426() && mouseX < this.addButton.method_46426() + this.addButton.method_25368() && mouseY >= this.addButton.method_46427() && mouseY < this.addButton.method_46427() + this.addButton.method_25364()) {
                GuiUtil.fishyTooltip(context, class_310.method_1551().field_1772, List.of(class_2561.method_43470((String)"This will delete your draft.")), mouseX, mouseY);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.addButton.method_25402(mouseX, mouseY, button);
        }
    }
}

