/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.GenericEntryList;
import me.valkeea.fishyaddons.gui.TabbedListScreen;
import me.valkeea.fishyaddons.handler.KeyShortcut;
import me.valkeea.fishyaddons.util.KeyUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class KeybindEntryList
extends GenericEntryList {
    public KeybindEntryList(class_310 client, int width, int height, int y, int itemHeight, TabbedListScreen parentScreen) {
        super(client, width, height, y, itemHeight, parentScreen);
    }

    @Override
    public String getDefaultInput() {
        return "> Press a Key <";
    }

    @Override
    public Map<String, String> getEntries() {
        return FishyConfig.getKeybinds();
    }

    @Override
    public boolean isEntryToggled(String key) {
        return FishyConfig.isKeybindToggled(key);
    }

    @Override
    public void setEntry(String key, String value) {
        FishyConfig.setKeybind(key, value);
    }

    @Override
    public void removeEntry(String key) {
        FishyConfig.removeKeybind(key);
    }

    @Override
    public void toggleEntry(String key, boolean toggled) {
        FishyConfig.toggleKeybind(key, toggled);
    }

    @Override
    public void getGuideText(class_332 context, class_327 tr, int x, int y) {
        context.method_27535(tr, (class_2561)class_2561.method_43470((String)"Keybind"), x - 5, y - 10, -5592406);
        context.method_27535(tr, (class_2561)class_2561.method_43470((String)"Executed Command"), x + 110, y - 10, -5592406);
    }

    @Override
    public String getAddButtonText() {
        return "+ Add Keybind";
    }

    @Override
    public String getSaveButtonText() {
        return "Save";
    }

    @Override
    public String getDeleteButtonText() {
        return "Delete";
    }

    @Override
    public String getToggleOnText() {
        return "ON";
    }

    @Override
    public String getToggleOffText() {
        return "OFF";
    }

    public GenericEntryList.GenericEntry getHoveredKeybindEntry() {
        return (GenericEntryList.GenericEntry)this.method_37019();
    }

    public void method_47399(class_6382 builder) {
    }

    @Override
    public boolean isValidEntry(String key, String value) {
        return !key.contains("> Press a Key <") && !key.isEmpty() && !value.isEmpty();
    }

    @Override
    public Object createInputWidget(String input, GenericEntryList.GenericEntry output) {
        return new KeybindButtonWidget(input, output, this, this.parentScreen);
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int button, TabbedListScreen screen) {
        GenericEntryList.GenericEntry entry = this.getHoveredKeybindEntry();
        if (entry == null) {
            return false;
        }
        Object object = entry.inputWidget;
        if (object instanceof class_342) {
            class_342 field = (class_342)object;
            if (field.method_25402(mouseX, mouseY, button)) {
                field.method_25365(true);
                screen.method_25395((class_364)field);
                return true;
            }
        } else {
            class_4185 btn;
            object = entry.inputWidget;
            if (object instanceof class_4185 && (btn = (class_4185)object).method_25402(mouseX, mouseY, button)) {
                btn.method_25365(true);
                screen.method_25395((class_364)btn);
                return true;
            }
        }
        if (entry.outputField.method_25402(mouseX, mouseY, button)) {
            entry.outputField.method_25365(true);
            screen.method_25395((class_364)entry.outputField);
            return true;
        }
        if (entry.saveButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (entry.deleteButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return entry.toggleButton.method_25402(mouseX, mouseY, button);
    }

    @Environment(value=EnvType.CLIENT)
    public static class KeybindButtonWidget
    extends class_4185 {
        private boolean listening = false;
        private String keyValue;
        private final GenericEntryList.GenericEntry entry;
        private final KeybindEntryList entryList;
        private final TabbedListScreen parentScreen;
        private final class_4185.class_4241 customPress;

        public KeybindButtonWidget(String keyValue, GenericEntryList.GenericEntry entry, KeybindEntryList entryList, TabbedListScreen parentScreen) {
            super(-40, 5, 100, 20, (class_2561)class_2561.method_43470((String)(keyValue.isEmpty() ? "Set Key" : KeyUtil.getDisplayNameFor(keyValue))), b -> {}, field_40754);
            this.keyValue = keyValue;
            this.entry = entry;
            this.entryList = entryList;
            this.parentScreen = parentScreen;
            this.customPress = b -> {
                this.method_25365(true);
                this.listening = true;
                this.method_25355((class_2561)class_2561.method_43470((String)"> Press a Key <"));
            };
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (this.listening) {
                String translationKey;
                String keyName = KeyUtil.getGlfwKeyName(keyCode);
                this.keyValue = keyName != null ? keyName : ((translationKey = class_3675.method_15985((int)keyCode, (int)scanCode).method_1441()).startsWith("key.keyboard.") ? translationKey.substring("key.keyboard.".length()).toUpperCase() : translationKey.toUpperCase());
                this.handleKeyChange();
                this.listening = false;
                if (this.keyValue.startsWith("MOUSE")) {
                    int btn = -1;
                    try {
                        btn = Integer.parseInt(this.keyValue.substring(5));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.method_25355((class_2561)class_2561.method_43470((String)("Mouse " + (btn + 1))));
                } else {
                    this.method_25355((class_2561)class_2561.method_43470((String)String.valueOf(KeyUtil.getKeyCodeFromString(this.keyValue))));
                }
                if (this.parentScreen != null) {
                    this.parentScreen.refreshEntryList();
                }
                this.method_25365(false);
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.listening) {
                this.keyValue = "MOUSE" + button;
                this.handleKeyChange();
                this.listening = false;
                return true;
            }
            if (this.method_25405(mouseX, mouseY)) {
                this.customPress.onPress((class_4185)this);
                return true;
            }
            return false;
        }

        private void handleKeyChange() {
            boolean duplicateExists = this.entryList.method_25396().stream().anyMatch(e -> {
                GenericEntryList.GenericEntry ge;
                return e instanceof GenericEntryList.GenericEntry && (ge = e) != this.entry && !ge.isNew && ge.input.equals(this.keyValue);
            });
            if (duplicateExists) {
                this.parentScreen.showFishyPopup((class_2561)class_2561.method_43470((String)("Keybind '" + this.keyValue + "' already exists!")), (class_2561)class_2561.method_43470((String)"Overwrite Existing"), () -> {
                    this.entryList.removeEntry(this.keyValue);
                    this.entryList.method_25396().removeIf(e -> {
                        if (!(e instanceof GenericEntryList.GenericEntry)) return false;
                        GenericEntryList.GenericEntry ge = e;
                        if (ge.isNew) return false;
                        if (!ge.input.equals(this.keyValue)) return false;
                        return true;
                    });
                    this.updateEntryAndConfig();
                    this.parentScreen.fishyPopup = null;
                    if (this.entry.outputField != null) {
                        this.entry.outputField.method_25365(true);
                    }
                }, (class_2561)class_2561.method_43470((String)"Discard Change"), () -> {
                    this.entryList.method_25396().remove((Object)this.entry);
                    this.parentScreen.addingNewEntry = false;
                    this.parentScreen.fishyPopup = null;
                    this.parentScreen.refreshEntryList();
                });
                this.entry.duplicatePopupShown = true;
            } else {
                this.updateEntryAndConfig();
            }
        }

        private void updateEntryAndConfig() {
            String oldKey = this.entry.input;
            if (!oldKey.equals(this.keyValue) && !oldKey.isEmpty()) {
                FishyConfig.removeKeybind(oldKey);
            }
            this.entry.input = this.keyValue;
            FishyConfig.setKeybind(this.keyValue, this.entry.output);
            if (this.entry.isNew) {
                this.entry.isNew = false;
                if (this.parentScreen != null) {
                    this.parentScreen.addingNewEntry = false;
                }
            }
            if (this.parentScreen != null) {
                this.parentScreen.refreshEntryList();
            }
            KeyShortcut.refresh();
        }

        public String getKeyValue() {
            return this.keyValue;
        }
    }
}

