/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.valkeea.fishyaddons.gui.SearchEntry;
import me.valkeea.fishyaddons.gui.SearchMenu;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_437;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class SoundSearchMenu
extends SearchMenu {
    private final Consumer<String> onRightClick;
    List<String> soundIds = class_7923.field_41172.method_10220().map(arg_0 -> ((class_2378)class_7923.field_41172).method_10221(arg_0)).filter(Objects::nonNull).map(class_2960::toString).sorted().toList();

    public SoundSearchMenu(List<String> entries, int x, int y, int width, int entryHeight, Consumer<String> onSelect, Consumer<String> onRightClick, class_437 screen) {
        super(entries.stream().map(id -> new SearchEntry((String)id, null, () -> onSelect.accept((String)id))).collect(Collectors.toList()), x, y, width, entryHeight, entry -> onSelect.accept(entry.name), screen);
        this.onRightClick = onRightClick;
    }

    public SoundSearchMenu(List<String> entries, int x, int y, int width, int entryHeight, Consumer<String> onSelect, Consumer<String> onRightClick, class_437 screen, class_342 externalField) {
        super(entries.stream().map(id -> new SearchEntry((String)id, null, () -> onSelect.accept((String)id))).collect(Collectors.toList()), x, y, width, entryHeight, (SearchEntry entry) -> onSelect.accept(entry.name), screen, externalField);
        this.onRightClick = onRightClick;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isVisible()) {
            return false;
        }
        if (button == 1) {
            return this.handleRightClick(mouseX, mouseY);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean handleRightClick(double mouseX, double mouseY) {
        int entryIndex;
        int totalEntries = this.getFilteredEntries().size();
        int visibleEntries = Math.min(totalEntries, this.getMaxVisibleEntries());
        int[] entryHeights = this.calculateEntryHeights(visibleEntries);
        int entryTop = this.getY();
        for (int i = 0; i < visibleEntries && (entryIndex = i + this.getScrollOffset()) < this.getFilteredEntries().size(); ++i) {
            int entryHeight = entryHeights[i];
            int entryBottom = entryTop + entryHeight;
            if (this.isClickInsideEntry(mouseX, mouseY, entryTop, entryBottom)) {
                SearchEntry entry = this.getFilteredEntries().get(entryIndex);
                this.onRightClick.accept(entry.name);
                return true;
            }
            entryTop = entryBottom;
        }
        return false;
    }

    private int[] calculateEntryHeights(int visibleEntries) {
        int entryIndex;
        int[] entryHeights = new int[visibleEntries];
        for (int i = 0; i < visibleEntries && (entryIndex = i + this.getScrollOffset()) < this.getFilteredEntries().size(); ++i) {
            SearchEntry entry = this.getFilteredEntries().get(entryIndex);
            int descLines = 0;
            if (entry.description != null && !entry.description.isEmpty()) {
                descLines = entry.description.split("\n").length;
            }
            entryHeights[i] = 14 + descLines * 12 + 4;
        }
        return entryHeights;
    }

    private boolean isClickInsideEntry(double mouseX, double mouseY, int entryTop, int entryBottom) {
        return mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)entryTop && mouseY <= (double)entryBottom;
    }

    public List<String> getSoundIds() {
        return this.soundIds;
    }
}

