/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.Objects;
import me.valkeea.fishyaddons.gui.VCRenderUtils;
import me.valkeea.fishyaddons.gui.VCText;
import me.valkeea.fishyaddons.gui.VCVisuals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class VCButton {
    private VCButton() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void render(class_332 context, class_327 textRenderer, ButtonConfig config) {
        switch (config.type.ordinal()) {
            case 1: {
                VCButton.renderToggle(context, textRenderer, config);
                break;
            }
            case 2: {
                VCButton.renderToggleWithText(context, textRenderer, config, config.text);
                break;
            }
            case 3: {
                VCButton.renderKeybind(context, textRenderer, config);
                break;
            }
            case 4: {
                VCButton.renderNavigation(context, textRenderer, config);
                break;
            }
            case 5: {
                VCButton.renderMcToggle(context, textRenderer, config);
                break;
            }
            default: {
                VCButton.renderStandard(context, textRenderer, config);
            }
        }
    }

    public static class_4185 createNavigationButton(int x, int y, int width, int height, class_5250 message, class_4185.class_4241 onPress, final float uiScale) {
        return new class_4185(x, y, width, height, (class_2561)message, onPress, button -> message){

            protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
                ButtonConfig config = new ButtonConfig(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, this.method_25369().getString()).withScale(uiScale).withEnabled(this.field_22763).withHovered(this.method_49606()).withType(ButtonType.NAVIGATION);
                VCButton.render(context, class_310.method_1551().field_1772, config);
            }
        };
    }

    public static class_4185 createMcToggle(int x, int y, int width, int height, final boolean enabled, class_4185.class_4241 onPress, final float uiScale) {
        class_5250 message = enabled ? class_2561.method_43470((String)"ON") : class_2561.method_43470((String)"OFF");
        return new class_4185(x, y, width, height, (class_2561)message, onPress, button -> message){

            protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
                ButtonConfig config = new ButtonConfig(this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, this.method_25369().getString()).withScale(uiScale).withEnabled(enabled).withHovered(this.method_49606()).withType(ButtonType.MCTOGGLE);
                VCButton.render(context, class_310.method_1551().field_1772, config);
            }
        };
    }

    private static void renderNavigation(class_332 context, class_327 textRenderer, ButtonConfig config) {
        int bgColor = config.enabled ? VCVisuals.bgHex2(config.hovered) : -2143272896;
        int borderColor = config.enabled ? VCVisuals.borderHex2(config.hovered) : -2143272896;
        VCRenderUtils.gradient(context, config.x, config.y, config.width, config.height, bgColor);
        context.method_49601(config.x, config.y, config.width, config.height, borderColor);
        int textColor = config.enabled ? -1 : -3866625;
        int textX = config.x + config.width / 2;
        int textY = config.y + (config.height - (int)(8.0f * config.uiScale)) / 2;
        VCText.drawScaledCenteredText(context, textRenderer, config.text, textX, textY, textColor, config.uiScale);
    }

    private static void renderMcToggle(class_332 context, class_327 textRenderer, ButtonConfig config) {
        int textColor = config.enabled ? 0xCCFFCC : 0xFF8080;
        int bgColor = VCVisuals.bgHex2(config.hovered);
        int borderColor = VCVisuals.borderHex2(config.hovered);
        VCRenderUtils.gradient(context, config.x, config.y, config.width, config.height, bgColor);
        context.method_49601(config.x, config.y, config.width, config.height, borderColor);
        int textX = config.x + config.width / 2;
        int textY = config.y + (config.height - (int)(8.0f * config.uiScale)) / 2;
        VCText.drawScaledCenteredText(context, textRenderer, config.text, textX, textY, textColor, config.uiScale);
    }

    private static void renderStandard(class_332 context, class_327 textRenderer, ButtonConfig config) {
        int bgColor = VCVisuals.bgHex(config.hovered, config.enabled);
        VCRenderUtils.gradient(context, config.x, config.y, config.width, config.height, bgColor);
        int borderColor = VCVisuals.borderHex(config.hovered, config.enabled);
        context.method_49601(config.x, config.y, config.width, config.height, borderColor);
        int textColor = !config.enabled ? 0xFF8080 : (config.text.equals("ON") || config.text.equals("CONF") ? 0xCCFFCC : (config.text.equals("OFF") ? 0xFF8080 : -1));
        int textX = config.x + config.width / 2 - (int)((float)textRenderer.method_1727(config.text) * Math.min(config.uiScale, 1.0f)) / 2;
        int n = config.y;
        int n2 = config.height;
        Objects.requireNonNull(textRenderer);
        int textY = n + (n2 - 9) / 2 + 2;
        VCText.drawScaledButtonText(context, textRenderer, config.text, textX, textY, textColor, config.uiScale);
    }

    private static void renderToggle(class_332 context, class_327 textRenderer, ButtonConfig config) {
        String text = config.enabled ? "ON" : "OFF";
        int textColor = config.enabled ? 0xCCFFCC : 0xFF8080;
        int bgColor = VCVisuals.bgHex(config.hovered, config.enabled);
        int borderColor = VCVisuals.borderHex(config.hovered, config.enabled);
        VCRenderUtils.gradient(context, config.x, config.y, config.width, config.height, bgColor);
        context.method_49601(config.x, config.y, config.width, config.height, borderColor);
        int textX = config.x + config.width / 2 - (int)((float)textRenderer.method_1727(text) * Math.min(config.uiScale, 1.0f)) / 2;
        int n = config.y;
        int n2 = config.height;
        Objects.requireNonNull(textRenderer);
        int textY = n + (n2 - 9) / 2 + 2;
        VCText.drawScaledButtonText(context, textRenderer, text, textX, textY, textColor, config.uiScale);
    }

    private static void renderToggleWithText(class_332 context, class_327 textRenderer, ButtonConfig config, String buttonText) {
        String text = buttonText;
        int textColor = config.enabled ? 0xCCFFCC : 0xFF8080;
        int bgColor = VCVisuals.bgHex(config.hovered, config.enabled);
        int borderColor = VCVisuals.borderHex(config.hovered, config.enabled);
        VCRenderUtils.gradient(context, config.x, config.y, config.width, config.height, bgColor);
        context.method_49601(config.x, config.y, config.width, config.height, borderColor);
        int textX = config.x + config.width / 2 - (int)((float)textRenderer.method_1727(text) * Math.min(config.uiScale, 1.0f)) / 2;
        int n = config.y;
        int n2 = config.height;
        Objects.requireNonNull(textRenderer);
        int textY = n + (n2 - 9) / 2 + 2;
        VCText.drawScaledButtonText(context, textRenderer, text, textX, textY, textColor, config.uiScale);
    }

    private static void renderKeybind(class_332 context, class_327 textRenderer, ButtonConfig config) {
        int textColor = config.listening ? -128 : (!config.hasKey ? -2276284 : -11141121);
        boolean enabled = config.hasKey || config.listening;
        int bgColor = VCVisuals.bgHex(config.hovered, enabled);
        int borderColor = VCVisuals.borderHex(config.hovered, enabled);
        VCRenderUtils.gradient(context, config.x, config.y, config.width, config.height, bgColor);
        context.method_49601(config.x, config.y, config.width, config.height, borderColor);
        int textX = config.x + config.width / 2 - (int)((float)textRenderer.method_1727(config.text) * Math.min(config.uiScale, 1.0f)) / 2;
        int n = config.y;
        int n2 = config.height;
        Objects.requireNonNull(textRenderer);
        int textY = n + (n2 - 9) / 2 + 2;
        VCText.drawScaledButtonText(context, textRenderer, config.text, textX, textY, textColor, config.uiScale);
    }

    public static ButtonConfig standard(int x, int y, int width, int height, String text) {
        return new ButtonConfig(x, y, width, height, text);
    }

    public static ButtonConfig toggle(int x, int y, int width, int height, boolean enabled) {
        return new ButtonConfig(x, y, width, height, enabled ? "ON" : "OFF").withType(ButtonType.TOGGLE).withEnabled(enabled);
    }

    public static ButtonConfig toggleWithText(int x, int y, int width, int height, String text, boolean enabled) {
        return new ButtonConfig(x, y, width, height, text).withType(ButtonType.SIMPLE).withEnabled(enabled);
    }

    public static ButtonConfig keybind(int x, int y, int width, int height, String displayText) {
        return new ButtonConfig(x, y, width, height, displayText).withType(ButtonType.KEYBIND);
    }

    public static ButtonConfig navigation(int x, int y, int width, int height, String text) {
        return new ButtonConfig(x, y, width, height, text).withType(ButtonType.NAVIGATION);
    }

    public static boolean isHovered(int buttonX, int buttonY, int buttonWidth, int buttonHeight, int mouseX, int mouseY) {
        return mouseX >= buttonX && mouseX <= buttonX + buttonWidth && mouseY >= buttonY && mouseY <= buttonY + buttonHeight;
    }

    @Environment(value=EnvType.CLIENT)
    public static class ButtonConfig {
        private int x;
        private int y;
        private int width;
        private int height;
        private String text;
        private boolean enabled = true;
        private boolean hovered = false;
        private float uiScale = 1.0f;
        private ButtonType type = ButtonType.STANDARD;
        private boolean listening = false;
        private boolean hasKey = true;

        public ButtonConfig(int x, int y, int width, int height, String text) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.text = text;
        }

        public ButtonConfig withScale(float scale) {
            this.uiScale = scale;
            return this;
        }

        public ButtonConfig withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public ButtonConfig withHovered(boolean hovered) {
            this.hovered = hovered;
            return this;
        }

        public ButtonConfig withType(ButtonType type) {
            this.type = type;
            return this;
        }

        public ButtonConfig withListening(boolean listening) {
            this.listening = listening;
            return this;
        }

        public ButtonConfig withHasKey(boolean hasKey) {
            this.hasKey = hasKey;
            return this;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum ButtonType {
        STANDARD,
        TOGGLE,
        SIMPLE,
        KEYBIND,
        NAVIGATION,
        MCTOGGLE;

    }
}

