/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class VCConstants {
    public static final int BASE_WIDTH = 1920;
    public static final int BASE_HEIGHT = 1080;
    public static final int BASE_ENTRY_HEIGHT = 65;
    public static final int BASE_SUB_ENTRY_HEIGHT = 40;
    public static final int BASE_HEADER_HEIGHT = 35;
    public static final int BASE_ENTRY_WIDTH = 800;
    public static final int BASE_SEARCH_HEIGHT = 24;
    public static final int MIN_ENTRY_HEIGHT = 35;
    public static final int MIN_SUB_ENTRY_HEIGHT = 22;
    public static final int MIN_HEADER_HEIGHT = 18;
    public static final int MIN_SEARCH_HEIGHT = 8;
    public static final int TINY_SCALE_MIN_ENTRY = 25;
    public static final int TINY_SCALE_MIN_SUB = 18;
    public static final int TINY_SCALE_MIN_HEADER = 15;
    public static final int TINY_SCALE_MIN_SEARCH = 12;
    public static final float TINY_SCALE_THRESHOLD = 0.4f;
    public static final float SMALL_SCALE_THRESHOLD = 0.5f;
    public static final float COMPACT_SCALE_THRESHOLD = 0.7f;
    public static final int MIN_DYNAMIC_WIDTH_SMALL = 200;
    public static final int MIN_DYNAMIC_WIDTH_NORMAL = 300;

    public static int getEntryHeight(float uiScale) {
        float scale = Math.min(uiScale, 1.0f);
        int dynamicMin = uiScale < 0.4f ? 25 : 35;
        return Math.max(dynamicMin, (int)(65.0f * scale));
    }

    public static int getSubEntryHeight(float uiScale) {
        float scale = Math.min(uiScale, 1.0f);
        int dynamicMin = uiScale < 0.4f ? 18 : 22;
        return Math.max(dynamicMin, (int)(40.0f * scale));
    }

    public static int getHeaderHeight(float uiScale) {
        float scale = Math.min(uiScale, 1.0f);
        int dynamicMin = uiScale < 0.4f ? 15 : 18;
        return Math.max(dynamicMin, (int)(35.0f * scale));
    }

    public static int getEntryWidth(float uiScale) {
        float scale = Math.min(uiScale, 1.0f);
        int scaledWidth = (int)(800.0f * scale);
        int dynamicMinWidth = uiScale < 0.5f ? 200 : 300;
        return Math.max(dynamicMinWidth, scaledWidth);
    }

    public static int getSearchHeight(float uiScale) {
        float scale = Math.min(uiScale, 1.0f);
        int dynamicMin = uiScale < 0.4f ? 12 : 8;
        return Math.max(dynamicMin, (int)(24.0f * scale));
    }

    private VCConstants() {
        throw new UnsupportedOperationException("UIConstants is a utility class and should not be instantiated");
    }
}

