/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.config.ItemConfig;
import me.valkeea.fishyaddons.gui.VCScreen;
import me.valkeea.fishyaddons.safeguard.BlacklistManager;
import me.valkeea.fishyaddons.tool.FishyMode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class VCEntry {
    public final String name;
    public final String description;
    public final EntryType type;
    public final Runnable action;
    public final List<class_2561> tooltipText;
    public final String configKey;
    public final boolean defaultValue;
    public final Runnable refreshAction;
    public final List<VCEntry> subEntries;
    protected final String hudElementName;
    protected final boolean hasColorControl;
    protected final boolean hasAdd;
    private boolean isListening = false;
    public final String buttonText;
    public final String simpleButtonConfigKey;
    public final boolean simpleButtonDefault;
    public final float minValue;
    public final float maxValue;
    public final String formatString;
    public final Consumer<Float> valueChangeAction;
    public final SliderType sliderType;

    private VCEntry(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.tooltipText = builder.tooltipText != null ? List.copyOf(builder.tooltipText) : null;
        this.action = builder.action;
        this.configKey = builder.configKey;
        this.defaultValue = builder.defaultValue;
        this.refreshAction = builder.refreshAction;
        this.subEntries = builder.subEntries;
        this.hudElementName = builder.hudElementName;
        this.hasColorControl = builder.hasColorControl;
        this.hasAdd = builder.hasAdd;
        this.buttonText = builder.buttonText;
        this.simpleButtonConfigKey = builder.simpleButtonConfigKey;
        this.simpleButtonDefault = builder.simpleButtonDefault;
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.formatString = builder.formatString;
        this.valueChangeAction = builder.valueChangeAction;
        this.sliderType = builder.sliderType;
    }

    public static VCEntry toggle(String name, String description, String configKey, boolean defaultValue, Runnable refreshAction) {
        return new Builder(name, description, EntryType.TOGGLE).configKey(configKey).defaultValue(defaultValue).refreshAction(refreshAction).build();
    }

    public static VCEntry toggleColorOrHud(String name, String description, String configKey, boolean defaultValue, Runnable refreshAction, VCScreen.ExtraControl extraControl) {
        return new Builder(name, description, EntryType.TOGGLE).configKey(configKey).defaultValue(defaultValue).refreshAction(refreshAction).extraControl(extraControl).build();
    }

    public static VCEntry icToggle(String name, String description, String configKey, boolean defaultValue) {
        return new Builder(name, description, EntryType.ITEM_CONFIG_TOGGLE).configKey(configKey).defaultValue(defaultValue).build();
    }

    public static VCEntry blToggle(String name, String description, String configKey, boolean defaultValue) {
        return new Builder(name, description, EntryType.BLACKLIST_TOGGLE).configKey(configKey).defaultValue(defaultValue).build();
    }

    public static VCEntry toggle2(String name, String description, String mainConfigKey, boolean defaultValue, String buttonText, String buttonConfigKey, Boolean simpleDefault, Runnable mainRefresh) {
        return new Builder(name, description, EntryType.SIMPLE_BUTTON).configKey(mainConfigKey).defaultValue(defaultValue).buttonText(buttonText).simpleButtonConfigKey(buttonConfigKey).simpleButtonDefault(simpleDefault).refreshAction(mainRefresh).build();
    }

    public static VCEntry toggleSlider(String name, String description, String toggleKey, boolean defaultToggle, String sliderKey, float min, float max, String format, Runnable refreshAction) {
        return new Builder(name, description, EntryType.TOGGLE_WITH_SLIDER).toggleWithSlider(toggleKey, defaultToggle, sliderKey, min, max, format).refreshAction(refreshAction).build();
    }

    public static VCEntry slider(String name, String description, String configKey, float min, float max, String format, Consumer<Float> valueChangeAction) {
        return new Builder(name, description, EntryType.SLIDER).configKey(configKey).sliderRange(min, max).formatString(format).valueChangeAction(valueChangeAction).build();
    }

    public static VCEntry typedSlider(String name, String description, String type, float min, float max, String format, Consumer<Float> valueChangeAction, SliderType sliderType) {
        return new Builder(name, description, EntryType.SLIDER).configKey(type).sliderRange(min, max).formatString(format).valueChangeAction(valueChangeAction).sliderType(sliderType).build();
    }

    public static VCEntry typedSliderColor(String name, String description, String configKey, float min, float max, String format, Consumer<Float> valueChangeAction, SliderType sliderType, boolean hasColorControl) {
        return new Builder(name, description, EntryType.SLIDER).configKey(configKey).sliderRange(min, max).formatString(format).valueChangeAction(valueChangeAction).sliderType(sliderType).hasColorControl(hasColorControl).build();
    }

    public static VCEntry header(String name, String description) {
        return new Builder(name, description, EntryType.HEADER).build();
    }

    public static VCEntry keybind(String name, String description, String configKey, boolean defaultValue, Runnable refreshAction) {
        return new Builder(name, description, EntryType.KEYBIND).configKey(configKey).defaultValue(defaultValue).refreshAction(refreshAction).build();
    }

    public static VCEntry expandable(String name, String description, List<VCEntry> subEntries, List<class_2561> tooltipText) {
        return new Builder(name, description, EntryType.EXPANDABLE).subEntries(subEntries).tooltipText(tooltipText).build();
    }

    public static VCEntry toggleExpandable(String name, String description, List<VCEntry> subEntries, List<class_2561> tooltipText, String configKey, boolean defaultValue, Runnable refreshAction) {
        return new Builder(name, description, EntryType.EXPANDABLE).subEntries(subEntries).tooltipText(tooltipText).configKey(configKey).defaultValue(defaultValue).refreshAction(refreshAction).build();
    }

    public static VCEntry redirect(String name, String description, String buttonText, Runnable mainAction) {
        return new Builder(name, description, EntryType.BUTTON).buttonText(buttonText).action(mainAction).build();
    }

    public static VCEntry sliderColor(String name, String description, String configKey, float min, float max, String format, Consumer<Float> valueChangeAction) {
        return new Builder(name, description, EntryType.SLIDER).configKey(configKey).sliderRange(min, max).formatString(format).valueChangeAction(valueChangeAction).hasColorControl(true).build();
    }

    public boolean getToggleState() {
        if (this.configKey == null) {
            return false;
        }
        switch (this.type.ordinal()) {
            case 0: 
            case 2: 
            case 7: 
            case 9: {
                return this.getFishyConfigToggleState();
            }
            case 3: {
                return this.getItemConfigToggleState();
            }
            case 4: {
                return this.getBlacklistToggleState();
            }
        }
        return false;
    }

    public void toggleSetting() {
        if (this.configKey != null) {
            switch (this.type.ordinal()) {
                case 0: 
                case 2: 
                case 7: 
                case 9: {
                    this.toggleFishyConfig();
                    break;
                }
                case 3: {
                    this.toggleItemConfig();
                    break;
                }
                case 4: {
                    this.toggleBlacklist();
                    break;
                }
            }
        }
        if (this.refreshAction != null) {
            this.refreshAction.run();
        }
    }

    private boolean getFishyConfigToggleState() {
        return FishyConfig.getState(this.configKey, this.defaultValue);
    }

    private boolean getItemConfigToggleState() {
        return ItemConfig.getState(this.configKey, this.defaultValue);
    }

    private boolean getBlacklistToggleState() {
        for (BlacklistManager.GuiBlacklistEntry entry : BlacklistManager.getMergedBlacklist()) {
            if (entry.identifiers == null || entry.identifiers.isEmpty() || !entry.identifiers.contains(this.configKey)) continue;
            return entry.isEnabled();
        }
        return this.defaultValue;
    }

    public boolean getSimpleButtonState() {
        if (this.type == EntryType.SIMPLE_BUTTON && this.simpleButtonConfigKey != null) {
            return FishyConfig.getState(this.simpleButtonConfigKey, this.simpleButtonDefault);
        }
        return false;
    }

    private void toggleFishyConfig() {
        FishyConfig.toggle(this.configKey, this.defaultValue);
    }

    private void toggleItemConfig() {
        ItemConfig.toggle(this.configKey, this.defaultValue);
    }

    private void toggleBlacklist() {
        for (BlacklistManager.GuiBlacklistEntry entry : BlacklistManager.getMergedBlacklist()) {
            if (entry.identifiers == null || entry.identifiers.isEmpty() || !entry.identifiers.contains(this.configKey)) continue;
            entry.setEnabled(!entry.isEnabled());
            BlacklistManager.updateBlacklistEntry(entry.identifiers.get(0), entry.isEnabled());
            break;
        }
    }

    public void toggleSimpleButton() {
        if (this.type == EntryType.SIMPLE_BUTTON && this.simpleButtonConfigKey != null) {
            FishyConfig.toggle(this.simpleButtonConfigKey, this.simpleButtonDefault);
        }
        if (this.refreshAction != null) {
            this.refreshAction.run();
        }
    }

    public List<VCEntry> getSubEntries() {
        return this.subEntries != null ? this.subEntries : new ArrayList<VCEntry>();
    }

    public boolean hasSubEntries() {
        return this.subEntries != null && !this.subEntries.isEmpty();
    }

    public boolean hasToggle() {
        return this.type == EntryType.EXPANDABLE && this.configKey != null;
    }

    public boolean hasHudControls() {
        return this.hudElementName != null;
    }

    public String getHudElementName() {
        return this.hudElementName;
    }

    public boolean hasColorControl() {
        return this.hasColorControl;
    }

    public boolean hasAdd() {
        return this.hasAdd;
    }

    public boolean isListening() {
        return this.isListening;
    }

    public void setListening(boolean listening) {
        this.isListening = listening;
    }

    public String getKeybindValue() {
        if (this.type == EntryType.KEYBIND && this.configKey != null) {
            return FishyConfig.getKeyString(this.configKey);
        }
        return "NONE";
    }

    public void setKeybindValue(String key) {
        if (this.type == EntryType.KEYBIND && this.configKey != null && key != null) {
            FishyConfig.setKeyString(this.configKey, key);
        }
    }

    public float getSliderValue() {
        if (this.type == EntryType.SLIDER && this.configKey != null) {
            if ("modUiScale".equals(this.configKey)) {
                return this.uiScaleValue();
            }
            if ("themeMode".equals(this.configKey)) {
                return this.themeValue();
            }
            if ("customParticleColorIndex".equals(this.configKey)) {
                return this.presetIndexValue();
            }
            return this.standardValue();
        }
        if (this.type == EntryType.TOGGLE_WITH_SLIDER && this.buttonText != null) {
            return this.toggleSliderValue();
        }
        return 0.0f;
    }

    private float uiScaleValue() {
        return FishyConfig.getFloat("modUiScale", 0.4265625f);
    }

    private float themeValue() {
        String currentTheme = FishyMode.getTheme();
        String[] themes = new String[]{"default", "purple", "blue", "white", "green"};
        for (int i = 0; i < themes.length; ++i) {
            if (!themes[i].equalsIgnoreCase(currentTheme)) continue;
            return i;
        }
        return 0.0f;
    }

    private float presetIndexValue() {
        return FishyConfig.getCustomParticleColorIndex();
    }

    private float standardValue() {
        return FishyConfig.getFloat(this.configKey, (this.minValue + this.maxValue) / 2.0f);
    }

    private float toggleSliderValue() {
        return FishyConfig.getFloat(this.buttonText, (this.minValue + this.maxValue) / 2.0f);
    }

    public void setSliderValue(float value) {
        if (this.type == EntryType.SLIDER && this.configKey != null) {
            float clampedValue = Math.clamp(value, this.minValue, this.maxValue);
            FishyConfig.setFloat(this.configKey, clampedValue);
            if (this.valueChangeAction != null) {
                this.valueChangeAction.accept(Float.valueOf(clampedValue));
            }
        } else if (this.type == EntryType.TOGGLE_WITH_SLIDER && this.buttonText != null) {
            float clampedValue = Math.clamp(value, this.minValue, this.maxValue);
            FishyConfig.setFloat(this.buttonText, clampedValue);
            if (this.valueChangeAction != null) {
                this.valueChangeAction.accept(Float.valueOf(clampedValue));
            }
        }
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public SliderType getSliderType() {
        return this.sliderType;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder {
        private final String name;
        private final String description;
        private final EntryType type;
        private List<class_2561> tooltipText = null;
        private Runnable action = null;
        private String configKey = null;
        private boolean defaultValue = false;
        private Runnable refreshAction = null;
        private List<VCEntry> subEntries = null;
        private String hudElementName = null;
        private boolean hasColorControl = false;
        private boolean hasAdd = false;
        private String buttonText = null;
        private String simpleButtonConfigKey = null;
        private boolean simpleButtonDefault = false;
        private float minValue = 0.0f;
        private float maxValue = 100.0f;
        private String formatString = "%.0f";
        private Consumer<Float> valueChangeAction = null;
        private SliderType sliderType = SliderType.FLOAT;

        public Builder(String name, String description, EntryType type) {
            this.name = name;
            this.description = description;
            this.type = type;
        }

        public Builder action(Runnable action) {
            this.action = action;
            return this;
        }

        public Builder configKey(String configKey) {
            this.configKey = configKey;
            return this;
        }

        public Builder defaultValue(boolean defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder refreshAction(Runnable refreshAction) {
            this.refreshAction = refreshAction;
            return this;
        }

        public Builder subEntries(List<VCEntry> subEntries) {
            this.subEntries = subEntries;
            return this;
        }

        public Builder tooltipText(List<class_2561> tooltipText) {
            this.tooltipText = tooltipText;
            return this;
        }

        public Builder hudElementName(String hudElementName) {
            this.hudElementName = hudElementName;
            return this;
        }

        public Builder hasColorControl(boolean hasColorControl) {
            this.hasColorControl = hasColorControl;
            return this;
        }

        public Builder hasAdd(boolean hasAdd) {
            this.hasAdd = hasAdd;
            return this;
        }

        public Builder extraControl(VCScreen.ExtraControl extraControl) {
            if (extraControl != null) {
                this.hudElementName = extraControl.getElementName();
                this.hasColorControl = extraControl.hasColorControl();
                this.hasAdd = extraControl.hasAdd();
            }
            return this;
        }

        public Builder buttonText(String buttonText) {
            this.buttonText = buttonText;
            return this;
        }

        public Builder simpleButtonConfigKey(String simpleButtonConfigKey) {
            this.simpleButtonConfigKey = simpleButtonConfigKey;
            return this;
        }

        public Builder simpleButtonDefault(boolean simpleButtonDefault) {
            this.simpleButtonDefault = simpleButtonDefault;
            return this;
        }

        public Builder sliderRange(float minValue, float maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            return this;
        }

        public Builder formatString(String formatString) {
            this.formatString = formatString;
            return this;
        }

        public Builder valueChangeAction(Consumer<Float> valueChangeAction) {
            this.valueChangeAction = valueChangeAction;
            return this;
        }

        public Builder sliderType(SliderType sliderType) {
            this.sliderType = sliderType;
            return this;
        }

        public Builder toggleWithSlider(String toggleKey, boolean defaultToggle, String sliderKey, float min, float max, String format) {
            this.configKey = toggleKey;
            this.defaultValue = defaultToggle;
            this.buttonText = sliderKey;
            this.minValue = min;
            this.maxValue = max;
            this.formatString = format;
            return this;
        }

        public VCEntry build() {
            return new VCEntry(this);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum EntryType {
        TOGGLE,
        BUTTON,
        EXPANDABLE,
        ITEM_CONFIG_TOGGLE,
        BLACKLIST_TOGGLE,
        KEYBIND,
        HEADER,
        SIMPLE_BUTTON,
        SLIDER,
        TOGGLE_WITH_SLIDER;

    }

    @Environment(value=EnvType.CLIENT)
    public static enum SliderType {
        FLOAT,
        STRING,
        PRESET;

    }
}

