/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.VCButton;
import me.valkeea.fishyaddons.gui.VCConstants;
import me.valkeea.fishyaddons.gui.VCContext;
import me.valkeea.fishyaddons.gui.VCEntry;
import me.valkeea.fishyaddons.gui.VCRenderUtils;
import me.valkeea.fishyaddons.gui.VCScreen;
import me.valkeea.fishyaddons.gui.VCSlider;
import me.valkeea.fishyaddons.gui.VCText;
import me.valkeea.fishyaddons.util.KeyUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class VCGui {
    private final VCScreen screen;
    private final Supplier<Integer> themeColorSupplier;
    private final Supplier<Float> uiScaleSupplier;
    private final Supplier<Map<String, VCSlider>> sliderRegistrySupplier;

    public VCGui(VCScreen screen, Supplier<Integer> themeColorSupplier, Supplier<Float> uiScaleSupplier, Supplier<Map<String, VCSlider>> sliderRegistrySupplier) {
        this.screen = screen;
        this.themeColorSupplier = themeColorSupplier;
        this.uiScaleSupplier = uiScaleSupplier;
        this.sliderRegistrySupplier = sliderRegistrySupplier;
    }

    public int renderConfigEntry(VCContext renderCtx, VCEntry entry, int x, int y, boolean isSubEntry) {
        float uiScale = this.uiScaleSupplier.get().floatValue();
        int entryHeight = VCConstants.getEntryHeight(uiScale);
        int subEntryHeight = VCConstants.getSubEntryHeight(uiScale);
        int headerHeight = VCConstants.getHeaderHeight(uiScale);
        if (entry.type == VCEntry.EntryType.HEADER) {
            return this.renderHeaderEntry(renderCtx.context, entry, x, y, renderCtx.entryWidth, headerHeight, isSubEntry);
        }
        int baseCurrentHeight = isSubEntry ? subEntryHeight : entryHeight;
        int currentEntryHeight = this.calculateCurrentEntryHeight(baseCurrentHeight, uiScale);
        if (isSubEntry) {
            int subBgWidth = (int)((float)renderCtx.entryWidth * 0.95f);
            renderCtx.context.method_25294(x + (int)(5.0f * uiScale), y, x + subBgWidth, y + currentEntryHeight, 0x30000000);
        }
        int contentX = x + (int)(15.0f * uiScale);
        int indentOffset = isSubEntry ? (int)(30.0f * uiScale) : 0;
        int contentY = y + (int)(12.0f * uiScale);
        int nameColor = isSubEntry ? this.darkenColor(this.themeColorSupplier.get()) : this.themeColorSupplier.get().intValue();
        String displayName = entry.name;
        VCText.drawScaledText(renderCtx.context, this.screen.method_64506(), displayName, contentX += indentOffset, contentY, nameColor, uiScale);
        this.desc(renderCtx, this.screen, entry, contentX, contentY, uiScale, isSubEntry);
        int controlAreaWidth = this.getCompactControlAreaWidth(uiScale);
        int controlX = x + renderCtx.entryWidth - controlAreaWidth;
        int controlY = y + (int)(14.0f * uiScale);
        if (entry.type == VCEntry.EntryType.EXPANDABLE) {
            this.renderExpandButton(renderCtx, entry, controlX, controlY);
        } else if (isSubEntry) {
            this.renderEntryControl(renderCtx.context, entry, controlX + (int)(20.0f * uiScale), controlY, renderCtx.mouseX, renderCtx.mouseY);
        } else {
            this.renderEntryControl(renderCtx.context, entry, controlX, controlY, renderCtx.mouseX, renderCtx.mouseY);
        }
        if (!isSubEntry) {
            int separatorY = y + currentEntryHeight - (int)(2.0f * uiScale);
            renderCtx.context.method_25294(x, separatorY, x + renderCtx.entryWidth, separatorY + 1, -12303292);
        }
        return currentEntryHeight;
    }

    private void desc(VCContext renderCtx, VCScreen screen, VCEntry entry, int contentX, int contentY, float uiScale, boolean isSubEntry) {
        String[] descLines;
        if (!isSubEntry && entry.description != null) {
            String[] descLines2 = entry.description.split("\n");
            int lineSpacing = (int)(12.0f * uiScale);
            int descStartY = contentY + (int)(16.0f * uiScale);
            for (int i = 0; i < Math.min(descLines2.length, 2); ++i) {
                VCText.drawScaledText(renderCtx.context, screen.method_64506(), descLines2[i], contentX, descStartY + i * lineSpacing, -3355444, uiScale);
            }
        } else if (isSubEntry && entry.description != null && (descLines = entry.description.split("\n")).length > 0) {
            int descY = contentY + (int)(16.0f * uiScale);
            VCText.drawScaledText(renderCtx.context, screen.method_64506(), descLines[0], contentX, descY, -3881788, uiScale);
        }
    }

    private int calculateCurrentEntryHeight(int baseCurrentHeight, float uiScale) {
        if (uiScale < 0.4f) {
            return Math.max(12, (int)((float)baseCurrentHeight * 0.6f));
        }
        if (uiScale < 0.5f) {
            return Math.max(15, (int)((float)baseCurrentHeight * 0.7f));
        }
        if (uiScale < 0.7f) {
            return Math.max(18, (int)((float)baseCurrentHeight * 0.8f));
        }
        return baseCurrentHeight;
    }

    private int getCompactControlAreaWidth(float uiScale) {
        int baseControlAreaWidth = 140;
        if (uiScale < 0.5f) {
            return Math.max(60, (int)((float)baseControlAreaWidth * uiScale * 0.5f));
        }
        if (uiScale < 0.7f) {
            return Math.max(70, (int)((float)baseControlAreaWidth * uiScale * 0.6f));
        }
        return (int)((float)baseControlAreaWidth * uiScale);
    }

    public int renderHeaderEntry(class_332 context, VCEntry entry, int x, int y, int entryWidth, int headerHeight, boolean isSubHeader) {
        float uiScale = this.uiScaleSupplier.get().floatValue();
        if (isSubHeader) {
            int textX = x + (int)(20.0f * uiScale);
            int textY = y + (int)(15.0f * uiScale);
            VCText.drawScaledText(context, this.screen.method_64506(), entry.name, textX, textY, -7829368, uiScale);
            int subBgWidth = (int)((float)entryWidth * 0.95f);
            context.method_25294(x + (int)(5.0f * uiScale), y, x + subBgWidth, y + headerHeight, 0x30000000);
            return headerHeight;
        }
        int unscaledTextWidth = this.screen.method_64506().method_1727(entry.name);
        int effectiveTextWidth = uiScale < 1.0f ? (int)((float)unscaledTextWidth * uiScale) : unscaledTextWidth;
        if (uiScale >= 0.7f && uiScale < 1.0f) {
            effectiveTextWidth = Math.round((float)unscaledTextWidth + 4.0f * uiScale);
        }
        int textCenterX = x + entryWidth / 2;
        int textX = textCenterX - effectiveTextWidth / 2;
        int textY = y + (int)(12.0f * uiScale);
        Objects.requireNonNull(this.screen.method_64506());
        int scaledTextHeight = (int)(9.0f * Math.min(uiScale, 1.0f));
        int lineHeight = Math.max(1, (int)(1.0f * uiScale));
        int lineY = textY + scaledTextHeight / 2 - lineHeight / 2;
        int gapPadding = uiScale >= 0.7f && uiScale < 1.0f ? Math.max(8, (int)(12.0f * uiScale)) : Math.max(6, (int)(8.0f * uiScale));
        int gapStart = textCenterX - effectiveTextWidth / 2 - gapPadding;
        int gapEnd = textCenterX + effectiveTextWidth / 2 + gapPadding;
        if (gapStart > x) {
            context.method_25294(x, lineY, gapStart, lineY + lineHeight, -11141121);
        }
        if (gapEnd < x + entryWidth) {
            context.method_25294(gapEnd, lineY, x + entryWidth, lineY + lineHeight, -11141121);
        }
        VCText.drawScaledText(context, this.screen.method_64506(), entry.name, textX, textY, -11141121, uiScale);
        return headerHeight;
    }

    public void renderExpandButton(VCContext renderCtx, VCEntry entry, int x, int y) {
        boolean expandButtonHovered;
        boolean isExpanded = this.screen.isExpanded(entry.name);
        float uiScale = this.uiScaleSupplier.get().floatValue();
        int buttonHeight = (int)(18.0f * uiScale);
        int buttonGap = uiScale < 0.7f ? Math.max(1, (int)(2.0f * uiScale)) : (int)(3.0f * uiScale);
        int expandButtonWidth = (int)(60.0f * uiScale);
        int expandButtonX = x + (int)(40.0f * uiScale) + buttonGap;
        int expandButtonY = y + (buttonHeight - (int)(12.0f * uiScale)) / 2;
        if (entry.hasToggle()) {
            boolean enabled = entry.getToggleState();
            int toggleWidth = (int)(30.0f * uiScale);
            boolean toggleHovered = VCButton.isHovered(x, y, toggleWidth, buttonHeight, renderCtx.mouseX, renderCtx.mouseY);
            VCButton.render(renderCtx.context, this.screen.method_64506(), VCButton.toggle(x, y, toggleWidth, buttonHeight, enabled).withHovered(toggleHovered).withScale(uiScale));
        }
        int triangleColor = (expandButtonHovered = VCButton.isHovered(expandButtonX, y, expandButtonWidth, buttonHeight, renderCtx.mouseX, renderCtx.mouseY)) ? -6029313 : -11141121;
        VCRenderUtils.gradientTriangle(renderCtx.context, expandButtonX, y + buttonHeight / 2, expandButtonWidth, buttonHeight / 2, triangleColor, isExpanded);
        String text = isExpanded ? "Collapse" : "Expand";
        int textWidth = this.screen.method_64506().method_1727(text);
        int textX = expandButtonX + expandButtonWidth / 2 - (int)((float)textWidth * Math.min(uiScale, 1.0f) / 2.0f);
        VCText.drawScaledText(renderCtx.context, this.screen.method_64506(), text, textX, expandButtonY, this.themeColorSupplier.get(), uiScale);
        if (expandButtonHovered && entry.tooltipText != null) {
            int width = class_310.method_1551().method_22683().method_4480();
            int tooltipX = Math.min(expandButtonX + expandButtonWidth / 3, width - 100);
            int tooltipY = expandButtonY;
            VCRenderUtils.preview(renderCtx.context, this.screen.method_64506(), entry.tooltipText, tooltipX, tooltipY, this.themeColorSupplier.get(), uiScale);
        }
    }

    private void renderEntryControl(class_332 context, VCEntry entry, int x, int y, int mouseX, int mouseY) {
        switch (entry.type) {
            case TOGGLE: 
            case ITEM_CONFIG_TOGGLE: 
            case BLACKLIST_TOGGLE: {
                this.renderToggleControl(context, entry, x, y, mouseX, mouseY);
                break;
            }
            case TOGGLE_WITH_SLIDER: {
                this.renderToggleWithSliderControl(context, entry, x, y, mouseX, mouseY);
                break;
            }
            case SIMPLE_BUTTON: {
                this.renderSimpleButtonControl(context, entry, x, y, mouseX, mouseY);
                break;
            }
            case BUTTON: {
                this.renderButtonControl(context, x, y, mouseX, mouseY);
                break;
            }
            case KEYBIND: {
                this.renderKeybindControl(context, entry, x, y, mouseX, mouseY);
                break;
            }
            case SLIDER: {
                this.renderSliderControl(context, entry, x, y, mouseX, mouseY);
                break;
            }
            case HEADER: {
                break;
            }
        }
    }

    private void renderToggleControl(class_332 context, VCEntry entry, int x, int y, int mouseX, int mouseY) {
        float uiScale = this.uiScaleSupplier.get().floatValue();
        int currentX = x;
        boolean enabled = entry.getToggleState();
        int toggleWidth = (int)(30.0f * uiScale);
        int buttonHeight = (int)(18.0f * uiScale);
        boolean toggleHovered = VCButton.isHovered(currentX, y, toggleWidth, buttonHeight, mouseX, mouseY);
        VCButton.render(context, this.screen.method_64506(), VCButton.toggle(currentX, y, toggleWidth, buttonHeight, enabled).withHovered(toggleHovered).withScale(uiScale));
        int buttonGap = uiScale < 0.7f ? Math.max(1, (int)(2.0f * uiScale)) : (int)(3.0f * uiScale);
        currentX += toggleWidth + buttonGap;
        if (entry.hasHudControls()) {
            int hudWidth = uiScale < 0.7f ? Math.max(20, (int)(40.0f * uiScale)) : (int)(30.0f * uiScale);
            boolean hudHovered = VCButton.isHovered(currentX, y, hudWidth, buttonHeight, mouseX, mouseY);
            VCButton.render(context, this.screen.method_64506(), VCButton.standard(currentX, y, hudWidth, buttonHeight, "HUD").withHovered(hudHovered).withScale(uiScale));
            currentX += hudWidth + buttonGap;
        }
        if (entry.hasColorControl()) {
            this.renderColorButton(context, entry, currentX, y);
        }
        if (entry.hasAdd()) {
            int addWidth = uiScale < 0.7f ? Math.max(20, (int)(40.0f * uiScale)) : (int)(30.0f * uiScale);
            boolean addHovered = VCButton.isHovered(currentX, y, addWidth, buttonHeight, mouseX, mouseY);
            VCButton.render(context, this.screen.method_64506(), VCButton.standard(currentX, y, addWidth, buttonHeight, "ADD").withHovered(addHovered).withScale(uiScale));
        }
    }

    private void renderColorButton(class_332 context, VCEntry entry, int x, int y) {
        float uiScale = this.uiScaleSupplier.get().floatValue();
        int colorSize = (int)(18.0f * uiScale);
        int currentColor = this.getCurrentColor(entry);
        context.method_25294(x, y, x + colorSize, y + colorSize, currentColor);
        context.method_49601(x, y, colorSize, colorSize, -2130706433);
    }

    private int getCurrentColor(VCEntry entry) {
        if ("renderCoords".equals(entry.configKey)) {
            return FishyConfig.getInt("renderCoordsColor");
        }
        if ("xpOutline".equals(entry.configKey)) {
            return FishyConfig.getInt("xpColor");
        }
        if ("customParticleColorIndex".equals(entry.configKey)) {
            if ("custom".equals(FishyConfig.getParticleColorMode())) {
                float[] rgb = FishyConfig.getCustomParticleRGB();
                if (rgb != null && rgb.length == 3) {
                    int r = (int)(rgb[0] * 255.0f);
                    int g = (int)(rgb[1] * 255.0f);
                    int b = (int)(rgb[2] * 255.0f);
                    return 0xFF000000 | r << 16 | g << 8 | b;
                }
            } else {
                int index = FishyConfig.getCustomParticleColorIndex();
                return switch (index) {
                    case 1 -> -10027009;
                    case 2 -> -10027111;
                    case 3 -> -13057;
                    case 4 -> -1710593;
                    default -> -8355712;
                };
            }
        }
        return -65536;
    }

    public void renderSimpleButtonControl(class_332 context, VCEntry entry, int x, int y, int mouseX, int mouseY) {
        int currentX = x;
        int buttonHeight = (int)(18.0f * this.uiScaleSupplier.get().floatValue());
        float uiScale = this.uiScaleSupplier.get().floatValue();
        int buttonGap = uiScale < 0.7f ? Math.max(1, (int)(2.0f * uiScale)) : (int)(3.0f * uiScale);
        int toggleWidth = (int)(30.0f * uiScale);
        boolean toggleHovered = VCButton.isHovered(currentX, y, toggleWidth, buttonHeight, mouseX, mouseY);
        boolean enabled = entry.getToggleState();
        VCButton.render(context, this.screen.method_64506(), VCButton.toggle(currentX, y, toggleWidth, buttonHeight, enabled).withHovered(toggleHovered).withScale(uiScale));
        currentX += toggleWidth + buttonGap;
        String buttonText = entry.buttonText != null ? entry.buttonText : "CONF";
        int textWidth = this.screen.method_64506().method_1727(buttonText);
        int minWidth = (int)(30.0f * uiScale);
        int textBasedWidth = (int)((float)textWidth * Math.min(uiScale, 1.0f)) + (int)(10.0f * uiScale);
        int simpleButtonWidth = uiScale >= 0.7f && uiScale <= 0.8f ? Math.max(minWidth, textBasedWidth + (int)(4.0f * uiScale)) : Math.max(minWidth, textBasedWidth);
        boolean simpleButtonHovered = VCButton.isHovered(currentX, y, simpleButtonWidth, buttonHeight, mouseX, mouseY);
        boolean simpleButtonEnabled = entry.getSimpleButtonState();
        VCButton.render(context, this.screen.method_64506(), VCButton.toggleWithText(currentX, y, simpleButtonWidth, buttonHeight, buttonText, simpleButtonEnabled).withHovered(simpleButtonHovered).withScale(uiScale));
    }

    public void renderButtonControl(class_332 context, int x, int y, int mouseX, int mouseY) {
        float uiScale = this.uiScaleSupplier.get().floatValue();
        int buttonWidth = uiScale < 0.7f ? Math.max(40, (int)(90.0f * uiScale)) : (int)(90.0f * uiScale);
        int buttonHeight = (int)(18.0f * uiScale);
        boolean buttonHovered = VCButton.isHovered(x, y, buttonWidth, buttonHeight, mouseX, mouseY);
        VCButton.render(context, this.screen.method_64506(), VCButton.standard(x, y, buttonWidth, buttonHeight, "Configure").withHovered(buttonHovered).withScale(uiScale));
    }

    public void renderKeybindControl(class_332 context, VCEntry entry, int x, int y, int mouseX, int mouseY) {
        float uiScale = this.uiScaleSupplier.get().floatValue();
        String currentKey = entry.getKeybindValue();
        boolean listening = entry.isListening();
        boolean hasKey = !"NONE".equals(currentKey) && currentKey != null && !currentKey.isEmpty();
        String displayText = listening || !hasKey ? "> <" : KeyUtil.getDisplayNameFor(currentKey);
        int buttonWidth = (int)(30.0f * uiScale);
        int buttonHeight = (int)(18.0f * uiScale);
        boolean keybindHovered = VCButton.isHovered(x, y, buttonWidth, buttonHeight, mouseX, mouseY);
        VCButton.render(context, this.screen.method_64506(), VCButton.keybind(x, y, buttonWidth, buttonHeight, displayText).withListening(listening).withHasKey(hasKey).withHovered(keybindHovered).withScale(uiScale));
    }

    public void renderSliderControl(class_332 context, VCEntry entry, int x, int y, int mouseX, int mouseY) {
        VCSlider slider = this.getOrCreateSlider(entry);
        if (slider == null) {
            return;
        }
        slider.setPosition(x, y + 3);
        slider.setValue(entry.getSliderValue());
        slider.render(context, mouseX, mouseY);
        float uiScale = this.uiScaleSupplier.get().floatValue();
        int valueTextX = x + slider.getWidth() + (int)(8.0f * uiScale);
        int valueTextY = y + (int)(7.0f * uiScale);
        String valueText = this.formatSliderValue(entry);
        int textColor = this.getSliderTextColor(entry);
        VCText.drawScaledText(context, this.screen.method_64506(), valueText, valueTextX, valueTextY, textColor, uiScale);
        if (entry.hasColorControl()) {
            int buttonGap = uiScale < 0.7f ? Math.max(1, (int)(2.0f * uiScale)) : (int)(3.0f * uiScale);
            int colorButtonX = valueTextX + (int)((float)this.screen.method_64506().method_1727(valueText) * Math.min(uiScale, 1.0f)) + buttonGap;
            this.renderColorButton(context, entry, colorButtonX, y);
        }
    }

    public void renderToggleWithSliderControl(class_332 context, VCEntry entry, int x, int y, int mouseX, int mouseY) {
        int currentX = x;
        float uiScale = this.uiScaleSupplier.get().floatValue();
        int buttonHeight = (int)(18.0f * uiScale);
        boolean enabled = entry.getToggleState();
        int toggleWidth = (int)(30.0f * uiScale);
        boolean toggleHovered = VCButton.isHovered(currentX, y, toggleWidth, buttonHeight, mouseX, mouseY);
        VCButton.render(context, this.screen.method_64506(), VCButton.toggle(x, y, toggleWidth, buttonHeight, enabled).withHovered(toggleHovered).withScale(uiScale));
        int toggleSliderGap = uiScale < 0.7f ? Math.max(2, (int)(4.0f * uiScale)) : (int)(6.0f * uiScale);
        currentX += toggleWidth + toggleSliderGap;
        VCSlider slider = this.getOrCreateSlider(entry);
        if (slider != null) {
            slider.setPosition(currentX, y + (buttonHeight - slider.getHeight()) / 2);
            slider.setValue(entry.getSliderValue());
            slider.render(context, mouseX, mouseY);
            float value = entry.getSliderValue();
            String valueText = value <= 0.0f ? "Always" : String.format(entry.getFormatString(), Float.valueOf(value));
            int textColor = this.getSliderTextColor(entry);
            VCText.drawScaledText(context, this.screen.method_64506(), valueText, currentX += slider.getWidth() + (int)(8.0f * uiScale), y + (int)(7.0f * uiScale), textColor, uiScale);
        }
    }

    private VCSlider getOrCreateSlider(VCEntry entry) {
        Map<String, VCSlider> sliderRegistry = this.sliderRegistrySupplier.get();
        if (entry.configKey == null) {
            return null;
        }
        return sliderRegistry.computeIfAbsent(entry.configKey, key -> {
            float uiScale = this.uiScaleSupplier.get().floatValue();
            VCSlider slider = new VCSlider(0, 0, entry.getSliderValue(), entry.getMinValue(), entry.getMaxValue(), entry.getFormatString(), value -> {
                entry.setSliderValue(value);
                if (entry.valueChangeAction != null) {
                    entry.valueChangeAction.accept(Float.valueOf(value));
                }
            });
            slider.setUIScale(uiScale);
            return slider;
        });
    }

    public String formatSliderValue(VCEntry entry) {
        float value = entry.getSliderValue();
        if (entry.getSliderType() == VCEntry.SliderType.STRING) {
            String[] themes = new String[]{"Default", "purple", "Blue", "White", "Green"};
            int index = Math.clamp((long)((int)value), 0, themes.length - 1);
            return themes[index];
        }
        if (entry.getSliderType() == VCEntry.SliderType.PRESET) {
            return switch ((int)value) {
                case 0 -> "Off";
                case 1 -> "Aqua";
                case 2 -> "Mint";
                case 3 -> "Pink";
                case 4 -> "Prism";
                default -> "Off";
            };
        }
        if (entry.getFormatString().contains("%%")) {
            return String.format(entry.getFormatString(), Float.valueOf(value * 100.0f));
        }
        return String.format(entry.getFormatString(), Float.valueOf(value));
    }

    private int getSliderTextColor(VCEntry entry) {
        if ("customParticleColorIndex".equals(entry.configKey)) {
            return this.getCurrentColor(entry);
        }
        return this.themeColorSupplier.get();
    }

    private int darkenColor(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = (int)((double)r * 0.8);
        g = (int)((double)g * 0.8);
        b = (int)((double)b * 0.8);
        return color & 0xFF000000 | r << 16 | g << 8 | b;
    }
}

