/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.VCEntry;
import me.valkeea.fishyaddons.gui.VCScreen;
import me.valkeea.fishyaddons.gui.VCState;
import me.valkeea.fishyaddons.handler.ChatAlert;
import me.valkeea.fishyaddons.handler.ChatReplacement;
import me.valkeea.fishyaddons.handler.ChatTimers;
import me.valkeea.fishyaddons.handler.ClientPing;
import me.valkeea.fishyaddons.handler.CommandAlias;
import me.valkeea.fishyaddons.handler.CopyChat;
import me.valkeea.fishyaddons.handler.FaColors;
import me.valkeea.fishyaddons.handler.GuiIcons;
import me.valkeea.fishyaddons.handler.ItemSearchOverlay;
import me.valkeea.fishyaddons.handler.KeyShortcut;
import me.valkeea.fishyaddons.handler.MobAnimations;
import me.valkeea.fishyaddons.handler.ParticleVisuals;
import me.valkeea.fishyaddons.handler.PetInfo;
import me.valkeea.fishyaddons.handler.RenderTweaks;
import me.valkeea.fishyaddons.handler.ResourceHandler;
import me.valkeea.fishyaddons.handler.SkyblockCleaner;
import me.valkeea.fishyaddons.handler.WeatherTracker;
import me.valkeea.fishyaddons.handler.XpColor;
import me.valkeea.fishyaddons.hud.EqDisplay;
import me.valkeea.fishyaddons.hud.TrackerDisplay;
import me.valkeea.fishyaddons.tool.FishyMode;
import me.valkeea.fishyaddons.tracker.SackDropParser;
import me.valkeea.fishyaddons.tracker.TrackerUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class VCManager {
    public static List<VCEntry> createAllEntries() {
        ArrayList<VCEntry> entries = new ArrayList<VCEntry>();
        VCManager.addUi(entries);
        VCManager.addQol(entries);
        VCManager.addRender(entries);
        VCManager.addSb(entries);
        VCManager.addFg(entries);
        return entries;
    }

    private static void addUi(List<VCEntry> entries) {
        entries.add(VCEntry.header("\u2500\u2500 Interface \u2500\u2500", ""));
        entries.add(VCEntry.slider("Custom UI Scale", "Adjust mod scaling manually (Also influenced by vanilla settings).", "modUiScale", 0.0f, 1.3f, "%.1fx", value -> {
            FishyConfig.setFloat("modUiScale", value.floatValue());
            class_310 client = class_310.method_1551();
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof VCScreen) {
                VCScreen currentScreen = (VCScreen)patt0$temp;
                VCState.preserveState(currentScreen.getScrollOffset(), currentScreen.getLastSearchText(), currentScreen.getExpandedEntries());
            }
            client.method_1507((class_437)new VCScreen());
        }));
        entries.add(VCEntry.typedSlider("Mod Theme", "Choose the visual theme for FishyAddons.\nThis affects colors and styling throughout the mod.", "themeMode", 0.0f, 4.0f, "%.0f", value -> {
            String[] themes = new String[]{"default", "purple", "blue", "white", "green"};
            int themeIndex = Math.round(value.floatValue());
            if (themeIndex >= 0 && themeIndex < themes.length) {
                FishyMode.setTheme(themes[themeIndex]);
            }
        }, VCEntry.SliderType.STRING));
        entries.add(VCEntry.toggle("Transparent Minecraft GUI", "Uses textures from ValksfullSbPack (WIP), currently being ported from 1.8.9.", "fishyGui", false, () -> {
            ResourceHandler.updateGuiPack();
            class_310 client = class_310.method_1551();
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof VCScreen) {
                VCScreen currentScreen = (VCScreen)patt0$temp;
                VCState.preservePersistentState(currentScreen.getScrollOffset(), currentScreen.getLastSearchText(), currentScreen.getExpandedEntries());
            }
            client.method_1507((class_437)new VCScreen());
        }));
        entries.add(VCEntry.toggle("HD Font", "Replaces the default font with a high-definition one\nfrom ValksfullSbPack.", "hdFont", false, () -> {
            ResourceHandler.updateFontPack();
            class_310 client = class_310.method_1551();
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof VCScreen) {
                VCScreen currentScreen = (VCScreen)patt0$temp;
                VCState.preservePersistentState(currentScreen.getScrollOffset(), currentScreen.getLastSearchText(), currentScreen.getExpandedEntries());
            }
            client.method_1507((class_437)new VCScreen());
        }));
    }

    private static void addQol(List<VCEntry> entries) {
        entries.add(VCEntry.header("\u2500\u2500 General QoL \u2500\u2500", ""));
        ArrayList<VCEntry> invSearchSubEntries = new ArrayList<VCEntry>();
        invSearchSubEntries.add(VCEntry.toggleColorOrHud("Main Toggle", "Enables a HUD textfield for inventory search.", "invSearch", false, null, new VCScreen.ExtraControl("Item Search", false, false)));
        invSearchSubEntries.add(VCEntry.slider("Overlay Opacity", "Adjust the darkness of the search overlay when highlighting items.", "searchOverlayOpacity", 0.0f, 1.0f, "%.0f%%", opacity -> ItemSearchOverlay.getInstance().setOpacity(opacity.floatValue())));
        entries.add(VCEntry.expandable("Inventory Search", "Scan your inventory items by name or lore.\nRight-click the search field to toggle search mode.", invSearchSubEntries, Arrays.asList(class_2561.method_43470((String)"Inventory Search:"), class_2561.method_43470((String)"- \u00a78Toggle setting"), class_2561.method_43470((String)"- \u00a78Configure overlay opacity"), class_2561.method_43470((String)"- \u00a78Shortcut to HUD editor"))));
        entries.add(VCEntry.toggleColorOrHud("Highlight Coordinates", "Render a beacon-style highlight at coordinates shared in chat.\nUse /fa coords <title> to render/send additional text.\nSupports any coordinates in the format: x:<x>, y:<y>, z:<z>", "renderCoords", false, null, new VCScreen.ExtraControl(null, true, false)));
        entries.add(VCEntry.toggleColorOrHud("Ping Display", "Shows your current ping in the HUD.\nUse the HUD editor to customize position and appearance.\nUse /fa ping to send this value in chat.", "pingHud", false, ClientPing::refresh, new VCScreen.ExtraControl("Ping Display", false, false)));
        entries.add(VCEntry.toggle2("Copy Chat", "Right-click chat messages to copy them to clipboard.\nHold shift to copy just the hovered line.", "copyChat", false, "NOTI", "ccNoti", false, CopyChat::refresh));
        entries.add(VCEntry.toggle("Skip Front Perspective", "Skip the front-facing perspective when cycling camera views (F5).\nGoes directly from first person to back view.", "skipPerspective", false, null));
        entries.add(VCEntry.toggleColorOrHud("Custom Keybinds", "Configure custom keybinds for commands.", "keyShortcutsOn", false, KeyShortcut::refresh, new VCScreen.ExtraControl(null, false, true)));
        entries.add(VCEntry.toggleColorOrHud("Custom Commands", "Configure custom commands.", "aliasesOn", false, CommandAlias::refresh, new VCScreen.ExtraControl(null, false, true)));
        entries.add(VCEntry.toggleColorOrHud("Chat Replacement", "Configure chat message replacements.", "chatReplacementsOn", false, ChatReplacement::refresh, new VCScreen.ExtraControl(null, false, true)));
        entries.add(VCEntry.toggleColorOrHud("Chat Alerts", "Custom alerts with optional title, sound and autochat on\nchat events. Be specific to prevent undesired matches.", "chatAlertsOn", false, ChatAlert::refresh, new VCScreen.ExtraControl(null, false, true)));
    }

    private static void addRender(List<VCEntry> entries) {
        entries.add(VCEntry.header("\u2500\u2500 Rendering Tweaks \u2500\u2500", ""));
        ArrayList<VCEntry> colorSubEntries = new ArrayList<VCEntry>();
        ArrayList<VCEntry> xpSubEntries = new ArrayList<VCEntry>();
        entries.add(VCEntry.toggle("Skip Death Animation", "Prevent death animation from rendering on entities.\nUseful for reducing visual clutter caused by already-dead entities.", "deathAni", false, MobAnimations::refresh));
        entries.add(VCEntry.toggle("Skip Fire Animation", "Prevent fire from rendering on entities.\nThis will not remove the FOV effect.", "fireAni", false, MobAnimations::refresh));
        entries.add(VCEntry.toggle("Clear Lava", "Removes the red fog overlay when submerged in lava.\nDisabled outside Skyblock.", "fishyLava", false, RenderTweaks::refresh));
        entries.add(VCEntry.toggle("Clear Water", "Removes underwater fog and improves visibility.\nDisabled outside Skyblock.", "fishyWater", false, RenderTweaks::refresh));
        xpSubEntries.add(VCEntry.toggleColorOrHud("Color and Outline", "Set a color and toggle a bold outline.", "xpOutline", false, XpColor::refresh, new VCScreen.ExtraControl(null, true, false)));
        entries.add(VCEntry.toggleExpandable("XP Text Color", "Customize the appearance of vanilla experience display by\naltering the color and adding an outline.", xpSubEntries, Arrays.asList(class_2561.method_43470((String)"XP Color:"), class_2561.method_43470((String)"- \u00a78Set the color and"), class_2561.method_43470((String)"  \u00a78optional outline")), "xpColorEnabled", false, XpColor::refresh));
        entries.add(VCEntry.typedSliderColor("Redstone Particle Color", "Customize redstone particle colors. Use the slider to select presets\n(Off/Aqua/Mint/Pink/Prism) or click the color square for custom colors.", "customParticleColorIndex", 0.0f, 4.0f, "%.0f", value -> {
            int index = Math.round(value.floatValue());
            FishyConfig.setCustomParticleColorIndex(index);
            if ("custom".equals(FishyConfig.getParticleColorMode())) {
                FishyConfig.setParticleColorMode("preset");
            }
            ParticleVisuals.refreshCache();
        }, VCEntry.SliderType.PRESET, true));
        colorSubEntries.add(VCEntry.toggleColorOrHud("Custom Fa Colors", "Add your own entries (not shared with others).", "customFaColors", false, FaColors::refresh, new VCScreen.ExtraControl(null, false, true)));
        entries.add(VCEntry.toggleExpandable("FA Colors", "Colors player names for all users.\nNote: Name label recoloring is incompatible with Skyhanni.", colorSubEntries, Arrays.asList(class_2561.method_43470((String)"FA Colors:"), class_2561.method_43470((String)"- \u00a78Predetermined list of players will be"), class_2561.method_43470((String)"  \u00a78recolored globally"), class_2561.method_43470((String)"- \u00a78You can add your own entries, but"), class_2561.method_43470((String)"  \u00a78other players will not see them")), "globalFaColors", false, FaColors::refresh));
    }

    private static void addSb(List<VCEntry> entries) {
        entries.add(VCEntry.header("\u2500\u2500 SkyBlock Features \u2500\u2500", ""));
        ArrayList<VCEntry> petSubEntries = new ArrayList<VCEntry>();
        ArrayList<VCEntry> profitEntries = new ArrayList<VCEntry>();
        ArrayList<VCEntry> trackerEntries = new ArrayList<VCEntry>();
        entries.add(VCEntry.toggle("Equipment Display", "Renders a secondary armor display with your current equipment.\nData updates when /eq is opened.", "equipmentDisplay", false, EqDisplay::reset));
        petSubEntries.add(VCEntry.toggleColorOrHud("Dynamic", "Updates data on tab updates, limited to once per second.\nIf disabled, data will rely on chat.", "tabTicks", false, PetInfo::refresh, new VCScreen.ExtraControl("Pet Display", false, false)));
        petSubEntries.add(VCEntry.toggle("Show XP", "Displays the XP of your active pet.", "petXpCheck", false, PetInfo::refresh));
        entries.add(VCEntry.toggleExpandable("Pet Display", "Renders an editable HUD element for your currently active pet.", petSubEntries, Arrays.asList(class_2561.method_43470((String)"Pet Display:"), class_2561.method_43470((String)"- \u00a78Show/Hide pet XP"), class_2561.method_43470((String)"- \u00a78Toggle dynamic/chat-based mode"), class_2561.method_43470((String)"- \u00a78Shortcut to HUD editor")), "petHud", false, PetInfo::refresh));
        profitEntries.add(VCEntry.toggle("Price per Item", "Adds additional price data to the display.", "pricePerItem", false, TrackerUtils::refresh));
        profitEntries.add(VCEntry.toggle("Track Sack Drops", "Requires sack notifications on to function.", "trackSack", false, SackDropParser::refresh));
        profitEntries.add(VCEntry.slider("Filter by Minimum Value", "Hides items under this value, set to 0 to disable.", "minItemValue", 0.0f, 50000.0f, "%.0f", value -> {
            FishyConfig.setFloat("minItemValue", value.floatValue());
            FishyConfig.enable("minValueFilter", value.floatValue() > 0.0f);
            TrackerDisplay.refreshDisplay();
        }));
        profitEntries.add(VCEntry.toggle("Book Drop Message", "Displays a message with the book title when a book is dropped.", "bookDropAlert", false, null));
        profitEntries.add(VCEntry.toggle("Tracker Drop Notifications", "Adds a drop message to tracked items without one.", "trackerNotis", false, null));
        entries.add(VCEntry.toggleExpandable("Profit Tracker (WIP)", "Configure settings for the Profit Tracker. Use /fp for available commands.\nTIP: Right- click an entry in the display to hide it.", profitEntries, Arrays.asList(class_2561.method_43470((String)"Profit Tracker:"), class_2561.method_43470((String)"- \u00a78Toggle book drop message"), class_2561.method_43470((String)"- \u00a78Configure Profit Tracker:"), class_2561.method_43470((String)"  \u00a78- Minimum value filter"), class_2561.method_43470((String)"  \u00a78- Set profit display options"), class_2561.method_43470((String)"- \u00a78- /fp toggle, /fp help")), "profitTrackerHud", false, TrackerUtils::refresh));
        trackerEntries.add(VCEntry.header("\u2500\u2500 Century Cake Tracker \u2500\u2500", ""));
        trackerEntries.add(VCEntry.toggle("Enable Notifications", "Notifies the user when a century cake is about to expire or expires.", "centuryCakeChatReminder", false, null));
        trackerEntries.add(VCEntry.toggleColorOrHud("Century Cake Display", "Enables a HUD timer.", "centuryCakeHud", false, TrackerUtils::refresh, new VCScreen.ExtraControl("Century Cakes: ", false, false)));
        trackerEntries.add(VCEntry.header("\u2500\u2500 Rain Tracker \u2500\u2500", ""));
        trackerEntries.add(VCEntry.toggle("Rain Tracker", "Tracks the worlds weather state and notifies if rain stops.\nDue to Hypixel quirks this will not work reliably in the Park cave.", "rainNoti", false, WeatherTracker::track));
        trackerEntries.add(VCEntry.header("\u2500\u2500 Moonglade Minigame Alarm \u2500\u2500", ""));
        trackerEntries.add(VCEntry.toggle("Alarm", "Alerts you with a sound and system toast when the minigame is ready.", "beaconAlarm", false, ChatTimers.getInstance()::refresh));
        trackerEntries.add(VCEntry.toggleColorOrHud("Timer Display", "Adds a HUD timer if the minigame is on cooldown.", "timerHud", false, ChatTimers.getInstance()::refresh, new VCScreen.ExtraControl("Moonglade: ", false, false)));
        entries.add(VCEntry.expandable("Trackers and alerts", "Configure settings for Century Cake Display, Rain Tracker\nand Moonglade Minigame alarm.", trackerEntries, Arrays.asList(class_2561.method_43470((String)"Trackers and alerts:"), class_2561.method_43470((String)"- \u00a78Toggle century cake chat alert/display"), class_2561.method_43470((String)"- \u00a78Toggle Moonglade Alarm"), class_2561.method_43470((String)"- \u00a78Toggle rain warning"), class_2561.method_43470((String)"  \u00a78- Or use /fa rain on | off"))));
        entries.add(VCEntry.toggle("Clean Wither Impact", "Removes explosion particles and any sound effects caused by\nwither blade abilities.", "cleanHype", false, SkyblockCleaner::refresh));
        entries.add(VCEntry.toggle("Mute Phantoms", "Disables all phantom mob sounds.", "mutePhantom", false, SkyblockCleaner::refresh));
        entries.add(VCEntry.toggle("Mute Runes", "Disables all annoying rune sounds.", "muteRune", false, SkyblockCleaner::refresh));
        entries.add(VCEntry.toggleSlider("Hide Hotspot Holograms", "Hides all fishing hotspot armor stands if they are\nin the configured distance.", "hideHotspot", false, "hotspotDistance", 0.0f, 20.0f, "%.0f blocks", SkyblockCleaner::refresh));
        entries.add(VCEntry.keybind("Hide Gui Buttons", "Set the key to hide Skyblock gui icons. Tap the key to add/remove\n hovered slots, peek and bypass block by holding shift.", "lockGuiSlotKey", false, GuiIcons::refresh));
        entries.add(VCEntry.slider("Invisibug Helper", "Scales the particles emitted by Invisibugs (crit) while on Galatea.\nSet to 0 to disable.", "dmgScale", 0.0f, 1.5f, "%.2f", value -> {
            FishyConfig.setFloat("dmgScale", value.floatValue());
            FishyConfig.enable("scaleCritParticles", value.floatValue() > 0.0f);
            ParticleVisuals.refreshCache();
        }));
    }

    private static void addFg(List<VCEntry> entries) {
        entries.add(VCEntry.header("\u2500\u2500 Item Safeguard \u2500\u2500", ""));
        ArrayList<VCEntry> itemManagementSubEntries = new ArrayList<VCEntry>();
        itemManagementSubEntries.add(VCEntry.icToggle("Sell Protection", "Main toggle for protecting items in blacklisted GUIs.\n(Auction, salvaging, trade menu, npc shops)", "sellProtectionEnabled", false));
        itemManagementSubEntries.add(VCEntry.icToggle("Safeguard Tooltips", "Display a tag at the end of a protected item's tooltip.", "tooltipEnabled", false));
        itemManagementSubEntries.add(VCEntry.icToggle("Protection Notification", "Show chat notifications when safeguard features are triggered.", "protectNotiEnabled", false));
        itemManagementSubEntries.add(VCEntry.icToggle("Protection Alert", "Give auditory feedback when attempting to drop or sell protected items.", "protectTriggerEnabled", false));
        itemManagementSubEntries.add(VCEntry.header("\u2500\u2500 Manage Blocked GUIs \u2500\u2500", ""));
        itemManagementSubEntries.add(VCEntry.blToggle("Block Auction House", "Prevent interactions in auctions.", "Create Auction", true));
        itemManagementSubEntries.add(VCEntry.blToggle("Block Player Trades", "Prevent trading guarded items.", "Coins Transaction", true));
        itemManagementSubEntries.add(VCEntry.blToggle("Block Salvaging", "Prevent interactions with item salvaging interfaces.", "Salvage Items", true));
        itemManagementSubEntries.add(VCEntry.blToggle("Block NPC Sales", "Prevent interactions with NPC shops.", "Sell Item", true));
        entries.add(VCEntry.expandable("Item Safeguard", "Protect Skyblock items from drops and undesired clicks.\nExpand to configure advanced settings", itemManagementSubEntries, Arrays.asList(class_2561.method_43470((String)"Item Safeguard:"), class_2561.method_43470((String)"- \u00a78Manage blocked guis"), class_2561.method_43470((String)"- \u00a78Toggle settings for visual and auditory feedback"), class_2561.method_43470((String)"- \u00a78/fg add to add items, /fg help to see all commands"))));
        entries.add(VCEntry.keybind("Bind and Lock Slots ", "Set the key to lock (tap) and bind (drag) slots.\nLeft-click again to remove key.", "lockKey", false, null));
    }

    public static List<VCEntry> filterEntries(List<VCEntry> allEntries, String searchText) {
        if (searchText == null || searchText.trim().isEmpty()) {
            return new ArrayList<VCEntry>(allEntries);
        }
        ArrayList<VCEntry> filtered = new ArrayList<VCEntry>();
        String lowerSearch = searchText.toLowerCase().trim();
        for (VCEntry entry : allEntries) {
            if (!VCManager.matchesSearch(entry, lowerSearch)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    private static boolean matchesSearch(VCEntry entry, String search) {
        String lowerDesc;
        int descIdx;
        if (entry.type == VCEntry.EntryType.HEADER) {
            return false;
        }
        String name = entry.name.startsWith("  ") ? entry.name.substring(2) : entry.name;
        String lowerName = name.toLowerCase();
        int idx = lowerName.indexOf(search);
        if (idx != -1) {
            boolean afterSpace;
            boolean atStart = idx == 0;
            boolean bl = afterSpace = idx > 0 && lowerName.charAt(idx - 1) == ' ';
            if (atStart || afterSpace) {
                return true;
            }
        }
        if (entry.description != null && (descIdx = (lowerDesc = entry.description.toLowerCase()).indexOf(search)) != -1) {
            boolean afterSpace;
            boolean atStart = descIdx == 0;
            boolean bl = afterSpace = descIdx > 0 && lowerDesc.charAt(descIdx - 1) == ' ';
            if (atStart || afterSpace) {
                return true;
            }
        }
        return false;
    }

    public static boolean needsHudButton(VCEntry entry) {
        return entry.hudElementName != null;
    }

    public static boolean needsColorButton(VCEntry entry) {
        return entry.hasColorControl;
    }

    public static boolean needsAddButton(VCEntry entry) {
        return entry.hasAdd();
    }

    private VCManager() {
        throw new UnsupportedOperationException("Utility class");
    }
}

