/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.function.Consumer;
import me.valkeea.fishyaddons.gui.VCButton;
import me.valkeea.fishyaddons.gui.VCRenderUtils;
import me.valkeea.fishyaddons.gui.VCText;
import me.valkeea.fishyaddons.gui.VCTextField;
import me.valkeea.fishyaddons.render.FaLayers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class VCPopup {
    private final class_2561 title;
    private final String leftButtonText;
    private final String rightButtonText;
    private final boolean hasTextField;
    private final float uiScale;
    private final Runnable onLeft;
    private Consumer<String> onSave;
    private Runnable onRight;
    private VCButton.ButtonConfig leftButtonConfig;
    private VCButton.ButtonConfig rightButtonConfig;
    private VCTextField textField;
    private int x;
    private int y;
    private int width;
    private int height;

    public VCPopup(class_2561 title, Runnable onLeft, String leftButtonText, Consumer<String> onSave, String rightButtonText, float uiScale) {
        this.title = title;
        this.onLeft = onLeft;
        this.leftButtonText = leftButtonText;
        this.rightButtonText = rightButtonText;
        this.hasTextField = true;
        this.onSave = onSave;
        this.uiScale = uiScale;
    }

    public VCPopup(class_2561 title, String leftButtonText, Runnable onLeft, String rightButtonText, Runnable onRight, float uiScale) {
        this.title = title;
        this.leftButtonText = leftButtonText;
        this.rightButtonText = rightButtonText;
        this.hasTextField = false;
        this.onSave = null;
        this.onLeft = onLeft;
        this.onRight = onRight;
        this.uiScale = uiScale;
    }

    public void init(class_327 textRenderer, int screenWidth, int screenHeight) {
        this.width = (int)(260.0f * this.uiScale);
        this.height = (int)(80.0f * this.uiScale);
        this.height = (this.hasTextField ? 110 : 80) * (int)this.uiScale;
        this.x = (screenWidth - this.width) / 2;
        this.y = (screenHeight - this.height) / 2;
        int buttonWidth = (int)(90.0f * this.uiScale);
        int buttonHeight = (int)(20.0f * this.uiScale);
        int buttonY = this.y + (this.hasTextField ? 80 : 50) * (int)this.uiScale;
        this.leftButtonConfig = VCButton.standard(this.x + (int)(15.0f * this.uiScale), buttonY, buttonWidth, buttonHeight, this.leftButtonText).withScale(this.uiScale);
        this.rightButtonConfig = VCButton.standard(this.x + (int)((float)(this.width - buttonWidth) - 15.0f * this.uiScale), buttonY, buttonWidth, buttonHeight, this.rightButtonText).withScale(this.uiScale);
        int tfWidth = (int)((float)this.width - 40.0f * this.uiScale);
        int tfHeight = (int)(20.0f * this.uiScale);
        int tfX = this.x + (int)(20.0f * this.uiScale);
        int tfY = this.y + (int)(45.0f * this.uiScale);
        this.textField = new VCTextField(textRenderer, tfX, tfY, tfWidth, tfHeight, (class_2561)class_2561.method_43470((String)""));
        this.textField.setUIScale(this.uiScale);
        this.textField.method_1880(10);
        this.textField.method_25365(true);
    }

    public void render(class_332 context, class_327 textRenderer, int mouseX, int mouseY, float delta) {
        FaLayers.renderAboveOverlay(context, () -> {
            VCRenderUtils.opaqueGradient(context, this.x, this.y, this.width, this.height, -14342875);
            VCRenderUtils.border(context, this.x, this.y, this.width, this.height, -16777216);
            VCText.drawScaledCenteredText(context, textRenderer, this.title.getString(), this.x + this.width / 2, this.y + (int)(15.0f * this.uiScale), 14863081, this.uiScale);
        });
        if (this.hasTextField && this.textField != null) {
            this.textField.method_48579(context, mouseX, mouseY, delta);
        }
        if (this.leftButtonConfig != null && this.rightButtonConfig != null) {
            int buttonWidth = (int)(90.0f * this.uiScale);
            int buttonHeight = (int)(20.0f * this.uiScale);
            int buttonY = this.y + (this.hasTextField ? 80 : 50) * (int)this.uiScale;
            int leftButtonX = this.x + (int)(15.0f * this.uiScale);
            int rightButtonX = this.x + (int)((float)(this.width - buttonWidth) - 15.0f * this.uiScale);
            this.leftButtonConfig.withHovered(VCButton.isHovered(leftButtonX, buttonY, buttonWidth, buttonHeight, mouseX, mouseY));
            this.rightButtonConfig.withHovered(VCButton.isHovered(rightButtonX, buttonY, buttonWidth, buttonHeight, mouseX, mouseY));
            FaLayers.renderAboveOverlay(context, () -> {
                VCButton.render(context, textRenderer, this.leftButtonConfig);
                VCButton.render(context, textRenderer, this.rightButtonConfig);
            });
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.hasTextField && this.textField != null && mouseX >= (double)this.textField.method_46426() && mouseX < (double)(this.textField.method_46426() + this.textField.method_25368()) && mouseY >= (double)this.textField.method_46427() && mouseY < (double)(this.textField.method_46427() + this.textField.method_25364()) && this.textField.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return this.buttonClick(mouseX, mouseY);
    }

    private boolean buttonClick(double mouseX, double mouseY) {
        int buttonWidth = (int)(90.0f * this.uiScale);
        int buttonHeight = (int)(20.0f * this.uiScale);
        int buttonY = this.y + (this.hasTextField ? 80 : 50) * (int)this.uiScale;
        int leftButtonX = this.x + (int)(15.0f * this.uiScale);
        int rightButtonX = this.x + (int)((float)(this.width - buttonWidth) - 15.0f * this.uiScale);
        boolean left = VCButton.isHovered(leftButtonX, buttonY, buttonWidth, buttonHeight, (int)mouseX, (int)mouseY);
        boolean right = VCButton.isHovered(rightButtonX, buttonY, buttonWidth, buttonHeight, (int)mouseX, (int)mouseY);
        if (left) {
            if (this.onLeft != null) {
                this.onLeft.run();
            }
            return true;
        }
        if (right) {
            if (this.hasTextField) {
                if (this.onSave != null && this.textField != null) {
                    this.onSave.accept(this.textField.method_1882());
                }
            } else if (this.onRight != null) {
                this.onRight.run();
            }
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.hasTextField && this.textField != null) {
            return this.textField.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        if (this.hasTextField && this.textField != null) {
            return this.textField.method_25400(chr, modifiers);
        }
        return false;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public VCTextField getTextField() {
        return this.textField;
    }

    public boolean hasTextField() {
        return this.hasTextField;
    }
}

