/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class VCRenderUtils {
    public static void preview(class_332 context, class_327 textRenderer, List<class_2561> lines, int x, int y, int themeColor, float uiScale) {
        if (lines == null || lines.isEmpty()) {
            return;
        }
        int width = 0;
        for (class_2561 line : lines) {
            int lineWidth = textRenderer.method_27525((class_5348)line);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 400.0f);
        matrices.method_22905(uiScale, uiScale, 1.0f);
        int tooltipX = (int)((float)x / uiScale) + 8;
        int tooltipY = (int)((float)y / uiScale);
        int height = lines.size() * 10 + 5;
        context.method_25294(tooltipX - 3, tooltipY - 3, tooltipX + width + 3, tooltipY + height + 3, -1879048192);
        context.method_25294(tooltipX - 2, tooltipY - 2, tooltipX + width + 1, tooltipY + height + 1, -1342177280);
        for (int i = 0; i < lines.size(); ++i) {
            context.method_27535(textRenderer, lines.get(i), tooltipX, tooltipY + i * 10, themeColor);
        }
        matrices.method_22909();
    }

    public static void gradientTriangle(class_332 context, int x, int y, int width, int height, int color, boolean isNorth) {
        for (int i = 0; i < height; ++i) {
            int lineY = isNorth ? y + i : y + height - i - 1;
            int lineXStart = x + width / 2 - i;
            int lineXEnd = x + width / 2 + i;
            int gradientColor = color & 0xFFFFFF | (255 - 255 * i / height) * 0x1000000;
            context.method_25294(lineXStart, lineY, lineXEnd, lineY + 1, gradientColor);
        }
    }

    public static void drawNw(class_332 context, int x, int y, int width, int height, int color) {
        int gradientColor;
        int i;
        for (i = 0; i < 2; ++i) {
            int lineY = y + i;
            gradientColor = color & 0xFFFFFF | (255 - 255 * i / 2) * 0x1000000;
            context.method_25294(x, lineY, x + width, lineY + 1, gradientColor);
        }
        for (i = 0; i < 2; ++i) {
            int lineX = x + i;
            gradientColor = color & 0xFFFFFF | (255 - 255 * i / 2) * 0x1000000;
            context.method_25294(lineX, y, lineX + 1, y + height, gradientColor);
        }
    }

    public static void drawSe(class_332 context, int x, int y, int width, int height, int color) {
        int gradientColor;
        int i;
        for (i = 0; i < 2; ++i) {
            int lineY = y + height - i;
            gradientColor = color & 0xFFFFFFFF | (255 - 255 * i / 2) * 0x1000000;
            context.method_25294(x, lineY, x + width, lineY + 1, gradientColor);
        }
        for (i = 0; i < 2; ++i) {
            int lineX = x + width - i;
            gradientColor = color & 0xFFFFFFFF | (255 - 255 * i / 2) * 0x1000000;
            context.method_25294(lineX, y, lineX + 1, y + height, gradientColor);
        }
    }

    public static void draw3dButton(class_332 context, int x, int y, int width, int height, int color) {
        VCRenderUtils.drawNw(context, x, y, width, height, color);
        VCRenderUtils.drawSe(context, x, y, width, height, color);
    }

    public static void border(class_332 context, int x, int y, int width, int height, int color) {
        context.method_25294(x, y, x + width, y + 1, color);
        context.method_25294(x, y + height - 1, x + width, y + height, color);
        context.method_25294(x, y + 1, x + 1, y + height - 1, color);
        context.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public static void gradient(class_332 context, int x, int y, int width, int height, int color) {
        for (int i = 0; i < height; ++i) {
            int gradientColor = color & 0xFFFFFF | (255 - 255 * i / height) * 0x1000000;
            context.method_25294(x, y + i, x + width, y + i + 1, gradientColor);
        }
    }

    public static void opaqueGradient(class_332 context, int x, int y, int width, int height, int color) {
        for (int i = 0; i < height; ++i) {
            context.method_25294(x, y + i, x + width, y + i + 1, color);
        }
    }

    private VCRenderUtils() {
        throw new UnsupportedOperationException("Utility class");
    }
}

