/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.ColorWheel;
import me.valkeea.fishyaddons.gui.FishyAddonsScreen;
import me.valkeea.fishyaddons.gui.GUIChatAlert;
import me.valkeea.fishyaddons.gui.GUIFaColor;
import me.valkeea.fishyaddons.gui.HudEditScreen;
import me.valkeea.fishyaddons.gui.TabbedListScreen;
import me.valkeea.fishyaddons.gui.VCButton;
import me.valkeea.fishyaddons.gui.VCConstants;
import me.valkeea.fishyaddons.gui.VCContext;
import me.valkeea.fishyaddons.gui.VCEntry;
import me.valkeea.fishyaddons.gui.VCGui;
import me.valkeea.fishyaddons.gui.VCManager;
import me.valkeea.fishyaddons.gui.VCRenderUtils;
import me.valkeea.fishyaddons.gui.VCSlider;
import me.valkeea.fishyaddons.gui.VCState;
import me.valkeea.fishyaddons.gui.VCText;
import me.valkeea.fishyaddons.gui.VCTextField;
import me.valkeea.fishyaddons.handler.ParticleVisuals;
import me.valkeea.fishyaddons.handler.XpColor;
import me.valkeea.fishyaddons.tool.FishyMode;
import me.valkeea.fishyaddons.util.KeyUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class VCScreen
extends class_437 {
    private int entryHeight;
    private int subEntryHeight;
    private int headerHeight;
    private int entryWidth;
    private float uiScale;
    private int endY;
    private List<VCEntry> configEntries;
    private List<VCEntry> filteredEntries;
    private VCTextField searchField;
    private int scrollOffset = 0;
    private int maxVisibleEntries;
    private String lastSearchText = "";
    private Map<String, Boolean> expandedEntries = new HashMap<String, Boolean>();
    private boolean isDraggingScrollbar = false;
    private int scrollbarThumbOffset = 0;
    private Map<String, VCSlider> sliderRegistry = new HashMap<String, VCSlider>();
    private VCGui renderer;

    public VCScreen() {
        super((class_2561)class_2561.method_43470((String)"\u2500 \u03b1 FishyAddons Configuration \u03b1 \u2500"));
        this.configEntries = new ArrayList<VCEntry>();
        this.filteredEntries = new ArrayList<VCEntry>();
        this.renderer = new VCGui(this, this::getThemeColor, () -> Float.valueOf(this.uiScale), () -> this.sliderRegistry);
    }

    private int getThemeColor() {
        return FishyMode.getThemeColor();
    }

    public class_327 method_64506() {
        return this.field_22793;
    }

    public int getScrollOffset() {
        return this.scrollOffset;
    }

    public String getLastSearchText() {
        return this.lastSearchText;
    }

    public Map<String, Boolean> getExpandedEntries() {
        return this.expandedEntries;
    }

    protected void method_25426() {
        this.calcScaledDimensions();
        this.configEntries = VCManager.createAllEntries();
        this.filteredEntries = new ArrayList<VCEntry>(this.configEntries);
        this.restoreState();
        int centerX = this.field_22789 / 2;
        int searchY = 40;
        int scaledSearchHeight = VCConstants.getSearchHeight(this.uiScale);
        this.searchField = new VCTextField(this.field_22793, centerX - this.entryWidth / 2, searchY, this.entryWidth, scaledSearchHeight, (class_2561)class_2561.method_43470((String)"Search features..."));
        this.searchField.setUIScale(this.uiScale);
        this.searchField.method_1863(this::onSearchChanged);
        this.searchField.method_47404((class_2561)class_2561.method_43470((String)"Search features..."));
        this.searchField.method_1852(this.lastSearchText);
        this.method_37063((class_364)this.searchField);
        if (!this.lastSearchText.isEmpty()) {
            this.onSearchChanged(this.lastSearchText);
        }
        int scaledButtonHeight = Math.max(12, (int)(20.0f * this.uiScale));
        int scaledButtonMargin = Math.max(1, (int)(4.0f * this.uiScale));
        int scaledBottomSpacing = Math.max(1, (int)(2.0f * this.uiScale));
        int availableHeight = this.field_22790 - searchY - scaledSearchHeight - scaledButtonHeight - scaledButtonMargin - scaledBottomSpacing;
        if (this.uiScale < 0.7f) {
            availableHeight += Math.max(0, (int)(8.0f * this.uiScale));
            if (this.uiScale < 0.5f) {
                availableHeight += Math.max(0, (int)(10.0f * this.uiScale));
            }
        }
        int averageEntryHeight = this.getAverageEntryHeight();
        this.maxVisibleEntries = Math.max(1, availableHeight / averageEntryHeight);
        int buttonWidth = Math.max(40, (int)(75.0f * this.uiScale));
        int buttonY = this.field_22790 - scaledButtonHeight - scaledBottomSpacing;
        this.endY = buttonY - (int)(5.0f * this.uiScale);
        this.method_37063((class_364)VCButton.createNavigationButton(centerX - buttonWidth - (int)(10.0f * this.uiScale), buttonY, buttonWidth, scaledButtonHeight, class_2561.method_43470((String)"Back").method_10862(class_2583.field_24360.method_36139(-8355712)), btn -> {
            VCState.preservePersistentState(this.scrollOffset, this.lastSearchText, this.expandedEntries);
            class_310.method_1551().method_1507((class_437)new FishyAddonsScreen());
        }, this.uiScale));
        this.method_37063((class_364)VCButton.createNavigationButton(centerX + (int)(10.0f * this.uiScale), buttonY, buttonWidth, scaledButtonHeight, class_2561.method_43470((String)"Close").method_10862(class_2583.field_24360.method_36139(-8355712)), btn -> {
            VCState.preservePersistentState(this.scrollOffset, this.lastSearchText, this.expandedEntries);
            class_310.method_1551().method_1507(null);
        }, this.uiScale));
    }

    private void restoreState() {
        this.scrollOffset = VCState.getLastScrollOffset();
        this.lastSearchText = VCState.getLastSearchText();
        this.expandedEntries = VCState.getLastExpandedEntries();
        VCState.clearTemporaryState();
    }

    private void calcScaledDimensions() {
        float customScale = FishyConfig.getFloat("modUiScale", 0.4265625f);
        double scale = Math.clamp((double)customScale, 0.5, 1.3);
        this.uiScale = (float)scale;
        this.entryHeight = VCConstants.getEntryHeight(this.uiScale);
        this.subEntryHeight = VCConstants.getSubEntryHeight(this.uiScale);
        this.headerHeight = VCConstants.getHeaderHeight(this.uiScale);
        int scaledWidth = (int)(800.0 * scale);
        if (this.uiScale < 0.5f) {
            scaledWidth = (int)((float)scaledWidth * 0.5f);
        } else if (this.uiScale < 0.7f) {
            scaledWidth = (int)((float)scaledWidth * 0.65f);
        }
        int dynamicMinWidth = this.uiScale < 0.7f ? 300 : 400;
        int maxAllowedWidth = Math.max(dynamicMinWidth, this.field_22789 - 120);
        if (dynamicMinWidth > maxAllowedWidth) {
            dynamicMinWidth = maxAllowedWidth;
        }
        this.entryWidth = Math.clamp((long)scaledWidth, dynamicMinWidth, maxAllowedWidth);
    }

    private int getCompactControlAreaWidth() {
        int baseControlAreaWidth = 140;
        if (this.uiScale < 0.5f) {
            return Math.max(60, (int)((float)baseControlAreaWidth * this.uiScale * 0.5f));
        }
        if (this.uiScale < 0.7f) {
            return Math.max(70, (int)((float)baseControlAreaWidth * this.uiScale * 0.6f));
        }
        return (int)((float)baseControlAreaWidth * this.uiScale);
    }

    private void onSearchChanged(String text) {
        this.lastSearchText = text;
        if (text.isEmpty()) {
            this.filteredEntries = new ArrayList<VCEntry>(this.configEntries);
            this.expandMatching("");
        } else {
            String searchText = text.toLowerCase().trim();
            List matches = this.configEntries.stream().filter(entry -> this.matchesSearch((VCEntry)entry, searchText)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (matches.size() == 1) {
                VCEntry singleMatch = (VCEntry)matches.get(0);
                if (singleMatch.type == VCEntry.EntryType.HEADER || this.shouldNavigateTo(singleMatch, searchText)) {
                    this.filteredEntries = new ArrayList<VCEntry>(this.configEntries);
                    this.expandMatching(searchText);
                    this.navigateToEntry(singleMatch);
                } else {
                    this.filteredEntries = matches;
                    this.scrollOffset = 0;
                    this.expandMatching(searchText);
                }
            } else {
                this.filteredEntries = matches;
                this.scrollOffset = 0;
                this.expandMatching(searchText);
            }
        }
    }

    private boolean shouldNavigateTo(VCEntry entry, String searchText) {
        return entry.type == VCEntry.EntryType.HEADER || entry.name != null && entry.name.toLowerCase().equals(searchText);
    }

    private void navigateToEntry(VCEntry targetEntry) {
        List<VCEntry> allVisibleEntries = this.getAllVisibleEntries();
        int targetIndex = -1;
        for (int i = 0; i < allVisibleEntries.size(); ++i) {
            if (allVisibleEntries.get(i) != targetEntry) continue;
            targetIndex = i;
            break;
        }
        if (targetIndex != -1) {
            int actualMaxVisible = this.calculateActualMaxVisibleEntries(allVisibleEntries);
            int maxScroll = allVisibleEntries.size() - actualMaxVisible;
            this.scrollOffset = Math.clamp((long)targetIndex, 0, maxScroll);
        }
    }

    private void expandMatching(String searchText) {
        for (VCEntry entry : this.configEntries) {
            if (!entry.hasSubEntries()) continue;
            if (searchText.isEmpty()) {
                this.expandedEntries.put(entry.name, false);
                continue;
            }
            boolean hasMatchingSubEntry = entry.getSubEntries().stream().anyMatch(subEntry -> subEntry.name != null && subEntry.name.toLowerCase().contains(searchText) || subEntry.description != null && subEntry.description.toLowerCase().contains(searchText));
            boolean mainEntryMatches = entry.name != null && entry.name.toLowerCase().contains(searchText) || entry.description != null && entry.description.toLowerCase().contains(searchText);
            this.expandedEntries.put(entry.name, hasMatchingSubEntry || mainEntryMatches);
        }
    }

    private List<VCEntry> getAllVisibleEntries() {
        ArrayList<VCEntry> allVisibleEntries = new ArrayList<VCEntry>();
        for (VCEntry entry : this.configEntries) {
            allVisibleEntries.add(entry);
            if (!entry.hasSubEntries() || !this.isExpanded(entry.name)) continue;
            allVisibleEntries.addAll(entry.getSubEntries());
        }
        return allVisibleEntries;
    }

    private boolean matchesSearch(VCEntry entry, String searchText) {
        if (searchText == null || searchText.trim().isEmpty()) {
            return true;
        }
        if (entry.name != null && entry.name.toLowerCase().contains(searchText)) {
            return true;
        }
        if (entry.description != null && entry.description.toLowerCase().contains(searchText)) {
            return true;
        }
        return entry.hasSubEntries() && this.subEntryMatches(entry, searchText);
    }

    private boolean subEntryMatches(VCEntry entry, String searchText) {
        for (VCEntry subEntry : entry.getSubEntries()) {
            if (subEntry.name != null && subEntry.name.toLowerCase().contains(searchText)) {
                return true;
            }
            if (subEntry.description == null || !subEntry.description.toLowerCase().contains(searchText)) continue;
            return true;
        }
        return false;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        VCRenderUtils.gradient(context, 0, 0, this.field_22789, this.field_22790, 0x8000000);
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 300.0f);
        VCText.drawScaledCenteredText(context, this.field_22793, "\u2500 \u03b1 FishyAddons Configuration \u03b1 \u2500", this.field_22789 / 2, 20, -11141121, this.uiScale);
        matrices.method_22909();
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderConfigEntries(context, mouseX, mouseY);
    }

    private void renderConfigEntries(class_332 context, int mouseX, int mouseY) {
        VCEntry entry;
        int currentEntryHeight;
        int startY = this.searchField.method_46427() + this.searchField.method_25364() + 10;
        int centerX = this.field_22789 / 2;
        int entryX = centerX - this.entryWidth / 2;
        List<VCEntry> visibleEntries = this.getVisibleEntries();
        int actualMaxVisible = this.calculateActualMaxVisibleEntries(visibleEntries);
        int maxScroll = Math.max(0, visibleEntries.size() - actualMaxVisible);
        this.scrollOffset = Math.clamp((long)this.scrollOffset, 0, maxScroll);
        int currentY = startY;
        for (int i = this.scrollOffset; i < visibleEntries.size() && currentY + (currentEntryHeight = this.calculateEntryHeight(entry = visibleEntries.get(i))) <= this.endY; ++i) {
            int renderedHeight = this.renderConfigEntry(context, entry, entryX, currentY, mouseX, mouseY);
            currentY += renderedHeight;
            if (!this.shouldDrawSubEnd(visibleEntries, i)) continue;
            int separatorHeight = this.drawSubEnd(context, entryX, currentY);
            currentY += separatorHeight;
        }
        if (visibleEntries.size() > this.maxVisibleEntries) {
            this.renderScrollIndicator(context, centerX + this.entryWidth / 2 + 20, startY);
        }
    }

    private boolean shouldDrawSubEnd(List<VCEntry> visibleEntries, int currentIndex) {
        if (currentIndex >= visibleEntries.size() - 1) {
            return false;
        }
        VCEntry currentEntry = visibleEntries.get(currentIndex);
        VCEntry nextEntry = visibleEntries.get(currentIndex + 1);
        if (this.isSubEntry(currentEntry) && !this.isSubEntry(nextEntry) || nextEntry == null) {
            return true;
        }
        if (this.isSubEntry(currentEntry) && this.isSubEntry(nextEntry)) {
            VCEntry nextParent;
            VCEntry currentParent = this.findParentEntry(currentEntry);
            return currentParent != (nextParent = this.findParentEntry(nextEntry));
        }
        return false;
    }

    private VCEntry findParentEntry(VCEntry subEntry) {
        for (VCEntry entry : this.configEntries) {
            if (!entry.hasSubEntries()) continue;
            for (VCEntry sub : entry.getSubEntries()) {
                if (sub != subEntry) continue;
                return entry;
            }
        }
        return null;
    }

    private int drawSubEnd(class_332 context, int entryX, int currentY) {
        int separatorHeight = VCConstants.getHeaderHeight(this.uiScale);
        int subBgWidth = (int)((float)this.entryWidth * 0.95f);
        context.method_25294(entryX + (int)(5.0f * this.uiScale), currentY, entryX + subBgWidth, currentY + separatorHeight, 0x30000000);
        int lineY = currentY + separatorHeight - (int)(2.0f * this.uiScale);
        context.method_25294(entryX + (int)(5.0f * this.uiScale), lineY, entryX + subBgWidth, lineY + 1, -12303292);
        return separatorHeight;
    }

    private List<VCEntry> getVisibleEntries() {
        ArrayList<VCEntry> visibleEntries = new ArrayList<VCEntry>();
        for (VCEntry entry : this.filteredEntries) {
            visibleEntries.add(entry);
            if (!entry.hasSubEntries() || !this.isExpanded(entry.name)) continue;
            visibleEntries.addAll(entry.getSubEntries());
        }
        return visibleEntries;
    }

    public boolean isExpanded(String entryName) {
        return this.expandedEntries.getOrDefault(entryName, false);
    }

    private void toggleExpanded(String entryName) {
        boolean wasExpanded = this.isExpanded(entryName);
        this.expandedEntries.put(entryName, !wasExpanded);
        if (!wasExpanded) {
            this.adjustForExpand(entryName);
        }
    }

    private void adjustForExpand(String entryName) {
        int actualMaxVisible;
        int maxVisibleIndex;
        int lastSubEntryIndex;
        List<VCEntry> visibleEntries = this.getVisibleEntries();
        int expandedEntryIndex = -1;
        for (int i = 0; i < visibleEntries.size(); ++i) {
            VCEntry entry = visibleEntries.get(i);
            if (!entry.name.equals(entryName)) continue;
            expandedEntryIndex = i;
            break;
        }
        if (expandedEntryIndex == -1) {
            return;
        }
        VCEntry expandedEntry = visibleEntries.get(expandedEntryIndex);
        int subEntryCount = 0;
        if (expandedEntry.hasSubEntries()) {
            subEntryCount = expandedEntry.getSubEntries().size();
        }
        if ((lastSubEntryIndex = expandedEntryIndex + subEntryCount) > (maxVisibleIndex = this.scrollOffset + (actualMaxVisible = this.calculateActualMaxVisibleEntries(visibleEntries)) - 1)) {
            int newScrollOffset = lastSubEntryIndex - actualMaxVisible + 1;
            newScrollOffset = Math.max(0, newScrollOffset);
            if (expandedEntryIndex < (newScrollOffset = Math.min(newScrollOffset, visibleEntries.size() - actualMaxVisible))) {
                newScrollOffset = expandedEntryIndex;
            }
            this.scrollOffset = newScrollOffset;
        }
    }

    private boolean isSubEntry(VCEntry targetEntry) {
        for (VCEntry entry : this.configEntries) {
            if (!entry.hasSubEntries()) continue;
            for (VCEntry subEntry : entry.getSubEntries()) {
                if (subEntry != targetEntry) continue;
                return true;
            }
        }
        return false;
    }

    private int renderConfigEntry(class_332 context, VCEntry entry, int x, int y, int mouseX, int mouseY) {
        boolean isSubEntry = this.isSubEntry(entry);
        VCContext renderCtx = new VCContext(context, mouseX, mouseY, x, this.entryWidth);
        return this.renderer.renderConfigEntry(renderCtx, entry, x, y, isSubEntry);
    }

    private int getHeaderHeight() {
        return this.headerHeight;
    }

    private VCSlider getOrCreateSlider(VCEntry entry) {
        if (entry.configKey == null) {
            return null;
        }
        return this.sliderRegistry.computeIfAbsent(entry.configKey, key -> {
            VCSlider slider = new VCSlider(0, 0, entry.getSliderValue(), entry.getMinValue(), entry.getMaxValue(), entry.getFormatString(), entry::setSliderValue);
            slider.setUIScale(this.uiScale);
            return slider;
        });
    }

    private int getCurrentColor(VCEntry entry) {
        if ("renderCoords".equals(entry.configKey)) {
            return FishyConfig.getInt("renderCoordsColor");
        }
        if ("Color and Outline".equals(entry.name)) {
            return FishyConfig.getInt("xpColor");
        }
        if ("customParticleColorIndex".equals(entry.configKey)) {
            if ("custom".equals(FishyConfig.getParticleColorMode())) {
                float[] rgb = FishyConfig.getCustomParticleRGB();
                if (rgb != null && rgb.length == 3) {
                    int r = Math.round(rgb[0] * 255.0f);
                    int g = Math.round(rgb[1] * 255.0f);
                    int b = Math.round(rgb[2] * 255.0f);
                    return 0xFF000000 | r << 16 | g << 8 | b;
                }
            } else {
                int index = FishyConfig.getCustomParticleColorIndex();
                return switch (index) {
                    case 0 -> -8355712;
                    case 1 -> -10027009;
                    case 2 -> -10027111;
                    case 3 -> -13057;
                    case 4 -> -1710593;
                    default -> -1;
                };
            }
        }
        return -65536;
    }

    private void openColorWheel(VCEntry entry) {
        class_437 class_4372 = this.field_22787.field_1755;
        if (class_4372 instanceof VCScreen) {
            VCScreen currentScreen = (VCScreen)class_4372;
            VCState.preserveState(currentScreen.getScrollOffset(), currentScreen.getLastSearchText(), currentScreen.getExpandedEntries());
        }
        float[] currentColor = ColorWheel.intToRGB(this.getCurrentColor(entry));
        Consumer<float[]> onColorSelected = rgb -> {
            int colorInt = ColorWheel.rgbToInt(rgb);
            if ("renderCoords".equals(entry.configKey)) {
                FishyConfig.setInt("renderCoordsColor", colorInt);
            } else if ("Color and Outline".equals(entry.name)) {
                FishyConfig.setInt("xpColor", colorInt);
                XpColor.refresh();
            } else if ("customParticleColorIndex".equals(entry.configKey)) {
                ParticleVisuals.setCustomColor(rgb);
                FishyConfig.setParticleColorMode("custom");
                ParticleVisuals.refreshCache();
            }
        };
        class_310.method_1551().method_1507((class_437)new ColorWheel(this, currentColor, onColorSelected));
    }

    private void renderScrollIndicator(class_332 context, int x, int y) {
        List<VCEntry> visibleEntries = this.getVisibleEntries();
        int actualMaxVisible = this.calculateActualMaxVisibleEntries(visibleEntries);
        int indicatorHeight = actualMaxVisible * this.entryHeight;
        int totalEntries = visibleEntries.size();
        int scrollbarWidth = Math.max(4, (int)(8.0f * this.uiScale));
        context.method_25294(x, y, x + scrollbarWidth, y + indicatorHeight, 0x44000000);
        if (totalEntries > actualMaxVisible) {
            int thumbHeight = Math.max((int)(10.0f * this.uiScale), actualMaxVisible * indicatorHeight / totalEntries);
            int thumbY = y + this.scrollOffset * (indicatorHeight - thumbHeight) / (totalEntries - actualMaxVisible);
            context.method_25294(x + 1, thumbY, x + scrollbarWidth - 1, thumbY + thumbHeight, this.getThemeColor());
            context.method_25294(x + 1, thumbY + thumbHeight - 1, x + scrollbarWidth - 1, thumbY + thumbHeight, -16777216);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        List<VCEntry> visibleEntries = this.getVisibleEntries();
        if (visibleEntries.size() > this.maxVisibleEntries) {
            int startY = this.searchField.method_46427() + this.searchField.method_25364() + 10;
            int centerX = this.field_22789 / 2;
            int scrollbarX = centerX + this.entryWidth / 2 + 20;
            int indicatorHeight = this.maxVisibleEntries * this.entryHeight;
            int scrollbarWidth = Math.max(4, (int)(8.0f * this.uiScale));
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)startY && mouseY <= (double)(startY + indicatorHeight)) {
                int totalEntries = visibleEntries.size();
                int thumbHeight = Math.max((int)(10.0f * this.uiScale), this.maxVisibleEntries * indicatorHeight / totalEntries);
                int thumbY = startY + this.scrollOffset * (indicatorHeight - thumbHeight) / (totalEntries - this.maxVisibleEntries);
                if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                    this.isDraggingScrollbar = true;
                    this.scrollbarThumbOffset = (int)mouseY - thumbY;
                } else {
                    this.isDraggingScrollbar = true;
                    this.scrollbarThumbOffset = thumbHeight / 2;
                    double trackClickY = mouseY - (double)startY - (double)this.scrollbarThumbOffset;
                    double scrollPercent = trackClickY / (double)(indicatorHeight - thumbHeight);
                    int actualMaxVisible = this.calculateActualMaxVisibleEntries(this.getVisibleEntries());
                    int newScrollOffset = (int)(scrollPercent * (double)(totalEntries - actualMaxVisible));
                    this.scrollOffset = Math.clamp((long)newScrollOffset, 0, totalEntries - actualMaxVisible);
                }
                return true;
            }
        }
        if (this.searchField.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return this.handleEntryClicks(mouseX, mouseY, visibleEntries);
    }

    private boolean handleEntryClicks(double mouseX, double mouseY, List<VCEntry> visibleEntries) {
        int startY = this.searchField.method_46427() + this.searchField.method_25364() + 10;
        int centerX = this.field_22789 / 2;
        int entryX = centerX - this.entryWidth / 2;
        int currentY = startY;
        for (int i = this.scrollOffset; i < visibleEntries.size(); ++i) {
            VCEntry entry = visibleEntries.get(i);
            if (entry.type == VCEntry.EntryType.HEADER) {
                currentY += this.getHeaderHeight();
                continue;
            }
            int currentEntryHeight = this.calculateEntryHeight(entry);
            if (currentY + currentEntryHeight > this.endY) break;
            if (this.isMouseOverEntry(mouseX, mouseY, entryX, currentY, currentEntryHeight) && this.entryClick(mouseX, mouseY, entry, entryX, currentY)) {
                return true;
            }
            currentY += currentEntryHeight;
            if (!this.shouldDrawSubEnd(visibleEntries, i)) continue;
            currentY += VCConstants.getHeaderHeight(this.uiScale);
        }
        return false;
    }

    private int calculateEntryHeight(VCEntry entry) {
        int baseCurrentHeight;
        boolean isSubEntry = this.isSubEntry(entry);
        int n = baseCurrentHeight = isSubEntry ? this.subEntryHeight : this.entryHeight;
        if (this.uiScale < 0.4f) {
            return Math.max(12, (int)((float)baseCurrentHeight * 0.6f));
        }
        if (this.uiScale < 0.5f) {
            return Math.max(15, (int)((float)baseCurrentHeight * 0.7f));
        }
        if (this.uiScale < 0.7f) {
            return Math.max(18, (int)((float)baseCurrentHeight * 0.8f));
        }
        return baseCurrentHeight;
    }

    private int getAverageEntryHeight() {
        int subEntryHeightScaled;
        int mainEntryHeight;
        if (this.uiScale < 0.4f) {
            mainEntryHeight = Math.max(12, (int)((float)this.entryHeight * 0.6f));
            subEntryHeightScaled = Math.max(12, (int)((float)this.subEntryHeight * 0.6f));
        } else if (this.uiScale < 0.5f) {
            mainEntryHeight = Math.max(15, (int)((float)this.entryHeight * 0.7f));
            subEntryHeightScaled = Math.max(15, (int)((float)this.subEntryHeight * 0.7f));
        } else if (this.uiScale < 0.7f) {
            mainEntryHeight = Math.max(18, (int)((float)this.entryHeight * 0.8f));
            subEntryHeightScaled = Math.max(18, (int)((float)this.subEntryHeight * 0.8f));
        } else {
            mainEntryHeight = this.entryHeight;
            subEntryHeightScaled = this.subEntryHeight;
        }
        return (int)((float)mainEntryHeight * 0.7f + (float)subEntryHeightScaled * 0.3f);
    }

    private int calculateActualMaxVisibleEntries(List<VCEntry> visibleEntries) {
        int reservedSpace;
        int availableSpace;
        VCEntry entry;
        int currentEntryHeight;
        int startY;
        int currentY = startY = this.searchField.method_46427() + this.searchField.method_25364() + 10;
        int count = 0;
        for (int i = 0; i < visibleEntries.size() && currentY + (currentEntryHeight = this.calculateEntryHeight(entry = visibleEntries.get(i))) <= this.endY; ++i) {
            currentY += currentEntryHeight;
            ++count;
            if (!this.shouldDrawSubEnd(visibleEntries, i)) continue;
            int separatorHeight = VCConstants.getHeaderHeight(this.uiScale);
            if (currentY + separatorHeight > this.endY) break;
            currentY += separatorHeight;
        }
        if ((availableSpace = this.endY - currentY) > (reservedSpace = (int)((float)this.entryHeight * 1.5f))) {
            --count;
        }
        return Math.max(1, count);
    }

    private boolean isMouseOverEntry(double mouseX, double mouseY, int entryX, int currentY, int currentEntryHeight) {
        return mouseX >= (double)entryX && mouseX <= (double)(entryX + this.entryWidth) && mouseY >= (double)currentY && mouseY <= (double)(currentY + currentEntryHeight);
    }

    private boolean entryClick(double mouseX, double mouseY, VCEntry entry, int entryX, int currentY) {
        return switch (entry.type) {
            case VCEntry.EntryType.EXPANDABLE -> this.expandableClick(mouseX, mouseY, entry, entryX, currentY);
            case VCEntry.EntryType.TOGGLE, VCEntry.EntryType.ITEM_CONFIG_TOGGLE, VCEntry.EntryType.BLACKLIST_TOGGLE -> this.handleToggleClick(mouseX, mouseY, entry, entryX, currentY);
            case VCEntry.EntryType.SIMPLE_BUTTON -> this.simpleButtonClick(mouseX, mouseY, entry, entryX, currentY);
            case VCEntry.EntryType.BUTTON -> this.buttonClick(entry);
            case VCEntry.EntryType.KEYBIND -> this.keybindClick(mouseX, mouseY, entry, entryX, currentY);
            case VCEntry.EntryType.SLIDER -> this.sliderClick(mouseX, mouseY, entry, entryX, currentY);
            case VCEntry.EntryType.TOGGLE_WITH_SLIDER -> this.toggleSliderClick(mouseX, mouseY, entry, entryX, currentY);
            default -> false;
        };
    }

    private boolean expandableClick(double mouseX, double mouseY, VCEntry entry, int entryX, int currentY) {
        int controlAreaWidth = this.getCompactControlAreaWidth();
        int startX = entryX + this.entryWidth - controlAreaWidth;
        int buttonY = currentY + (int)(14.0f * this.uiScale);
        int buttonHeight = (int)(18.0f * this.uiScale);
        int buttonGap = this.uiScale < 0.7f ? Math.max(1, (int)(2.0f * this.uiScale)) : (int)(3.0f * this.uiScale);
        int expandButtonWidth = (int)(60.0f * this.uiScale);
        int expandButtonX = startX + (int)(40.0f * this.uiScale) + buttonGap;
        if (entry.hasToggle()) {
            int toggleWidth = (int)(30.0f * this.uiScale);
            if (mouseX >= (double)startX && mouseX <= (double)(startX + toggleWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight)) {
                entry.toggleSetting();
                return true;
            }
        }
        if (mouseX >= (double)expandButtonX && mouseX <= (double)(expandButtonX + expandButtonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight)) {
            this.toggleExpanded(entry.name);
            return true;
        }
        return false;
    }

    private boolean handleToggleClick(double mouseX, double mouseY, VCEntry entry, int entryX, int currentY) {
        ControlClickArea area = this.calculateControlArea(entry, entryX, currentY);
        int currentButtonX = area.controlX;
        if (this.isClickOnToggleButton(mouseX, mouseY, currentButtonX, area.controlY)) {
            entry.toggleSetting();
            return true;
        }
        if (entry.hasHudControls() && this.isClickOnHudButton(mouseX, mouseY, currentButtonX += (int)(30.0f * this.uiScale), area.controlY)) {
            VCState.preservePersistentState(this.scrollOffset, this.lastSearchText, this.expandedEntries);
            class_310.method_1551().method_1507((class_437)new HudEditScreen(entry.getHudElementName()));
            return true;
        }
        if (entry.hasColorControl() && this.isClickOnColorButton(mouseX, mouseY, currentButtonX, area.controlY)) {
            VCState.preservePersistentState(this.scrollOffset, this.lastSearchText, this.expandedEntries);
            this.openColorWheel(entry);
            return true;
        }
        if (entry.hasAdd() && this.isClickOnAddButton(mouseX, mouseY, currentButtonX, area.controlY)) {
            VCState.preservePersistentState(this.scrollOffset, this.lastSearchText, this.expandedEntries);
            this.openListGui(entry);
            return true;
        }
        return false;
    }

    private void openListGui(VCEntry entry) {
        if (entry.name == null) {
            return;
        }
        switch (entry.name) {
            case "Custom Fa Colors": {
                class_310.method_1551().method_1507((class_437)new GUIFaColor(this));
                break;
            }
            case "Chat Alerts": {
                class_310.method_1551().method_1507((class_437)new GUIChatAlert(this));
                break;
            }
            case "Custom Command": {
                class_310.method_1551().method_1507((class_437)new TabbedListScreen(this, TabbedListScreen.Tab.COMMANDS));
                break;
            }
            case "Custom Keybinds": {
                class_310.method_1551().method_1507((class_437)new TabbedListScreen(this, TabbedListScreen.Tab.KEYBINDS));
                break;
            }
            case "Chat Replacement": {
                class_310.method_1551().method_1507((class_437)new TabbedListScreen(this, TabbedListScreen.Tab.CHAT));
                break;
            }
        }
    }

    private boolean simpleButtonClick(double mouseX, double mouseY, VCEntry entry, int entryX, int currentY) {
        ControlClickArea area = this.calculateControlArea(entry, entryX, currentY);
        int currentButtonX = area.controlX;
        int toggleWidth = (int)(30.0f * this.uiScale);
        if (this.isClickOnToggleButton(mouseX, mouseY, currentButtonX, area.controlY)) {
            entry.toggleSetting();
            return true;
        }
        String buttonText = entry.buttonText != null ? entry.buttonText : "CONF";
        int textWidth = this.field_22793.method_1727(buttonText);
        int simpleButtonWidth = Math.max((int)(30.0f * this.uiScale), (int)((float)textWidth * this.uiScale) + (int)(10.0f * this.uiScale));
        if (this.isClickOnSimpleButton(mouseX, mouseY, currentButtonX += toggleWidth + area.buttonGap, area.controlY, simpleButtonWidth)) {
            entry.toggleSimpleButton();
            return true;
        }
        return false;
    }

    private boolean buttonClick(VCEntry entry) {
        if (entry.action != null) {
            entry.action.run();
            return true;
        }
        return false;
    }

    private boolean keybindClick(double mouseX, double mouseY, VCEntry entry, int entryX, int currentY) {
        ControlClickArea area = this.calculateControlArea(entry, entryX, currentY);
        int buttonWidth = (int)(30.0f * this.uiScale);
        int buttonHeight = (int)(18.0f * this.uiScale);
        if (mouseX >= (double)area.controlX && mouseX <= (double)(area.controlX + buttonWidth) && mouseY >= (double)area.controlY && mouseY <= (double)(area.controlY + buttonHeight)) {
            if (entry.isListening()) {
                entry.setKeybindValue("NONE");
                entry.setListening(false);
            } else {
                entry.setListening(true);
            }
            return true;
        }
        return false;
    }

    private boolean sliderClick(double mouseX, double mouseY, VCEntry entry, int entryX, int currentY) {
        VCSlider slider;
        ControlClickArea area = this.calculateControlArea(entry, entryX, currentY);
        if (entry.hasColorControl() && (slider = this.getOrCreateSlider(entry)) != null) {
            int valueTextX = area.controlX + slider.getWidth() + (int)(8.0f * this.uiScale);
            String valueText = this.renderer.formatSliderValue(entry);
            int valueTextWidth = (int)((float)this.field_22793.method_1727(valueText) * Math.min(this.uiScale, 1.0f));
            int buttonGap = this.uiScale < 0.7f ? Math.max(1, (int)(2.0f * this.uiScale)) : (int)(3.0f * this.uiScale);
            int colorButtonX = valueTextX + valueTextWidth + buttonGap;
            int colorSize = (int)(18.0f * this.uiScale);
            if (mouseX >= (double)colorButtonX && mouseX <= (double)(colorButtonX + colorSize) && mouseY >= (double)area.controlY && mouseY <= (double)(area.controlY + colorSize)) {
                this.openColorWheel(entry);
                return true;
            }
        }
        if ((slider = this.getOrCreateSlider(entry)) == null) {
            return false;
        }
        slider.setPosition(area.controlX, area.controlY + 3);
        return slider.mouseClicked(mouseX, mouseY, 0);
    }

    private boolean toggleSliderClick(double mouseX, double mouseY, VCEntry entry, int entryX, int currentY) {
        ControlClickArea area = this.calculateControlArea(entry, entryX, currentY);
        int toggleButtonX = area.controlX;
        int toggleButtonY = area.controlY;
        int toggleButtonWidth = (int)(30.0f * this.uiScale);
        int toggleButtonHeight = (int)(20.0f * this.uiScale);
        if (mouseX >= (double)toggleButtonX && mouseX <= (double)(toggleButtonX + toggleButtonWidth) && mouseY >= (double)toggleButtonY && mouseY <= (double)(toggleButtonY + toggleButtonHeight)) {
            entry.toggleSetting();
            return true;
        }
        int sliderX = toggleButtonX + toggleButtonWidth + (int)(8.0f * this.uiScale);
        int sliderY = toggleButtonY + (toggleButtonHeight - (int)(12.0f * this.uiScale)) / 2;
        VCSlider slider = this.getOrCreateSlider(entry);
        if (slider != null) {
            slider.setPosition(sliderX, sliderY);
            return slider.mouseClicked(mouseX, mouseY, 0);
        }
        return false;
    }

    private ControlClickArea calculateControlArea(VCEntry entry, int entryX, int currentY) {
        int controlAreaWidth = this.getCompactControlAreaWidth();
        int controlX = entryX + this.entryWidth - controlAreaWidth;
        if (this.isSubEntry(entry)) {
            controlX += (int)(20.0f * this.uiScale);
        }
        int controlY = currentY + (int)(14.0f * this.uiScale);
        int buttonGap = this.uiScale < 0.7f ? Math.max(1, (int)(2.0f * this.uiScale)) : (int)(3.0f * this.uiScale);
        return new ControlClickArea(controlX, controlY, buttonGap);
    }

    private boolean isClickOnToggleButton(double mouseX, double mouseY, int buttonX, int buttonY) {
        int toggleWidth = (int)(30.0f * this.uiScale);
        int buttonHeight = (int)(18.0f * this.uiScale);
        return mouseX >= (double)buttonX && mouseX <= (double)(buttonX + toggleWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight);
    }

    private boolean isClickOnHudButton(double mouseX, double mouseY, int buttonX, int buttonY) {
        int hudWidth = (int)(40.0f * this.uiScale);
        int buttonHeight = (int)(18.0f * this.uiScale);
        return mouseX >= (double)buttonX && mouseX <= (double)(buttonX + hudWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight);
    }

    private boolean isClickOnAddButton(double mouseX, double mouseY, int buttonX, int buttonY) {
        int addWidth = (int)(40.0f * this.uiScale);
        int buttonHeight = (int)(18.0f * this.uiScale);
        return mouseX >= (double)buttonX && mouseX <= (double)(buttonX + addWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight);
    }

    private boolean isClickOnColorButton(double mouseX, double mouseY, int buttonX, int buttonY) {
        int colorSize = (int)(18.0f * this.uiScale);
        return mouseX >= (double)buttonX && mouseX <= (double)(buttonX + colorSize) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + colorSize);
    }

    private boolean isClickOnSimpleButton(double mouseX, double mouseY, int buttonX, int buttonY, int buttonWidth) {
        int buttonHeight = (int)(18.0f * this.uiScale);
        return mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + buttonHeight);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        for (VCSlider slider : this.sliderRegistry.values()) {
            slider.mouseReleased(button);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        List<VCEntry> visibleEntries;
        for (VCSlider slider : this.sliderRegistry.values()) {
            if (!slider.mouseDragged(mouseX, button)) continue;
            return true;
        }
        if (this.isDraggingScrollbar && (visibleEntries = this.getVisibleEntries()).size() > this.maxVisibleEntries) {
            int startY = this.searchField.method_46427() + this.searchField.method_25364() + 10;
            int indicatorHeight = this.maxVisibleEntries * this.entryHeight;
            int totalEntries = visibleEntries.size();
            int actualMaxVisible = this.calculateActualMaxVisibleEntries(visibleEntries);
            int maxScroll = Math.max(0, totalEntries - actualMaxVisible);
            int thumbHeight = Math.max((int)(10.0f * this.uiScale), this.maxVisibleEntries * indicatorHeight / totalEntries);
            double thumbTopY = mouseY - (double)startY - (double)this.scrollbarThumbOffset;
            thumbTopY = Math.clamp(thumbTopY, 0.0, (double)indicatorHeight - (double)thumbHeight);
            double scrollPercent = maxScroll > 0 ? thumbTopY / (double)(indicatorHeight - thumbHeight) : 0.0;
            int newScrollOffset = (int)(scrollPercent * (double)maxScroll);
            this.scrollOffset = Math.clamp((long)newScrollOffset, 0, maxScroll);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        List<VCEntry> visibleEntries = this.getVisibleEntries();
        int actualMaxVisible = this.calculateActualMaxVisibleEntries(visibleEntries);
        if (visibleEntries.size() > actualMaxVisible) {
            this.scrollOffset -= (int)verticalAmount * 2;
            int maxScroll = Math.max(0, visibleEntries.size() - actualMaxVisible);
            this.scrollOffset = Math.clamp((long)this.scrollOffset, 0, maxScroll);
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.handleKeybindInput(keyCode)) {
            return true;
        }
        if (keyCode == 256) {
            this.handleEscapeKey();
            return true;
        }
        if (keyCode == 264) {
            List<VCEntry> currentVisible = this.getVisibleEntries();
            int actualMaxVisible = this.calculateActualMaxVisibleEntries(currentVisible);
            this.scrollOffset = Math.clamp((long)this.scrollOffset + 1L, 0, currentVisible.size() - actualMaxVisible);
            return true;
        }
        if (keyCode == 265) {
            this.scrollOffset = Math.max(this.scrollOffset - 1, 0);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private boolean handleKeybindInput(int keyCode) {
        List<VCEntry> visibleEntries = this.getVisibleEntries();
        for (VCEntry entry : visibleEntries) {
            if (entry.type != VCEntry.EntryType.KEYBIND || !entry.isListening()) continue;
            String newKey = KeyUtil.getGlfwKeyName(keyCode);
            if (keyCode == 256 || keyCode == 257) {
                entry.setListening(false);
                return true;
            }
            if (newKey != null) {
                entry.setKeybindValue(newKey);
            }
            entry.setListening(false);
            return true;
        }
        return false;
    }

    private void handleEscapeKey() {
        int startY;
        List<VCEntry> visibleEntries = this.getVisibleEntries();
        int currentY = startY = this.searchField.method_46427() + this.searchField.method_25364() + 10;
        for (int i = this.scrollOffset; i < visibleEntries.size(); ++i) {
            VCEntry entry = visibleEntries.get(i);
            int currentEntryHeight = this.calculateEntryHeight(entry);
            boolean shouldExit = false;
            if (currentY + currentEntryHeight > this.endY) {
                shouldExit = true;
            } else {
                if (entry.hasSubEntries() && this.isExpanded(entry.name)) {
                    this.toggleExpanded(entry.name);
                    return;
                }
                currentY += currentEntryHeight;
            }
            if (shouldExit) break;
        }
        VCState.preservePersistentState(this.scrollOffset, this.lastSearchText, this.expandedEntries);
        class_310.method_1551().method_1507(null);
    }

    @Environment(value=EnvType.CLIENT)
    private static class ControlClickArea {
        final int controlX;
        final int controlY;
        final int buttonGap;

        ControlClickArea(int controlX, int controlY, int buttonGap) {
            this.controlX = controlX;
            this.controlY = controlY;
            this.buttonGap = buttonGap;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ExtraControl {
        private final String elementName;
        private final boolean hasColorControl;
        private final boolean hasAdd;

        public ExtraControl(String elementName, boolean hasColorControl, boolean hasAdd) {
            this.elementName = elementName;
            this.hasColorControl = hasColorControl;
            this.hasAdd = hasAdd;
        }

        public String getElementName() {
            return this.elementName;
        }

        public boolean hasColorControl() {
            return this.hasColorControl;
        }

        public boolean hasAdd() {
            return this.hasAdd;
        }
    }
}

