/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import me.valkeea.fishyaddons.tool.FishyMode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class VCSlider {
    private static final int BASE_SLIDER_WIDTH = 70;
    private static final int BASE_SLIDER_HEIGHT = 12;
    private static final int BASE_KNOB_WIDTH = 6;
    private static final int BASE_KNOB_HEIGHT = 10;
    private static final String DEFAULT_FORMAT = "%.0f%%";
    private int x;
    private int y;
    private float value;
    private boolean isDragging = false;
    private final ValueChangeListener listener;
    private final float minValue;
    private final float maxValue;
    private final String displayFormat;
    private int sliderWidth;
    private int sliderHeight;
    private int knobWidth;
    private int knobHeight;

    public VCSlider(int x, int y, float initialValue, ValueChangeListener listener) {
        this(x, y, initialValue, 0.0f, 1.0f, DEFAULT_FORMAT, listener);
    }

    public VCSlider(int x, int y, float initialValue, float minValue, float maxValue, String displayFormat, ValueChangeListener listener) {
        this.x = x;
        this.y = y;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.displayFormat = displayFormat;
        this.listener = listener;
        this.updateScaledDimensions(1.0f);
        this.value = Math.clamp((initialValue - minValue) / (maxValue - minValue), 0.0f, 1.0f);
    }

    public void setUIScale(float scale) {
        this.updateScaledDimensions(scale);
    }

    private void updateScaledDimensions(float scale) {
        this.sliderWidth = Math.max(20, (int)(70.0f * scale));
        this.sliderHeight = Math.max(4, (int)(12.0f * scale));
        this.knobWidth = Math.max(3, (int)(6.0f * scale));
        this.knobHeight = Math.max(6, (int)(10.0f * scale));
    }

    public void render(class_332 context, int mouseX, int mouseY) {
        boolean isHovered;
        int themeColor = FishyMode.getThemeColor();
        int trackY = this.y + (this.sliderHeight - 4) / 2;
        context.method_25294(this.x, trackY, this.x + this.sliderWidth, trackY + 4, -1070386381);
        int knobX = this.x + (int)((float)(this.sliderWidth - this.knobWidth) * this.value);
        int knobY = this.y + (this.sliderHeight - this.knobHeight) / 2;
        boolean bl = isHovered = mouseX >= knobX && mouseX <= knobX + this.knobWidth && mouseY >= knobY && mouseY <= knobY + this.knobHeight;
        int knobColor = this.isDragging ? themeColor | 0xFF000000 : (isHovered ? themeColor & 0xFFFFFF | 0xE0000000 : themeColor & 0xFFFFFF | 0xC0000000);
        context.method_25294(knobX, knobY, knobX + this.knobWidth, knobY + this.knobHeight, knobColor);
        context.method_25294(knobX, knobY, knobX + this.knobWidth, knobY + 1, -1067030938);
        context.method_25294(knobX, knobY + this.knobHeight - 1, knobX + this.knobWidth, knobY + this.knobHeight, -1067030938);
        context.method_25294(knobX, knobY, knobX + 1, knobY + this.knobHeight, -1067030938);
        context.method_25294(knobX + this.knobWidth - 1, knobY, knobX + this.knobWidth, knobY + this.knobHeight, -1067030938);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOver(mouseX, mouseY)) {
            this.isDragging = true;
            this.updateValue(mouseX);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(int button) {
        if (button == 0 && this.isDragging) {
            this.isDragging = false;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, int button) {
        if (this.isDragging && button == 0) {
            this.updateValue(mouseX);
            return true;
        }
        return false;
    }

    private void updateValue(double mouseX) {
        float newValue = (float)(mouseX - (double)this.x) / (float)(this.sliderWidth - this.knobWidth);
        if ((newValue = Math.clamp(newValue, 0.0f, 1.0f)) != this.value) {
            this.value = newValue;
            if (this.listener != null) {
                float actualValue = this.minValue + this.value * (this.maxValue - this.minValue);
                this.listener.onValueChanged(actualValue);
            }
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX <= (double)(this.x + this.sliderWidth) && mouseY >= (double)this.y && mouseY <= (double)(this.y + this.sliderHeight);
    }

    public float getValue() {
        return this.minValue + this.value * (this.maxValue - this.minValue);
    }

    public void setValue(float actualValue) {
        this.value = Math.clamp((actualValue - this.minValue) / (this.maxValue - this.minValue), 0.0f, 1.0f);
    }

    public void setPosition(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    public boolean isDragging() {
        return this.isDragging;
    }

    public String getPercentageText() {
        float actualValue = this.getValue();
        if (this.displayFormat.equals(DEFAULT_FORMAT)) {
            return String.format(this.displayFormat, Float.valueOf(actualValue * 100.0f));
        }
        return String.format(this.displayFormat, Float.valueOf(actualValue));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.sliderWidth;
    }

    public int getHeight() {
        return this.sliderHeight;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ValueChangeListener {
        public void onValueChanged(float var1);
    }
}

