/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class VCState {
    private static int preservedScrollOffset = 0;
    private static String preservedSearchText = "";
    private static Map<String, Boolean> preservedExpandedEntries = new HashMap<String, Boolean>();
    private static int persistentScrollOffset = 0;
    private static String persistentSearchText = "";
    private static Map<String, Boolean> persistentExpandedEntries = new HashMap<String, Boolean>();

    public static void preserveState(int scrollOffset, String searchText, Map<String, Boolean> expandedEntries) {
        preservedScrollOffset = scrollOffset;
        preservedSearchText = searchText != null ? searchText : "";
        preservedExpandedEntries = new HashMap<String, Boolean>(expandedEntries != null ? expandedEntries : new HashMap());
    }

    public static void preservePersistentState(int scrollOffset, String searchText, Map<String, Boolean> expandedEntries) {
        persistentScrollOffset = scrollOffset;
        persistentSearchText = searchText != null ? searchText : "";
        persistentExpandedEntries = new HashMap<String, Boolean>(expandedEntries != null ? expandedEntries : new HashMap<String, Boolean>());
        VCState.preserveState(scrollOffset, searchText, expandedEntries);
    }

    public static void setLastSearchText(String searchText) {
        preservedSearchText = searchText != null ? searchText : "";
    }

    public static int getLastScrollOffset() {
        if (preservedScrollOffset != 0 || VCState.hasTemporaryState()) {
            return preservedScrollOffset;
        }
        return persistentScrollOffset;
    }

    public static String getLastSearchText() {
        if (!preservedSearchText.isEmpty() || VCState.hasTemporaryState()) {
            return preservedSearchText;
        }
        return persistentSearchText;
    }

    public static Map<String, Boolean> getLastExpandedEntries() {
        if (!preservedExpandedEntries.isEmpty() || VCState.hasTemporaryState()) {
            return new HashMap<String, Boolean>(preservedExpandedEntries);
        }
        return new HashMap<String, Boolean>(persistentExpandedEntries);
    }

    public static void clearTemporaryState() {
        preservedScrollOffset = 0;
        preservedSearchText = "";
        preservedExpandedEntries.clear();
    }

    private static boolean hasTemporaryState() {
        return preservedScrollOffset != 0 || !preservedSearchText.isEmpty() || !preservedExpandedEntries.isEmpty();
    }

    public static void clearState() {
        preservedScrollOffset = 0;
        preservedSearchText = "";
        preservedExpandedEntries.clear();
        persistentScrollOffset = 0;
        persistentSearchText = "";
        persistentExpandedEntries.clear();
    }

    public static boolean hasPreservedState() {
        return VCState.hasTemporaryState() || VCState.hasPersistentState();
    }

    private static boolean hasPersistentState() {
        return persistentScrollOffset != 0 || !persistentSearchText.isEmpty() || !persistentExpandedEntries.isEmpty();
    }

    private VCState() {
        throw new UnsupportedOperationException("Utility class");
    }
}

