/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.Objects;
import me.valkeea.fishyaddons.render.FaLayers;
import me.valkeea.fishyaddons.tool.FishyMode;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;

@Environment(value=EnvType.CLIENT)
public class VCTextField
extends class_342 {
    private static final class_2960 BG_TEXTURE = class_2960.method_60655((String)"fishyaddons", (String)"textures/gui/default/textbg.png");
    private static final String THEME = FishyMode.getTheme();
    private static final class_2960 BG_TEXTURE_FOCUS = class_2960.method_60655((String)"fishyaddons", (String)("textures/gui/" + THEME + "/textbg_highlighted.png"));
    private boolean useCustomCharacterHandling = false;
    private float uiScale = 1.0f;

    public VCTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 message) {
        super(textRenderer, x, y, width, height, message);
        this.method_1880(54);
    }

    public VCTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 message, boolean useCustomCharacterHandling) {
        super(textRenderer, x, y, width, height, message);
        this.method_1880(54);
        this.useCustomCharacterHandling = useCustomCharacterHandling;
    }

    public void setUseCustomCharacterHandling(boolean useCustomCharacterHandling) {
        this.useCustomCharacterHandling = useCustomCharacterHandling;
    }

    public void setUIScale(float scale) {
        this.uiScale = scale;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        class_2960 texture = this.method_25370() ? BG_TEXTURE_FOCUS : BG_TEXTURE;
        FaLayers.renderAboveOverlay(context, () -> {
            context.method_25290(class_1921::method_62277, texture, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
            boolean oldDrawsBackground = this.method_1851();
            this.method_1858(false);
            int originalY = this.method_46427();
            int originalX = this.method_46426();
            int scaledVerticalOffset = (this.field_22759 - 8) / 2;
            int scaledHorizontalOffset = Math.max(2, (int)(4.0f * this.uiScale));
            int adjustedY = this.method_46427() + scaledVerticalOffset;
            int adjustedX = this.method_46426() + scaledHorizontalOffset;
            this.method_46419(adjustedY);
            this.method_46421(adjustedX);
            if (this.uiScale != 1.0f) {
                Objects.requireNonNull(class_310.method_1551().field_1772);
                this.method_46421(adjustedX + 9 / 4);
                this.renderScaledText(context, mouseX, mouseY, delta);
            } else {
                super.method_48579(context, mouseX, mouseY, delta);
            }
            this.method_1858(oldDrawsBackground);
            this.method_46419(originalY);
            this.method_46421(originalX);
        });
    }

    private void renderScaledText(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_51448().method_22903();
        context.method_51448().method_22905(this.uiScale, this.uiScale, 1.0f);
        float scaledX = (float)this.method_46426() / this.uiScale;
        float scaledY = (float)this.method_46427() / this.uiScale;
        float scaledMouseX = (float)mouseX / this.uiScale;
        float scaledMouseY = (float)mouseY / this.uiScale;
        int origX = this.method_46426();
        int origY = this.method_46427();
        this.method_46421((int)scaledX);
        this.method_46419((int)scaledY);
        super.method_48579(context, (int)scaledMouseX, (int)scaledMouseY, delta);
        this.method_46421(origX);
        this.method_46419(origY);
        context.method_51448().method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean inside;
        boolean bl = inside = mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
        if (!inside) {
            this.method_25365(false);
        }
        return inside;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean handled;
        if (this.method_25370() && this.isStandardTextInputKey(keyCode) && (handled = super.method_25404(keyCode, scanCode, modifiers))) {
            return true;
        }
        handled = super.method_25404(keyCode, scanCode, modifiers);
        if (this.useCustomCharacterHandling && !handled && this.method_25370() && this.isPrintableCharacter(keyCode)) {
            char character = (char)keyCode;
            character = (modifiers & 1) != 0 ? this.getShiftedCharacter(character) : Character.toLowerCase(character);
            return this.method_25400(character, modifiers);
        }
        return handled;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.method_25370() && this.method_20315()) {
            return super.method_25400(chr, modifiers);
        }
        return false;
    }

    private boolean isStandardTextInputKey(int keyCode) {
        return keyCode == 259 || keyCode == 261 || keyCode == 262 || keyCode == 263 || keyCode == 268 || keyCode == 269 || keyCode == 257 || keyCode == 335 || keyCode == 341 || keyCode == 342 || keyCode == 345;
    }

    private boolean isPrintableCharacter(int keyCode) {
        return keyCode >= 32 && keyCode <= 126;
    }

    private char getShiftedCharacter(char c) {
        if (c >= 'a' && c <= 'z') {
            return Character.toUpperCase(c);
        }
        switch (c) {
            case '1': {
                return '!';
            }
            case '2': {
                return '@';
            }
            case '3': {
                return '#';
            }
            case '4': {
                return '\u00a4';
            }
            case '5': {
                return '%';
            }
            case '6': {
                return '&';
            }
            case '7': {
                return '/';
            }
            case '8': {
                return '(';
            }
            case '9': {
                return ')';
            }
            case '0': {
                return '=';
            }
            case '-': {
                return '_';
            }
            case '+': {
                return '?';
            }
            case '\u00b4': {
                return '`';
            }
            case '\u00a7': {
                return '\u00bd';
            }
            case ',': {
                return ';';
            }
            case '.': {
                return ':';
            }
            case '\u00a8': {
                return '^';
            }
        }
        return c;
    }
}

