/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.util.FishyNotis;
import me.valkeea.fishyaddons.util.HelpUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class CakeTimer {
    private static final CakeTimer INSTANCE = new CakeTimer();
    private static final File TIMER_FILE = new File(class_310.method_1551().field_1697, "config/fishyaddons/display.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Pattern CAKE_PATTERN = Pattern.compile("(?:Big Yum! You refresh|Yum! You gain) (.+) for 48 hours!");
    private static final long CAKE_DURATION_MS = 172800000L;
    private final Map<String, Long> activeCakes = new HashMap<String, Long>();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private boolean hasScheduledExpiryCheck = false;

    private CakeTimer() {
    }

    public static CakeTimer getInstance() {
        return INSTANCE;
    }

    public void init() {
        this.loadTimers();
        this.scheduleNoti();
    }

    public void handleChat(String message) {
        String cleanMessage = HelpUtil.stripColor(message);
        Matcher matcher = CAKE_PATTERN.matcher(cleanMessage);
        if (matcher.find()) {
            String buffName = matcher.group(1);
            if (buffName != null) {
                buffName = buffName.trim();
            }
            long currentTime = System.currentTimeMillis();
            long expiryTime = currentTime + 172800000L;
            this.activeCakes.put(buffName, expiryTime);
            this.saveTimers();
        }
    }

    public void onLoad() {
        if (!FishyConfig.getState("centuryCakeChatReminder", false)) {
            return;
        }
        this.scheduler.schedule(() -> {
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            boolean hasExpiredCakes = false;
            for (Map.Entry<String, Long> entry : this.activeCakes.entrySet()) {
                if (entry.getValue() > currentTime) continue;
                hasExpiredCakes = true;
                break;
            }
            if (hasExpiredCakes) {
                FishyNotis.send("\u00a7cSome of your century cake buffs have expired!");
            }
        }, 5L, TimeUnit.SECONDS);
    }

    private void scheduleNoti() {
        if (this.hasScheduledExpiryCheck) {
            return;
        }
        this.hasScheduledExpiryCheck = true;
        this.scheduler.scheduleAtFixedRate(() -> {
            if (!FishyConfig.getState("centuryCakeChatReminder", false)) {
                return;
            }
            class_310 mc = class_310.method_1551();
            if (mc.field_1724 == null || mc.field_1687 == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            for (Map.Entry<String, Long> entry : this.activeCakes.entrySet()) {
                long timeLeft = entry.getValue() - currentTime;
                if (timeLeft <= 0L || timeLeft > 300000L) continue;
                mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)("\u00a76[FishyAddons] \u00a7e" + entry.getKey() + " \u00a77expires in \u00a7c" + CakeTimer.formatTimeLeft(timeLeft) + "\u00a77!")), false);
                this.activeCakes.remove(entry.getKey());
                this.saveTimers();
                break;
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public Map<String, Long> getActiveCakes() {
        long currentTime = System.currentTimeMillis();
        this.activeCakes.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
        return new HashMap<String, Long>(this.activeCakes);
    }

    public String getNextExpiringCake() {
        long currentTime = System.currentTimeMillis();
        String nextCake = null;
        long earliestExpiry = Long.MAX_VALUE;
        for (Map.Entry<String, Long> entry : this.activeCakes.entrySet()) {
            long expiryTime = entry.getValue();
            if (expiryTime <= currentTime || expiryTime >= earliestExpiry) continue;
            earliestExpiry = expiryTime;
            nextCake = entry.getKey();
        }
        return nextCake;
    }

    public long getTimeUntilNextExpiry() {
        String nextCake = this.getNextExpiringCake();
        if (nextCake == null) {
            return -1L;
        }
        Long expiryTime = this.activeCakes.get(nextCake);
        if (expiryTime == null) {
            return -1L;
        }
        return expiryTime - System.currentTimeMillis();
    }

    public String symbol(String cakeName) {
        String symbol = cakeName.replaceAll("[^\\p{So}]", "");
        return symbol.isEmpty() ? "?" : symbol;
    }

    public boolean hasActiveCakes() {
        long currentTime = System.currentTimeMillis();
        return this.activeCakes.values().stream().anyMatch(expiry -> expiry > currentTime);
    }

    public static String formatTimeLeft(long timeMs) {
        if (timeMs <= 0L) {
            return "Expired";
        }
        long totalSeconds = timeMs / 1000L;
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        if (days > 0L) {
            return String.format("%dd %dh %dm", days, hours, minutes);
        }
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds);
        }
        return String.format("%ds", seconds);
    }

    private void loadTimers() {
        if (!TIMER_FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(TIMER_FILE);){
            Map loadedTimers = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, Long>>(this){}.getType());
            if (loadedTimers != null) {
                this.activeCakes.clear();
                this.activeCakes.putAll(loadedTimers);
                long currentTime = System.currentTimeMillis();
                this.activeCakes.entrySet().removeIf(entry -> (Long)entry.getValue() <= currentTime);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load century cake timers: " + e.getMessage());
        }
    }

    private void saveTimers() {
        try {
            TIMER_FILE.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(TIMER_FILE);){
                GSON.toJson(this.activeCakes, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save century cake timers: " + e.getMessage());
        }
    }

    public void shutdown() {
        this.saveTimers();
        this.scheduler.shutdown();
    }
}

