/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import java.util.HashMap;
import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.hud.TitleDisplay;
import me.valkeea.fishyaddons.util.HelpUtil;
import me.valkeea.fishyaddons.util.SoundUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ChatAlert {
    private static final Map<String, FishyConfig.AlertData> alertCache = new HashMap<String, FishyConfig.AlertData>();
    private static boolean enabled = false;

    private ChatAlert() {
    }

    public static void refresh() {
        alertCache.clear();
        alertCache.putAll(FishyConfig.getChatAlerts());
        enabled = FishyConfig.getState("chatAlertsOn", false);
    }

    public static void handleMatch(String s) {
        if (!enabled) {
            return;
        }
        String message = HelpUtil.stripColor(s);
        for (Map.Entry<String, FishyConfig.AlertData> entry : alertCache.entrySet()) {
            String key = entry.getKey();
            FishyConfig.AlertData data = entry.getValue();
            if (data == null || !data.isToggled() || !message.contains(key)) continue;
            ChatAlert.executeAlert(data);
            break;
        }
    }

    public static void executeAlert(FishyConfig.AlertData data) {
        class_310 client = class_310.method_1551();
        if (data.getMsg() != null && !data.getMsg().isBlank() && client.field_1724 != null) {
            client.field_1724.field_3944.method_45729(data.getMsg());
        }
        if (data.getOnscreen() != null && !data.getOnscreen().isBlank() && client.field_1705 != null) {
            TitleDisplay.setTitle(data.getOnscreen(), data.getColor());
        }
        if (data.getSoundId() != null && !data.getSoundId().isBlank() && client.field_1724 != null) {
            try {
                class_2960 id = class_2960.method_12829((String)data.getSoundId());
                if (id != null) {
                    SoundUtil.playDynamicSound(id.toString(), data.getVolume(), 1.0f);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

