/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.util.ZoneUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class FaColors {
    private static final Object2ObjectOpenHashMap<String, class_5251> global = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<String, class_5251> user = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<String, class_5251> combinedMap = new Object2ObjectOpenHashMap();
    private static final Map<String, List<Segment>> segmentCache = new WeakHashMap<String, List<Segment>>();
    private static final Map<class_2561, class_2561> rewriteCache = new WeakHashMap<class_2561, class_2561>();
    private static final Map<class_2561, class_2561> sidebarCache = new WeakHashMap<class_2561, class_2561>();
    private static final Map<class_2561, class_2561> labelCache = new WeakHashMap<class_2561, class_2561>();
    private static final Map<class_2561, class_2561> tooltipCache = new WeakHashMap<class_2561, class_2561>();
    private static boolean useGlobal = false;
    private static boolean useCustom = false;

    private static void fetchGlobal() {
        try {
            String url = "https://gist.githubusercontent.com/valkeea/de655343d713bf3378555fe6775f8e3b/raw/facolors.json";
            URLConnection conn = URI.create(url).toURL().openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestProperty("User-Agent", "FishyAddons");
            try (InputStream in = conn.getInputStream();
                 InputStreamReader reader = new InputStreamReader(in);){
                Gson gson = new Gson();
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map map = (Map)gson.fromJson((Reader)reader, type);
                if (map == null || map.isEmpty() || map.size() > 100) {
                    throw new IllegalStateException("Invalid gist data");
                }
                global.clear();
                for (Map.Entry entry : map.entrySet()) {
                    String hex = (String)entry.getValue();
                    int color = Integer.parseInt(hex, 16);
                    global.put((Object)((String)entry.getKey()), (Object)class_5251.method_27717((int)color));
                }
                FaColors.refresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            FaColors.useFallbackColors();
        }
    }

    public static void refresh() {
        useGlobal = FishyConfig.getState("globalFaColors", false);
        useCustom = FishyConfig.getState("customFaColors", false);
        FaColors.loadUserMap();
        FaColors.combine();
        FaColors.clearCache();
    }

    private static void combine() {
        combinedMap.clear();
        if (useGlobal) {
            combinedMap.putAll(global);
        }
        if (useCustom) {
            combinedMap.putAll(user);
        }
    }

    private static void clearCache() {
        segmentCache.clear();
        rewriteCache.clear();
        sidebarCache.clear();
        labelCache.clear();
        tooltipCache.clear();
    }

    public static boolean shouldColor() {
        return useGlobal || useCustom;
    }

    private static void useFallbackColors() {
        global.clear();
        global.put((Object)"valkeea", (Object)class_5251.method_27717((int)16759012));
        FaColors.refresh();
    }

    private static List<Segment> splitWithMatches(String input) {
        if (input.isEmpty()) {
            return List.of();
        }
        List<Segment> cached = segmentCache.get(input);
        if (cached != null) {
            return cached;
        }
        ArrayList<Segment> segments = new ArrayList<Segment>();
        int pos = 0;
        while (pos < input.length()) {
            int bestStart = -1;
            int bestEnd = -1;
            class_5251 bestColor = null;
            String bestKey = null;
            for (Map.Entry e : combinedMap.object2ObjectEntrySet()) {
                String key = (String)e.getKey();
                int idx = input.indexOf(key, pos);
                if (idx < 0) continue;
                int end = idx + key.length();
                if (bestStart != -1 && idx >= bestStart && (idx != bestStart || end <= bestEnd)) continue;
                bestStart = idx;
                bestEnd = end;
                bestColor = (class_5251)e.getValue();
                bestKey = key;
            }
            if (bestStart == -1) {
                segments.add(new Segment(input.substring(pos), null));
                break;
            }
            if (bestStart > pos) {
                segments.add(new Segment(input.substring(pos, bestStart), null));
            }
            segments.add(new Segment(bestKey, bestColor));
            pos = bestEnd;
        }
        segmentCache.put(input, segments);
        return segments;
    }

    public static <T> Optional<T> applyRecolorAll(String input, class_2583 baseStyle, class_5348.class_5246<T> visitor) {
        for (Segment seg : FaColors.splitWithMatches(input)) {
            class_2583 style = seg.color == null ? baseStyle : baseStyle.method_27703(seg.color);
            visitor.accept(style, seg.text);
        }
        return Optional.empty();
    }

    private static class_2561 multiple(class_2561 input) {
        class_7417 content = input.method_10851();
        class_5250 result = class_2561.method_43473().method_10862(input.method_10866());
        if (content instanceof class_8828) {
            class_8828 plain = (class_8828)content;
            for (Segment seg : FaColors.splitWithMatches(plain.comp_737())) {
                class_2583 segStyle = seg.color == null ? input.method_10866() : input.method_10866().method_27703(seg.color);
                result.method_10852((class_2561)class_2561.method_43470((String)seg.text).method_10862(segStyle));
            }
        }
        for (class_2561 sibling : input.method_10855()) {
            result.method_10852(FaColors.multiple(sibling));
        }
        return result;
    }

    public static class_2561 multipleCached(class_2561 input) {
        class_2561 cached = rewriteCache.get(input);
        if (cached != null) {
            return cached;
        }
        class_2561 rewritten = FaColors.multiple(input);
        rewriteCache.put(input, rewritten);
        return rewritten;
    }

    public static class_2561 first(class_2561 input) {
        class_2561 cached = labelCache.get(input);
        if (cached != null) {
            return cached;
        }
        class_7417 class_74172 = input.method_10851();
        if (class_74172 instanceof class_8828) {
            class_8828 plain = (class_8828)class_74172;
            String str = plain.comp_737();
            class_5251 color = null;
            for (Map.Entry e : combinedMap.object2ObjectEntrySet()) {
                if (!str.equals(e.getKey())) continue;
                color = (class_5251)e.getValue();
                break;
            }
            if (color != null) {
                class_5250 colored = class_2561.method_43470((String)str).method_10862(input.method_10866().method_27703(color));
                for (class_2561 sibling : input.method_10855()) {
                    colored.method_10852(sibling);
                }
                return colored;
            }
        }
        class_5250 result = input.method_27661();
        result.method_10855().clear();
        for (class_2561 sibling : input.method_10855()) {
            result.method_10852(FaColors.first(sibling));
        }
        labelCache.put(input, (class_2561)result);
        return result;
    }

    public static class_2561 recolorSidebarText(class_2561 input) {
        Object result;
        if (!FaColors.shouldColor() || !ZoneUtils.isInDungeon()) {
            return input;
        }
        class_2561 cached = sidebarCache.get(input);
        if (cached != null) {
            return cached;
        }
        class_7417 class_74172 = input.method_10851();
        if (class_74172 instanceof class_8828) {
            class_8828 plain = (class_8828)class_74172;
            String str = plain.comp_737();
            class_5251 color = null;
            for (Map.Entry e : combinedMap.object2ObjectEntrySet()) {
                String key = (String)e.getKey();
                if (!str.contains(key)) continue;
                color = (class_5251)e.getValue();
                break;
            }
            result = color != null ? class_2561.method_43470((String)str).method_10862(input.method_10866().method_27703(color)) : input;
        } else {
            result = input;
        }
        if (!input.method_10855().isEmpty()) {
            class_5250 mutableResult = class_2561.method_43470((String)"").method_10862(input.method_10866());
            for (class_2561 sibling : input.method_10855()) {
                mutableResult.method_10852(FaColors.recolorSidebarText(sibling));
            }
            result = mutableResult;
        }
        sidebarCache.put(input, (class_2561)result);
        return result;
    }

    public static class_2561 tooltip(class_2561 input) {
        class_7417 class_74172 = input.method_10851();
        if (class_74172 instanceof class_8828) {
            class_8828 plain = (class_8828)class_74172;
            String str = plain.comp_737();
            class_5251 color = null;
            for (Map.Entry e : combinedMap.object2ObjectEntrySet()) {
                if (!str.equals(e.getKey())) continue;
                color = (class_5251)e.getValue();
                break;
            }
            class_2583 newStyle = color == null ? input.method_10866() : input.method_10866().method_27703(color);
            class_5250 result = class_2561.method_43470((String)str).method_10862(newStyle);
            for (class_2561 sibling : input.method_10855()) {
                result.method_10852(FaColors.tooltip(sibling));
            }
            return result;
        }
        class_5250 result = input.method_27661();
        result.method_10855().clear();
        for (class_2561 sibling : input.method_10855()) {
            result.method_10852(FaColors.tooltip(sibling));
        }
        return result;
    }

    public static class_2561 tooltipCached(class_2561 input) {
        class_2561 cached = tooltipCache.get(input);
        if (cached != null) {
            return cached;
        }
        class_2561 rewritten = FaColors.tooltip(input);
        tooltipCache.put(input, rewritten);
        return rewritten;
    }

    public static void loadUserMap(Map<String, Integer> jsonMap) {
        user.clear();
        for (Map.Entry<String, Integer> entry : jsonMap.entrySet()) {
            user.put((Object)entry.getKey(), (Object)class_5251.method_27717((int)entry.getValue()));
        }
        FaColors.combine();
    }

    public static void clearUserMap() {
        user.clear();
        FaColors.combine();
    }

    public static void saveUserEntry(String key, int color) {
        user.put((Object)key, (Object)class_5251.method_27717((int)color));
        FishyConfig.setFaC(key, color);
        FaColors.refresh();
    }

    public static void deleteUserEntry(String key) {
        user.remove((Object)key);
        FishyConfig.removeFaC(key);
        FaColors.refresh();
    }

    public static void loadUserMap() {
        user.clear();
        Map<String, Integer> map = FishyConfig.getFaC();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            user.put((Object)entry.getKey(), (Object)class_5251.method_27717((int)entry.getValue()));
        }
        FaColors.combine();
    }

    static {
        FaColors.fetchGlobal();
    }

    @Environment(value=EnvType.CLIENT)
    public record Segment(String text, @Nullable class_5251 color) {
    }
}

