/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.config.ItemConfig;
import me.valkeea.fishyaddons.util.SbGui;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class GuiIcons {
    private static final Set<String> screenNames = new HashSet<String>();
    private static final Map<String, Set<Integer>> screenSlotMap = new HashMap<String, Set<Integer>>();
    private static List<Integer> cachedSlots = Collections.emptyList();
    private static String lastScreen = null;
    private static boolean enabled = false;

    private GuiIcons() {
    }

    public static void refresh() {
        String keyCode = FishyConfig.getKeyString("lockGuiSlotKey");
        enabled = !screenNames.isEmpty() && !screenSlotMap.isEmpty() && keyCode != null && !keyCode.equals("NONE");
    }

    public static boolean hasConfig(class_2561 title) {
        if (!enabled) {
            return false;
        }
        String screenName = title.getString();
        return !screenNames.isEmpty() && GuiIcons.checkScreen(screenName);
    }

    private static boolean checkScreen(String screenName) {
        for (String name : screenNames) {
            if (!screenName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlocked(int slotIndex) {
        return SbGui.getInstance().inGui() && GuiIcons.getSlotsForScreen(SbGui.getInstance().current()).contains(slotIndex) && !GuiIcons.isShiftDown(class_310.method_1551());
    }

    public static boolean handleShift(int slotIndex) {
        return SbGui.getInstance().inGui() && GuiIcons.getSlotsForScreen(SbGui.getInstance().current()).contains(slotIndex);
    }

    private static boolean isShiftDown(class_310 client) {
        if (client.field_1690 == null) {
            return false;
        }
        long handle = client.method_22683().method_4490();
        int keyCode = client.field_1690.field_1832.method_1429().method_1444();
        return class_3675.method_15987((long)handle, (int)keyCode);
    }

    public static void addGuiSlot(String screenName, int slotId) {
        Set slots;
        boolean added;
        String key = screenName.toLowerCase(Locale.ROOT);
        if (!screenNames.contains(screenName)) {
            screenNames.add(screenName);
            SbGui.getInstance().setInGui(screenName);
        }
        if (!(added = (slots = screenSlotMap.computeIfAbsent(key, k -> new HashSet())).add(slotId))) {
            GuiIcons.removeGuiSlot(screenName, slotId);
            if (slots.isEmpty()) {
                screenNames.removeIf(name -> name.equalsIgnoreCase(screenName));
                screenSlotMap.remove(key);
            }
        }
        GuiIcons.refresh();
        GuiIcons.refreshSlots(screenName);
        ItemConfig.saveGuiIcons();
    }

    private static void removeGuiSlot(String screenName, int slotIndex) {
        String key = screenName.toLowerCase(Locale.ROOT);
        Set<Integer> slots = screenSlotMap.get(key);
        if (slots != null) {
            slots.remove(slotIndex);
            if (slots.isEmpty()) {
                screenSlotMap.remove(key);
            }
        }
    }

    public static List<Integer> slots(String screenName) {
        Set slots = screenSlotMap.getOrDefault(screenName.toLowerCase(Locale.ROOT), Collections.emptySet());
        return new ArrayList<Integer>(slots);
    }

    private static void refreshSlots(String screen) {
        if (screen == null) {
            return;
        }
        lastScreen = screen;
        cachedSlots = GuiIcons.slots(lastScreen);
    }

    public static List<Integer> getSlotsForScreen(String screenName) {
        if (screenName == null) {
            return Collections.emptyList();
        }
        if (!screenName.equals(lastScreen)) {
            GuiIcons.refreshSlots(screenName);
        }
        return cachedSlots;
    }

    public static Set<String> getScreenNames() {
        return new HashSet<String>(screenNames);
    }

    public static void setScreenNames(Set<String> names) {
        screenNames.clear();
        screenNames.clear();
        screenNames.addAll(names);
    }

    public static Map<String, Set<Integer>> getScreenSlotMap() {
        HashMap<String, Set<Integer>> copy = new HashMap<String, Set<Integer>>();
        for (Map.Entry<String, Set<Integer>> e : screenSlotMap.entrySet()) {
            copy.put(e.getKey(), new HashSet(e.getValue()));
        }
        return copy;
    }

    public static void setScreenSlotMap(Map<String, Set<Integer>> map) {
        screenSlotMap.clear();
        for (Map.Entry<String, Set<Integer>> e : map.entrySet()) {
            screenSlotMap.put(e.getKey(), new HashSet(e.getValue()));
        }
    }
}

