/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.valkeea.fishyaddons.config.FishyConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class KeyShortcut {
    private static final long COOLDOWN_MS = 1000L;
    private static final Set<String> keysHeld = new HashSet<String>();
    private static final Map<String, Long> lastExecutionTime = new HashMap<String, Long>();
    private static Map<String, String> cachedKeybinds = Map.of();
    private static boolean enabled = false;

    private KeyShortcut() {
    }

    public static void refresh() {
        enabled = FishyConfig.getState("keyShortcutsOn", true);
        cachedKeybinds = Map.copyOf(FishyConfig.getKeybinds());
    }

    public static void handleShortcuts() {
        if (!enabled) {
            return;
        }
        Map<String, String> keybinds = cachedKeybinds;
        for (Map.Entry<String, String> entry : keybinds.entrySet()) {
            String key = entry.getKey();
            String command = entry.getValue();
            if (!FishyConfig.isKeybindToggled(key)) continue;
            boolean isPressed = false;
            if (key.startsWith("MOUSE")) {
                boolean pressed;
                int mouseButton = KeyShortcut.parseMouseButton(key);
                isPressed = pressed = GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)mouseButton) == 1;
            } else {
                int keyCode = KeyShortcut.parseKeyCode(key);
                if (keyCode != -1) {
                    isPressed = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)keyCode);
                }
            }
            KeyShortcut.handleKeyInput(key, command, isPressed);
        }
    }

    private static int parseKeyCode(String key) {
        try {
            if (key.startsWith("GLFW_KEY_")) {
                Field field = GLFW.class.getField(key);
                return field.getInt(null);
            }
            if (key.length() == 1) {
                return class_3675.method_15981((String)("key.keyboard." + key.toLowerCase())).method_1444();
            }
            if (key.startsWith("KEY_")) {
                return class_3675.method_15981((String)("key.keyboard." + key.substring(4).toLowerCase())).method_1444();
            }
            return class_3675.method_15981((String)key).method_1444();
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static int parseMouseButton(String key) {
        try {
            return Integer.parseInt(key.replace("MOUSE", "").trim());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static void handleKeyInput(String key, String command, boolean isPressed) {
        if (isPressed) {
            if (!keysHeld.contains(key)) {
                KeyShortcut.execute(key, command);
                keysHeld.add(key);
            }
        } else {
            keysHeld.remove(key);
        }
    }

    private static void execute(String key, String command) {
        long currentTime = System.currentTimeMillis();
        if (!(command == null || command.isEmpty() || lastExecutionTime.containsKey(key) && currentTime - lastExecutionTime.get(key) < 1000L)) {
            if (command.startsWith("/")) {
                command = command.substring(1);
            }
            class_310.method_1551().field_1724.field_3944.method_45730(command);
            lastExecutionTime.put(key, currentTime);
        }
    }
}

