/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.handler.TabScanner;
import me.valkeea.fishyaddons.util.SkyblockCheck;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class PetInfo {
    private static boolean isOn = false;
    private static boolean dynamicMode = false;
    private static boolean tablistReady = false;
    private static long lastScanTime = 0L;
    private static boolean needsScan = false;

    private PetInfo() {
    }

    public static void refresh() {
        isOn = FishyConfig.getState("petHud", false);
        dynamicMode = FishyConfig.getState("tabTicks", false);
    }

    public static void onWorldLoad() {
        PetInfo.setTablistReady(false);
        needsScan = true;
    }

    public static void onTablistReady() {
        PetInfo.setTablistReady(true);
    }

    public static boolean shouldScan() {
        if (!(isOn && SkyblockCheck.getInstance().rules() && tablistReady)) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (TabScanner.isPending()) {
            if (now - lastScanTime >= 200L) {
                lastScanTime = now;
                return true;
            }
            return false;
        }
        if (dynamicMode) {
            if (now - lastScanTime >= 1000L) {
                lastScanTime = now;
                return true;
            }
            return false;
        }
        if (needsScan && now - lastScanTime >= 1000L) {
            lastScanTime = now;
            needsScan = false;
            return true;
        }
        return false;
    }

    public static void handleChat(String message) {
        if (!isOn || !SkyblockCheck.getInstance().rules()) {
            return;
        }
        Pattern directPattern = Pattern.compile("\u00a7cAutopet \u00a7eequipped your (?:\u00a7.)+\\[Lvl \\d+\\] (.+?)(?=\u00a7a\u00a7lVIEW RULE|$)");
        Matcher directMatcher = directPattern.matcher(message);
        if (directMatcher.find()) {
            String fullMatch = directMatcher.group(0);
            String petInfoPart = fullMatch.substring(fullMatch.indexOf("[Lvl"));
            petInfoPart = petInfoPart.replaceAll("[!\u00a1]+(?:\u00a7.)*$", "").replaceAll("\u00a7.$", "");
            String stripped = class_124.method_539((String)petInfoPart);
            class_5250 petInfo = class_2561.method_43470((String)petInfoPart);
            TabScanner.setOverride((class_2561)petInfo);
            class_5250 petOutline = class_2561.method_43470((String)stripped).method_27694(style -> style.method_10977(class_124.field_1074));
            TabScanner.setOutline((class_2561)petOutline);
            return;
        }
        Pattern summonPattern = Pattern.compile("You summoned your (.+) ?[!\u00a1]?");
        Matcher summonMatcher = summonPattern.matcher(message);
        if (summonMatcher.find() || message.matches("\\[Lvl \\d+\\] .+")) {
            TabScanner.clearOverride();
            TabScanner.startSummonScan();
            needsScan = true;
        }
        if (message.contains("You despawned your")) {
            class_5250 msg = class_2561.method_43470((String)"Despawned").method_10862(class_2583.field_24360.method_36139(-8355712));
            TabScanner.setOverride((class_2561)msg);
        }
    }

    public static void setTablistReady(boolean ready) {
        tablistReady = ready;
    }

    public static boolean isTablistReady() {
        return tablistReady;
    }

    public static boolean isOn() {
        return isOn;
    }

    public static boolean isDynamic() {
        return dynamicMode;
    }

    public static boolean shouldIncludeXp() {
        return FishyConfig.getState("petXpCheck", false);
    }
}

