/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.valkeea.fishyaddons.handler.PetInfo;
import me.valkeea.fishyaddons.util.FishyNotis;
import me.valkeea.fishyaddons.util.TablistUtils;
import me.valkeea.fishyaddons.util.TextUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class TabScanner {
    private static final Pattern PET_PATTERN = Pattern.compile("\\[Lvl \\d+\\] .+");
    private static final int FAIL_LIMIT = 20;
    private static class_2561 directOverride = null;
    private static class_2561 overrideOutline = null;
    private static PetTabInfo l1Scanned = null;
    private static boolean pendingSummon = false;
    private static String prevl1 = null;
    private static long summonStartTime = 0L;
    private static int failCount = 0;
    private static final int MIN_SUMMON_WAIT_MS = 500;
    private static final int MAX_SUMMON_WAIT_MS = 5000;

    private TabScanner() {
    }

    public static void setOverride(class_2561 petInfo) {
        directOverride = petInfo;
        TabScanner.clearPet();
    }

    public static void setOutline(class_2561 outline) {
        overrideOutline = outline;
    }

    public static void clearOverride() {
        directOverride = null;
        overrideOutline = null;
    }

    public static void startSummonScan() {
        String currentPetText;
        prevl1 = currentPetText = l1Scanned != null ? TabScanner.extract(TabScanner.l1Scanned.l1) : null;
        pendingSummon = true;
        summonStartTime = System.currentTimeMillis();
        failCount = 0;
        TabScanner.clearPet();
    }

    public static boolean isPending() {
        return pendingSummon;
    }

    private static void clearPet() {
        l1Scanned = null;
    }

    public static class_2561 getPet() {
        if (directOverride != null) {
            return directOverride;
        }
        return l1Scanned != null ? l1Scanned.getCombined() : null;
    }

    public static class_2561 getOutline() {
        if (overrideOutline != null) {
            return overrideOutline;
        }
        if (directOverride != null) {
            String stripped = class_124.method_539((String)directOverride.getString());
            return class_2561.method_43470((String)stripped).method_27694(style -> style.method_10977(class_124.field_1074));
        }
        return l1Scanned != null ? l1Scanned.getCombinedForOutline() : null;
    }

    public static void onUpdate() {
        List<class_2561> lines;
        if (pendingSummon && System.currentTimeMillis() - summonStartTime > 10000L) {
            pendingSummon = false;
            prevl1 = null;
            summonStartTime = 0L;
            failCount = 0;
        }
        if (PetInfo.isDynamic()) {
            TabScanner.clearOverride();
        }
        if ((lines = TablistUtils.getLines()).isEmpty()) {
            TabScanner.clearPet();
            return;
        }
        PetLineResult l1Result = TabScanner.findPetLine(lines);
        if (l1Result == null) {
            TabScanner.noneFound();
            return;
        }
        if (pendingSummon) {
            TabScanner.handleSummon(l1Result);
            return;
        }
        TabScanner.updateScannedPet(l1Result, lines);
        failCount = 0;
    }

    private static PetLineResult findPetLine(List<class_2561> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            if (!TabScanner.isPetLine(line.getString())) continue;
            return new PetLineResult(i, line, line.getString().trim());
        }
        return null;
    }

    private static void noneFound() {
        if (pendingSummon) {
            long timeSinceSummon = System.currentTimeMillis() - summonStartTime;
            if (timeSinceSummon > 5000L) {
                pendingSummon = false;
                prevl1 = null;
                summonStartTime = 0L;
                failCount = 0;
                TabScanner.sendFailNotification();
                return;
            }
            if (++failCount >= 20) {
                pendingSummon = false;
                prevl1 = null;
                summonStartTime = 0L;
                failCount = 0;
                TabScanner.sendFailNotification();
            }
        } else {
            TabScanner.clearPet();
        }
    }

    private static void handleSummon(PetLineResult l1Result) {
        boolean hasChanged;
        String currentl1 = l1Result.lineText;
        long timeSinceSummon = System.currentTimeMillis() - summonStartTime;
        if (timeSinceSummon > 5000L) {
            l1Scanned = new PetTabInfo(l1Result.line, null);
            pendingSummon = false;
            prevl1 = null;
            summonStartTime = 0L;
            failCount = 0;
            return;
        }
        if (timeSinceSummon < 500L) {
            return;
        }
        String currentPetId = TabScanner.getIdentifier(currentl1);
        String prevPetId = TabScanner.getIdentifier(prevl1);
        boolean bl = hasChanged = prevPetId == null || !currentPetId.equals(prevPetId);
        if (hasChanged) {
            l1Scanned = new PetTabInfo(l1Result.line, null);
            pendingSummon = false;
            prevl1 = null;
            summonStartTime = 0L;
            failCount = 0;
        } else {
            ++failCount;
        }
    }

    private static void updateScannedPet(PetLineResult l1Result, List<class_2561> lines) {
        class_2561 l1 = l1Result.line;
        class_2561 l2 = null;
        if (PetInfo.isDynamic() && PetInfo.shouldIncludeXp()) {
            l2 = TabScanner.findXpLine(lines, l1Result.index);
        }
        l1Scanned = new PetTabInfo(l1, l2);
    }

    private static class_2561 findXpLine(List<class_2561> lines, int l1Idx) {
        for (int i = 0; i < lines.size(); ++i) {
            if (i == l1Idx || !TabScanner.isXpLine(lines.get(i))) continue;
            return lines.get(i);
        }
        return null;
    }

    private static String extract(class_2561 l1) {
        if (l1 == null) {
            return null;
        }
        String fullText = l1.getString().trim();
        return class_124.method_539((String)fullText);
    }

    private static String getIdentifier(String l1) {
        if (l1 == null) {
            return null;
        }
        String stripped = class_124.method_539((String)l1);
        Matcher matcher = PET_PATTERN.matcher(stripped);
        if (matcher.matches()) {
            return stripped;
        }
        return stripped;
    }

    private static boolean isPetLine(String line) {
        if (line == null) {
            return false;
        }
        Matcher m = PET_PATTERN.matcher(line.trim());
        return m.matches();
    }

    private static boolean isXpLine(class_2561 line) {
        class_2561 maxLevel;
        List siblings = line.method_10855();
        if (siblings.size() == 2 && (maxLevel = (class_2561)siblings.get(1)).getString().trim().equals("MAX LEVEL") && maxLevel.method_10866().method_10973() != null && maxLevel.method_10866().method_10973().method_27716() == 0x55FFFF && Boolean.TRUE.equals(maxLevel.method_10866().method_10984())) {
            return true;
        }
        if (siblings.size() >= 5) {
            class_2561 t1 = (class_2561)siblings.get(1);
            class_2561 t2 = (class_2561)siblings.get(2);
            class_2561 t3 = (class_2561)siblings.get(3);
            class_2561 t4 = (class_2561)siblings.get(4);
            String s1 = t1.getString().trim();
            String s2 = t2.getString().trim();
            String s3 = t3.getString().trim();
            String s4 = t4.getString().trim();
            return t1.method_10866().method_10973() != null && t1.method_10866().method_10973().method_27716() == 0xFFFF55 && s1.matches("[\\d,\\.]+") && t2.method_10866().method_10973() != null && t2.method_10866().method_10973().method_27716() == 0xFFAA00 && s2.equals("/") && t3.method_10866().method_10973() != null && t3.method_10866().method_10973().method_27716() == 0xFFFF55 && s3.endsWith("XP") && t4.method_10866().method_10973() != null && t4.method_10866().method_10973().method_27716() == 0xFFAA00 && s4.matches("\\([\\d\\.]+%\\)");
        }
        return false;
    }

    private static void sendFailNotification() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            FishyNotis.send((class_2561)class_2561.method_43470((String)"Failed to find pet info. Please check your tab widgets.").method_27692(class_124.field_1061));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PetTabInfo {
        private final class_2561 l1;
        private final class_2561 l2;

        public PetTabInfo(class_2561 l1, class_2561 l2) {
            this.l1 = l1;
            this.l2 = l2;
        }

        public class_2561 getCombined() {
            if (this.l2 != null) {
                return class_2561.method_43473().method_10852(this.l1).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(this.l2);
            }
            return this.l1;
        }

        public class_2561 getCombinedForOutline() {
            class_2561 combined = this.getCombined();
            return TextUtils.recolor(combined);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class PetLineResult {
        final int index;
        final class_2561 line;
        final String lineText;

        PetLineResult(int index, class_2561 line, String lineText) {
            this.index = index;
            this.line = line;
            this.lineText = lineText;
        }
    }
}

