/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.handler;

import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.util.AreaUtils;
import me.valkeea.fishyaddons.util.FishyNotis;
import me.valkeea.fishyaddons.util.PlaySound;
import me.valkeea.fishyaddons.util.ZoneUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class WeatherTracker {
    private static boolean lastRainState = false;
    private static boolean initialized = false;

    private WeatherTracker() {
    }

    public static void onRainStateChange(boolean isRaining) {
        if (!FishyConfig.getState("rainNoti", true)) {
            return;
        }
        if (!initialized && !ZoneUtils.checkDenOrPark()) {
            return;
        }
        if (lastRainState && !isRaining) {
            if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_23318() == 69.0) {
                class_5250 message = class_2561.method_43470((String)"Warning: rain tracking is disabled in water with no sky access.").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});
                FishyNotis.send((class_2561)message);
            } else {
                WeatherTracker.stopped();
            }
        } else if (!lastRainState && isRaining) {
            WeatherTracker.started();
        }
        lastRainState = isRaining;
    }

    public static boolean isRaining() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            return client.field_1687.method_8419();
        }
        return false;
    }

    public static void track() {
        WeatherTracker.onRainStateChange(WeatherTracker.isRaining());
        if (!initialized) {
            lastRainState = WeatherTracker.isRaining();
            initialized = true;
        }
    }

    public static void reset() {
        initialized = false;
        lastRainState = false;
        WeatherTracker.shouldTrack();
    }

    public static void shouldTrack() {
        if (AreaUtils.isDenOrPark()) {
            initialized = true;
            lastRainState = WeatherTracker.isRaining();
        } else {
            initialized = false;
            lastRainState = false;
        }
    }

    private static void stopped() {
        if (!FishyConfig.getState("rainNoti", true)) {
            return;
        }
        class_5250 message = class_2561.method_43470((String)"\u00a7b[\u03b1] \u00a7cRain has stopped! \u00a7b[\u03b1]").method_27692(class_124.field_1061);
        FishyNotis.alert((class_2561)message);
        PlaySound.rainAlarm();
    }

    private static void started() {
        if (!FishyConfig.getState("rainNoti", true)) {
            return;
        }
        class_5250 message = class_2561.method_43470((String)"Rain has started!").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
        FishyNotis.alert((class_2561)message);
    }
}

