/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.hud;

import java.awt.Rectangle;
import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.handler.CakeTimer;
import me.valkeea.fishyaddons.hud.HudElement;
import me.valkeea.fishyaddons.hud.HudElementState;
import me.valkeea.fishyaddons.tool.FishyMode;
import me.valkeea.fishyaddons.util.TextUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class CakeDisplay
implements HudElement {
    private boolean editingMode = false;
    private static final String HUD_KEY = "centuryCakeHud";
    private HudElementState cachedState = null;

    public void register() {
        HudLayerRegistrationCallback.EVENT.register(layeredDrawer -> layeredDrawer.attachLayerAfter(IdentifiedLayer.MISC_OVERLAYS, class_2960.method_60655((String)"fishyaddons", (String)"century_cake_hud"), (context, tickCounter) -> this.render(context, 0, 0)));
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        String displayText;
        if (!this.editingMode && !FishyConfig.getState(HUD_KEY, false)) {
            return;
        }
        CakeTimer timer = CakeTimer.getInstance();
        if (!this.editingMode && !timer.hasActiveCakes()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        HudElementState state = this.getCachedState();
        int hudX = state.x;
        int hudY = state.y;
        int size = state.size;
        int color = state.color;
        boolean outlined = state.outlined;
        boolean showBg = state.bg;
        float scale = (float)size / 12.0f;
        String symbolText = "";
        if (this.editingMode) {
            displayText = "1d 23h 45m";
        } else {
            Map<String, Long> activeCakes = timer.getActiveCakes();
            if (activeCakes.isEmpty()) {
                displayText = "Expired";
            } else {
                String nextCake = timer.getNextExpiringCake();
                symbolText = nextCake != null ? timer.symbol(nextCake) : "";
                long timeLeft = timer.getTimeUntilNextExpiry();
                displayText = CakeTimer.formatTimeLeft(timeLeft);
            }
        }
        class_5250 timerText = class_2561.method_43470((String)displayText);
        class_5250 symbolTextComponent = class_2561.method_43470((String)symbolText);
        int textWidth = mc.field_1772.method_27525((class_5348)timerText);
        int symbolWidth = symbolText.isEmpty() ? 0 : mc.field_1772.method_27525((class_5348)symbolTextComponent);
        int symbolPadding = symbolText.isEmpty() ? 0 : 2;
        int iconSize = (int)(12.0f * scale);
        int totalWidth = iconSize + 2 + symbolWidth + symbolPadding + textWidth;
        if (this.editingMode || showBg) {
            int shadowX1 = hudX + 1;
            int shadowY1 = hudY + 2;
            int shadowX2 = hudX + (int)((float)totalWidth * scale) + 2;
            int shadowY2 = hudY + (int)((float)size * 0.8f) - 1;
            context.method_25294(shadowX1, shadowY1, shadowX2, shadowY2, Integer.MIN_VALUE);
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)hudX, (float)hudY, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        class_2960 cakeTexture = class_2960.method_60655((String)"fishyaddons", (String)("textures/gui/" + FishyMode.getTheme() + "/cake.png"));
        context.method_25290(class_1921::method_62277, cakeTexture, 0, -3, 0.0f, 0.0f, 12, 12, 12, 12);
        int textX = iconSize + 2;
        if (!symbolText.isEmpty()) {
            if (outlined) {
                TextUtils.drawOutlinedText(context, mc.field_1772, (class_2561)symbolTextComponent, textX, 0.0f, 0x808080, -16777216, context.method_51448().method_23760().method_23761(), (class_4597)class_310.method_1551().method_22940().method_23000(), class_327.class_6415.field_33993, 0xF000F0);
            } else {
                context.method_51439(mc.field_1772, (class_2561)symbolTextComponent, textX, 0, 0x808080, true);
            }
            textX += symbolWidth + symbolPadding;
        }
        if (outlined) {
            TextUtils.drawOutlinedText(context, mc.field_1772, (class_2561)timerText, textX, 0.0f, color, -16777216, context.method_51448().method_23760().method_23761(), (class_4597)class_310.method_1551().method_22940().method_23000(), class_327.class_6415.field_33993, 0xF000F0);
        } else {
            context.method_51439(mc.field_1772, (class_2561)timerText, textX, 0, color, true);
        }
        context.method_51448().method_22909();
        if (this.editingMode) {
            context.method_25294(hudX - 2, hudY - 2, hudX + (int)((float)totalWidth * scale) + 18, hudY + (int)((float)size * 1.1f) + 4, -2130706433);
        }
    }

    @Override
    public Rectangle getBounds(class_310 mc) {
        int hudX = this.getHudX();
        int hudY = this.getHudY();
        int size = this.getHudSize();
        float scale = (float)size / 12.0f;
        int iconSize = (int)(12.0f * scale);
        String sampleText = this.getDisplayName() == null ? "\u26a1 1d 23h 45m" : this.getDisplayName();
        int textWidth = mc.field_1772.method_1727(sampleText);
        int totalWidth = iconSize + 2 + textWidth;
        int width = (int)((float)Math.max(100, totalWidth) * scale);
        int height = (int)((float)size + 4.0f * scale);
        return new Rectangle(hudX, hudY, width, height);
    }

    @Override
    public HudElementState getCachedState() {
        if (this.cachedState == null) {
            this.cachedState = new HudElementState(FishyConfig.getHudX(HUD_KEY, 5), FishyConfig.getHudY(HUD_KEY, 5), FishyConfig.getHudSize(HUD_KEY, 12), FishyConfig.getHudColor(HUD_KEY, 0xFFAA00), FishyConfig.getHudOutline(HUD_KEY, false), FishyConfig.getHudBg(HUD_KEY, true));
        }
        return this.cachedState;
    }

    @Override
    public void invalidateCache() {
        this.cachedState = null;
    }

    @Override
    public int getHudX() {
        return FishyConfig.getHudX(HUD_KEY, 5);
    }

    @Override
    public int getHudY() {
        return FishyConfig.getHudY(HUD_KEY, 5);
    }

    @Override
    public void setHudPosition(int x, int y) {
        FishyConfig.setHudX(HUD_KEY, x);
        FishyConfig.setHudY(HUD_KEY, y);
    }

    @Override
    public int getHudSize() {
        return FishyConfig.getHudSize(HUD_KEY, 12);
    }

    @Override
    public void setHudSize(int size) {
        FishyConfig.setHudSize(HUD_KEY, size);
    }

    @Override
    public int getHudColor() {
        return FishyConfig.getHudColor(HUD_KEY, 0xFFAA00);
    }

    @Override
    public void setHudColor(int color) {
        FishyConfig.setHudColor(HUD_KEY, color);
    }

    @Override
    public boolean getHudOutline() {
        return FishyConfig.getHudOutline(HUD_KEY, false);
    }

    @Override
    public void setHudOutline(boolean outline) {
        FishyConfig.setHudOutline(HUD_KEY, outline);
    }

    @Override
    public boolean getHudBg() {
        return FishyConfig.getHudBg(HUD_KEY, true);
    }

    @Override
    public void setHudBg(boolean bg) {
        FishyConfig.setHudBg(HUD_KEY, bg);
    }

    @Override
    public void setEditingMode(boolean editing) {
        this.editingMode = editing;
    }

    @Override
    public String getDisplayName() {
        return "Century Cakes: ";
    }
}

