/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.hud;

import java.util.ArrayList;
import java.util.List;
import me.valkeea.fishyaddons.handler.ItemSearchOverlay;
import me.valkeea.fishyaddons.hud.CakeDisplay;
import me.valkeea.fishyaddons.hud.HudElement;
import me.valkeea.fishyaddons.hud.InfoDisplay;
import me.valkeea.fishyaddons.hud.PetDisplay;
import me.valkeea.fishyaddons.hud.PingDisplay;
import me.valkeea.fishyaddons.hud.SearchHudElement;
import me.valkeea.fishyaddons.hud.TimerDisplay;
import me.valkeea.fishyaddons.hud.TitleDisplay;
import me.valkeea.fishyaddons.hud.TrackerDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class ElementRegistry {
    private static final List<HudElement> ELEMENTS = new ArrayList<HudElement>();

    private ElementRegistry() {
    }

    public static void register(HudElement element) {
        ELEMENTS.add(element);
    }

    public static List<HudElement> getElements() {
        return ELEMENTS;
    }

    public static void init() {
        PingDisplay pingDisplay = new PingDisplay();
        TimerDisplay timerDisplay = new TimerDisplay();
        TitleDisplay titleDisplay = new TitleDisplay();
        PetDisplay petDisplay = new PetDisplay();
        TrackerDisplay trackerDisplay = new TrackerDisplay();
        SearchHudElement searchHudElement = new SearchHudElement();
        CakeDisplay centuryCakeDisplay = new CakeDisplay();
        InfoDisplay infoDisplay = InfoDisplay.getInstance();
        ElementRegistry.register(pingDisplay);
        ElementRegistry.register(timerDisplay);
        ElementRegistry.register(titleDisplay);
        ElementRegistry.register(petDisplay);
        ElementRegistry.register(trackerDisplay);
        ElementRegistry.register(searchHudElement);
        ElementRegistry.register(centuryCakeDisplay);
        ElementRegistry.register(infoDisplay);
        pingDisplay.register();
        timerDisplay.register();
        titleDisplay.register();
        petDisplay.register();
        trackerDisplay.register();
        searchHudElement.register();
        centuryCakeDisplay.register();
        infoDisplay.register();
        ItemSearchOverlay searchOverlay = ItemSearchOverlay.getInstance();
        searchOverlay.setSearchHudElement(searchHudElement);
    }
}

