/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.hud;

import java.util.HashMap;
import java.util.Map;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.util.EqTextures;
import me.valkeea.fishyaddons.util.SkyblockCheck;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_490;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class EqDisplay {
    private static EqDisplay instance = null;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FishyAddons/ArmorDisplay");
    private static final class_2960 SLOT_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"textures/gui/container/inventory.png");
    private static final Map<Integer, class_1799> cachedSkullItems = new HashMap<Integer, class_1799>();
    private static final Map<Integer, Integer[]> cachedArmorPositions = new HashMap<Integer, Integer[]>();
    private static final Map<Integer, Integer[]> renderedPositions = new HashMap<Integer, Integer[]>();
    private static final long CACHE_REFRESH_INTERVAL = 5000L;
    private static final int SLOT_SIZE = 18;
    private static boolean positionsComputed = false;
    private static boolean renderedPositionsComputed = false;
    private static boolean shouldRender = false;
    private static long lastEquipmentCheck = 0L;

    public static EqDisplay getInstance() {
        if (instance == null) {
            instance = new EqDisplay();
        }
        return instance;
    }

    private static void refresh() {
        cachedSkullItems.clear();
        for (int i = 0; i < 4; ++i) {
            class_1799 item = EqTextures.getSlotItemStack(i);
            if (item == null) continue;
            cachedSkullItems.put(i, item);
        }
    }

    public static void reset() {
        shouldRender = false;
        lastEquipmentCheck = 0L;
    }

    private static void computePos(class_490 screen) {
        int i;
        int[][] armorSlotPositions;
        if (renderedPositionsComputed) {
            return;
        }
        if (!positionsComputed) {
            armorSlotPositions = EqDisplay.findVanillaPos(screen);
            if (armorSlotPositions.length >= 4) {
                for (i = 0; i < 4; ++i) {
                    cachedArmorPositions.put(i, new Integer[]{armorSlotPositions[i][0], armorSlotPositions[i][1]});
                }
                positionsComputed = true;
            }
        } else {
            armorSlotPositions = new int[4][2];
            for (i = 0; i < 4; ++i) {
                Integer[] cached = cachedArmorPositions.get(i);
                if (cached == null) continue;
                armorSlotPositions[i][0] = cached[0];
                armorSlotPositions[i][1] = cached[1];
            }
        }
        if (armorSlotPositions.length >= 4) {
            for (i = 0; i < 4; ++i) {
                int vanillaSlotX = armorSlotPositions[i][0];
                int vanillaSlotY = armorSlotPositions[i][1];
                int slotX = vanillaSlotX - 24;
                int slotY = vanillaSlotY - 1;
                renderedPositions.put(i, new Integer[]{slotX, slotY});
            }
            renderedPositionsComputed = true;
        } else {
            LOGGER.warn("Using fallback positions");
            for (i = 0; i < 4; ++i) {
                int slotX = -50;
                int slotY = 10 + i * 20;
                renderedPositions.put(i, new Integer[]{slotX, slotY});
            }
            renderedPositionsComputed = true;
        }
    }

    public static void render(class_332 context, class_490 screen) {
        boolean shouldRefreshCache;
        if (!FishyConfig.getState("equipmentDisplay", false) || !EqDisplay.shouldRender()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        EqDisplay.computePos(screen);
        long currentTime = System.currentTimeMillis();
        boolean bl = shouldRefreshCache = currentTime - lastEquipmentCheck > 5000L;
        if (shouldRefreshCache) {
            EqDisplay.refresh();
            lastEquipmentCheck = currentTime;
        }
        for (int i = 0; i < 4; ++i) {
            Integer[] pos = renderedPositions.get(i);
            if (pos == null) continue;
            int slotX = pos[0];
            int slotY = pos[1];
            EqDisplay.renderSlotBg(context, slotX, slotY);
            if (!EqTextures.hasSlotData(i) || EqTextures.isEmptySlot(i) || !cachedSkullItems.containsKey(i) && !EqTextures.hasSkullTexture(i)) continue;
            EqDisplay.renderSkull(context, slotX + 1, slotY + 1, i);
        }
    }

    private static int[][] findVanillaPos(class_490 screen) {
        try {
            class_1723 handler = (class_1723)screen.method_17577();
            if (handler == null) {
                return new int[0][0];
            }
            int[][] positions = new int[4][2];
            for (int i = 0; i < 4; ++i) {
                positions[i][0] = 8;
                positions[i][1] = 8 + i * 18;
            }
            return positions;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to find vanilla armor slot positions: {}", (Object)e.getMessage());
            return new int[0][0];
        }
    }

    private static boolean shouldRender() {
        if (!shouldRender) {
            if (!FishyConfig.getState("equipmentDisplay", false)) {
                shouldRender = false;
            }
            for (int i = 0; i < 4; ++i) {
                if (!EqTextures.hasSlotData(i)) continue;
                shouldRender = true;
            }
        }
        return shouldRender;
    }

    private static void renderSlotBg(class_332 context, int x, int y) {
        context.method_25290(class_1921::method_62277, SLOT_TEXTURE, x, y, 7.0f, 83.0f, 18, 18, 256, 256);
    }

    private static void renderSkull(class_332 context, int x, int y, int slotIndex) {
        try {
            class_1799 skullStack = EqTextures.getSlotItemStack(slotIndex);
            if (skullStack != null && !skullStack.method_7960()) {
                context.method_51427(skullStack, x, y);
            } else {
                context.method_25294(x, y, x + 16, y + 16, -12566464);
            }
        }
        catch (Exception e) {
            context.method_25294(x, y, x + 16, y + 16, -7650029);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        if (!EqDisplay.shouldRender()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            Integer[] pos = renderedPositions.get(i);
            if (pos == null) continue;
            int slotX = pos[0];
            int slotY = pos[1];
            if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 18)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 18))) continue;
            return true;
        }
        return false;
    }

    public boolean handleMouseClick(int button) {
        if (!SkyblockCheck.getInstance().isInSkyblock()) {
            return false;
        }
        if (button == 0) {
            class_310 client = class_310.method_1551();
            if (client.field_1724 != null) {
                client.field_1724.field_3944.method_45729("/equipment");
                return true;
            }
        }
        return false;
    }
}

