/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.hud;

import java.util.HashMap;
import java.util.Map;
import me.valkeea.fishyaddons.tracker.ItemTrackerData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class HudDisplayCache {
    private static HudDisplayCache instance;
    private CachedHudData cachedData;
    private long lastApiUpdate = 0L;
    private static final long CACHE_VALIDITY_MS = 5000L;
    private static final long API_STALENESS_THRESHOLD = 6000000L;

    private HudDisplayCache() {
    }

    public static HudDisplayCache getInstance() {
        if (instance == null) {
            instance = new HudDisplayCache();
        }
        return instance;
    }

    public boolean hasData() {
        return this.cachedData != null;
    }

    public CachedHudData getDisplayData() {
        boolean needsRefresh;
        long currentTime = System.currentTimeMillis();
        long apiTimestamp = Math.max(ItemTrackerData.getLastBazaarUpdateTime(), ItemTrackerData.getLastAuctionUpdateTime());
        boolean bl = needsRefresh = this.cachedData == null || apiTimestamp > this.lastApiUpdate || this.cachedData.cacheTime > 0L && currentTime - this.cachedData.cacheTime > 5000L;
        if (needsRefresh) {
            this.refreshCache(apiTimestamp, currentTime);
        }
        return this.cachedData;
    }

    public void invalidateCache() {
        this.cachedData = null;
        this.lastApiUpdate = 0L;
    }

    private void refreshCache(long apiTimestamp, long currentTime) {
        Map<String, Integer> items = ItemTrackerData.getAllItems();
        HashMap<String, Double> itemValues = new HashMap<String, Double>();
        for (String itemName : items.keySet()) {
            double unitPrice = ItemTrackerData.getCachedItemValue(itemName);
            if (!(unitPrice > 0.0)) continue;
            itemValues.put(itemName, unitPrice);
        }
        int totalItems = ItemTrackerData.getTotalItemCount();
        double totalValue = ItemTrackerData.getTotalSessionValue();
        long sessionDuration = ItemTrackerData.getTotalDurationMinutes();
        boolean hasRecentApiData = apiTimestamp > 0L && currentTime - apiTimestamp < 6000000L;
        String formattedValue = this.formatCoins(totalValue);
        String timeString = sessionDuration > 60L ? String.format(" (%dh %dmin)", sessionDuration / 60L, sessionDuration % 60L) : String.format(" (%dmin)", sessionDuration);
        String apiIndicator = this.calculateApiIndicator(hasRecentApiData);
        this.cachedData = new CachedHudDataBuilder().setItems(items).setItemValues(itemValues).setTotalItems(totalItems).setTotalValue(totalValue).setFormattedValue(formattedValue).setTimeString(timeString).setApiIndicator(apiIndicator).setHasRecentApiData(hasRecentApiData).setCacheTime(currentTime).build();
        this.lastApiUpdate = apiTimestamp;
    }

    private String calculateApiIndicator(boolean hasRecentData) {
        long lastBazaarUpdate = ItemTrackerData.getLastBazaarUpdateTime();
        if (lastBazaarUpdate > 0L) {
            return hasRecentData ? " \u00a7a\u25cf" : " \u00a7c\u25cf";
        }
        return " \u00a77\u25cf";
    }

    private String formatCoins(double coins) {
        if (coins == 0.0) {
            return "0 coins";
        }
        if (coins >= 1.0E9) {
            return String.format("%.1fb coins", coins / 1.0E9);
        }
        if (coins >= 1000000.0) {
            return String.format("%.1fm coins", coins / 1000000.0);
        }
        if (coins >= 1000.0) {
            return String.format("%.1fk coins", coins / 1000.0);
        }
        return String.format("%.0f coins", coins);
    }

    @Environment(value=EnvType.CLIENT)
    public static class CachedHudData {
        public final Map<String, Integer> items;
        public final Map<String, Double> itemValues;
        public final int totalItems;
        public final double totalValue;
        public final String formattedValue;
        public final String timeString;
        public final String apiIndicator;
        public final boolean hasRecentApiData;
        public final long cacheTime;

        CachedHudData(CachedHudDataBuilder builder) {
            this.items = builder.items;
            this.itemValues = builder.itemValues;
            this.totalItems = builder.totalItems;
            this.totalValue = builder.totalValue;
            this.formattedValue = builder.formattedValue;
            this.timeString = builder.timeString;
            this.apiIndicator = builder.apiIndicator;
            this.hasRecentApiData = builder.hasRecentApiData;
            this.cacheTime = builder.cacheTime;
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class CachedHudDataBuilder {
        Map<String, Integer> items;
        Map<String, Double> itemValues;
        int totalItems;
        double totalValue;
        String formattedValue;
        String timeString;
        String apiIndicator;
        boolean hasRecentApiData;
        long cacheTime;

        private CachedHudDataBuilder() {
        }

        CachedHudDataBuilder setItems(Map<String, Integer> items) {
            this.items = items;
            return this;
        }

        CachedHudDataBuilder setItemValues(Map<String, Double> itemValues) {
            this.itemValues = itemValues;
            return this;
        }

        CachedHudDataBuilder setTotalItems(int totalItems) {
            this.totalItems = totalItems;
            return this;
        }

        CachedHudDataBuilder setTotalValue(double totalValue) {
            this.totalValue = totalValue;
            return this;
        }

        CachedHudDataBuilder setFormattedValue(String formattedValue) {
            this.formattedValue = formattedValue;
            return this;
        }

        CachedHudDataBuilder setTimeString(String timeString) {
            this.timeString = timeString;
            return this;
        }

        CachedHudDataBuilder setApiIndicator(String apiIndicator) {
            this.apiIndicator = apiIndicator;
            return this;
        }

        CachedHudDataBuilder setHasRecentApiData(boolean hasRecentApiData) {
            this.hasRecentApiData = hasRecentApiData;
            return this;
        }

        CachedHudDataBuilder setCacheTime(long cacheTime) {
            this.cacheTime = cacheTime;
            return this;
        }

        CachedHudData build() {
            return new CachedHudData(this);
        }
    }
}

