/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.hud;

import java.awt.Rectangle;
import java.util.Objects;
import me.valkeea.fishyaddons.hud.HudElement;
import me.valkeea.fishyaddons.hud.HudElementState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class InfoDisplay
implements HudElement {
    private static InfoDisplay instance = null;
    private boolean visible = false;
    private String message = "";
    private int hudX = 20;
    private int hudY = 40;
    private int width = 220;
    private int height = 60;
    private int bgColor = -1440603614;
    private int textColor = 0xFFFFFF;
    private boolean outlined = false;
    private boolean bg = true;

    private InfoDisplay() {
    }

    public static InfoDisplay getInstance() {
        if (instance == null) {
            instance = new InfoDisplay();
        }
        return instance;
    }

    public void register() {
        HudLayerRegistrationCallback.EVENT.register(layeredDrawer -> layeredDrawer.attachLayerAfter(IdentifiedLayer.MISC_OVERLAYS, class_2960.method_60655((String)"fishyaddons", (String)"info_hud"), (context, tickCounter) -> this.render(context, 0, 0)));
    }

    public void show(String msg) {
        this.message = msg;
        this.visible = true;
    }

    public void hide() {
        this.visible = false;
        this.invalidateCache();
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        if (!this.visible) {
            return;
        }
        class_310 mc = class_310.method_1551();
        String[] lines = this.message.replace("\\n", "\n").split("\n");
        int maxWidth = 0;
        Objects.requireNonNull(mc.field_1772);
        int lineHeight = 9 + 2;
        int hudHeight = 18 + (lines.length - 1) * lineHeight + 12;
        for (String line : lines) {
            int lineWidth = mc.field_1772.method_1727(line);
            if (lineWidth <= maxWidth) continue;
            maxWidth = lineWidth;
        }
        context.method_25294(this.hudX, this.hudY, this.hudX + maxWidth + 24, this.hudY + hudHeight, this.bgColor);
        int textX = this.hudX + 12;
        int textY = this.hudY + 12;
        for (int i = 0; i < lines.length; ++i) {
            context.method_51439(mc.field_1772, (class_2561)class_2561.method_43470((String)lines[i]), textX, textY + i * lineHeight, this.textColor, false);
        }
        int guideWidth = mc.field_1772.method_1727("Press X to close");
        context.method_25294(this.hudX + 6, textY + lines.length * lineHeight + 6, this.hudX + guideWidth + 14, textY + lines.length * lineHeight + 18, -1442840576);
        context.method_51439(mc.field_1772, (class_2561)class_2561.method_43470((String)"Press X to close"), textX, textY + lines.length * lineHeight + 8, 0xAAAAAA, false);
    }

    @Override
    public Rectangle getBounds(class_310 mc) {
        return new Rectangle(this.hudX, this.hudY, this.width, this.height);
    }

    @Override
    public HudElementState getCachedState() {
        return new HudElementState(this.hudX, this.hudY, this.height, this.textColor, this.outlined, this.bg);
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public int getHudX() {
        return this.hudX;
    }

    @Override
    public int getHudY() {
        return this.hudY;
    }

    @Override
    public void setHudPosition(int x, int y) {
        this.hudX = x;
        this.hudY = y;
    }

    @Override
    public int getHudSize() {
        return this.height;
    }

    @Override
    public void setHudSize(int size) {
        this.height = size;
    }

    @Override
    public int getHudColor() {
        return this.textColor;
    }

    @Override
    public void setHudColor(int color) {
        this.textColor = color;
    }

    @Override
    public boolean getHudOutline() {
        return this.outlined;
    }

    @Override
    public void setHudOutline(boolean outline) {
        this.outlined = outline;
    }

    @Override
    public boolean getHudBg() {
        return this.bg;
    }

    @Override
    public void setHudBg(boolean bg) {
        this.bg = bg;
    }

    @Override
    public void setEditingMode(boolean editing) {
    }

    @Override
    public String getDisplayName() {
        return "Update Notification";
    }
}

