/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.hud;

import java.awt.Rectangle;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.FaTextField;
import me.valkeea.fishyaddons.hud.HudElement;
import me.valkeea.fishyaddons.hud.HudElementState;
import me.valkeea.fishyaddons.render.FaLayers;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class SearchHudElement
implements HudElement {
    private boolean editingMode = false;
    private static final String HUD_KEY = "invSearch";
    private static final String SEARCH_PLACEHOLDER = "right-click to search...";
    private static final String EDITING_MODE_TEXT = "Search Field";
    private static final String HUD_CONFIG_KEY = "search";
    private HudElementState cachedState = null;
    private FaTextField searchField;
    private static SearchHudElement instance = null;
    private boolean overlayActive = false;

    public SearchHudElement() {
        instance = this;
        class_310 client = class_310.method_1551();
        if (client != null && client.field_1772 != null) {
            this.searchField = new FaTextField(client.field_1772, 10, 10, 150, 15, (class_2561)class_2561.method_43470((String)SEARCH_PLACEHOLDER), true);
            this.searchField.method_1862(false);
        }
    }

    public static SearchHudElement getInstance() {
        return instance;
    }

    public void register() {
        HudLayerRegistrationCallback.EVENT.register(layeredDrawer -> layeredDrawer.attachLayerAfter(IdentifiedLayer.MISC_OVERLAYS, class_2960.method_60655((String)"fishyaddons", (String)"search_hud"), (context, tickCounter) -> {
            if (this.shouldRender()) {
                this.render(context, 0, 0);
            }
        }));
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        if (!this.shouldRender()) {
            return;
        }
        this.initIfNeeded();
        if (this.searchField == null) {
            return;
        }
        this.updateDimensions();
        this.renderContent(context, mouseX, mouseY);
    }

    private boolean shouldRender() {
        class_310 mc = class_310.method_1551();
        boolean isInInventory = mc.field_1755 instanceof class_465;
        boolean isEnabled = FishyConfig.getState(HUD_KEY, false);
        if (!isInInventory && this.searchField != null) {
            this.searchField.method_25365(false);
        }
        if (!(this.editingMode || isEnabled && isInInventory)) {
            if (this.searchField != null) {
                this.searchField.method_1862(false);
                this.searchField.method_25365(false);
            }
            return false;
        }
        return true;
    }

    private void initIfNeeded() {
        class_310 client;
        if (this.searchField == null && (client = class_310.method_1551()) != null && client.field_1772 != null) {
            this.searchField = new FaTextField(client.field_1772, 10, 10, 150, 15, (class_2561)class_2561.method_43470((String)SEARCH_PLACEHOLDER), true);
        }
    }

    private void updateDimensions() {
        HudElementState state = this.getCachedState();
        int hudX = state.x;
        int hudY = state.y;
        int size = state.size;
        float scale = (float)size / 15.0f;
        int scaledWidth = (int)(150.0f * scale);
        int scaledHeight = (int)(15.0f * scale);
        if (this.searchField.method_25368() != scaledWidth || this.searchField.method_25364() != scaledHeight) {
            String currentText = this.searchField.method_1882();
            boolean wasFocused = this.searchField.method_25370();
            this.searchField = new FaTextField(class_310.method_1551().field_1772, hudX, hudY, scaledWidth, scaledHeight, (class_2561)class_2561.method_43470((String)SEARCH_PLACEHOLDER), true);
            this.searchField.method_1852(currentText);
            if (wasFocused) {
                this.searchField.method_25365(false);
            }
        } else {
            this.searchField.method_46421(hudX);
            this.searchField.method_46419(hudY);
        }
        this.searchField.method_1862(true);
    }

    private void renderContent(class_332 context, int mouseX, int mouseY) {
        HudElementState state = this.getCachedState();
        int hudX = state.x;
        int hudY = state.y;
        int size = state.size;
        float scale = (float)size / 15.0f;
        int scaledWidth = (int)(150.0f * scale);
        int scaledHeight = (int)(15.0f * scale);
        if (this.editingMode) {
            FaLayers.fillAtTopLevel(context, hudX - 2, hudY - 2, hudX + scaledWidth + 2, hudY + scaledHeight + 2, Integer.MIN_VALUE);
        }
        if (this.searchField.method_1882().isEmpty()) {
            String placeholderText = this.editingMode ? EDITING_MODE_TEXT : SEARCH_PLACEHOLDER;
            int placeholderColor = this.editingMode ? -2130706433 : -2139062144;
            FaLayers.drawTextAtTopLevel(context, class_310.method_1551().field_1772, placeholderText, hudX + 4, hudY + (scaledHeight - 8) / 2, placeholderColor, false);
        }
        FaLayers.renderAtTopLevel(context, () -> this.searchField.method_25394(context, mouseX, mouseY, 0.0f));
        if (this.overlayActive) {
            FaLayers.drawBoxAtTopLevel(context, hudX - 1, hudY - 1, scaledWidth + 2, scaledHeight + 2, -16711711);
        }
    }

    @Override
    public void setHudPosition(int x, int y) {
        FishyConfig.setHudX(HUD_CONFIG_KEY, x);
        FishyConfig.setHudY(HUD_CONFIG_KEY, y);
    }

    @Override
    public Rectangle getBounds(class_310 mc) {
        HudElementState state = this.getCachedState();
        float scale = (float)state.size / 15.0f;
        int scaledWidth = (int)(150.0f * scale);
        int scaledHeight = (int)(15.0f * scale);
        return new Rectangle(state.x, state.y, scaledWidth, scaledHeight);
    }

    @Override
    public HudElementState getCachedState() {
        if (this.cachedState == null) {
            this.cachedState = new HudElementState(this.getHudX(), this.getHudY(), this.getHudSize(), this.getHudColor(), this.getHudOutline(), this.getHudBg());
        }
        return this.cachedState;
    }

    @Override
    public void invalidateCache() {
        this.cachedState = null;
    }

    public FaTextField getSearchField() {
        return this.searchField;
    }

    public boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        class_310 mc = class_310.method_1551();
        boolean isInInventory = mc.field_1755 instanceof class_465;
        if (!FishyConfig.getState(HUD_KEY, false) || !isInInventory) {
            return false;
        }
        if (this.searchField != null && this.searchField.method_1885()) {
            return this.searchField.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean handleMouseClicked(double mouseX, double mouseY, int button) {
        return this.handleMouseClick(mouseX, mouseY, button);
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int button) {
        class_310 mc = class_310.method_1551();
        boolean isInInventory = mc.field_1755 instanceof class_465;
        if (!FishyConfig.getState(HUD_KEY, false) || !isInInventory) {
            return false;
        }
        if (this.searchField != null && this.searchField.method_1885()) {
            HudElementState state = this.getCachedState();
            int hudX = state.x;
            int hudY = state.y;
            float scale = (float)state.size / 15.0f;
            int scaledWidth = (int)(150.0f * scale);
            int scaledHeight = (int)(15.0f * scale);
            if (mouseX >= (double)hudX && mouseX <= (double)(hudX + scaledWidth) && mouseY >= (double)hudY && mouseY <= (double)(hudY + scaledHeight)) {
                if (button == 0) {
                    this.searchField.method_25365(true);
                    double relativeX = mouseX - (double)hudX;
                    double relativeY = mouseY - (double)hudY;
                    return this.searchField.method_25402(relativeX, relativeY, button);
                }
                if (button == 1) {
                    this.overlayActive = !this.overlayActive;
                    return true;
                }
                return false;
            }
            this.searchField.method_25365(false);
            return false;
        }
        return false;
    }

    public String getSearchTerm() {
        return this.searchField != null ? this.searchField.method_1882() : "";
    }

    public boolean isOverlayActive() {
        return this.overlayActive;
    }

    public void setOverlayActive(boolean active) {
        this.overlayActive = active;
    }

    public void clearSearch() {
        if (this.searchField != null) {
            this.searchField.method_1852("");
        }
    }

    public void onScreenChange() {
        if (this.searchField != null) {
            class_310 mc = class_310.method_1551();
            boolean isInInventory = mc.field_1755 instanceof class_465;
            this.searchField.method_25365(false);
            if (!isInInventory) {
                this.searchField.method_1862(false);
            }
        }
    }

    @Override
    public int getHudX() {
        return FishyConfig.getHudX(HUD_CONFIG_KEY, 100);
    }

    @Override
    public int getHudY() {
        return FishyConfig.getHudY(HUD_CONFIG_KEY, 10);
    }

    @Override
    public int getHudSize() {
        return FishyConfig.getHudSize(HUD_CONFIG_KEY, 20);
    }

    @Override
    public int getHudColor() {
        return FishyConfig.getHudColor(HUD_CONFIG_KEY, 0xFFFFFF);
    }

    @Override
    public boolean getHudOutline() {
        return FishyConfig.getHudOutline(HUD_CONFIG_KEY, false);
    }

    @Override
    public boolean getHudBg() {
        return FishyConfig.getHudBg(HUD_CONFIG_KEY, true);
    }

    @Override
    public String getDisplayName() {
        return "Item Search";
    }

    @Override
    public void setEditingMode(boolean editing) {
        this.editingMode = editing;
    }

    @Override
    public void setHudSize(int size) {
        FishyConfig.setHudSize(HUD_CONFIG_KEY, size);
    }

    @Override
    public void setHudColor(int color) {
        FishyConfig.setHudColor(HUD_CONFIG_KEY, color);
    }

    @Override
    public void setHudOutline(boolean outline) {
        FishyConfig.setHudOutline(HUD_CONFIG_KEY, outline);
    }

    @Override
    public void setHudBg(boolean bg) {
        FishyConfig.setHudBg(HUD_CONFIG_KEY, bg);
    }
}

