/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.hud;

import java.awt.Rectangle;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.handler.ChatTimers;
import me.valkeea.fishyaddons.hud.HudElement;
import me.valkeea.fishyaddons.hud.HudElementState;
import me.valkeea.fishyaddons.util.TextUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class TimerDisplay
implements HudElement {
    private boolean editingMode = false;
    private static final String HUD_KEY = "timerHud";
    private HudElementState cachedState = null;

    public void register() {
        HudLayerRegistrationCallback.EVENT.register(layeredDrawer -> layeredDrawer.attachLayerAfter(IdentifiedLayer.MISC_OVERLAYS, class_2960.method_60655((String)"fishyaddons", (String)"timer_hud"), (context, tickCounter) -> this.render(context, 0, 0)));
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        if (!(this.editingMode || ChatTimers.getInstance().isBeaconAlarmHudOn() && ChatTimers.getInstance().isBeaconActive())) {
            return;
        }
        long secondsLeft = ChatTimers.getInstance().getBeaconTimer();
        if (secondsLeft < 0L) {
            return;
        }
        class_310 mc = class_310.method_1551();
        HudElementState state = this.getCachedState();
        int hudX = state.x;
        int hudY = state.y;
        int size = state.size;
        int color = state.color;
        boolean outlined = state.outlined;
        boolean showBg = state.bg;
        float scale = (float)size / 12.0f;
        class_5250 timerLabel = class_2561.method_43470((String)"Moonglade:");
        class_5250 timerValue = class_2561.method_43470((String)(" " + TimerDisplay.formatTime(secondsLeft)));
        int labelWidth = mc.field_1772.method_27525((class_5348)timerLabel);
        int valueWidth = mc.field_1772.method_27525((class_5348)timerValue);
        int textWidth = labelWidth + valueWidth;
        if (this.editingMode || showBg) {
            int shadowX1 = hudX + 1;
            int shadowY1 = hudY + 2;
            int shadowX2 = hudX + (int)((float)textWidth * scale) + 2;
            int shadowY2 = hudY + (int)((float)size * 0.8f) - 1;
            context.method_25294(shadowX1, shadowY1, shadowX2, shadowY2, Integer.MIN_VALUE);
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)hudX, (float)hudY, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        if (outlined) {
            TextUtils.drawOutlinedText(context, mc.field_1772, (class_2561)timerLabel, 0.0f, 0.0f, color, -16777216, context.method_51448().method_23760().method_23761(), (class_4597)class_310.method_1551().method_22940().method_23000(), class_327.class_6415.field_33993, 0xF000F0);
            TextUtils.drawOutlinedText(context, mc.field_1772, (class_2561)timerValue, labelWidth, 0.0f, 0xFFFFFF, -16777216, context.method_51448().method_23760().method_23761(), (class_4597)class_310.method_1551().method_22940().method_23000(), class_327.class_6415.field_33993, 0xF000F0);
        } else {
            context.method_51439(mc.field_1772, (class_2561)timerLabel, 0, 0, color, true);
            context.method_51439(mc.field_1772, (class_2561)timerValue, labelWidth, 0, 0xFFFFFF, true);
        }
        context.method_51448().method_22909();
        if (this.editingMode) {
            context.method_25294(hudX - 2, hudY - 2, hudX + (int)((float)textWidth * scale) + 18, hudY + (int)((float)size * 1.1f) + 4, -2130706433);
        }
    }

    public static String formatTime(long seconds) {
        long minutes = seconds / 60L;
        long remainingSeconds = seconds % 60L;
        return String.format("%02d:%02d", minutes, remainingSeconds);
    }

    @Override
    public Rectangle getBounds(class_310 mc) {
        int hudX = this.getHudX();
        int hudY = this.getHudY();
        int size = this.getHudSize();
        float scale = (float)size / 12.0f;
        int textWidth = mc.field_1772.method_1727(this.getDisplayName() == null ? "" : this.getDisplayName());
        int width = (int)((float)Math.max(80, textWidth) * scale);
        int height = (int)((float)size + 4.0f * scale);
        return new Rectangle(hudX, hudY, width, height);
    }

    @Override
    public HudElementState getCachedState() {
        if (this.cachedState == null) {
            this.cachedState = new HudElementState(FishyConfig.getHudX(HUD_KEY, 5), FishyConfig.getHudY(HUD_KEY, 5), FishyConfig.getHudSize(HUD_KEY, 12), FishyConfig.getHudColor(HUD_KEY, 0xFFFFFF), FishyConfig.getHudOutline(HUD_KEY, false), FishyConfig.getHudBg(HUD_KEY, true));
        }
        return this.cachedState;
    }

    @Override
    public void invalidateCache() {
        this.cachedState = null;
    }

    @Override
    public int getHudX() {
        return FishyConfig.getHudX(HUD_KEY, 5);
    }

    @Override
    public int getHudY() {
        return FishyConfig.getHudY(HUD_KEY, 5);
    }

    @Override
    public void setHudPosition(int x, int y) {
        FishyConfig.setHudX(HUD_KEY, x);
        FishyConfig.setHudY(HUD_KEY, y);
    }

    @Override
    public int getHudSize() {
        return FishyConfig.getHudSize(HUD_KEY, 12);
    }

    @Override
    public void setHudSize(int size) {
        FishyConfig.setHudSize(HUD_KEY, size);
    }

    @Override
    public int getHudColor() {
        return FishyConfig.getHudColor(HUD_KEY, 13162944);
    }

    @Override
    public void setHudColor(int color) {
        FishyConfig.setHudColor(HUD_KEY, color);
    }

    @Override
    public boolean getHudOutline() {
        return FishyConfig.getHudOutline(HUD_KEY, false);
    }

    @Override
    public void setHudOutline(boolean outline) {
        FishyConfig.setHudOutline(HUD_KEY, outline);
    }

    @Override
    public boolean getHudBg() {
        return FishyConfig.getHudBg(HUD_KEY, true);
    }

    @Override
    public void setHudBg(boolean bg) {
        FishyConfig.setHudBg(HUD_KEY, bg);
    }

    @Override
    public void setEditingMode(boolean editing) {
        this.editingMode = editing;
    }

    @Override
    public String getDisplayName() {
        return "Moonglade: ";
    }
}

