/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.hud;

import java.awt.Rectangle;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.GuiUtil;
import me.valkeea.fishyaddons.hud.HudElement;
import me.valkeea.fishyaddons.hud.HudElementState;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class TitleDisplay
implements HudElement {
    private boolean editingMode = false;
    private static String title = null;
    private static int titlecolor = 0xFFFFFF;
    private static final String HUD_KEY = "titleHud";
    private static long alertStartTime = 0L;
    private static long alertDurationMs = 2000L;
    private HudElementState cachedState;

    public void register() {
        HudLayerRegistrationCallback.EVENT.register(layeredDrawer -> layeredDrawer.attachLayerAfter(IdentifiedLayer.MISC_OVERLAYS, class_2960.method_60655((String)"fishyaddons", (String)"title_hud"), (context, tickCounter) -> this.render(context, 0, 0)));
    }

    public static void setTitle(String t, int color) {
        title = t;
        titlecolor = color;
        alertStartTime = System.currentTimeMillis();
        alertDurationMs = 2000L;
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        boolean showAlert;
        boolean bl = showAlert = title != null && !title.isEmpty() && System.currentTimeMillis() - alertStartTime < alertDurationMs;
        if (!this.editingMode && !showAlert) {
            return;
        }
        class_310 mc = class_310.method_1551();
        int hudX = FishyConfig.getHudX(HUD_KEY, 5);
        int hudY = FishyConfig.getHudY(HUD_KEY, 5);
        int size = FishyConfig.getHudSize(HUD_KEY, 40);
        float scale = (float)size / 12.0f;
        int textWidth = mc.field_1772.method_1727(title == null ? "" : title);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)hudX, (float)hudY, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        context.method_51433(mc.field_1772, title, -textWidth / 2, 0, titlecolor, true);
        context.method_51448().method_22909();
        if (this.editingMode) {
            Rectangle bounds = this.getBounds(class_310.method_1551());
            GuiUtil.drawBox(context, bounds.x - 2, bounds.y - 2, bounds.width + 4, (int)((float)size + 4.0f * scale), -2130706433);
            context.method_51433(mc.field_1772, "Alert Title", hudX - bounds.width / 2, hudY + 2, 0xFFFFFF, false);
        }
    }

    public static String getTitle() {
        return title;
    }

    @Override
    public Rectangle getBounds(class_310 mc) {
        int hudX = this.getHudX();
        int hudY = this.getHudY();
        int size = this.getHudSize();
        float scale = (float)size / 20.0f;
        int textWidth = mc.field_1772.method_1727(title == null ? "" : title);
        int boxWidth = Math.max(80, textWidth + 8);
        int scaledBoxWidth = (int)((float)boxWidth * scale);
        int height = (int)((float)size + 4.0f * scale);
        return new Rectangle(hudX - scaledBoxWidth / 2 - 2, hudY - 2, scaledBoxWidth + 4, height);
    }

    @Override
    public void invalidateCache() {
        this.cachedState = null;
    }

    @Override
    public HudElementState getCachedState() {
        if (this.cachedState == null) {
            this.cachedState = new HudElementState(FishyConfig.getHudX(HUD_KEY, 5), FishyConfig.getHudY(HUD_KEY, 5), FishyConfig.getHudSize(HUD_KEY, 40), 0, FishyConfig.getHudOutline(HUD_KEY, false), FishyConfig.getHudBg(HUD_KEY, true));
        }
        return this.cachedState;
    }

    @Override
    public int getHudX() {
        return FishyConfig.getHudX(HUD_KEY, 5);
    }

    @Override
    public int getHudY() {
        return FishyConfig.getHudY(HUD_KEY, 5);
    }

    @Override
    public void setHudPosition(int x, int y) {
        FishyConfig.setHudX(HUD_KEY, x);
        FishyConfig.setHudY(HUD_KEY, y);
    }

    @Override
    public int getHudSize() {
        return FishyConfig.getHudSize(HUD_KEY, 12);
    }

    @Override
    public void setHudSize(int size) {
        FishyConfig.setHudSize(HUD_KEY, size);
    }

    @Override
    public int getHudColor() {
        return FishyConfig.getHudColor(HUD_KEY, 0xFFFFFF);
    }

    @Override
    public void setHudColor(int color) {
        FishyConfig.setHudColor(HUD_KEY, color);
    }

    @Override
    public boolean getHudOutline() {
        return FishyConfig.getHudOutline(HUD_KEY, false);
    }

    @Override
    public void setHudOutline(boolean outline) {
        FishyConfig.setHudOutline(HUD_KEY, outline);
    }

    @Override
    public boolean getHudBg() {
        return FishyConfig.getHudBg(HUD_KEY, true);
    }

    @Override
    public void setHudBg(boolean bg) {
        FishyConfig.setHudBg(HUD_KEY, bg);
    }

    @Override
    public void setEditingMode(boolean editing) {
        this.editingMode = editing;
    }

    @Override
    public String getDisplayName() {
        return "Title HUD";
    }
}

