/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.hud;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.valkeea.fishyaddons.command.ProfitTrackerCommand;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.config.ItemConfig;
import me.valkeea.fishyaddons.config.TrackerProfiles;
import me.valkeea.fishyaddons.gui.VCButton;
import me.valkeea.fishyaddons.hud.HudDisplayCache;
import me.valkeea.fishyaddons.hud.HudElement;
import me.valkeea.fishyaddons.hud.HudElementState;
import me.valkeea.fishyaddons.render.FaLayers;
import me.valkeea.fishyaddons.tracker.ItemTrackerData;
import me.valkeea.fishyaddons.tracker.SackDropParser;
import me.valkeea.fishyaddons.tracker.TrackerUtils;
import me.valkeea.fishyaddons.util.FishyNotis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class TrackerDisplay
implements HudElement {
    private static final String HUD_KEY = "profitTrackerHud";
    private static TrackerDisplay instance = null;
    private HudElementState cachedState = null;
    private List<ItemValueData> lastDisplayedItems = new ArrayList<ItemValueData>();
    private int lastHudX;
    private int lastHudY;
    private int lastHudSize;
    private float lastScale;
    private boolean editingMode = false;

    public TrackerDisplay() {
        instance = this;
    }

    public static TrackerDisplay getInstance() {
        return instance;
    }

    public static void refreshDisplay() {
        if (instance != null) {
            HudDisplayCache.getInstance().invalidateCache();
        }
    }

    public void register() {
        HudLayerRegistrationCallback.EVENT.register(layeredDrawer -> layeredDrawer.attachLayerAfter(IdentifiedLayer.MISC_OVERLAYS, class_2960.method_60655((String)"fishyaddons", (String)"profit_tracker_hud"), (context, tickCounter) -> this.render(context, 0, 0)));
    }

    private boolean isTrackerVisible() {
        return !HudDisplayCache.getInstance().getDisplayData().isEmpty();
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY) {
        if (!this.editingMode && !TrackerUtils.isEnabled()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        HudElementState state = this.getCachedState();
        int hudX = state.x;
        int hudY = state.y;
        int size = state.size;
        int color = state.color;
        boolean showBg = state.bg;
        float scale = (float)size / 12.0f;
        HudDisplayCache.CachedHudData displayData = HudDisplayCache.getInstance().getDisplayData();
        if (!this.editingMode && displayData.isEmpty()) {
            return;
        }
        List<class_2561> lines = this.getDisplayLines(this.editingMode, displayData);
        int maxWidth = this.getMaxLineWidth(mc, lines);
        int totalHeight = lines.size() * size;
        int scaledWidth = (int)((float)maxWidth * scale);
        int scaledHeight = (int)((float)totalHeight * scale);
        if (this.editingMode || showBg) {
            this.drawBackground(context, hudX, hudY, scaledWidth, scaledHeight);
        }
        this.drawTextLines(context, lines, hudX, hudY, scale, size, color);
        this.lastHudX = hudX;
        this.lastHudY = hudY;
        this.lastHudSize = size;
        this.lastScale = scale;
        this.lastDisplayedItems.clear();
        if (!this.editingMode && !displayData.isEmpty()) {
            List<ItemValueData> allItems = this.getSortedItemValues(displayData);
            allItems.stream().limit(15L).forEach(this.lastDisplayedItems::add);
        }
        if (!this.editingMode && this.isInventoryOpen(mc)) {
            FaLayers.renderAtTopLevel(context, () -> {
                int buttonY = Math.max(10, hudY - 30);
                this.drawButtons(context, hudX, buttonY);
            });
        }
        if (this.editingMode) {
            context.method_49601(hudX - 1, hudY - 1, scaledWidth + 2, scaledHeight + 2, -1);
        }
    }

    private List<ItemValueData> getSortedItemValues(HudDisplayCache.CachedHudData displayData) {
        ArrayList itemsWithValue = new ArrayList();
        ArrayList itemsWithoutValue = new ArrayList();
        boolean useMinValueFilter = FishyConfig.getState("minValueFilter", false);
        float minItemValue = FishyConfig.getFloat("minItemValue", 0.0f);
        Set<String> excludedItems = this.getExcludedItems();
        displayData.items.entrySet().forEach(entry -> {
            String itemName = (String)entry.getKey();
            int quantity = (Integer)entry.getValue();
            double unitPrice = displayData.itemValues.getOrDefault(itemName, 0.0);
            double totalValue = unitPrice * (double)quantity;
            if (excludedItems.contains(itemName)) {
                return;
            }
            if (useMinValueFilter && unitPrice > 0.0 && unitPrice < (double)minItemValue) {
                return;
            }
            ItemValueData data = new ItemValueData(itemName, quantity, totalValue);
            if (totalValue > 0.0) {
                itemsWithValue.add(data);
            } else {
                itemsWithoutValue.add(data);
            }
        });
        itemsWithValue.sort((a, b) -> Double.compare(b.totalValue, a.totalValue));
        itemsWithoutValue.sort((a, b) -> Integer.compare(b.quantity, a.quantity));
        ArrayList<ItemValueData> allItems = new ArrayList<ItemValueData>();
        allItems.addAll(itemsWithValue);
        allItems.addAll(itemsWithoutValue);
        return allItems;
    }

    private List<class_2561> getDisplayLines(boolean editingMode, HudDisplayCache.CachedHudData displayData) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        if (editingMode) {
            lines.add((class_2561)class_2561.method_43470((String)"Profit Tracker (5m)"));
            lines.add((class_2561)class_2561.method_43470((String)"\u00a7b+3 \u00a7fRecombobulator 3000"));
            lines.add((class_2561)class_2561.method_43470((String)"Total: \u00a73 items"));
            lines.add((class_2561)class_2561.method_43470((String)"Value: \u00a7b~27m coins"));
        } else if (!displayData.isEmpty()) {
            String currentProfile = TrackerProfiles.getCurrentProfile();
            Object profileSuffix = "default".equals(currentProfile) ? "" : " (" + currentProfile + ")";
            lines.add((class_2561)class_2561.method_43470((String)("Profit Tracker" + displayData.timeString + (String)profileSuffix)));
            List<ItemValueData> allItems = this.getSortedItemValues(displayData);
            allItems.stream().limit(15L).forEach(data -> lines.add((class_2561)class_2561.method_43470((String)this.getItemLine((ItemValueData)data))));
            lines.add((class_2561)class_2561.method_43470((String)String.format("Total: \u00a73%d items", displayData.totalItems)));
            if (displayData.totalValue > 0.0) {
                lines.add((class_2561)class_2561.method_43470((String)String.format("Value: \u00a7b%s%s", displayData.formattedValue, displayData.apiIndicator)));
            }
        } else {
            lines.add((class_2561)class_2561.method_43470((String)"No items tracked"));
        }
        return lines;
    }

    private String getItemLine(ItemValueData data) {
        String itemName = this.capitalizeItemName(data.itemName);
        int quantity = data.quantity;
        StringBuilder lineBuilder = new StringBuilder();
        lineBuilder.append(String.format("\u00a73+%d \u00a77%s", quantity, itemName));
        if (TrackerUtils.isOn() && data.totalValue > 0.0) {
            lineBuilder.append(String.format(" \u00a77(\u00a7b%s\u00a77)", this.formatCoins(data.totalValue)));
        }
        return lineBuilder.toString();
    }

    private int getMaxLineWidth(class_310 mc, List<class_2561> lines) {
        int maxWidth = 0;
        for (class_2561 line : lines) {
            int lineWidth = mc.field_1772.method_27525((class_5348)line);
            maxWidth = Math.max(maxWidth, lineWidth);
        }
        return maxWidth;
    }

    private void drawBackground(class_332 context, int hudX, int hudY, int scaledWidth, int scaledHeight) {
        int bgX1 = hudX - 2;
        int bgY1 = hudY - 2;
        int bgX2 = hudX + scaledWidth + 4;
        int bgY2 = hudY + scaledHeight + 2;
        context.method_25294(bgX1, bgY1, bgX2, bgY2, Integer.MIN_VALUE);
    }

    private void drawTextLines(class_332 context, List<class_2561> lines, int hudX, int hudY, float scale, int size, int color) {
        class_310 mc = class_310.method_1551();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)hudX, (float)hudY, 0.0f);
        context.method_51448().method_22905(scale, scale, 1.0f);
        for (int i = 0; i < lines.size(); ++i) {
            class_2561 line = lines.get(i);
            int yOffset = i * size;
            context.method_51439(mc.field_1772, line, 0, yOffset, color, true);
        }
        context.method_51448().method_22909();
    }

    private boolean isInventoryOpen(class_310 mc) {
        if (mc.field_1755 == null) {
            return false;
        }
        String screenClassName = mc.field_1755.getClass().getSimpleName();
        return screenClassName.equals("class_490") || screenClassName.equals("class_476") || screenClassName.equals("class_475") || screenClassName.contains("Inventory");
    }

    private void drawButtons(class_332 context, int x, int y) {
        String[] buttonTexts = new String[]{"Refresh", "Save", "Delete", "Sack", "Profile"};
        float scale = (float)this.getCachedState().size / 12.0f;
        int buttonWidth = (int)(40.0f * scale);
        int buttonHeight = (int)(16.0f * scale);
        int buttonSpacing = (int)(2.0f * scale);
        class_310 mc = class_310.method_1551();
        double actualMouseX = mc.field_1729.method_1603() * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4480();
        double actualMouseY = mc.field_1729.method_1604() * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4507();
        for (int i = 0; i < buttonTexts.length; ++i) {
            int buttonX = x + i * (buttonWidth + buttonSpacing);
            int buttonY = y;
            boolean isHovered = VCButton.isHovered(buttonX, buttonY, buttonWidth, buttonHeight, (int)actualMouseX, (int)actualMouseY);
            VCButton.render(context, mc.field_1772, VCButton.standard(buttonX, buttonY, buttonWidth, buttonHeight, buttonTexts[i]).withHovered(isHovered).withScale(0.5f));
        }
    }

    public boolean handleMouseClick(double mouseX, double mouseY, int button) {
        class_310 mc = class_310.method_1551();
        if (!this.isInventoryOpen(mc) || !this.isTrackerVisible()) {
            return false;
        }
        HudElementState state = this.getCachedState();
        int hudX = state.x;
        int hudY = state.y;
        float scale = (float)this.getCachedState().size / 12.0f;
        int buttonY = Math.max(10, hudY - 30);
        int buttonWidth = (int)(40.0f * scale);
        int buttonHeight = (int)(16.0f * scale);
        int buttonSpacing = (int)(2.0f * scale);
        for (int i = 0; i < 5; ++i) {
            int buttonX = hudX + i * (buttonWidth + buttonSpacing);
            if (!VCButton.isHovered(buttonX, buttonY, buttonWidth, buttonHeight, (int)mouseX, (int)mouseY)) continue;
            if (i == 4 && button == 1) {
                this.showProfileMenu();
            } else if (button == 0) {
                this.handleButtonClick(i);
            }
            return true;
        }
        if (button == 1 && !this.lastDisplayedItems.isEmpty()) {
            return this.handleItemLineRightClick(mouseX, mouseY);
        }
        return false;
    }

    private boolean handleItemLineRightClick(double mouseX, double mouseY) {
        int lineHeight = (int)((float)this.lastHudSize * this.lastScale);
        int startY = this.lastHudY + lineHeight;
        for (int i = 0; i < this.lastDisplayedItems.size(); ++i) {
            int lineY = startY + i * lineHeight;
            int nextLineY = lineY + lineHeight;
            if (!(mouseY >= (double)lineY) || !(mouseY < (double)nextLineY) || !(mouseX >= (double)this.lastHudX) || !(mouseX <= (double)(this.lastHudX + 200))) continue;
            ItemValueData clickedItem = this.lastDisplayedItems.get(i);
            this.addExcludedItem(clickedItem.itemName);
            String displayName = this.capitalizeItemName(clickedItem.itemName);
            FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a7bFishyAddons \u00a7dwill no longer track: \u00a7f" + displayName)));
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7       \u00a77Use \u00a73/fp ignored \u00a77to see or restore ignored items"));
            return true;
        }
        return false;
    }

    public void restoreExcludedItem(String itemName) {
        this.removeExcludedItem(itemName);
        String displayName = this.capitalizeItemName(itemName);
        FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a7aRestored item: \u00a7f" + displayName)));
    }

    public void restoreAllExcludedItems() {
        Set<String> excluded = this.getExcludedItems();
        if (excluded.isEmpty()) {
            FishyNotis.notice("\u00a77No excluded items to restore");
            return;
        }
        this.saveExcludedItems(new HashSet<String>());
        FishyNotis.send("\u00a7aRestored all excluded items");
    }

    public Set<String> getExcludedItemsForDisplay() {
        return this.getExcludedItems();
    }

    private void handleButtonClick(int buttonIndex) {
        switch (buttonIndex) {
            case 0: {
                FishyNotis.notice("\u00a7bRefreshing cache...");
                ItemTrackerData.forceRefreshAuctionCache();
                ItemTrackerData.refreshBazaarPrices();
                HudDisplayCache.getInstance().invalidateCache();
                break;
            }
            case 1: {
                TrackerUtils.save();
                break;
            }
            case 2: {
                String profileName = TrackerProfiles.getCurrentProfile();
                if ("default".equals(profileName)) {
                    FishyNotis.warn("\u00a7cCannot delete the default profile!");
                    FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a73/fp clear \u00a77if you wish to reset the session."));
                    break;
                }
                if (TrackerProfiles.deleteProfile(profileName)) {
                    TrackerUtils.onDelete(profileName);
                    break;
                }
                FishyNotis.notice("\u00a77No file to delete");
                break;
            }
            case 3: {
                if (SackDropParser.isOn()) {
                    SackDropParser.toggle();
                    FishyNotis.off("Sack tracking");
                    break;
                }
                SackDropParser.toggle();
                FishyNotis.on("Sack tracking");
                break;
            }
            case 4: {
                this.cycleProfile();
                break;
            }
        }
    }

    private void cycleProfile() {
        List<String> profiles = TrackerProfiles.getAvailableProfiles();
        String currentProfile = TrackerProfiles.getCurrentProfile();
        int currentIndex = profiles.indexOf(currentProfile);
        int nextIndex = (currentIndex + 1) % profiles.size();
        String nextProfile = profiles.get(nextIndex);
        TrackerProfiles.setCurrentProfile(nextProfile);
        FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a7dSwitched to profile: \u00a73" + nextProfile)));
        HudDisplayCache.getInstance().invalidateCache();
    }

    private void showProfileMenu() {
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7bYou can also left-click to cycle profiles!"));
        ProfitTrackerCommand.sendProfileClickable();
    }

    private String capitalizeItemName(String itemName) {
        if (itemName == null || itemName.isEmpty()) {
            return itemName;
        }
        String[] words = itemName.split(" ");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word;
            if (i > 0) {
                result.append(" ");
            }
            if ((word = words[i]).isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            result.append(word.substring(1));
        }
        return result.toString();
    }

    private String formatCoins(double coins) {
        if (coins >= 1000000.0) {
            return String.format("%.1fm", coins / 1000000.0);
        }
        if (coins >= 1000.0) {
            return String.format("%.1fk", coins / 1000.0);
        }
        return String.format("%.0f", coins);
    }

    @Override
    public Rectangle getBounds(class_310 mc) {
        HudElementState state = this.getCachedState();
        float scale = (float)state.size / 12.0f;
        int estimatedWidth = (int)(150.0f * scale);
        int estimatedHeight = (int)((float)(9 * state.size) * scale);
        return new Rectangle(state.x, state.y, estimatedWidth, estimatedHeight);
    }

    @Override
    public HudElementState getCachedState() {
        if (this.cachedState == null) {
            this.cachedState = new HudElementState(this.getHudX(), this.getHudY(), this.getHudSize(), this.getHudColor(), this.getHudOutline(), this.getHudBg());
        }
        return this.cachedState;
    }

    @Override
    public void invalidateCache() {
        this.cachedState = null;
    }

    private Set<String> getExcludedItems() {
        String excludedStr = ItemConfig.getString("tracker_excluded_items", "");
        if (excludedStr.isEmpty()) {
            return new HashSet<String>();
        }
        return new HashSet<String>(Arrays.asList(excludedStr.split(",")));
    }

    private void addExcludedItem(String itemName) {
        Set<String> excluded = this.getExcludedItems();
        excluded.add(itemName);
        this.saveExcludedItems(excluded);
    }

    private void removeExcludedItem(String itemName) {
        Set<String> excluded = this.getExcludedItems();
        excluded.remove(itemName);
        this.saveExcludedItems(excluded);
    }

    private void saveExcludedItems(Set<String> excluded) {
        String excludedStr = String.join((CharSequence)",", excluded);
        ItemConfig.setString("tracker_excluded_items", excludedStr);
        HudDisplayCache.getInstance().invalidateCache();
    }

    @Override
    public int getHudX() {
        return FishyConfig.getHudX(HUD_KEY, 14);
    }

    @Override
    public int getHudY() {
        return FishyConfig.getHudY(HUD_KEY, 100);
    }

    @Override
    public void setHudPosition(int x, int y) {
        FishyConfig.setHudX(HUD_KEY, x);
        FishyConfig.setHudY(HUD_KEY, y);
    }

    @Override
    public int getHudSize() {
        return FishyConfig.getHudSize(HUD_KEY, 12);
    }

    @Override
    public void setHudSize(int size) {
        FishyConfig.setHudSize(HUD_KEY, size);
    }

    @Override
    public int getHudColor() {
        return FishyConfig.getHudColor(HUD_KEY, 9102006);
    }

    @Override
    public void setHudColor(int color) {
        FishyConfig.setHudColor(HUD_KEY, color);
    }

    @Override
    public boolean getHudOutline() {
        return false;
    }

    @Override
    public void setHudOutline(boolean outline) {
    }

    @Override
    public boolean getHudBg() {
        return FishyConfig.getHudBg(HUD_KEY, true);
    }

    @Override
    public void setHudBg(boolean bg) {
        FishyConfig.setHudBg(HUD_KEY, bg);
    }

    @Override
    public void setEditingMode(boolean editing) {
        this.editingMode = editing;
    }

    @Override
    public String getDisplayName() {
        return "Profit Tracker";
    }

    @Environment(value=EnvType.CLIENT)
    private static class ItemValueData {
        final String itemName;
        final int quantity;
        final double totalValue;

        ItemValueData(String itemName, int quantity, double totalValue) {
            this.itemName = itemName;
            this.quantity = quantity;
            this.totalValue = totalValue;
        }
    }
}

