/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.mixin;

import me.valkeea.fishyaddons.handler.GuiIcons;
import me.valkeea.fishyaddons.safeguard.SlotProtectionManager;
import me.valkeea.fishyaddons.tool.FishyMode;
import me.valkeea.fishyaddons.util.HelpUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_465.class})
public abstract class MixinHandledScreenSlotOverlay {
    private static final ThreadLocal<class_1735> CURRENT_SLOT = new ThreadLocal();

    @Inject(method={"drawSlot"}, at={@At(value="HEAD")})
    private void onDrawSlotHead(class_332 context, class_1735 slot, CallbackInfo ci) {
        CURRENT_SLOT.set(slot);
    }

    @Inject(method={"drawSlot"}, at={@At(value="TAIL")})
    private void drawSlotOverlay(class_332 context, class_1735 slot, CallbackInfo ci) {
        if (!HelpUtil.isPlayerInventory()) {
            return;
        }
        class_465 screen = (class_465)this;
        int invIndex = SlotProtectionManager.remap(screen, slot.field_7874);
        if (invIndex <= 8 && invIndex >= 44) {
            return;
        }
        if (SlotProtectionManager.isSlotLocked(invIndex)) {
            this.overlay(context, slot, "falocked");
        } else if (SlotProtectionManager.isSlotBound(invIndex)) {
            this.overlay(context, slot, "fabound");
        }
    }

    @Redirect(method={"drawSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawItem(Lnet/minecraft/item/ItemStack;III)V"))
    private void blockDrawItem(class_332 context, class_1799 stack, int x, int y, int seed) {
        class_1735 slot = CURRENT_SLOT.get();
        if (slot != null && GuiIcons.isBlocked(slot.field_7874)) {
            return;
        }
        context.method_51428(stack, x, y, seed);
    }

    @Redirect(method={"drawSlot"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawItemWithoutEntity(Lnet/minecraft/item/ItemStack;III)V"))
    private void blockDrawItemWithoutEntity(class_332 context, class_1799 stack, int x, int y, int seed) {
        class_1735 slot = CURRENT_SLOT.get();
        if (slot != null && GuiIcons.isBlocked(slot.field_7874)) {
            return;
        }
        context.method_55231(stack, x, y, seed);
    }

    @Inject(method={"drawSlot"}, at={@At(value="RETURN")})
    private void onDrawSlotReturn(class_332 context, class_1735 slot, CallbackInfo ci) {
        CURRENT_SLOT.remove();
    }

    private void overlay(class_332 context, class_1735 slot, String textureName) {
        String mode = FishyMode.getTheme();
        class_2960 texture = class_2960.method_60655((String)"fishyaddons", (String)("textures/gui/" + mode + "/" + textureName + ".png"));
        context.method_25290(class_1921::method_62277, texture, slot.field_7873, slot.field_7872, 0.0f, 0.0f, 16, 16, 16, 16);
    }
}

