/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.safeguard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import me.valkeea.fishyaddons.config.ItemConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BlacklistManager {
    private static final List<GuiBlacklistEntry> defaultBlacklist = new ArrayList<GuiBlacklistEntry>();
    private static final List<GuiBlacklistEntry> userBlacklist = new CopyOnWriteArrayList<GuiBlacklistEntry>();
    private static boolean loaded = false;

    private BlacklistManager() {
    }

    public static List<GuiBlacklistEntry> getMergedBlacklist() {
        ArrayList<GuiBlacklistEntry> merged = new ArrayList<GuiBlacklistEntry>();
        for (GuiBlacklistEntry def : defaultBlacklist) {
            GuiBlacklistEntry override = BlacklistManager.findUserOverride(def);
            if (override != null) {
                merged.add(new GuiBlacklistEntry(def.identifiers, override.isEnabled(), def.checkTitle));
                continue;
            }
            merged.add(def);
        }
        for (GuiBlacklistEntry userEntry : userBlacklist) {
            if (userEntry.identifiers == null || userEntry.identifiers.isEmpty()) continue;
            boolean overridesExisting = false;
            for (GuiBlacklistEntry def : defaultBlacklist) {
                if (!BlacklistManager.matchesIdentifier(def, userEntry.identifiers.get(0))) continue;
                overridesExisting = true;
                break;
            }
            if (overridesExisting) continue;
            merged.add(userEntry);
        }
        return merged;
    }

    public static List<GuiBlacklistEntry> getUserBlacklist() {
        BlacklistManager.ensureLoaded();
        return new ArrayList<GuiBlacklistEntry>(userBlacklist);
    }

    public static void updateBlacklistEntry(String identifier, boolean enabled) {
        BlacklistManager.ensureLoaded();
        for (GuiBlacklistEntry entry : userBlacklist) {
            for (String id : entry.identifiers) {
                if (!id.equalsIgnoreCase(identifier)) continue;
                entry.setEnabled(enabled);
                BlacklistManager.saveUserBlacklist();
                return;
            }
        }
        userBlacklist.add(new GuiBlacklistEntry(Collections.singletonList(identifier), enabled, false));
        BlacklistManager.saveUserBlacklist();
    }

    private static GuiBlacklistEntry findUserOverride(GuiBlacklistEntry def) {
        for (String id : def.identifiers) {
            for (GuiBlacklistEntry userEntry : userBlacklist) {
                if (!BlacklistManager.matchesIdentifier(userEntry, id)) continue;
                return userEntry;
            }
        }
        return null;
    }

    private static boolean matchesIdentifier(GuiBlacklistEntry entry, String identifier) {
        if (entry.identifiers == null || entry.identifiers.isEmpty() || identifier == null) {
            return false;
        }
        for (String id : entry.identifiers) {
            if (id == null || !id.equalsIgnoreCase(identifier)) continue;
            return true;
        }
        return false;
    }

    public static void saveUserBlacklist() {
        BlacklistManager.getUserBlacklist();
        ItemConfig.save();
    }

    public static synchronized void loadUserBlacklist() {
        userBlacklist.clear();
        loaded = true;
    }

    public static List<Map<String, Object>> getUserBlacklistAsJson() {
        BlacklistManager.ensureLoaded();
        ArrayList<Map<String, Object>> jsonList = new ArrayList<Map<String, Object>>();
        for (GuiBlacklistEntry entry : userBlacklist) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("identifiers", entry.identifiers);
            map.put("enabled", entry.isEnabled());
            map.put("checkTitle", entry.checkTitle);
            jsonList.add(map);
        }
        return jsonList;
    }

    public static void loadUserBlacklistFromJson(List<Map<String, Object>> jsonEntries) {
        userBlacklist.clear();
        for (Map<String, Object> entry : jsonEntries) {
            Object idObj = entry.get("identifiers");
            ArrayList<String> identifiers = new ArrayList<String>();
            if (idObj instanceof List) {
                for (Object o : (List)idObj) {
                    if (!(o instanceof String)) continue;
                    String string = (String)o;
                    identifiers.add(string);
                }
            }
            boolean enabled = Boolean.TRUE.equals(entry.get("enabled"));
            boolean checkTitle = Boolean.TRUE.equals(entry.get("checkTitle"));
            userBlacklist.add(new GuiBlacklistEntry(identifiers, enabled, checkTitle));
        }
        loaded = true;
    }

    private static void ensureLoaded() {
        if (!loaded) {
            BlacklistManager.loadUserBlacklist();
        }
    }

    static {
        defaultBlacklist.add(new GuiBlacklistEntry(Arrays.asList("Create Auction", "Create BIN Auction", "Find items for sale by players"), true, true));
        defaultBlacklist.add(new GuiBlacklistEntry(Arrays.asList("Coins Transaction"), true, false));
        defaultBlacklist.add(new GuiBlacklistEntry(Arrays.asList("Salvage Items"), true, true));
        defaultBlacklist.add(new GuiBlacklistEntry(Arrays.asList("Sell Item", "Click items in your inventory to sell", "Click to buyback"), true, false));
        BlacklistManager.loadUserBlacklist();
    }

    @Environment(value=EnvType.CLIENT)
    public static class GuiBlacklistEntry {
        public final List<String> identifiers;
        private boolean enabled;
        public final boolean checkTitle;

        public GuiBlacklistEntry(List<String> identifiers, boolean enabled, boolean checkTitle) {
            this.identifiers = identifiers;
            this.enabled = enabled;
            this.checkTitle = checkTitle;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

