/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.safeguard;

import java.util.List;
import me.valkeea.fishyaddons.safeguard.BlacklistManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class BlacklistMatcher {
    private BlacklistMatcher() {
    }

    public static boolean isBlacklistedGUI(class_465<?> gui, String screenClassName) {
        String guiTitle = BlacklistMatcher.getGuiTitle(gui);
        return BlacklistMatcher.isBlacklistedByTitle(guiTitle) || BlacklistMatcher.isBlacklistedBySlots(gui, screenClassName);
    }

    private static boolean isBlacklistedByTitle(String guiTitle) {
        if (guiTitle == null) {
            return false;
        }
        for (BlacklistManager.GuiBlacklistEntry entry : BlacklistMatcher.getMergedBlacklist()) {
            if (!entry.isEnabled() || !entry.checkTitle || !BlacklistMatcher.containsIdentifier(guiTitle, entry.identifiers)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsIdentifier(String guiTitle, List<String> identifiers) {
        String lowerGuiTitle = guiTitle.toLowerCase();
        for (String identifier : identifiers) {
            String cleanIdentifier;
            String stripped = BlacklistMatcher.stripColor(identifier);
            if (stripped == null || !guiTitle.equalsIgnoreCase(cleanIdentifier = stripped.toLowerCase().trim()) && !lowerGuiTitle.contains(cleanIdentifier)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBlacklistedBySlots(class_465<?> gui, String screenClassName) {
        for (class_1735 slot : gui.method_17577().field_7761) {
            class_1799 stack = slot.method_7677();
            if (stack == null || stack.method_7960() || !BlacklistMatcher.isBlacklistedItem(stack, screenClassName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBlacklistedItem(class_1799 stack, String screenClassName) {
        List tooltip;
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_310 client = class_310.method_1551();
        try {
            tooltip = stack.method_7950(class_1792.class_9635.field_51353, (class_1657)client.field_1724, (class_1836)class_1836.field_41070);
        }
        catch (Exception e) {
            return false;
        }
        for (BlacklistManager.GuiBlacklistEntry entry : BlacklistMatcher.getMergedBlacklist()) {
            if (!entry.isEnabled() || !BlacklistMatcher.matchesAnyIdentifier(entry, stack, tooltip, screenClassName)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesAnyIdentifier(BlacklistManager.GuiBlacklistEntry entry, class_1799 stack, List<class_2561> tooltip, String screenClassName) {
        if (entry.identifiers == null || entry.identifiers.isEmpty()) {
            return false;
        }
        for (String identifier : entry.identifiers) {
            String cleanIdentifier = BlacklistMatcher.getCleanIdentifier(identifier);
            if (cleanIdentifier == null) continue;
            if (entry.checkTitle && BlacklistMatcher.matchesScreenClassName(screenClassName, cleanIdentifier)) {
                return true;
            }
            if (BlacklistMatcher.matchesCustomName(stack, cleanIdentifier)) {
                return true;
            }
            if (!BlacklistMatcher.matchesTooltip(tooltip, cleanIdentifier)) continue;
            return true;
        }
        return false;
    }

    private static String getCleanIdentifier(String identifier) {
        String stripped = BlacklistMatcher.stripColor(identifier);
        return stripped == null ? null : stripped.toLowerCase().trim();
    }

    private static boolean matchesScreenClassName(String screenClassName, String cleanIdentifier) {
        return screenClassName != null && screenClassName.toLowerCase().contains(cleanIdentifier);
    }

    private static boolean matchesCustomName(class_1799 stack, String cleanIdentifier) {
        String strippedName;
        if (stack.method_65130() != null && (strippedName = BlacklistMatcher.stripColor(stack.method_65130().getString())) != null) {
            String cleanName = strippedName.toLowerCase().trim();
            return cleanName.contains(cleanIdentifier);
        }
        return false;
    }

    private static boolean matchesTooltip(List<class_2561> tooltip, String cleanIdentifier) {
        for (class_2561 line : tooltip) {
            String cleanLine;
            String strippedLine = BlacklistMatcher.stripColor(line.getString());
            if (strippedLine == null || !(cleanLine = strippedLine.toLowerCase().trim()).contains(cleanIdentifier)) continue;
            return true;
        }
        return false;
    }

    public static String getGuiTitle(class_465<?> gui) {
        try {
            return gui.method_25440().getString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String stripColor(String input) {
        return input == null ? null : input.replaceAll("(?i)\u00a7[0-9a-fklmnor]", "");
    }

    public static List<BlacklistManager.GuiBlacklistEntry> getMergedBlacklist() {
        return BlacklistManager.getMergedBlacklist();
    }
}

